/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.cache.MIMBCache;
import MITI.bridges.javabridge.JavaBridge;
import MITI.bridges.javabridgeinterface.BridgeEnvironment;
import MITI.bridges.javabridgeinterface.BridgeInterface;
import MITI.bridges.javabridgeinterface.BridgeLoader;
import MITI.bridges.javabridgeinterface.ClassPath;
import MITI.bridges.javabridgeinterface.MimbOptions;
import MITI.bridges.javabridgeinterface.Parameter;
import MITI.bridges.mimb.BridgeLibrary;
import MITI.bridges.mimb.MIRModelBridges;
import MITI.bridges.mimb.MIRSetup;
import MITI.messages.MIRModelBridge.MBCM;
import MITI.messages.Mimb.MIMB;
import MITI.messages.Mimb.MMGR;
import MITI.mimb.executable.LicenseKey;
import MITI.mimb.executable.Platform;
import MITI.mimb.executable.actions.Action;
import MITI.mimb.executable.actions.BrowseAction;
import MITI.mimb.executable.actions.DataQualityAction;
import MITI.mimb.executable.actions.ExportAction;
import MITI.mimb.executable.actions.GetBridgeInformationAction;
import MITI.mimb.executable.actions.GetBridgeListAction;
import MITI.mimb.executable.actions.GetBridgeSpecsAction;
import MITI.mimb.executable.actions.ImportAction;
import MITI.mimb.executable.actions.InvalidAction;
import MITI.mimb.executable.actions.SaveBridgeParametersAction;
import MITI.mimb.executable.actions.TestAction;
import MITI.mimb.executable.debug.Conversation;
import MITI.mimb.executable.oem.OEM;
import MITI.mimb.executable.oem.OEMCode;
import MITI.mimb.executable.printers.Printer;
import MITI.mimb.executable.printers.TextPrinter;
import MITI.mimb.executable.printers.XmlPrinter;
import MITI.mimb.executable.requests.BridgeRunRequest;
import MITI.mimb.executable.requests.BrowseRequest;
import MITI.mimb.executable.requests.DataQualityRequest;
import MITI.mimb.executable.requests.GetBridgeInformationRequest;
import MITI.mimb.executable.requests.GetBridgeListRequest;
import MITI.mimb.executable.requests.GetBridgeSpecsRequest;
import MITI.mimb.executable.requests.Request;
import MITI.mimb.executable.requests.RunMimbExtendedRequest;
import MITI.mimb.executable.requests.SaveBridgeParametersRequest;
import MITI.mimb.executable.requests.TestRequest;
import MITI.mimb.executable.responses.ErrorResponse;
import MITI.mimb.executable.responses.Response;
import MITI.mimb.executable.responses.RunMimbResponse;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.secretvault.MIRSecretVault;
import MITI.secretvault.SecretProviderType;
import MITI.util.DateUtil;
import MITI.util.MachineInfo;
import MITI.util.Shutdown;
import MITI.util.VersionInfo;
import MITI.util.cmd.CommandLineOption;
import MITI.util.cmd.CommandLineParser;
import MITI.util.cmd.FlagOption;
import MITI.util.cmd.HelpOption;
import MITI.util.cmd.HiddenOption;
import MITI.util.cmd.Option;
import MITI.util.cmd.RepeatableOption;
import MITI.util.cmd.TypedOption;
import MITI.util.config.MimbConfiguration;
import MITI.util.config.MitiLocale;
import MITI.util.file.FileUtil;
import MITI.util.file.Zip;
import MITI.util.log.BufferedLogEventHandler;
import MITI.util.log.LogEventHandler;
import MITI.util.log.MIRLogger;
import MITI.util.log.PrintStreamLogEventHandler;
import MITI.util.log.XmlLogEventHandler;
import MITI.util.text.BridgeSpecificationLiteral;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MimbExecutable {
    private static OutputStream logOutputStream;
    private static String requestFilePath;
    private static String replyFilePath;
    private static PrintStream replyFileOutputStream;
    private static String commandLineFile;
    private static String logLevel;
    private static String importBridge;
    private static String importPath;
    private static HashMap<String, String> importBridgeOptions;
    private static HashMap<String, String> exportBridgeOptions;
    private static String exportBridge;
    private static String exportPath;
    private static MIRValidationLevel.Enum validationLevel;
    private static HelpOption helpOption;
    private static Option logOption;
    private static Option requestOption;
    private static Option replyOption;
    private static Option importBridgeOption;
    private static Option exportBridgeOption;
    private static Option importPathOption;
    private static Option exportPathOption;
    private static RepeatableOption importBridgeParameterOption;
    private static RepeatableOption exportBridgeParameterOption;
    private static Option consistencyOption;
    private static Option validationOption;
    private static FlagOption processIDOption;
    private static FlagOption downloadOption;
    private static HiddenOption shutdownOption;
    private static CommandLineOption[] options;

    private static void printUsage() {
        CommandLineParser.printUsage(options, System.out);
    }

    private static void printJavaInfo() {
        MBCM.MSG_STARTING_JVM.log(MachineInfo.getJavaVersion(), MachineInfo.getJavaHome(), MachineInfo.getJavaMemory(), MachineInfo.getJavaOptions());
    }

    private static boolean validateActions(List<Action> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Action action = list.get(i);
            if (!(action instanceof BrowseAction || action instanceof TestAction || action instanceof GetBridgeListAction || action instanceof GetBridgeSpecsAction || action instanceof GetBridgeInformationAction || action instanceof SaveBridgeParametersAction ? n != 1 : (action instanceof ImportAction ? i != 0 : action instanceof ExportAction && i != n - 1))) continue;
            return false;
        }
        return true;
    }

    private static MIMBReturnCode printCommandLineToFile(List<Action> list, String string) {
        File file = new File(string);
        StringBuilder stringBuilder = new StringBuilder();
        Action.printCommandLineHeader(stringBuilder);
        stringBuilder.append("\n");
        Action.printCommandLineComment(stringBuilder, "This is an automatically generated script");
        stringBuilder.append("\n");
        stringBuilder.append("\n");
        Action.printCommandLineIni(stringBuilder, "import");
        stringBuilder.append("\n");
        Action.printCommandLineIni(stringBuilder, "validate");
        stringBuilder.append("\n");
        Action.printCommandLineIni(stringBuilder, "export");
        stringBuilder.append("\n");
        stringBuilder.append("\n");
        for (int i = 0; i < list.size(); ++i) {
            Action action = list.get(i);
            action.printCommandLine(stringBuilder);
        }
        Action.printCommandLineComment(stringBuilder, "Run the executable");
        stringBuilder.append("\n");
        stringBuilder.append("MIMB ");
        Action.printCommandLineUse(stringBuilder, "import");
        stringBuilder.append(" ");
        Action.printCommandLineUse(stringBuilder, "validate");
        stringBuilder.append(" ");
        Action.printCommandLineUse(stringBuilder, "export");
        stringBuilder.append("\n");
        FileUtil.writeContent(file, stringBuilder.toString(), Charset.defaultCharset());
        return MIMBReturnCode.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        int n;
        Object object3;
        MIMBReturnCode mIMBReturnCode = MIMBReturnCode.SUCCESS;
        int n2 = 0;
        try {
            CommandLineParser.process(stringArray, 0, options);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(MBCM.MSG_STARTING_JVM.getMessage(MachineInfo.getJavaVersion(), MachineInfo.getJavaHome(), MachineInfo.getJavaMemory(), MachineInfo.getJavaOptions()));
            MimbExecutable.printUsage();
            System.err.println(illegalArgumentException.toString());
            mIMBReturnCode = MIMBReturnCode.ERROR_EXE;
            System.exit(mIMBReturnCode.getValue());
        }
        if (helpOption.isSet()) {
            MimbExecutable.printUsage();
            System.exit(mIMBReturnCode.getValue());
        }
        if (shutdownOption.isSet()) {
            Shutdown.listen(shutdownOption.getFileValue());
        }
        if (processIDOption.isSet()) {
            System.out.println("PID=" + MachineInfo.getJavaProcessId());
        }
        IOException iOException = null;
        if (logOption.isSet()) {
            object3 = logOption.getFileValue();
            try {
                logOutputStream = new FileOutputStream((File)object3);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        requestFilePath = requestOption.getStringValue();
        if (replyOption.isSet()) {
            replyFilePath = replyOption.getStringValue();
        }
        object3 = null;
        object3 = requestFilePath != null ? new XmlLogEventHandler(logOutputStream != null ? logOutputStream : System.err) : new PrintStreamLogEventHandler(logOutputStream != null ? new PrintStream(logOutputStream) : System.err);
        BufferedLogEventHandler bufferedLogEventHandler = new BufferedLogEventHandler();
        MIRLogger mIRLogger = MIRLogger.init(new LogEventHandler[]{object3, bufferedLogEventHandler});
        if (iOException != null) {
            MIMB.TOOL_CANNOT_OPEN_LOG_FILE.log(mIRLogger, iOException, logOption.getStringValue());
            ++n2;
        }
        importBridge = importBridgeOption.getStringValue();
        importPath = importPathOption.getStringValue();
        for (String object4 : importBridgeParameterOption.getValues()) {
            n = object4.indexOf("=");
            if (n < 1) {
                throw new IllegalArgumentException(MBCM.INVALID_PARAM_FORMAT.getMessage(object4));
            }
            object2 = object4.substring(0, n).trim();
            object = object4.substring(n + 1).trim();
            importBridgeOptions.put((String)object2, (String)object);
        }
        exportBridge = exportBridgeOption.getStringValue();
        exportPath = exportPathOption.getStringValue();
        for (String unsupportedEncodingException : exportBridgeParameterOption.getValues()) {
            n = unsupportedEncodingException.indexOf("=");
            if (n < 1) {
                throw new IllegalArgumentException(MBCM.INVALID_PARAM_FORMAT.getMessage(unsupportedEncodingException));
            }
            object2 = unsupportedEncodingException.substring(0, n).trim();
            object = unsupportedEncodingException.substring(n + 1).trim();
            exportBridgeOptions.put((String)object2, (String)object);
        }
        if (validationOption.isSet()) {
            validationLevel = MIRValidationLevel.getByName(validationOption.getStringValue());
        } else if (consistencyOption.isSet()) {
            validationLevel = consistencyOption.getIntValue() == 0 ? MIRValidationLevel.NONE : (consistencyOption.getIntValue() == 2 ? MIRValidationLevel.ADVANCED : MIRValidationLevel.BASIC);
        }
        MIMB.DBG_MIMB_COMMAND_LINE_OPTIONS_PROCESSED.log(mIRLogger, new Object[0]);
        try {
            void var8_26;
            Object object5;
            if (requestFilePath != null) {
                if ("STDOUT".equals(replyFilePath)) {
                    object5 = new XmlPrinter(System.out, mIRLogger, bufferedLogEventHandler);
                } else {
                    try {
                        replyFileOutputStream = new PrintStream(new File(replyFilePath), "UTF-8");
                        object5 = new XmlPrinter(replyFileOutputStream, mIRLogger, bufferedLogEventHandler);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        MIMB.TOOL_CANNOT_OPEN_REPLY_FILE.log(mIRLogger, replyFilePath);
                        object5 = new XmlPrinter(System.out, mIRLogger, bufferedLogEventHandler);
                        ++n2;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        MIMB.TOOL_CANNOT_OPEN_REPLY_FILE.log(mIRLogger, replyFilePath);
                        object5 = new XmlPrinter(System.out, mIRLogger, bufferedLogEventHandler);
                        ++n2;
                    }
                }
            } else {
                object5 = new TextPrinter(System.out, mIRLogger, bufferedLogEventHandler);
            }
            if (n2 > 0) {
                ErrorResponse errorResponse = new ErrorResponse(MIMBReturnCode.ERROR_USAGE);
                mIMBReturnCode = ((Printer)object5).printReply(errorResponse);
                System.exit(mIMBReturnCode.getValue());
            }
            Object var8_23 = null;
            if (requestFilePath != null) {
                Document document;
                if (requestFilePath.equalsIgnoreCase("stdin")) {
                    document = MIRBridgeLib.parseXmlStream((InputStream)System.in, (MIRLogger)mIRLogger);
                } else {
                    object2 = new File(requestFilePath);
                    document = MIRBridgeLib.parseXmlFile((File)object2, (boolean)true, (MIRLogger)mIRLogger);
                }
                object2 = document.getDocumentElement();
                Request request = Request.decodeXmlRequest((Element)object2);
            } else {
                Request request = MimbExecutable.decodeCommandLineRequest();
            }
            MIMB.DBG_MIMB_REQUEST_PARSED.log(mIRLogger, new Object[0]);
            File file = MimbConfiguration.getMimbHome();
            if (downloadOption.isSet()) {
                if (importBridge != null) {
                    MimbExecutable.downloadDrivers(file, mIRLogger, true, importBridge, importBridgeOptions);
                } else if (exportBridge != null) {
                    MimbExecutable.downloadDrivers(file, mIRLogger, false, exportBridge, exportBridgeOptions);
                } else {
                    MimbExecutable.downloadDrivers(file, mIRLogger, null, null, null);
                }
                System.exit(0);
            }
            if ((object2 = OEM.getEnvOemCode()) == OEMCode.NOT_OEM) {
                try {
                    LicenseKey.isValid(OEMCode.NOT_OEM, new File(file, "conf/mimb.lic"));
                    object2 = OEMCode.MIMB_WEB;
                }
                catch (MIRException mIRException) {
                    // empty catch block
                }
            }
            object = MimbExecutable.executeRequest((Request)var8_26, mIRLogger, file, (OEMCode)((Object)object2));
            MIMB.DBG_MIMB_PRINTING_REPLY.log(mIRLogger, new Object[0]);
            mIMBReturnCode = ((Printer)object5).printReply((Response)object);
            MIMB.DBG_MIMB_PRINTED_REPLY.log(mIRLogger, new Object[0]);
        }
        catch (Exception exception) {
            MIMB.GENERAL_ERROR.log(mIRLogger, exception, exception.getMessage());
        }
        catch (Throwable throwable) {
            MIMB.TOOL_UNEXPECTED_ERROR.log(mIRLogger, throwable, "MIMB");
        }
        finally {
            if (logOutputStream != null) {
                try {
                    logOutputStream.close();
                }
                catch (IOException iOException3) {}
            }
            if (replyFileOutputStream != null) {
                replyFileOutputStream.close();
            }
        }
        System.exit(mIMBReturnCode.getValue());
    }

    public static Response executeRequest(Request request, MIRLogger mIRLogger, File file) throws MIRException {
        return MimbExecutable.executeRequest(request, mIRLogger, file, OEM.getEnvOemCode());
    }

    public static Response executeRequest(Request request, MIRLogger mIRLogger, File file, String string) throws MIRException {
        return MimbExecutable.executeRequest(request, mIRLogger, file, OEM.getOemCode(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Response executeRequest(Request request, MIRLogger mIRLogger, File file, OEMCode oEMCode) throws MIRException {
        Conversation conversation = null;
        Response response = null;
        try {
            String string = request.getLanguage();
            if (string != null && !string.isEmpty()) {
                MitiLocale.setLocale(string);
            }
            MIRSetup mIRSetup = MIRSetup.loadSetup((File)file);
            conversation = new Conversation(mIRSetup);
            conversation.logRequest(request);
            List<Action> list = MimbExecutable.generateRequestActions(request, mIRSetup, mIRLogger, oEMCode);
            response = MimbExecutable.executeRequest(list, mIRSetup, mIRLogger, file, oEMCode);
            if (conversation != null) {
                conversation.logResponse(response, mIRLogger.getEvents());
            }
        }
        catch (Throwable throwable) {
            if (conversation != null) {
                conversation.logResponse(response, mIRLogger.getEvents());
            }
            throw throwable;
        }
        return response;
    }

    private static Response executeRequest(List<Action> list, MIRSetup mIRSetup, MIRLogger mIRLogger, File file, OEMCode oEMCode) throws MIRException {
        Object object;
        Response response = null;
        long l = MachineInfo.getJavaProcessId();
        MIMB.MSG_PID.log(mIRLogger, (int)l);
        if (OEM.isDebugOem()) {
            MimbExecutable.printJavaInfo();
        }
        if (!commandLineFile.isEmpty()) {
            MIMBReturnCode mIMBReturnCode = MimbExecutable.printCommandLineToFile(list, commandLineFile);
            response = new RunMimbResponse(mIMBReturnCode);
            return response;
        }
        VersionInfo versionInfo = VersionInfo.loadPatch(mIRSetup.getHomeDirectory(), "MIMB-OEM");
        if (versionInfo != null) {
            MIMB.PATCH_INFO.log(mIRLogger, versionInfo.getComponent(), versionInfo.getVersionNumber(), versionInfo.getDate());
        }
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        String string = new Integer(operatingSystemMXBean.getAvailableProcessors()).toString() + " CPU(s)/Core(s)";
        MIMB.TOOL_USER_INFO.log(mIRLogger, Platform.isRunningAsService() ? "a service" : "an application", MachineInfo.getUsername());
        MIMB.TOOL_HARDWARE_INFO.log(mIRLogger, MachineInfo.getHardwareProcessorId(), string, MachineInfo.getHardwareMemory());
        MIMB.TOOL_SOFTWARE_INFO.log(mIRLogger, operatingSystemMXBean.getName(), operatingSystemMXBean.getVersion(), operatingSystemMXBean.getArch(), MachineInfo.getHostName(), "");
        MIMB.TOOL_ENCODING_INFO.log(mIRLogger, MachineInfo.getEncoding());
        MIMB.TOOL_DATA_DIRECTORY.log(mIRLogger, mIRSetup.getDataDirectory().getAbsolutePath());
        MIMB.DBG_MIMB_VALIDATING_REQUEST.log(mIRLogger, new Object[0]);
        if (!MimbExecutable.validateActions(list)) {
            response = new ErrorResponse(MIMBReturnCode.ERROR_USAGE);
            return response;
        }
        MIMB.DBG_MIMB_CHECKING_LICENSE.log(mIRLogger, new Object[0]);
        if (!MimbExecutable.checkLicenseKey(list, oEMCode, mIRSetup, mIRLogger)) {
            response = new ErrorResponse(MIMBReturnCode.ERROR_LICENSE);
            return response;
        }
        MIMBReturnCode mIMBReturnCode = MIMBReturnCode.SUCCESS;
        MIMB.DBG_MIMB_IS_READY_TO_EXECUTE.log(mIRLogger, new Object[0]);
        File file2 = null;
        Action action = null;
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (action != null) {
                ((Action)object).setDirectory(action.getDirectory());
                ((Action)object).setMiscParams(action.getMiscParams());
            }
            ((Action)object).execute();
            if (file2 == null && object instanceof ImportAction) {
                file2 = ((Action)object).getDirectory();
            }
            if ((mIMBReturnCode = ((Action)object).getResult()) != MIMBReturnCode.SUCCESS) {
                response = ((Action)object).getResponse();
                break;
            }
            action = object;
        }
        MIMB.DBG_MIMB_EXECUTED.log(mIRLogger, new Object[0]);
        JavaBridge.printVersionInfos((MIRLogger)mIRLogger);
        if (file2 != null && file2.exists()) {
            Map<String, String> map = System.getenv();
            object = map.get("MITI_KEEP_MIMB_TEMP_FILES");
            if (object != null && ((String)object).equals("ON")) {
                MIMB.WRN_KEPT_TEMP_EXPORT_FILES.log(mIRLogger, file2.getPath());
            } else {
                MIMB.DBG_REMOVING_TMP_DIR.log(mIRLogger, file2.getPath());
                FileUtil.delete(file2);
            }
        }
        if (response == null) {
            response = new RunMimbResponse(mIMBReturnCode);
        }
        return response;
    }

    private static List<Action> generateRequestActions(Request request, MIRSetup mIRSetup, MIRLogger mIRLogger, OEMCode oEMCode) throws MIRException {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        if (request != null) {
            MIRModelBridges mIRModelBridges = MIRModelBridges.load((File)mIRSetup.getHomeDirectory());
            BridgeLoader bridgeLoader = new BridgeLoader(mIRSetup.getJavaDirectory());
            String string = request.getUserIdentity();
            if (request instanceof GetBridgeListRequest) {
                GetBridgeListAction getBridgeListAction = new GetBridgeListAction(mIRSetup, mIRModelBridges, (GetBridgeListRequest)request, oEMCode);
                arrayList.add(getBridgeListAction);
            } else if (request instanceof GetBridgeSpecsRequest) {
                GetBridgeSpecsAction getBridgeSpecsAction = new GetBridgeSpecsAction(mIRSetup, mIRModelBridges, (GetBridgeSpecsRequest)request);
                arrayList.add(getBridgeSpecsAction);
            } else if (request instanceof GetBridgeInformationRequest) {
                GetBridgeInformationAction getBridgeInformationAction = new GetBridgeInformationAction(bridgeLoader, mIRSetup, mIRModelBridges, (GetBridgeInformationRequest)request, oEMCode);
                arrayList.add(getBridgeInformationAction);
            } else if (request instanceof SaveBridgeParametersRequest) {
                SaveBridgeParametersAction saveBridgeParametersAction = new SaveBridgeParametersAction(bridgeLoader, mIRSetup, mIRModelBridges, (SaveBridgeParametersRequest)request, oEMCode);
                arrayList.add(saveBridgeParametersAction);
            } else if (request instanceof BrowseRequest) {
                MimbExecutable.processLogLevelRequestAttribute(((BrowseRequest)request).getLogLevel(), mIRLogger);
                BrowseAction browseAction = new BrowseAction(bridgeLoader, mIRSetup, mIRModelBridges, (BrowseRequest)request, MIRValidationLevel.getDefaultLevel(), oEMCode);
                arrayList.add(browseAction);
            } else if (request instanceof TestRequest) {
                MimbExecutable.processLogLevelRequestAttribute(((TestRequest)request).getLogLevel(), mIRLogger);
                TestAction testAction = new TestAction(bridgeLoader, mIRSetup, mIRModelBridges, (TestRequest)request, oEMCode);
                arrayList.add(testAction);
            } else if (request instanceof RunMimbExtendedRequest) {
                Object object;
                RunMimbExtendedRequest runMimbExtendedRequest = (RunMimbExtendedRequest)request;
                commandLineFile = runMimbExtendedRequest.getCommandLineFile();
                String string2 = runMimbExtendedRequest.getLogLevel();
                MimbExecutable.processLogLevelRequestAttribute(string2, mIRLogger);
                String string3 = runMimbExtendedRequest.getLanguage();
                String string4 = runMimbExtendedRequest.getResetCache();
                if ("CLEAN_XMI_ONLY".equals(string4)) {
                    MIMBCache.setResetXmiCache((boolean)true);
                } else if ("CLEAN_ALL".equals(string4)) {
                    MIMBCache.setResetXmiCache((boolean)true);
                    MIMBCache.setResetNativeCache((boolean)true);
                }
                BridgeRunRequest bridgeRunRequest = runMimbExtendedRequest.getImportRequest();
                if (bridgeRunRequest != null) {
                    bridgeRunRequest.setUserIdentity(string);
                    object = new ImportAction(bridgeLoader, mIRSetup, mIRModelBridges, bridgeRunRequest, runMimbExtendedRequest.getValidationLevel(), string2, string3, oEMCode);
                    arrayList.add((Action)object);
                }
                if ((object = runMimbExtendedRequest.getExportRequest()) != null) {
                    ((Request)object).setUserIdentity(string);
                    ExportAction exportAction = new ExportAction(bridgeLoader, mIRSetup, mIRModelBridges, (BridgeRunRequest)object, runMimbExtendedRequest.getValidationLevel(), string2, string3, oEMCode);
                    arrayList.add(exportAction);
                }
            } else if (request instanceof DataQualityRequest) {
                DataQualityAction dataQualityAction = new DataQualityAction(bridgeLoader, mIRSetup, mIRModelBridges, (DataQualityRequest)request, string, oEMCode);
                arrayList.add(dataQualityAction);
            } else {
                InvalidAction invalidAction = new InvalidAction(mIRSetup, string);
                arrayList.add(invalidAction);
            }
        }
        return arrayList;
    }

    private static Request decodeCommandLineRequest() {
        MimbOptions mimbOptions;
        BridgeRunRequest bridgeRunRequest;
        String string = "";
        String string2 = "";
        if ("list".equals(importBridge)) {
            GetBridgeListRequest getBridgeListRequest = new GetBridgeListRequest();
            getBridgeListRequest.setIsExport(false);
            getBridgeListRequest.setWithSpecification(false);
            getBridgeListRequest.setUserIdentity(string);
            getBridgeListRequest.setLanguage(string2);
            return getBridgeListRequest;
        }
        if (importBridge != null && "specs".equals(importPath)) {
            GetBridgeInformationRequest getBridgeInformationRequest = new GetBridgeInformationRequest();
            getBridgeInformationRequest.setBridgeId(importBridge);
            getBridgeInformationRequest.setBridgeDisplayName("");
            getBridgeInformationRequest.setIsExport(false);
            getBridgeInformationRequest.setUserIdentity(string);
            getBridgeInformationRequest.setLanguage(string2);
            return getBridgeInformationRequest;
        }
        if ("list".equals(exportBridge)) {
            GetBridgeListRequest getBridgeListRequest = new GetBridgeListRequest();
            getBridgeListRequest.setIsExport(true);
            getBridgeListRequest.setWithSpecification(false);
            getBridgeListRequest.setUserIdentity(string);
            getBridgeListRequest.setLanguage(string2);
            return getBridgeListRequest;
        }
        if (exportBridge != null && "specs".equals(exportPath)) {
            GetBridgeInformationRequest getBridgeInformationRequest = new GetBridgeInformationRequest();
            getBridgeInformationRequest.setBridgeId(exportBridge);
            getBridgeInformationRequest.setBridgeDisplayName("");
            getBridgeInformationRequest.setIsExport(true);
            getBridgeInformationRequest.setUserIdentity(string);
            getBridgeInformationRequest.setLanguage(string2);
            return getBridgeInformationRequest;
        }
        RunMimbExtendedRequest runMimbExtendedRequest = new RunMimbExtendedRequest();
        runMimbExtendedRequest.setLanguage(string2);
        runMimbExtendedRequest.setLogLevel(logLevel);
        runMimbExtendedRequest.setUserIdentity(string);
        runMimbExtendedRequest.setValidationLevel(validationLevel);
        runMimbExtendedRequest.setCommandLineFile(commandLineFile);
        if (importBridge != null) {
            bridgeRunRequest = new BridgeRunRequest();
            bridgeRunRequest.setBridgeId(importBridge);
            bridgeRunRequest.setBridgeDisplayName("");
            bridgeRunRequest.setDisableLog(false);
            mimbOptions = new MimbOptions();
            if (importPath != null) {
                mimbOptions.addOption("File/Directory", importPath, "");
            }
            for (String string3 : importBridgeOptions.keySet()) {
                mimbOptions.addOption(string3, importBridgeOptions.get(string3), "");
            }
            bridgeRunRequest.setUserOptions(mimbOptions);
            runMimbExtendedRequest.setImportRequest(bridgeRunRequest);
        }
        if (exportBridge != null) {
            bridgeRunRequest = new BridgeRunRequest();
            bridgeRunRequest.setBridgeId(exportBridge);
            bridgeRunRequest.setBridgeDisplayName("");
            bridgeRunRequest.setDisableLog(false);
            mimbOptions = new MimbOptions();
            if (exportPath != null) {
                mimbOptions.addOption("File/Directory", exportPath, "");
            }
            for (String string3 : exportBridgeOptions.keySet()) {
                mimbOptions.addOption(string3, exportBridgeOptions.get(string3), "");
            }
            bridgeRunRequest.setUserOptions(mimbOptions);
            runMimbExtendedRequest.setExportRequest(bridgeRunRequest);
        }
        return runMimbExtendedRequest;
    }

    private static boolean checkLicenseKey(List<Action> list, OEMCode oEMCode, MIRSetup mIRSetup, MIRLogger mIRLogger) throws MIRException {
        Object object;
        String string = MachineInfo.getHostId();
        MIMB.DBG_HOSTID.log(mIRLogger, string);
        if (mIRLogger.getLevel() >= 6) {
            object = MachineInfo.getMacAddress();
            MIMB.DBG_MAC_ADDRESS.log(mIRLogger, object);
        }
        if (!OEM.isDebugOem()) {
            MIMB.OEM_CODE.log(mIRLogger, oEMCode.toString());
        }
        object = new File(mIRSetup.getConfDirectory(), "mimb.lic");
        LicenseKey.isValid(oEMCode, (File)object);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        ImportAction importAction = null;
        ExportAction exportAction = null;
        BrowseAction browseAction = null;
        DataQualityAction dataQualityAction = null;
        for (Action action : list) {
            String string2;
            if (action instanceof GetBridgeListAction || action instanceof GetBridgeSpecsAction || action instanceof GetBridgeInformationAction || action instanceof SaveBridgeParametersAction || action instanceof TestAction) continue;
            if (action instanceof ImportAction) {
                importAction = (ImportAction)action;
                ++n2;
                if (action.isMIMBIntermediateStep(importAction.getBridgeId(), importAction.getBridgeDisplayName())) continue;
                string2 = BridgeLoader.getBridgeId((String)importAction.getBridgeId());
                LicenseKey.isValidBridge(oEMCode, (File)object, string2, false);
                continue;
            }
            if (action instanceof ExportAction) {
                exportAction = (ExportAction)action;
                ++n3;
                if (action.isMIMBIntermediateStep(exportAction.getBridgeId(), exportAction.getBridgeDisplayName())) continue;
                string2 = BridgeLoader.getBridgeId((String)exportAction.getBridgeId());
                LicenseKey.isValidBridge(oEMCode, (File)object, string2, true);
                continue;
            }
            if (action instanceof BrowseAction) {
                browseAction = (BrowseAction)action;
                string2 = BridgeLoader.getBridgeId((String)browseAction.getBridgeId());
                LicenseKey.isValidBridge(oEMCode, (File)object, string2, browseAction.isExport());
                continue;
            }
            if (action instanceof DataQualityAction) {
                dataQualityAction = (DataQualityAction)action;
                if (action.isMIMBIntermediateStep(dataQualityAction.getBridgeId(), dataQualityAction.getBridgeDisplayName())) continue;
                string2 = BridgeLoader.getBridgeId((String)dataQualityAction.getBridgeId());
                LicenseKey.isValidBridge(oEMCode, (File)object, string2, false);
                continue;
            }
            if (oEMCode == OEMCode.NOT_OEM) continue;
            ++n;
        }
        if (oEMCode != OEMCode.NOT_OEM && (n2 > 0 || n3 > 0)) {
            if (n2 != 1 || n3 != 1 || importAction == null || exportAction == null) {
                ++n;
            } else if (OEM.isInternalMimb()) {
                if (!Action.isMitiBridge(importAction.getBridgeId()) && !Action.isMitiBridge(exportAction.getBridgeId())) {
                    ++n;
                }
            } else {
                boolean bl = oEMCode.isOemBridge(importAction.getBridgeId(), false);
                boolean bl2 = oEMCode.isOemBridge(exportAction.getBridgeId(), true);
                if (!bl && !bl2) {
                    ++n;
                }
                if (bl && !oEMCode.isValidBridge(exportAction.getBridgeSpec(), true)) {
                    ++n;
                }
                if (bl2 && !oEMCode.isValidBridge(importAction.getBridgeSpec(), false)) {
                    ++n;
                }
            }
        }
        if (!OEM.isDebugOem()) {
            if (importAction != null) {
                MIMB.TOOL_IMPORT_BRIDGE.log(mIRLogger, importAction.getBridgeId(), "");
            }
            if (exportAction != null) {
                MIMB.TOOL_EXPORT_BRIDGE.log(mIRLogger, exportAction.getBridgeId(), "");
            }
        }
        if (n != 0) {
            MIMB.GENERAL_ERROR.log(mIRLogger, MMGR.MANAGER_LICENSE_UNSPECIFIED.getText());
            return false;
        }
        return true;
    }

    private static void processLogLevelRequestAttribute(String string, MIRLogger mIRLogger) {
        if (string.length() == 1 && string.compareTo("1") >= 0 && string.compareTo("6") <= 0) {
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            mIRLogger.setLocalLevel(n);
            MIMB.LOG_LEVEL.log(mIRLogger, string);
        }
    }

    private static void downloadDrivers(File file, MIRLogger mIRLogger, Boolean bl, String string, HashMap<String, String> hashMap) throws MIRException {
        boolean[] blArray;
        MIRSetup mIRSetup = MIRSetup.loadSetup((File)file);
        if (string == null) {
            for (BridgeLoader object2 : SecretProviderType.values()) {
                MBCM.MSG_MAVEN_DOWNLOADING_FILE.log("drivers for " + object2.getName().getText());
                MIRSecretVault.buildClassPath((MIRSetup)mIRSetup, (SecretProviderType)object2);
            }
        }
        BridgeLoader bridgeLoader = new BridgeLoader(mIRSetup.getJavaDirectory());
        BridgeEnvironment bridgeEnvironment = new BridgeEnvironment(mIRSetup, null, MIRValidationLevel.NONE);
        MIRModelBridges mIRModelBridges = MIRModelBridges.load((File)file);
        if (bl == null) {
            boolean[] blArray2 = new boolean[2];
            blArray2[0] = false;
            blArray = blArray2;
            blArray2[1] = true;
        } else {
            boolean[] blArray3 = new boolean[1];
            blArray = blArray3;
            blArray3[0] = bl == false;
        }
        for (boolean bl2 : blArray) {
            for (BridgeLibrary bridgeLibrary : string == null ? mIRModelBridges.getBridges(bl2) : Collections.singleton(mIRModelBridges.loadBridgeLibrary(string, bl2))) {
                BridgeSpecificationLiteral bridgeSpecificationLiteral = bridgeLibrary != null ? MIRModelBridges.getBridgeSpecificationLiteral((String)bridgeLibrary.getBridgeId(), (boolean)bl2) : null;
                if (bridgeSpecificationLiteral == null || bridgeSpecificationLiteral.isBridge_IsAlias() || !bridgeSpecificationLiteral.isBridge_IsDriverLiveDownloadEnabled()) continue;
                try {
                    MBCM.MSG_MAVEN_DOWNLOADING_FILE.log("drivers for " + bridgeLibrary.getBridgeId());
                    ArrayList<MimbOptions> arrayList = new ArrayList<MimbOptions>();
                    BridgeInterface bridgeInterface = bridgeLoader.loadBridge(bridgeLibrary.getBridgeId(), bl2);
                    if (bridgeInterface != null) {
                        MimbOptions mimbOptions;
                        if (hashMap != null && !hashMap.isEmpty()) {
                            mimbOptions = new MimbOptions();
                            for (Map.Entry<String, String> entry : hashMap.entrySet()) {
                                mimbOptions.addOption(entry.getKey(), entry.getValue(), "");
                            }
                            arrayList.add(mimbOptions);
                        } else {
                            mimbOptions = null;
                            for (Parameter parameter : bridgeInterface.getParameters()) {
                                if (!parameter.getName().toLowerCase().contains("version")) continue;
                                mimbOptions = parameter;
                                break;
                            }
                            if (mimbOptions != null) {
                                if (mimbOptions.getType() == Parameter.Type.ENUMERATED) {
                                    for (String string2 : mimbOptions.getPossibleValues().keySet()) {
                                        MimbOptions mimbOptions2 = new MimbOptions();
                                        mimbOptions2.addOption(mimbOptions.getName(), string2, "");
                                        arrayList.add(mimbOptions2);
                                    }
                                } else if (!mimbOptions.getDefaultValue().isEmpty()) {
                                    MimbOptions mimbOptions3 = new MimbOptions();
                                    mimbOptions3.addOption(mimbOptions.getName(), mimbOptions.getDefaultValue(), "");
                                    arrayList.add(mimbOptions3);
                                }
                            }
                        }
                        if (arrayList.isEmpty()) {
                            arrayList.add(new MimbOptions());
                        }
                        bridgeLoader.unloadBridge(bridgeInterface);
                    }
                    for (MimbOptions mimbOptions : arrayList) {
                        bridgeInterface = bridgeLoader.loadBridge(bridgeLibrary.getBridgeId(), bl2);
                        bridgeInterface.configureClassPath(new ClassPath(bridgeEnvironment, mIRLogger, mimbOptions), mimbOptions, bridgeEnvironment, MIRLogger.getLogger());
                        bridgeLoader.unloadBridge(bridgeInterface);
                    }
                }
                catch (MIRException mIRException) {
                    MIMB.TOOL_FAILED.log(mIRException.getMessage());
                }
            }
        }
        String string3 = VersionInfo.loadMitiJar(MimbExecutable.class).getVersionString().replace(".", "");
        String string4 = DateUtil.formatSimpleDate(System.currentTimeMillis(), false).substring(0, 10).replace("-", "");
        File file2 = new File(mIRSetup.getDownloadDirectory().getParent());
        File file3 = new File(mIRSetup.getHomeDirectory(), "MIMB-ThirdParty-Patch-" + string3 + "-" + string4 + ".zip");
        try {
            file3.delete();
            Zip.zip(file3, "data", file2);
            MIMB.TOOL_DOWNLOADED_DRIVERS.log(file3.getAbsolutePath());
        }
        catch (IOException iOException) {
            MIMB.TOOL_DOWNLOADED_DRIVERS.log(file2.getAbsolutePath());
        }
    }

    static {
        replyFilePath = "STDOUT";
        replyFileOutputStream = null;
        commandLineFile = "";
        logLevel = "";
        importBridge = null;
        importPath = null;
        importBridgeOptions = new LinkedHashMap<String, String>();
        exportBridgeOptions = new LinkedHashMap<String, String>();
        exportBridge = null;
        exportPath = null;
        validationLevel = MIRValidationLevel.BASIC;
        helpOption = new HelpOption();
        logOption = new Option(new String[]{"-l", "--logFile"}, MIMB.PARAM_DESCR_L.getText());
        requestOption = new Option(new String[]{"-r", "--request"}, MIMB.PARAM_DESCR_R.getText());
        replyOption = new Option(new String[]{"-y", "--reply"}, MIMB.PARAM_DESCR_Y.getText());
        importBridgeOption = new Option(new String[]{"-i", "--import"}, MIMB.PARAM_DESCR_I.getText());
        exportBridgeOption = new Option(new String[]{"-e", "--export"}, MIMB.PARAM_DESCR_E.getText());
        importPathOption = new Option(new String[]{"-f", "--from"}, MIMB.PARAM_DESCR_F.getText());
        exportPathOption = new Option(new String[]{"-t", "--to"}, MIMB.PARAM_DESCR_T.getText());
        importBridgeParameterOption = new RepeatableOption(new String[]{"-o", "--importOption"}, MIMB.PARAM_DESCR_O.getText());
        exportBridgeParameterOption = new RepeatableOption(new String[]{"-p", "--exportOption"}, MIMB.PARAM_DESCR_P.getText());
        consistencyOption = new Option(new String[]{"-c", "--consistency"}, MIMB.PARAM_DESCR_C.getText(), TypedOption.Type.INT);
        validationOption = new Option(new String[]{"-v", "--validation"}, MIMB.PARAM_DESCR_V.getText());
        processIDOption = new FlagOption(new String[]{"-X", "--pid"}, MIMB.PARAM_DESCR_X.getText());
        downloadOption = new FlagOption(new String[]{"-d", "--download"}, MIMB.PARAM_DESCR_D.getText());
        shutdownOption = new HiddenOption(new String[]{"-s", "--shutdown"});
        options = new CommandLineOption[]{helpOption, logOption, requestOption, replyOption, importBridgeOption, importPathOption, importBridgeParameterOption, exportBridgeOption, exportPathOption, exportBridgeParameterOption, consistencyOption, validationOption, processIDOption, downloadOption, shutdownOption};
    }

    public static enum MIMBReturnCode {
        SUCCESS_NO_CHANGES(-6),
        SUCCESS_BRIDGE_SPECS(-5),
        SUCCESS_SAVE_OPTIONS(-4),
        SUCCESS_METAMODEL_MAPPING(-3),
        SUCCESS_BRIDGE_INFORMATION(-2),
        SUCCESS_BRIDGE_LIST(-1),
        SUCCESS(0),
        ERROR_EXE(1),
        ERROR_USAGE(2),
        ERROR_IMPORT(3),
        ERROR_EXPORT(4),
        ERROR_VALIDATION(5),
        ERROR_SUBSET(6),
        ERROR_LICENSE(7),
        ERROR_REPORT(8),
        ERROR_TRANSFORM(9),
        ERROR_BROWSE(10),
        ERROR_TEST(11);

        private final int value;

        private MIMBReturnCode(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

