/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable;

import MITI.MIRException;
import MITI.license.mimb.MimbLicenseFile;
import MITI.mimb.executable.oem.OEMCode;
import MITI.server.services.common.LicenseException;
import MITI.util.file.FileUtil;
import java.io.File;

public class LicenseKey {
    public static void isValid(OEMCode oEMCode, File file) throws MIRException {
        if (oEMCode == OEMCode.NOT_OEM || oEMCode == OEMCode.MIMB_WEB) {
            try {
                MimbLicenseFile mimbLicenseFile = new MimbLicenseFile();
                mimbLicenseFile.read(FileUtil.readContent(file, FileUtil.UTF8));
                mimbLicenseFile.validate();
            }
            catch (LicenseException licenseException) {
                throw new MIRException(licenseException.getMessage(), licenseException);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw new MIRException("Invalid Licensing Configuration: no OEM token supplied and no Licensing.jar found");
            }
        }
    }

    public static void isValidBridge(OEMCode oEMCode, File file, String string, boolean bl) throws MIRException {
        if (oEMCode == OEMCode.NOT_OEM || oEMCode == OEMCode.MIMB_WEB) {
            try {
                MimbLicenseFile mimbLicenseFile = new MimbLicenseFile();
                mimbLicenseFile.read(FileUtil.readContent(file, FileUtil.UTF8));
                mimbLicenseFile.validate();
                mimbLicenseFile.checkBridge(string, bl);
            }
            catch (LicenseException licenseException) {
                throw new MIRException(licenseException.getMessage(), licenseException);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw new MIRException("Invalid Licensing Configuration: no OEM token supplied and no Licensing.jar found");
            }
        }
    }
}

