/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.concurrent;

import MITI.MIRException;
import MITI.bridges.cache.MIMBCacheResourceFile;
import MITI.bridges.concurrent.Task;
import MITI.bridges.javabridgeinterface.MimbOptions;
import MITI.bridges.mimb.MIRSetup;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.requests.BridgeRunRequest;
import MITI.mimb.executable.requests.Request;
import MITI.mimb.executable.requests.RunMimbExtendedRequest;
import MITI.mimb.executable.responses.ErrorResponse;
import MITI.mimb.executable.responses.Response;
import MITI.mimb.executable.responses.RunMimbResponse;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.util.log.MIRLogger;
import java.io.File;
import java.io.IOException;

public abstract class MIMBTask
extends Task {
    protected String importBridgeId;
    protected String exportBridgeId;
    protected MimbOptions importOptions = new MimbOptions();
    protected MimbOptions exportOptions = new MimbOptions();
    protected MIMBCacheResourceFile xmiResource;
    protected long mimbTime = 0L;

    public MIMBTask(MIMBCacheResourceFile mIMBCacheResourceFile) {
        this.xmiResource = mIMBCacheResourceFile;
    }

    public void setImportBridge(String string) {
        this.importBridgeId = string;
    }

    public void setExportBridge(String string) {
        this.exportBridgeId = string;
    }

    public void addImportOption(String string, String string2) {
        this.importOptions.addOption(string, string2, "");
    }

    public void addExportOption(String string, String string2) {
        this.exportOptions.addOption(string, string2, "");
    }

    public abstract void prepareParameters() throws MIRException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean internalCall() {
        Response response = null;
        try {
            Object object;
            this.prepareParameters();
            this.displayStartMessage();
            this.setUseInfoForStatus(true);
            String string = System.getenv("MIR_I18N_LANG");
            if (string == null || string.isEmpty()) {
                string = "en";
            }
            Request request = this.createRequest(string);
            long l = System.currentTimeMillis();
            try {
                object = MIRSetup.getDefault().getHomeDirectory();
                response = MimbExecutable.executeRequest(request, this.logger, (File)object);
            }
            catch (MIRException mIRException) {
                BLIB.DBG_DEBUG.log((MIRLogger)this.logger, mIRException, "MIMB failed with error code: " + mIRException.getMessage());
                this.success = false;
            }
            if (response == null) {
                BLIB.DBG_DEBUG.log((MIRLogger)this.logger, "MIMB failed with no response");
                this.success = false;
            } else if (response instanceof ErrorResponse) {
                object = response.getReturnCode().toString();
                BLIB.DBG_DEBUG.log((MIRLogger)this.logger, "MIMB failed with error code: " + (String)object);
                this.success = false;
            } else if (response instanceof RunMimbResponse) {
                BLIB.DBG_DEBUG.log((MIRLogger)this.logger, "MIMB completed successfully");
                this.success = true;
            }
            this.mimbTime = System.currentTimeMillis() - l;
        }
        catch (MIRException mIRException) {
            this.exception = mIRException;
            this.success = false;
        }
        finally {
            this.setUseInfoForStatus(false);
        }
        if (this.isSuccessful() && this.xmiResource != null) {
            try {
                this.xmiResource.setWritten();
            }
            catch (IOException iOException) {
                this.exception = iOException;
                this.success = false;
            }
        }
        if (!this.isSuccessful()) {
            this.displayErrorMessage();
        }
        return this.success;
    }

    private Request createRequest(String string) {
        RunMimbExtendedRequest runMimbExtendedRequest = new RunMimbExtendedRequest();
        runMimbExtendedRequest.setValidationLevel(MIRValidationLevel.getDefaultLevel());
        runMimbExtendedRequest.setCommandLineFile("");
        runMimbExtendedRequest.setLanguage(string);
        String string2 = new Integer(this.logger.getLevel()).toString();
        runMimbExtendedRequest.setLogLevel(string2);
        runMimbExtendedRequest.setUserIdentity("");
        BridgeRunRequest bridgeRunRequest = new BridgeRunRequest();
        bridgeRunRequest.setBridgeId(this.importBridgeId);
        bridgeRunRequest.setBridgeDisplayName("");
        bridgeRunRequest.setDisableLog(false);
        bridgeRunRequest.setLanguage(string);
        bridgeRunRequest.setUserOptions(this.importOptions);
        runMimbExtendedRequest.setImportRequest(bridgeRunRequest);
        BridgeRunRequest bridgeRunRequest2 = new BridgeRunRequest();
        bridgeRunRequest2.setBridgeId(this.exportBridgeId);
        bridgeRunRequest2.setBridgeDisplayName("MIMB Intermediate Step");
        bridgeRunRequest2.setDisableLog(true);
        bridgeRunRequest2.setLanguage(string);
        bridgeRunRequest2.setUserOptions(this.exportOptions);
        runMimbExtendedRequest.setExportRequest(bridgeRunRequest2);
        return runMimbExtendedRequest;
    }

    public long getMimbTime() {
        return this.mimbTime;
    }
}

