/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.relationship.batch;

import com.sas.batch.core.AbstractBatchUtility2;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.svcs.content.relationship.batch.RB;
import com.sas.svcs.security.authentication.client.AuthenticationClient;
import com.sas.svcs.security.authentication.client.AuthenticationClientHolder;
import com.sas.text.Message;
import java.net.URI;
import java.util.ResourceBundle;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public abstract class WIPServicesBatchUtility
extends AbstractBatchUtility2 {
    public static final String OPTION_HOST = "host";
    public static final String OPTION_PORT = "port";
    public static final String OPTION_USER = "user";
    public static final String OPTION_PASSWORD = "password";
    public static final String OPTION_PROTOCOL = "protocol";
    private static final String SPRING_CONFIG_RESOURCE_NAME = "/com/sas/svcs/content/relationship/batch/autowire-context.xml";
    private AuthenticationClient authClient;
    private String host;
    private String port;
    private String user;
    private String password;
    private String protocol;
    protected String springConfigResource = "/com/sas/svcs/content/relationship/batch/autowire-context.xml";
    protected ApplicationContext applicationContext;
    protected RestTemplate restTemplate;
    private String restBaseUrl;

    public void setConnection(String host, String port) {
        this.host = host;
        this.port = port;
    }

    public void setCredential(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public abstract int execute() throws Exception;

    public void executeBatch(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtRuntimeExceptionHandler(true, 8));
        try {
            if (!this.parse(args)) {
                return;
            }
            this.initializeBatchLogging();
            this.logStart();
            this.execute();
        }
        catch (Exception e) {
            this.logException(e);
        }
        this.logCompletion();
        this.terminateBatchLogging();
        System.exit(this.getReturnCode());
    }

    protected Options getCommandLineOptions(boolean forHelpText) {
        Options commandLineOptions = super.getCommandLineOptions(forHelpText);
        Option option = new Option(OPTION_HOST, true, RB.getStringResource("WIPServicesBatchUtility.Option.Host.Desc.txt"));
        option.setArgName(RB.getStringResource("WIPServicesBatchUtility.Option.Host.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_PORT, true, RB.getStringResource("WIPServicesBatchUtility.Option.Port.Desc.txt"));
        option.setArgName(RB.getStringResource("WIPServicesBatchUtility.Option.Port.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_PROTOCOL, true, RB.getStringResource("WIPServicesBatchUtility.Option.Protocol.Desc.txt"));
        option.setArgName(RB.getStringResource("WIPServicesBatchUtility.Option.Protocol.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_USER, true, RB.getStringResource("WIPServicesBatchUtility.Option.User.Desc.txt"));
        option.setArgName(RB.getStringResource("WIPServicesBatchUtility.Option.User.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_PASSWORD, true, RB.getStringResource("WIPServicesBatchUtility.Option.Pass.Desc.txt"));
        option.setArgName(RB.getStringResource("WIPServicesBatchUtility.Option.Pass.ArgName.txt"));
        commandLineOptions.addOption(option);
        return commandLineOptions;
    }

    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        if (!super.parse(args)) {
            return false;
        }
        if (!this.commandLine.hasOption(OPTION_HOST)) {
            throw new MissingOptionException(RB.getStringResource("WIPServicesBatchUtility.MissingHostOption.txt"));
        }
        if (!this.commandLine.hasOption(OPTION_PORT)) {
            throw new MissingOptionException(RB.getStringResource("WIPServicesBatchUtility.MissingPortOption.txt"));
        }
        if (!this.commandLine.hasOption(OPTION_USER) || !this.commandLine.hasOption(OPTION_PASSWORD)) {
            throw new MissingOptionException(RB.getStringResource("WIPServicesBatchUtility.MissingUserOption.txt"));
        }
        this.setConnection(this.commandLine.getOptionValue(OPTION_HOST), this.commandLine.getOptionValue(OPTION_PORT));
        this.setCredential(this.commandLine.getOptionValue(OPTION_USER), this.commandLine.getOptionValue(OPTION_PASSWORD));
        String protocol = this.commandLine.getOptionValue(OPTION_PROTOCOL);
        if (protocol != null) {
            this.setProtocol(protocol);
        }
        return true;
    }

    protected void initialize() throws Exception {
        System.getProperties().setProperty(OPTION_HOST, this.host);
        System.getProperties().setProperty(OPTION_PORT, this.port);
        if (this.protocol == null) {
            this.protocol = "http";
        }
        System.getProperties().setProperty(OPTION_PROTOCOL, this.protocol);
        this.applicationContext = new ClassPathXmlApplicationContext(this.springConfigResource);
        try {
            String CAS_URL = this.protocol + "://" + this.host + ":" + this.port + "/SASLogon";
            this.authClient = new AuthenticationClient(CAS_URL);
            this.authClient.logon(this.user, this.password);
            AuthenticationClientHolder.set((AuthenticationClient)this.authClient);
        }
        catch (Exception e) {
            throw new AuthenticationException(RB.getStringResource("WIPServicesBatchUtility.LogConnectionError.txt"), (Throwable)e);
        }
        if (this.isLogDecorations() && this.user != null) {
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"WIPServicesBatchUtility.LogConnectionInfo.fmt.txt", (Object)this.host, (Object)this.port, (Object)this.user));
        }
    }

    protected void initializeRESTServices() throws Exception {
        this.restBaseUrl = this.protocol + "://" + this.host + ":" + this.port;
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.user, this.password);
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(new AuthScope(this.host, Integer.parseInt(this.port), AuthScope.ANY_REALM), (Credentials)credentials);
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).build();
        PreAuthHttpComponentsClientHttpRequestFactory httpRequestFactory = new PreAuthHttpComponentsClientHttpRequestFactory((HttpClient)httpClient, this.host, this.user, this.password);
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)httpRequestFactory);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("REST services initialized.");
        }
    }

    protected final String generateRESTUrl(String serviceEndpoint) {
        if (serviceEndpoint == null || serviceEndpoint.isEmpty()) {
            throw new IllegalArgumentException("Invalid service endpoint");
        }
        if (this.restBaseUrl == null) {
            throw new IllegalStateException("The REST services have not been initialized");
        }
        return this.restBaseUrl + (serviceEndpoint.charAt(0) == '/' ? serviceEndpoint : "/" + serviceEndpoint);
    }

    protected void terminate() throws Exception {
        HttpComponentsClientHttpRequestFactory factory;
        if (this.authClient != null) {
            this.authClient.logout();
        }
        if (this.applicationContext != null) {
            ((ClassPathXmlApplicationContext)this.applicationContext).close();
        }
        if (this.restTemplate != null && (factory = (HttpComponentsClientHttpRequestFactory)this.restTemplate.getRequestFactory()) != null) {
            factory.destroy();
        }
    }

    protected void logWarning(String msg) {
        this.logger.warn(msg);
        if (this.returnCode < 4) {
            this.returnCode = 4;
        }
    }

    protected void logError(String msg) {
        this.logError(msg, null);
    }

    protected void logError(String msg, Throwable t) {
        if (t == null) {
            this.logger.error(msg);
        } else {
            this.logger.error(msg, t);
        }
        if (this.returnCode < 8) {
            this.returnCode = 8;
        }
    }

    private class PreAuthHttpComponentsClientHttpRequestFactory
    extends HttpComponentsClientHttpRequestFactory {
        private String hostName;
        private Credentials credentials;

        private PreAuthHttpComponentsClientHttpRequestFactory(HttpClient httpClient, String hostName, String userName, String password) {
            super(httpClient);
            this.hostName = hostName;
            this.credentials = new UsernamePasswordCredentials(userName, password);
        }

        protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
            HttpClientContext context = HttpClientContext.create();
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(new AuthScope(WIPServicesBatchUtility.this.host, Integer.parseInt(WIPServicesBatchUtility.this.port), AuthScope.ANY_REALM), this.credentials);
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(new HttpHost(this.hostName), (AuthScheme)new BasicScheme());
            context.setCredentialsProvider((CredentialsProvider)provider);
            context.setAuthCache((AuthCache)authCache);
            return context;
        }
    }
}

