/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.relationship.batch;

import com.sas.svcs.common.client.ContentFilterCriteria;
import com.sas.svcs.common.client.ObjectIdentityUtils;
import com.sas.svcs.common.client.PathIdentifier;
import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentException;
import com.sas.svcs.content.lookup.client.LookupService;
import com.sas.svcs.content.relationship.batch.CSVOutputWriter;
import com.sas.svcs.content.relationship.batch.ContentBatchUtil;
import com.sas.svcs.content.relationship.batch.ListOutputWriter;
import com.sas.svcs.content.relationship.batch.OutputWriter;
import com.sas.svcs.content.relationship.batch.RB;
import com.sas.svcs.content.relationship.batch.RelationshipBatchUtility;
import com.sas.svcs.content.relationship.batch.RelationshipContentFilterOptions;
import com.sas.svcs.content.relationship.client.RelationshipDirection;
import com.sas.svcs.content.relationship.client.RelationshipException;
import com.sas.svcs.content.relationship.client.RelationshipTypeService;
import com.sas.svcs.content.relationship.client.report.RelationshipFilter;
import com.sas.svcs.content.relationship.client.report.RelationshipReport;
import com.sas.svcs.content.relationship.client.report.RelationshipReportingService;
import com.sas.text.Message;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class RelationshipReporter
extends RelationshipBatchUtility {
    public static final String OPTION_FORMAT = "format";
    public static final String OPTION_FILE = "file";
    public static final String OPTION_REPORT = "report";
    public static final String OPTION_REL = "rel";
    public static final String OPTION_REL_CONTENT = "relContent";
    public static final String OPTION_DEPTH = "depth";
    public static final String OPTION_DIRECTION = "direction";
    public static final String OPTION_RELATIONSHIP_TYPES = "types";
    public static final String OPTION_TRAVERSAL = "traversal";
    public static final String OPTION_REL_ATTR_NAME = "attrName";
    public static final String OPTION_REL_ATTR_VALUE = "attrValue";
    private static final int DEFAULT_DEPTH = 1;
    private static final RelationshipDirection DEFAULT_DIRECTION = RelationshipDirection.TO;
    private static final List<String> DEFAULT_RELATIONSHIP_TYPES = Arrays.asList("D", "A");
    private static final RelationshipFilter.FilterTraversal DEFAULT_FILTER_TRAVERSAL = RelationshipFilter.FilterTraversal.PRE_ORDER;
    private RelationshipReportingService relationshipReportingService;
    private RelationshipTypeService relationshipTypeService;
    private LookupService lookupService;
    private OutputFormat format = OutputFormat.LIST;
    private ReportType reportType = ReportType.CUSTOM;
    private String outputFileName;
    private File outputFile;
    private RelationshipFilter relationshipFilter;
    private RelationshipContentFilterOptions relationshipContentFilterOptions;

    public RelationshipReporter() {
        super("sas-relationship-reporter");
    }

    public static void main(String[] args) {
        RelationshipReporter driver = new RelationshipReporter();
        driver.executeBatch(args);
    }

    @Override
    protected void initializeFilterOptions() {
        this.filterOptions = new RelationshipContentFilterOptions();
    }

    public void setFormat(OutputFormat format) {
        this.format = format;
    }

    public OutputFormat getFormat() {
        return this.format;
    }

    public void setReportType(ReportType type) {
        this.reportType = type;
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public RelationshipFilter getRelationshipFilter() {
        return this.relationshipFilter;
    }

    public void setRelationshipFilter(RelationshipFilter relationshipFilter) {
        this.relationshipFilter = relationshipFilter;
    }

    @Override
    protected void initialize() throws Exception {
        super.initialize();
        this.relationshipReportingService = (RelationshipReportingService)this.applicationContext.getBean(RelationshipReportingService.class);
        this.relationshipTypeService = (RelationshipTypeService)this.applicationContext.getBean(RelationshipTypeService.class);
        this.lookupService = (LookupService)this.applicationContext.getBean(LookupService.class);
        if (this.outputFileName != null) {
            File parent;
            this.outputFile = new File(this.outputFileName);
            File file = parent = this.outputFile.isDirectory() ? this.outputFile : this.outputFile.getParentFile();
            if (parent != null && !parent.exists()) {
                throw new RelationshipException(Message.format((ResourceBundle)RB.getResources(), (String)"RelationshipReporterUtility.CreateFile.Error.fmt.txt", (Object)parent.getAbsolutePath()));
            }
        }
    }

    @Override
    public int execute() throws Exception {
        if (this.reportType == null) {
            throw new IllegalArgumentException("Invalid reporting mode");
        }
        try {
            this.initialize();
            if (this.relationshipFilter == null) {
                RelationshipFilter filter = this.createRelationshipFilter(this.reportType);
                this.setRelationshipFilter(filter);
            }
            this.processRelationships(this.relationshipFilter);
        }
        finally {
            this.terminate();
        }
        return this.returnCode;
    }

    private RelationshipFilter createRelationshipFilter(ReportType mode) {
        RelationshipFilter filter = new RelationshipFilter();
        switch (mode) {
            case LINEAGE: {
                filter = new RelationshipFilter();
                filter.setDepth(10);
                filter.setDirection(RelationshipDirection.TO);
                filter.setRelationshipTypes(Arrays.asList("D", "I"));
                break;
            }
            case IMPACT: {
                filter = new RelationshipFilter();
                filter.setDepth(10);
                filter.setDirection(RelationshipDirection.FROM);
                filter.setRelationshipTypes(Arrays.asList("D", "I", "A"));
                break;
            }
            case DIRECT_DEPENDENCIES: {
                filter.setDepth(1);
                filter.setDirection(RelationshipDirection.TO);
                filter.setRelationshipTypes(Arrays.asList("D"));
                break;
            }
            case INDIRECT_DEPENDENCIES: {
                filter.setDepth(10);
                filter.setDirection(RelationshipDirection.TO);
                filter.setRelationshipTypes(Arrays.asList("D"));
                filter.setFilterTraversal(RelationshipFilter.FilterTraversal.POST_ORDER);
                break;
            }
            default: {
                filter = this.createDefaultRelationshipFilter();
            }
        }
        return filter;
    }

    private void processRelationships(RelationshipFilter relationshipFilter) throws ContentException, IOException {
        List subjects;
        RelationshipReport report = null;
        if (this.objectList != null && !this.objectList.isEmpty()) {
            List<ContentComponent> contentObjects = this.getObjectsByPath(this.objectList);
            this.logger.trace(Message.format((ResourceBundle)RB.getResources(), (String)"RelationshipLoaderUtility.LoadingRelationships.fmt.txt", (Object)(contentObjects == null ? 0 : contentObjects.size())));
            ArrayList<ObjectIdentity> identities = new ArrayList<ObjectIdentity>(contentObjects.size());
            for (ContentComponent contentObject : contentObjects) {
                identities.add(ObjectIdentityUtils.createObjectIdentity((Identifiable)contentObject));
            }
            this.logger.trace("Generating report.");
            report = this.relationshipReportingService.getRelationships(identities, relationshipFilter);
        } else {
            ContentFilterCriteria filter = this.getFilterCriteria();
            if (filter == null) {
                this.logger.info(RB.getStringResource("RelationshipReporterUtility.ReportNotCreated.txt"));
                return;
            }
            this.includeSubtypes(filter, this.filterOptions);
            ContentFilterCriteria relatedContentFilter = relationshipFilter.getContentFilter();
            if (relatedContentFilter != null && this.relationshipContentFilterOptions != null) {
                this.includeSubtypes(relatedContentFilter, this.relationshipContentFilterOptions);
            }
            this.logger.trace("Generating report.");
            report = this.relationshipReportingService.searchRelationships(filter, relationshipFilter);
        }
        List list = subjects = report == null ? null : report.getSubjects();
        if (subjects == null || subjects.isEmpty()) {
            this.logger.info(RB.getStringResource("RelationshipReporterUtility.NoObjectsFound.txt"));
        } else {
            OutputWriter writer;
            this.logger.trace("Retrieved relationship information for " + subjects.size() + " resources.");
            this.logger.trace("Formatting report output.");
            switch (this.format) {
                case LIST: {
                    writer = new ListOutputWriter();
                    break;
                }
                case CSV: {
                    writer = new CSVOutputWriter();
                    break;
                }
                default: {
                    writer = new ListOutputWriter();
                }
            }
            writer.setContentBatchUtil(this.contentBatchUtil);
            writer.setLookupService(this.lookupService);
            writer.setRelationshipTypeService(this.relationshipTypeService);
            writer.printOutput(report, this.outputFile);
            if (this.outputFile != null) {
                this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"RelationshipReporterUtility.Completed.fmt.txt", (Object)this.outputFile.getAbsolutePath()));
            }
        }
    }

    private RelationshipFilter createDefaultRelationshipFilter() {
        RelationshipFilter filter = new RelationshipFilter();
        filter.setDepth(1);
        filter.setDirection(DEFAULT_DIRECTION);
        filter.setRelationshipTypes(DEFAULT_RELATIONSHIP_TYPES);
        filter.setFilterTraversal(DEFAULT_FILTER_TRAVERSAL);
        return filter;
    }

    protected void displayHelp() {
        this.displayHelp(new String[]{RB.getStringResource("RelationshipReporterUtility.HelpUsage1.txt"), RB.getStringResource("RelationshipReporterUtility.HelpUsage2.txt"), RB.getStringResource("RelationshipReporterUtility.HelpUsage3.txt"), RB.getStringResource("RelationshipReporterUtility.HelpUsage4.txt"), RB.getStringResource("RelationshipReporterUtility.HelpUsage5.txt")});
    }

    @Override
    protected Options getCommandLineOptions(boolean forHelpText) {
        Options commandLineOptions = super.getCommandLineOptions(forHelpText);
        Option option = new Option(OPTION_FORMAT, true, RB.getStringResource("RelationshipReporterUtility.Option.Format.Desc.txt"));
        option.setArgName(RB.getStringResource("RelationshipReporterUtility.Option.Format.ArgName.txt"));
        option.setOptionalArg(false);
        commandLineOptions.addOption(option);
        option = new Option(OPTION_FILE, true, RB.getStringResource("RelationshipReporterUtility.Option.File.Desc.txt"));
        option.setArgName(RB.getStringResource("RelationshipReporterUtility.Option.File.ArgName.txt"));
        option.setOptionalArg(false);
        commandLineOptions.addOption(option);
        option = new Option(OPTION_REPORT, true, RB.getStringResource("RelationshipReporterUtility.Option.ReportType.Desc.txt"));
        option.setArgName(RB.getStringResource("RelationshipReporterUtility.Option.ReportType.ArgName.txt"));
        option.setOptionalArg(false);
        commandLineOptions.addOption(option);
        option = new Option(OPTION_REL, true, RB.getStringResource("RelationshipReporterUtility.Option.Rel.Desc.txt"));
        option.setOptionalArg(true);
        option.setArgName(RB.getStringResource("RelationshipReporterUtility.Option.Rel.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_REL_CONTENT, true, RB.getStringResource("RelationshipReporterUtility.Option.RelContent.Desc.txt"));
        option.setOptionalArg(true);
        option.setArgName(RB.getStringResource("RelationshipReporterUtility.Option.RelContent.ArgName.txt"));
        commandLineOptions.addOption(option);
        return commandLineOptions;
    }

    protected Options getCommandLineOptions(boolean forHelpText, String groupName) {
        Options commandLineOptions = super.getCommandLineOptions(forHelpText, groupName);
        if (OPTION_REL.equalsIgnoreCase(groupName)) {
            Option option = new Option(OPTION_DEPTH, true, RB.getStringResource("RelationshipReporterUtility.Option.Depth.Desc.txt"));
            option.setArgName(RB.getStringResource("RelationshipReporterUtility.Option.Depth.ArgName.txt"));
            commandLineOptions.addOption(option);
            option = new Option(OPTION_DIRECTION, true, RB.getStringResource("RelationshipReporterUtility.Option.Direction.Desc.txt"));
            option.setArgName(RB.getStringResource("RelationshipReporterUtility.Option.Direction.ArgName.txt"));
            commandLineOptions.addOption(option);
            option = new Option(OPTION_RELATIONSHIP_TYPES, true, RB.getStringResource("RelationshipReporterUtility.Option.RelationshipTypes.Desc.txt"));
            option.setArgName(RB.getStringResource("RelationshipReporterUtility.Option.RelationshipTypes.ArgName.txt"));
            option.setArgs(-2);
            commandLineOptions.addOption(option);
            option = new Option(OPTION_TRAVERSAL, true, RB.getStringResource("RelationshipReporterUtility.Option.Traversal.Desc.txt"));
            option.setArgName(RB.getStringResource("RelationshipReporterUtility.Option.Traversal.ArgName.txt"));
            commandLineOptions.addOption(option);
            option = new Option(OPTION_REL_ATTR_NAME, true, RB.getStringResource("RelationshipReporterUtility.Option.AttributeName.Desc.txt"));
            option.setArgName(RB.getStringResource("RelationshipReporterUtility.Option.AttributeName.ArgName.txt"));
            commandLineOptions.addOption(option);
            option = new Option(OPTION_REL_ATTR_VALUE, true, RB.getStringResource("RelationshipReporterUtility.Option.AttributeValue.Desc.txt"));
            option.setArgName(RB.getStringResource("RelationshipReporterUtility.Option.AttributeValue.ArgName.txt"));
            commandLineOptions.addOption(option);
        } else if (OPTION_REL_CONTENT.equalsIgnoreCase(groupName)) {
            this.relationshipContentFilterOptions = new RelationshipContentFilterOptions();
            this.relationshipContentFilterOptions.addToOptions(commandLineOptions);
        }
        return commandLineOptions;
    }

    @Override
    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        CommandLine cl;
        String fileName;
        if (!super.parse(args)) {
            return false;
        }
        if (this.commandLine.hasOption(OPTION_FORMAT)) {
            OutputFormat format = OutputFormat.getFormatForLabel(this.commandLine.getOptionValue(OPTION_FORMAT));
            if (format == null) {
                throw new ParseException(RB.getStringResource("RelationshipReporterUtility.InvalidFormat.txt"));
            }
            this.setFormat(format);
        }
        if ((fileName = this.commandLine.getOptionValue(OPTION_FILE)) != null) {
            this.setOutputFileName(fileName);
        }
        ReportType mode = ReportType.CUSTOM;
        if (this.commandLine.hasOption(OPTION_REPORT) && (mode = ReportType.getReportType(this.commandLine.getOptionValue(OPTION_REPORT))) == null) {
            throw new ParseException(RB.getStringResource("RelationshipReporterUtility.InvalidMode.txt"));
        }
        this.setReportType(mode);
        RelationshipFilter rf = this.createRelationshipFilter(mode);
        if (this.commandLine.hasOption(OPTION_REL)) {
            String attrName;
            String[] types;
            cl = this.getCommandLine(OPTION_REL);
            if (cl == null) {
                throw new ParseException(RB.getStringResource("RelationshipReporterUtility.ParseError.Rel.txt"));
            }
            if (cl.hasOption(OPTION_DEPTH)) {
                try {
                    int depth = Integer.parseInt(cl.getOptionValue(OPTION_DEPTH).trim());
                    rf.setDepth(depth);
                }
                catch (NumberFormatException e) {
                    throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"RelationshipReporterUtility.InvalidDepth.fmt.txt", (Object)cl.getOptionValue(OPTION_DEPTH)));
                }
            }
            if (cl.hasOption(OPTION_DIRECTION)) {
                String value = cl.getOptionValue(OPTION_DIRECTION);
                RelationshipDirection direction = RelationshipDirection.getDirectionByValue((String)value);
                if (direction == null || direction == RelationshipDirection.BOTH) {
                    throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"RelationshipReporterUtility.InvalidDirection.fmt.txt", (Object)value));
                }
                rf.setDirection(direction);
            }
            if (cl.hasOption(OPTION_RELATIONSHIP_TYPES) && (types = cl.getOptionValues(OPTION_RELATIONSHIP_TYPES)) != null && types.length > 0) {
                rf.setRelationshipTypes(Arrays.asList(types));
            }
            if (cl.hasOption(OPTION_TRAVERSAL)) {
                String value = cl.getOptionValue(OPTION_TRAVERSAL);
                RelationshipFilter.FilterTraversal traversal = RelationshipFilter.FilterTraversal.getTraversalForLabel((String)value);
                if (traversal == null) {
                    throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"RelationshipReporterUtility.InvalidTraversal.fmt.txt", (Object)value));
                }
                rf.setFilterTraversal(traversal);
            }
            if (cl.hasOption(OPTION_REL_ATTR_NAME) && (attrName = cl.getOptionValue(OPTION_REL_ATTR_NAME)) != null && attrName.length() > 0) {
                String attrValue = cl.getOptionValue(OPTION_REL_ATTR_VALUE);
                HashMap<String, String> attrs = new HashMap<String, String>(1);
                attrs.put(attrName, attrValue);
                rf.setAttributes(attrs);
            }
        }
        if (this.commandLine.hasOption(OPTION_REL_CONTENT)) {
            cl = this.getCommandLine(OPTION_REL_CONTENT);
            if (cl == null) {
                throw new ParseException(RB.getStringResource("RelationshipReporterUtility.ParseError.Content.txt"));
            }
            this.relationshipContentFilterOptions.parse(cl);
            rf.setContentFilter(this.relationshipContentFilterOptions.getFilter());
        }
        this.setRelationshipFilter(rf);
        List argList = this.commandLine.getArgList();
        if (argList != null && !argList.isEmpty()) {
            ContentFilterCriteria filter = this.filterOptions.getFilter();
            if (filter != null) {
                throw new ParseException(RB.getStringResource("RelationshipBatchUtility.InvalidFilteringWithArgs.txt"));
            }
            List<PathIdentifier> pathList = ContentBatchUtil.createPathIdentifierList(argList);
            this.setObjects(pathList);
        }
        return true;
    }

    protected List<String> getNestedOptionGroups() {
        ArrayList<String> groups = super.getNestedOptionGroups();
        if (groups == null) {
            groups = new ArrayList<String>();
        }
        groups.add(OPTION_REL);
        groups.add(OPTION_REL_CONTENT);
        return groups;
    }

    public static enum OutputFormat {
        LIST("list"),
        CSV("csv"),
        HTML("html");

        private String label;

        private OutputFormat(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static OutputFormat getFormatForLabel(String label) {
            if (LIST.getLabel().equalsIgnoreCase(label)) {
                return LIST;
            }
            if (CSV.getLabel().equalsIgnoreCase(label)) {
                return CSV;
            }
            if (HTML.getLabel().equalsIgnoreCase(label)) {
                return HTML;
            }
            return null;
        }
    }

    public static enum ReportType {
        LINEAGE("lineage"),
        IMPACT("impact"),
        DIRECT_DEPENDENCIES("directDependencies"),
        INDIRECT_DEPENDENCIES("indirectDependencies"),
        RESOURCES("resources"),
        CUSTOM("custom");

        private String label;

        private ReportType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static ReportType getReportType(String label) {
            if (LINEAGE.getLabel().equalsIgnoreCase(label)) {
                return LINEAGE;
            }
            if (IMPACT.getLabel().equalsIgnoreCase(label)) {
                return IMPACT;
            }
            if (DIRECT_DEPENDENCIES.getLabel().equalsIgnoreCase(label)) {
                return DIRECT_DEPENDENCIES;
            }
            if (INDIRECT_DEPENDENCIES.getLabel().equalsIgnoreCase(label)) {
                return INDIRECT_DEPENDENCIES;
            }
            if (RESOURCES.getLabel().equalsIgnoreCase(label)) {
                return RESOURCES;
            }
            if (CUSTOM.getLabel().equalsIgnoreCase(label)) {
                return CUSTOM;
            }
            return null;
        }
    }
}

