/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.relationship.batch;

import com.sas.svcs.common.client.ContentFilterCriteria;
import com.sas.svcs.common.client.ObjectIdentityUtils;
import com.sas.svcs.common.client.PathIdentifier;
import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.relationship.batch.ContentBatchUtil;
import com.sas.svcs.content.relationship.batch.RB;
import com.sas.svcs.content.relationship.batch.RelationshipBatchUtility;
import com.sas.svcs.content.relationship.client.loading.LoadReport;
import com.sas.svcs.content.relationship.client.loading.RelationshipLoadingService;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class RelationshipLoader
extends RelationshipBatchUtility {
    public static final String OPTION_CLEAN = "clean";
    public static final String OPTION_LOAD_ALL = "loadAll";
    private RelationshipLoadingService relationshipLoadingService;
    private boolean loadAllRelationships = false;
    private boolean clean = false;

    public RelationshipLoader() {
        super("sas-relationship-loader");
        this.setLogDecorations(true);
        this.setLogTimestamps(true);
    }

    public static void main(String[] args) {
        RelationshipLoader driver = new RelationshipLoader();
        driver.executeBatch(args);
    }

    public void setProcessAllContent(boolean loadAllRelationships) {
        this.loadAllRelationships = loadAllRelationships;
    }

    public boolean isProcessAllContent() {
        return this.loadAllRelationships;
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    public boolean isClean() {
        return this.clean;
    }

    @Override
    protected void initialize() throws Exception {
        super.initialize();
        this.relationshipLoadingService = (RelationshipLoadingService)this.applicationContext.getBean(RelationshipLoadingService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute() throws Exception {
        try {
            this.initialize();
            if (this.clean) {
                this.logger.info(RB.getStringResource("RelationshipLoaderUtility.Clean.Searching.txt"));
                List removedResources = this.relationshipLoadingService.removeOrphanedResources();
                this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"RelationshipLoaderUtility.Clean.Count.fmt.txt", (Object)removedResources.size()));
            } else if (this.loadAllRelationships) {
                this.logger.info(RB.getStringResource("RelationshipLoaderUtility.Loading.All.txt"));
                LoadReport report = this.relationshipLoadingService.loadAllRelationships();
                this.logReportInfo(report);
            } else if (this.objectList != null && !this.objectList.isEmpty()) {
                List<ContentComponent> contentObjects = this.getObjectsByPath(this.objectList);
                ArrayList<ObjectIdentity> identities = new ArrayList<ObjectIdentity>(contentObjects.size());
                for (ContentComponent content : contentObjects) {
                    identities.add(ObjectIdentityUtils.createObjectIdentity((Identifiable)content));
                }
                LoadReport report = this.relationshipLoadingService.loadRelationships(identities);
                this.logReportInfo(report);
            } else {
                ContentFilterCriteria filter = this.getFilterCriteria();
                if (filter != null) {
                    LoadReport report = this.relationshipLoadingService.loadRelationships(filter);
                    this.logReportInfo(report);
                }
            }
        }
        finally {
            this.terminate();
        }
        return this.returnCode;
    }

    private void logReportInfo(LoadReport report) {
        int subjectCount = report.getSubjectCount();
        int relationshipCount = report.getTotalRelationshipCount();
        this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"RelationshipLoaderUtility.Report.Count.fmt.txt", (Object)relationshipCount, (Object)subjectCount));
    }

    protected void displayHelp() {
        this.displayHelp(new String[]{RB.getStringResource("RelationshipLoaderUtility.HelpUsage.txt")});
    }

    @Override
    protected Options getCommandLineOptions(boolean forHelpText) {
        Options commandLineOptions = super.getCommandLineOptions(forHelpText);
        Option option = new Option(OPTION_LOAD_ALL, false, RB.getStringResource("RelationshipLoaderUtility.Option.LoadAll.Desc.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_CLEAN, false, RB.getStringResource("RelationshipLoaderUtility.Option.Clean.Desc.txt"));
        commandLineOptions.addOption(option);
        return commandLineOptions;
    }

    @Override
    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        if (!super.parse(args)) {
            return false;
        }
        ContentFilterCriteria filter = this.filterOptions.getFilter();
        boolean loadAll = this.commandLine.hasOption(OPTION_LOAD_ALL);
        boolean clean = this.commandLine.hasOption(OPTION_CLEAN);
        if (loadAll && clean) {
            throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"RelationshipBatchUtility.InvalidOptionCombo.fmt.txt", (Object)OPTION_LOAD_ALL, (Object)OPTION_CLEAN));
        }
        if (loadAll && filter != null) {
            throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"RelationshipBatchUtility.InvalidFilteringWithOption.fmt.txt", (Object)OPTION_LOAD_ALL));
        }
        if (clean && filter != null) {
            throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"RelationshipBatchUtility.InvalidFilteringWithOption.fmt.txt", (Object)OPTION_CLEAN));
        }
        List argList = this.commandLine.getArgList();
        if (argList != null && !argList.isEmpty()) {
            if (loadAll) {
                throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"RelationshipBatchUtility.InvalidOptionWithArgs.fmt.txt", (Object)OPTION_LOAD_ALL));
            }
            if (clean) {
                throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"RelationshipBatchUtility.InvalidOptionWithArgs.fmt.txt", (Object)OPTION_CLEAN));
            }
            if (filter != null) {
                throw new ParseException(RB.getStringResource("RelationshipBatchUtility.InvalidFilteringWithArgs.txt"));
            }
            List<PathIdentifier> pathList = ContentBatchUtil.createPathIdentifierList(argList);
            this.setObjects(pathList);
        }
        this.setProcessAllContent(loadAll);
        this.setClean(clean);
        return true;
    }
}

