/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.relationship.batch;

import com.sas.svcs.common.client.ContentFilterCriteria;
import com.sas.svcs.content.relationship.batch.ContentFilterOptions;
import com.sas.svcs.content.relationship.batch.RB;
import com.sas.svcs.content.relationship.client.report.RelationshipContentFilterCriteria;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class RelationshipContentFilterOptions
extends ContentFilterOptions {
    public static final String OPTION_ATTRIBUTE_NAME = "attrName";
    public static final String OPTION_ATTRIBUTE_VALUE = "attrValue";
    protected Map<String, String> attributes;

    @Override
    public ContentFilterCriteria getFilter() {
        this.setAttributes();
        return super.getFilter();
    }

    @Override
    protected void initializeFilter() {
        if (this.filter == null) {
            this.filter = new RelationshipContentFilterCriteria();
        }
    }

    private void setAttributes() {
        if (this.attributes != null) {
            this.initializeFilter();
            ((RelationshipContentFilterCriteria)this.filter).setAttributes(this.attributes);
        }
    }

    public void parse(CommandLine commandLine) {
        super.parse(commandLine);
        String attrName = commandLine.getOptionValue(OPTION_ATTRIBUTE_NAME);
        if (attrName != null && attrName.length() > 0) {
            String attrValue = commandLine.getOptionValue(OPTION_ATTRIBUTE_VALUE);
            this.attributes = new HashMap<String, String>(1);
            this.attributes.put(attrName, attrValue);
        }
    }

    public void addToOptions(Options options) {
        super.addToOptions(options);
        Option option = new Option(OPTION_ATTRIBUTE_NAME, true, RB.getStringResource("RelationshipContentFilterOptions.AttributeName.Desc.txt"));
        option.setArgName(RB.getStringResource("RelationshipContentFilterOptions.AttributeName.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_ATTRIBUTE_VALUE, true, RB.getStringResource("RelationshipContentFilterOptions.AttributeValue.Desc.txt"));
        option.setArgName(RB.getStringResource("RelationshipContentFilterOptions.AttributeValue.ArgName.txt"));
        options.addOption(option);
    }
}

