/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.relationship.batch;

import com.sas.svcs.common.client.Embeddable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.framework.client.ContentObjectDescriptor;
import com.sas.svcs.content.relationship.batch.OutputWriter;
import com.sas.svcs.content.relationship.batch.RB;
import com.sas.svcs.content.relationship.client.RelationshipDirection;
import com.sas.svcs.content.relationship.client.report.RelationshipDescriptor;
import com.sas.svcs.content.relationship.client.report.RelationshipReport;
import com.sas.svcs.content.relationship.client.report.ResourceDescriptor;
import com.sas.text.Message;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class ListOutputWriter
extends OutputWriter {
    private Map<ObjectIdentity, ContentComponent> parentCache;

    @Override
    protected String getFileExtension() {
        return "txt";
    }

    @Override
    protected void printOutput(RelationshipReport report, Writer writer) throws IOException {
        List subjects = report.getSubjects();
        for (ResourceDescriptor subject : subjects) {
            HashSet<ResourceDescriptor> resourceCache = new HashSet<ResourceDescriptor>();
            writer.write(this.getObjectString(subject));
            writer.write(NEW_LINE);
            this.printRelationships(subject, writer, 0, resourceCache);
            writer.write(NEW_LINE);
            writer.flush();
        }
    }

    private void printRelationships(ResourceDescriptor resource, Writer writer, int level, Set<ResourceDescriptor> resourceCache) throws IOException {
        if (resourceCache.contains(resource)) {
            return;
        }
        resourceCache.add(resource);
        List relationships = resource.getRelationships();
        if (!relationships.isEmpty()) {
            for (RelationshipDescriptor relationship : relationships) {
                ResourceDescriptor relatedResource = relationship.getRelatedResource();
                if (relatedResource == null) continue;
                writer.write(this.getObjectString(relatedResource, relationship, level));
                writer.write(NEW_LINE);
                this.printRelationships(relatedResource, writer, level + 1, resourceCache);
            }
        }
    }

    private String getRelationshipTypeLabel(RelationshipDescriptor relationship) {
        boolean directional = this.isRelationshipDirectional(relationship.getRelationshipType());
        RelationshipDirection direction = relationship.getDirection();
        if (directional && direction != null) {
            switch (direction) {
                case FROM: {
                    return this.getRelationshipTypePartnerLabel(relationship.getRelationshipType());
                }
            }
            return this.getRelationshipTypeLabel(relationship.getRelationshipType());
        }
        return this.getRelationshipTypeLabel(relationship.getRelationshipType());
    }

    private String getIndentation(int level) {
        String tab = "  ";
        for (int i = 0; i < level; ++i) {
            tab = tab + "    ";
        }
        return tab;
    }

    private String getObjectString(ContentComponent content) {
        String path;
        String label = content.getName();
        if (content instanceof ContentNode && (path = ((ContentNode)content).getPath()) != null) {
            label = path;
        }
        String typeName = this.contentBatchUtil.getDisplayType(content);
        return Message.format((ResourceBundle)RB.getResources(), (String)"ListOutputWriter.ObjectPath.fmt.txt", (Object)label, (Object)typeName);
    }

    private String getObjectString(ResourceDescriptor resource) {
        return this.getObjectString(resource.getContentObject());
    }

    private String getObjectString(ResourceDescriptor resource, RelationshipDescriptor relationship, int level) {
        ContentComponent parent;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getIndentation(level));
        sb.append(this.getRelationshipTypeLabel(relationship));
        sb.append(": ");
        sb.append(this.getObjectString(resource));
        if (resource.getContentObject() instanceof Embeddable && !"I".equalsIgnoreCase(relationship.getRelationshipType()) && null != (parent = this.getParent(resource))) {
            sb.append(" - ").append(RB.getStringResource("ListOutputWriter.In.txt")).append(" ").append(this.getObjectString(parent));
        }
        return sb.toString();
    }

    private ContentComponent getParent(ResourceDescriptor resource) {
        ObjectIdentity parentIdentity = ((Embeddable)resource.getContentObject()).getParentId();
        if (parentIdentity == null) {
            return null;
        }
        if (this.parentCache == null) {
            this.parentCache = new HashMap<ObjectIdentity, ContentComponent>();
        } else if (this.parentCache.containsKey(parentIdentity)) {
            return this.parentCache.get(parentIdentity);
        }
        ContentComponent parent = null;
        ContentObjectDescriptor parentDescriptor = this.fetchObject(parentIdentity);
        if (parentDescriptor != null) {
            parent = parentDescriptor.getContentObject();
        }
        this.parentCache.put(parentIdentity, parent);
        return parent;
    }
}

