/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.relationship.batch;

import com.sas.svcs.common.client.PathIdentifier;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentException;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import com.sas.svcs.content.objecttype.client.ObjectTypeUIDescriptor;
import com.sas.svcs.content.objecttype.client.ObjectTypeUIService;
import com.sas.svcs.content.relationship.batch.RB;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ContentBatchUtil {
    private Logger logger = LogManager.getLogger(Logger.class);
    private ObjectTypeService objectTypeService;
    private ObjectTypeUIService objectTypeUIService;

    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
    }

    public void setObjectTypeUIService(ObjectTypeUIService objectTypeUIService) {
        this.objectTypeUIService = objectTypeUIService;
    }

    public static PathIdentifier createPathIdentifier(String objectPath) {
        String typeString = null;
        int index = objectPath.lastIndexOf(40);
        if (index == -1) {
            typeString = "Folder";
        } else {
            int index2 = objectPath.indexOf(41, index + 1);
            typeString = objectPath.substring(index + 1, index2);
            objectPath = objectPath.substring(0, index);
        }
        return new PathIdentifier(objectPath, typeString);
    }

    public static List<PathIdentifier> createPathIdentifierList(List<String> objectPaths) {
        ArrayList<PathIdentifier> result = new ArrayList<PathIdentifier>();
        for (int i = 0; i < objectPaths.size(); ++i) {
            String pathString = objectPaths.get(i);
            String typeString = null;
            if (objectPaths.size() > i + 1) {
                typeString = objectPaths.get(i + 1);
            }
            PathIdentifier identifier = null;
            if (typeString != null && ContentBatchUtil.validateObjectType(typeString)) {
                ++i;
                identifier = new PathIdentifier(pathString, typeString);
            } else {
                identifier = ContentBatchUtil.createPathIdentifier(pathString);
            }
            result.add(identifier);
        }
        return result;
    }

    private static boolean validateObjectType(String typeString) {
        String regexp = "([a-zA-Z][^/()])+.([a-zA-Z][^/()])*";
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(typeString);
        return matcher.matches();
    }

    public long getTypeFromPathIdentifier(PathIdentifier path) {
        if (path.getTypeName() == null) {
            return 28L;
        }
        String typeString = path.getTypeName();
        ObjectType objectType = this.objectTypeService.getTypeByName(typeString);
        if (objectType != null) {
            return objectType.getId();
        }
        return -1L;
    }

    public ObjectType getObjectTypeFromPathIdentifier(PathIdentifier path) {
        String typeName = path.getTypeName();
        if (typeName == null) {
            typeName = "Folder";
        }
        return this.objectTypeService.getTypeByName(typeName);
    }

    public long getTypeFromName(String typeName) throws ContentException {
        ObjectType objectType = this.objectTypeService.getTypeByName(typeName);
        if (objectType == null) {
            throw new ContentException(Message.format((ResourceBundle)RB.getResources(), (String)"ContentServicesBatchUtility.InvalidType.fmt.txt", (Object)typeName));
        }
        return objectType.getId();
    }

    public String getDisplayType(String objectTypeName) {
        Locale locale = Locale.getDefault();
        String displayName = null;
        if (this.objectTypeUIService != null) {
            try {
                Properties localizedNames;
                ObjectTypeUIDescriptor descriptor = this.objectTypeUIService.getObjectTypeDescriptorByName(objectTypeName);
                if (descriptor != null && (localizedNames = descriptor.getLocalizedNames()) != null) {
                    displayName = localizedNames.getProperty(locale.toString());
                }
            }
            catch (Exception e) {
                this.logger.debug("Unable to retrieve localized type value for " + objectTypeName, (Throwable)e);
            }
        }
        return displayName == null ? objectTypeName : displayName;
    }

    public String getDisplayType(ContentComponent comp) {
        String typeName = comp.getObjectTypeName();
        return this.getDisplayType(typeName);
    }

    public String getObjectLabel(ContentComponent contentObject) {
        String path;
        String label = contentObject.getName();
        if (contentObject instanceof ContentNode && (path = ((ContentNode)contentObject).getPath()) != null) {
            label = path;
        }
        return label;
    }

    public List<String> includeSubtypes(List<String> typeNames) {
        List objectTypes = this.objectTypeService.getAllTypes();
        HashMap<String, HashSet<String>> parentTypeCache = new HashMap<String, HashSet<String>>();
        for (ObjectType objectType : objectTypes) {
            String parentType;
            String name = objectType.getName();
            int index = name.indexOf(46);
            if (index <= -1 || StringUtils.countMatches((CharSequence)name, (CharSequence)".") != 1 || this.objectTypeService.getTypeByName(parentType = name.substring(0, index)) == null) continue;
            HashSet<String> childTypes = (HashSet<String>)parentTypeCache.get(parentType);
            if (childTypes == null) {
                childTypes = new HashSet<String>();
                parentTypeCache.put(parentType, childTypes);
            }
            childTypes.add(name);
        }
        HashSet<String> typeValues = new HashSet<String>(typeNames);
        for (String type : typeNames) {
            Set childTypes;
            if (!parentTypeCache.containsKey(type) || (childTypes = (Set)parentTypeCache.get(type)) == null) continue;
            typeValues.addAll(childTypes);
        }
        return new ArrayList<String>(typeValues);
    }
}

