/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository.visuals;

import com.sas.report.repository.StartPFS;
import com.sas.report.repository.visuals.OpenSaveDialog;
import com.sas.services.ServiceException;
import com.sas.services.session.SessionContextInterface;
import java.awt.Button;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class PasswordDialog
extends JFrame {
    private static final String label_id = " UserID :";
    private static final String label_password = "Password:";
    private static final String label_domain = "Domain:";
    private static final String label_open = "Open";
    private static final String label_save = "Save";
    private static final String label_cancel = "Cancel";
    private String selection;
    private OpenSaveDialog testDialog;
    private boolean ok = false;
    Label nameLabel = new Label(" UserID :");
    Label passwordLabel = new Label("Password:");
    Label domainLabel = new Label("Domain:");
    TextField userTextField = new TextField(20);
    TextField passTextField = new TextField(20);
    TextField domainTextField = new TextField(20);
    Button openButton = new Button("Open");
    Button saveButton = new Button("Save");
    Button cancelButton = new Button("Cancel");

    public PasswordDialog() {
        super("PasswordDialog");
        this.setLF();
        this.enableEvents(64L);
        this.setSize(300, 150);
        this.setResizable(false);
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.anchor = 10;
        gc.insets = new Insets(5, 5, 5, 5);
        Panel display = new Panel(gb);
        gc.gridx = 0;
        gc.gridy = 0;
        gb.setConstraints(this.nameLabel, gc);
        display.add(this.nameLabel);
        gc.gridx = 1;
        gc.gridy = 0;
        gb.setConstraints(this.userTextField, gc);
        display.add(this.userTextField);
        gc.gridx = 0;
        gc.gridy = 1;
        gb.setConstraints(this.passwordLabel, gc);
        display.add(this.passwordLabel);
        gc.gridx = 1;
        gc.gridy = 1;
        gb.setConstraints(this.passTextField, gc);
        this.passTextField.setEchoChar('*');
        display.add(this.passTextField);
        gc.gridx = 0;
        gc.gridy = 2;
        gb.setConstraints(this.domainLabel, gc);
        display.add(this.domainLabel);
        gc.gridx = 1;
        gc.gridy = 2;
        gb.setConstraints(this.domainTextField, gc);
        display.add(this.domainTextField);
        this.getContentPane().add("Center", display);
        gb = new GridBagLayout();
        gc.fill = 2;
        gc.anchor = 10;
        gc.insets = new Insets(5, 5, 5, 5);
        Panel buttons = new Panel(gb);
        buttons.setSize(30, 150);
        gc.gridx = 0;
        gc.gridy = 0;
        gb.setConstraints(this.openButton, gc);
        buttons.add(this.openButton);
        gc.gridx = 1;
        gc.gridy = 0;
        gb.setConstraints(this.saveButton, gc);
        buttons.add(this.saveButton);
        gc.gridx = 2;
        gc.gridy = 0;
        gb.setConstraints(this.cancelButton, gc);
        buttons.add(this.cancelButton);
        this.getContentPane().add("South", buttons);
        this.userTextField.setText("omruser");
        this.passTextField.setText("DemoDemo1");
        this.domainTextField.setText(this.getDomain());
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent upOneLevelEvent) {
                String user = PasswordDialog.this.userTextField.getText();
                String pass = PasswordDialog.this.passTextField.getText();
                String domain = PasswordDialog.this.domainTextField.getText();
                try {
                    PasswordDialog.this.finish(user, pass, domain, 0);
                }
                catch (Exception e) {
                    System.out.println("error getting service");
                }
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent upOneLevelEvent) {
                String user = PasswordDialog.this.userTextField.getText();
                String pass = PasswordDialog.this.passTextField.getText();
                String domain = PasswordDialog.this.domainTextField.getText();
                try {
                    PasswordDialog.this.finish(user, pass, domain, 1);
                }
                catch (Exception e) {
                    System.out.println("CRITICAL ERROR: error trying to initiate open/save dialog");
                    e.printStackTrace();
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent upOneLevelEvent) {
                if (PasswordDialog.this.testDialog == null) {
                    System.exit(0);
                }
                PasswordDialog.this.selection = PasswordDialog.this.testDialog.getFolderSelected();
                System.out.println(">>>>>>>>>>>>" + PasswordDialog.this.selection);
                System.exit(0);
            }
        });
        this.validate();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (PasswordDialog.this.testDialog == null) {
                    System.exit(0);
                }
                PasswordDialog.this.selection = PasswordDialog.this.testDialog.getFolderSelected();
                System.out.println(">>>>>>>>>>>>" + PasswordDialog.this.selection);
                System.exit(0);
            }
        });
    }

    private void setLF() {
        String laf = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (UnsupportedLookAndFeelException exc) {
            System.err.println("Warning: UnsupportedLookAndFeel: " + laf);
        }
        catch (Exception exc) {
            System.err.println("Error loading " + laf + ": " + exc);
        }
    }

    public void finish(String user, String pass, String domain, int typeDialog) throws Exception {
        String configFile;
        Object userContext = null;
        SessionContextInterface sessionContext = null;
        System.out.println("USER: " + user + "  logged in ");
        System.out.println("Obtaining default software component...");
        String defaultComponent = StartPFS.getDefaultSoftwareComponentName();
        if (defaultComponent == null) {
            this.fail("StartPFS.getDefaultSoftwareComponentName() returned null");
        }
        if ((configFile = StartPFS.getDefaultDeploymentFileURL()) == null) {
            this.fail("StartPFS.getDefaultDeploymentFileURL() returned null");
        }
        System.out.println("Deploying platform services...");
        StartPFS.deployPlatformServices(configFile, defaultComponent);
        System.out.println("Initiating login process");
        try {
            System.out.println("Calling StartPFS.loginUser( user=" + user + ", password=" + pass + ", domain=" + domain + ")...");
            sessionContext = StartPFS.loginUser(user, pass, domain);
            if (sessionContext == null) {
                this.fail("StartPFS.loginUser(" + user + ", " + pass + ", " + domain + ") returned null");
            }
        }
        catch (RemoteException e) {
            System.err.println("Remote Exception encountered for user '" + user + "'");
            e.printStackTrace();
            throw e;
        }
        catch (ServiceException e) {
            System.err.println("ServiceException while getting user '" + user + "'");
            e.printStackTrace();
            String msg = "Bad User or Password";
            String emsg = e.getMessage();
            if (emsg != null) {
                int ndx = emsg.indexOf(46);
                if (ndx > 0) {
                    emsg = emsg.substring(0, ndx);
                }
                msg = msg + "\n" + emsg;
            }
            JOptionPane.showMessageDialog(this, msg, "Login Error", 0);
            throw e;
        }
        System.out.println("Obtained session for user " + user);
        String sessionId = null;
        try {
            sessionId = sessionContext.getEntityKey();
        }
        catch (RemoteException e) {
            System.err.println("Failed while trying to get an entity key");
            e.printStackTrace();
        }
        this.testDialog = typeDialog == 0 ? new OpenSaveDialog((Frame)this, sessionId, 0) : new OpenSaveDialog((Frame)this, sessionId, 1);
        this.testDialog.pack();
        this.testDialog.setVisible(true);
    }

    private void fail(String msg) {
        System.err.println("\nERROR\n" + msg + "\n...Exiting.");
        System.exit(-1);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public static void main(String[] args) {
        PasswordDialog frame = new PasswordDialog();
        frame.setVisible(true);
    }

    private String getDomain() {
        try {
            Configuration loginConfig = Configuration.getConfiguration();
            AppConfigurationEntry[] entries = loginConfig.getAppConfigurationEntry("PFS");
            for (int i = 0; i < entries.length; ++i) {
                AppConfigurationEntry entry = entries[i];
                Map<String, ?> map = entry.getOptions();
                String domain = (String)map.get("domain");
                if (domain == null) continue;
                return domain;
            }
            return "";
        }
        catch (Throwable t) {
            System.err.println("Trying to obtain JAAS login config: FAILED");
            t.printStackTrace();
            return "";
        }
    }
}

