/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository.visuals;

import com.sas.report.repository.DirectoryInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.Repository;
import com.sas.report.repository.RepositoryCreateException;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryFactory;
import com.sas.report.repository.RepositoryFilter;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryMessager;
import com.sas.report.repository.RepositoryNotDirectoryException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.report.repository.RepositoryResource;
import com.sas.report.repository.RepositoryUserInformation;
import com.sas.report.repository.SBIPURL;
import com.sas.report.repository.SortOrder;
import com.sas.report.repository.visuals.DuplicateNameException;
import com.sas.report.repository.visuals.GenericDialog;
import com.sas.report.repository.visuals.IllegalNameException;
import com.sas.report.repository.visuals.IllegalOpenException;
import com.sas.report.repository.visuals.IllegalSaveException;
import com.sas.report.repository.visuals.InputStreamException;
import com.sas.report.repository.visuals.InvalidDeletionException;
import com.sas.report.repository.visuals.InvalidDirectoryException;
import com.sas.report.repository.visuals.InvalidNewFolderException;
import com.sas.report.repository.visuals.InvalidPasteException;
import com.sas.report.repository.visuals.InvalidRenameException;
import com.sas.report.repository.visuals.NoNewLocationException;
import com.sas.report.repository.visuals.NoPasteEntryException;
import com.sas.report.repository.visuals.NoRepositoryServiceException;
import com.sas.report.repository.visuals.NotFoundException;
import com.sas.report.repository.visuals.OutputStreamException;
import com.sas.report.repository.visuals.SetFilter;
import com.sas.services.information.metadata.PathUrl;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

class GenericRepositoryAccess {
    private Repository reportRepository;
    private RepositoryFactory repositoryFactory;
    private RepositoryMessager messager;
    private RepositoryUserInformation userInformationProvider;
    private RepositoryFilter currentFilter = null;
    private DirectoryInterface rootDirectory;
    private DirectoryInterface currentDirectory;
    private DirectoryInterface storedDirectory;
    private EntryInterface currentEntry;
    private String folderTypeString;
    private String currentSelection = null;
    private String rootfolder;
    private String reportRepositoryName;
    private String sessionId;
    private Object fileStream;
    private List folders;
    private Vector entryData;
    private Vector typeData;
    private Vector repositoryList;
    private Vector repositories;
    private boolean isRepository;
    private GenericDialog dialog;
    private String pgm = "GenericRepositoryAccess";
    private String factorerr1 = RepositoryResource.getStringResource("factorerr1.txt");
    private String repobjerr1 = RepositoryResource.getStringResource("repobjerr1.txt");
    private String dirnull = RepositoryResource.getStringResource("dirnull.txt");
    private String emptyRList = RepositoryResource.getStringResource("emptyRepositoryList.txt");
    private String repStr = RepositoryResource.getStringResource("repStr.txt");
    private String rrConnectErrorMessage2 = RepositoryResource.getStringResource("rrConnectErrorMessage2.txt");
    private String rrConnectErrorMessage1 = RepositoryResource.getStringResource("rrConnectErrorMessage1.txt");
    private String rrConnectErrorTitle = RepositoryResource.getStringResource("rrConnectErrorTitle.txt");
    private String folderStr = RepositoryResource.getStringResource("folderStr.txt");
    private String entryStr = RepositoryResource.getStringResource("entryStr.txt");
    private String doesExist = RepositoryResource.getStringResource("doesExist.txt");
    private String typeRef = "type";
    private String createdRef = "Creation Date";
    private String lastModRef = "Modified Date";
    private String lastRefRef = "Reference Date";
    private String nameRef = "name";
    private String descRef = "description";
    private String authorRef = "Author";
    private String XMLfile = RepositoryResource.getStringResource("XMLfile.txt");
    private String fileName = null;
    private int entryIndexNumber;

    public GenericRepositoryAccess(GenericDialog dialog, String sessionId) throws NoRepositoryServiceException {
        this.dialog = dialog;
        this.sessionId = sessionId;
        try {
            this.initRepository();
        }
        catch (NoRepositoryServiceException e) {
            dialog.dispose();
            throw new NoRepositoryServiceException();
        }
    }

    public GenericRepositoryAccess() throws NoRepositoryServiceException {
        try {
            this.initRepository();
        }
        catch (NoRepositoryServiceException e) {
            throw new NoRepositoryServiceException();
        }
    }

    public void setFilter(String valueToFind) {
        if (valueToFind.equals(RepositoryResource.getStringResource("allFStr.txt"))) {
            this.currentFilter = null;
        } else {
            SetFilter currentFilter = new SetFilter(valueToFind);
            this.currentFilter = currentFilter;
        }
    }

    public RepositoryFilter getFilter(String valueToFind, int typeOfFind) {
        return this.currentFilter;
    }

    public RepositoryMessager getMessager() {
        return this.messager;
    }

    public String getPathURL() {
        String _e;
        PathUrl _path = null;
        StringBuffer buffer = new StringBuffer();
        if (this.currentEntry == null) {
            return null;
        }
        try {
            _path = this.currentEntry.getLocationUrl();
        }
        catch (RepositoryException e) {
            return null;
        }
        if (_path == null) {
            return null;
        }
        String _b = _path.getRepository();
        buffer.append("SBIP://" + _b);
        String _d = _path.getPath();
        if (_d != null) {
            buffer.append("/" + _d);
        }
        if ((_e = _path.getName()) != null) {
            buffer.append("/" + _e);
        }
        return buffer.toString();
    }

    private RepositoryUserInformation getUserInformationProvider() {
        return this.userInformationProvider;
    }

    public String getUserName() throws Exception {
        String _userName = null;
        try {
            _userName = this.userInformationProvider.getUserName();
        }
        catch (SecurityException esc) {
            throw new Exception();
        }
        catch (Exception esc) {
            throw new Exception();
        }
        return _userName;
    }

    public Vector getFolderListing() {
        Vector _directoryListing = new Vector();
        try {
            this.currentDirectory.list(_directoryListing);
        }
        catch (RepositoryException ex) {
            return null;
        }
        return _directoryListing;
    }

    public void disconnect() {
        if (this.reportRepository != null) {
            this.reportRepository.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAttribute(String attributeName, String attributeValue, String selectedEntry) throws Exception {
        EntryInterface _e = null;
        try {
            _e = this.currentDirectory.getEntry(selectedEntry);
        }
        catch (SecurityException ex) {
            this.messager.error(ex.getMessage());
            throw new Exception();
        }
        catch (RepositoryException ex) {
            this.messager.error(ex.getMessage());
            throw new Exception();
        }
        if (_e == null) return;
        try {
            if (attributeName.equals("TYPE")) {
                _e.setAttribute("type", attributeValue);
                return;
            }
            if (attributeName.equals("DESCRIPTION")) {
                _e.setAttribute("description", attributeValue);
                return;
            }
            if (attributeName.equals("LOCALE")) {
                _e.setAttribute("locale", attributeValue);
                return;
            }
            if (attributeName.equals("AUTHOR")) {
                _e.setAttribute("Author", attributeValue);
                return;
            }
            if (attributeName.equals("COMMENTS")) {
                _e.setAttribute("Comments", attributeValue);
                return;
            }
            if (!attributeName.equals("KEYWORD")) return;
            try {
                _e.removeAllKeywords();
            }
            catch (RepositoryException ex) {
                this.messager.error(ex.getMessage());
                throw new Exception();
            }
            String _a = attributeValue.trim();
            if (_a.equals("")) return;
            boolean _loop = true;
            int _indexInt = 0;
            Vector<String> _keys = new Vector<String>();
            while (_loop) {
                _indexInt = _a.indexOf(",");
                if (_indexInt == -1) {
                    if (_a.length() <= 0) return;
                    _keys.addElement(_a);
                    try {
                        _e.addKeywords(_keys);
                        return;
                    }
                    catch (RepositoryException ex) {
                        this.messager.error(ex.getMessage());
                        throw new Exception();
                    }
                }
                try {
                    _keys.addElement(_a.substring(0, _indexInt));
                    _e.addKeywords(_keys);
                    _a = _a.substring(_indexInt + 1);
                }
                catch (RepositoryException ex) {
                    this.messager.error(ex.getMessage());
                    throw new Exception();
                }
            }
            return;
        }
        catch (SecurityException ex) {
            this.messager.error(ex.getMessage());
            throw new Exception();
        }
        catch (RepositoryException ex) {
            this.messager.error(ex.getMessage());
            throw new Exception();
        }
    }

    public List findEntry(ArrayList criteria) {
        ArrayList foundEntries = new ArrayList();
        return foundEntries;
    }

    public Iterator getAttributes(String selectedEntry) {
        EntryInterface _e;
        try {
            _e = this.currentDirectory.getEntry(selectedEntry);
        }
        catch (RepositoryException ex) {
            this.messager.error(ex.getMessage());
            return null;
        }
        if (_e == null) {
            String[] _argString = new String[]{selectedEntry};
            String _message = RepositoryResource.getMessageString("nullFile.txt", 1, _argString);
            this.messager.error(_message);
            return null;
        }
        Iterator _it = null;
        try {
            _it = _e.getAttributes();
        }
        catch (RepositoryException exc) {
            this.messager.error(exc.getMessage());
            return null;
        }
        return _it;
    }

    public String getAttribute(String attributeName, String selectedEntry) {
        EntryInterface _e;
        String _attributeValue = null;
        try {
            _e = this.currentDirectory.getEntry(selectedEntry);
        }
        catch (SecurityException ex) {
            this.messager.error(ex.getMessage());
            return null;
        }
        catch (RepositoryException ex) {
            this.messager.error(ex.getMessage());
            return null;
        }
        if (_e == null) {
            String[] _argString = new String[]{selectedEntry};
            String _message = RepositoryResource.getMessageString("nullFile.txt", 1, _argString);
            this.messager.error(_message);
            return null;
        }
        try {
            Date d;
            if (attributeName.equals("LOCATION")) {
                _attributeValue = (String)_e.getAttribute("location");
            } else if (attributeName.equals("TYPE")) {
                _attributeValue = (String)_e.getAttribute("type");
            } else if (attributeName.equals("LOCALE")) {
                _attributeValue = (String)_e.getAttribute("locale");
            } else if (attributeName.equals("DESCRIPTION")) {
                _attributeValue = (String)_e.getAttribute("description");
            } else if (attributeName.equals("KEYWORD")) {
                _attributeValue = "";
                Iterator iter = _e.getKeywords();
                if (iter != null) {
                    while (iter.hasNext()) {
                        String _i = iter.next().toString();
                        _attributeValue = _attributeValue + _i + ",";
                    }
                    int _al = _attributeValue.length();
                    if (_al > 0) {
                        _attributeValue = _attributeValue.substring(0, _al - 1);
                    }
                } else {
                    _attributeValue = "";
                }
            } else if (attributeName.equals("AUTHOR")) {
                _attributeValue = (String)_e.getAttribute("Author");
            } else if (attributeName.equals("COMMENTS")) {
                _attributeValue = (String)_e.getAttribute("Comments");
            } else if (attributeName.equals("CREATION_DATE")) {
                Date d2 = (Date)_e.getAttribute("Creation Date");
                if (d2.getTime() > 0L) {
                    _attributeValue = d2.toString();
                }
            } else if (attributeName.equals("REFERENCE_DATE")) {
                Date d3 = (Date)_e.getAttribute("Reference Date");
                if (d3.getTime() > 0L) {
                    _attributeValue = d3.toString();
                }
            } else if (attributeName.equals("LAST_MODIFIED") && (d = (Date)_e.getAttribute("Modified Date")).getTime() > 0L) {
                _attributeValue = d.toString();
            }
        }
        catch (RepositoryException ex) {
            this.messager.error(ex.getMessage());
            return null;
        }
        return _attributeValue;
    }

    public Object accessFile(String selectedFile, int typeOfProcess, String typeOfExt) throws IllegalSaveException, IllegalOpenException, DuplicateNameException, IllegalNameException, NotFoundException {
        EntryInterface _saveEntry = null;
        Closeable _fout = null;
        String _tempName = selectedFile;
        if (selectedFile.indexOf(".") != -1) {
            _tempName = selectedFile.substring(0, selectedFile.indexOf("."));
        }
        String[] _argString = new String[]{_tempName};
        if (this.currentDirectory == null) {
            if (typeOfProcess == 1) {
                String _i = RepositoryResource.getMessageString("replocerr.txt", 1, _argString);
                this.messager.error(_i);
                throw new IllegalSaveException();
            }
            String _i = RepositoryResource.getMessageString("replocerr.txt", 1, _argString);
            this.messager.error(_i);
            throw new IllegalOpenException();
        }
        if (typeOfProcess == 1) {
            try {
                _saveEntry = this.currentDirectory.createEntry(selectedFile.trim());
            }
            catch (SecurityException ex) {
                String _i = RepositoryResource.getMessageString("GenericRepositoryAccesssaveSecurity.txt", 1, _argString);
                this.messager.error(_i);
                throw new IllegalSaveException();
            }
            catch (RepositoryNotDirectoryException ex) {
                String _i = RepositoryResource.getMessageString("GenericRepositoryAccesssaveDirNotFound.txt", 1, _argString);
                this.messager.error(_i);
                throw new IllegalSaveException();
            }
            catch (RepositoryLockedException ex) {
                String _i = RepositoryResource.getMessageString("GenericRepositoryAccesssaveRepLock.txt", 1, _argString);
                this.messager.error(_i);
                throw new IllegalSaveException();
            }
            catch (RepositoryIllegalNameException ex) {
                throw new IllegalNameException();
            }
            catch (RepositoryDuplicateNameException ex) {
                if (this.dialog != null) {
                    String _message = RepositoryResource.getMessageString("doesExist.txt", 1, _argString);
                    int result = this.dialog.showWarnDialog(_message);
                    switch (result) {
                        case 0: {
                            try {
                                _saveEntry = this.currentDirectory.getEntry(selectedFile);
                                break;
                            }
                            catch (SecurityException exc) {
                                String _i = RepositoryResource.getMessageString("GenericRepositoryAccesssaveSecurity.txt", 1, _argString);
                                this.messager.error(_i);
                                throw new IllegalNameException();
                            }
                            catch (RepositoryNotFoundException exc) {
                                throw new NotFoundException();
                            }
                            catch (RepositoryIllegalNameException exc) {
                                throw new IllegalNameException();
                            }
                            catch (RepositoryException exc) {
                                String _i = RepositoryResource.getMessageString("GenericRepositoryAccesssaveBadRep.txt", 1, _argString);
                                this.messager.error(_i);
                                throw new IllegalNameException();
                            }
                        }
                        case 1: {
                            throw new DuplicateNameException();
                        }
                    }
                }
                throw new DuplicateNameException();
            }
            catch (RepositoryException ex) {
                String _i = RepositoryResource.getMessageString("GenericRepositoryAccesssaveBadRep.txt", 1, _argString);
                this.messager.error(_i);
                throw new IllegalSaveException();
            }
            if (_saveEntry != null) {
                if (typeOfExt == null) {
                    typeOfExt = RepositoryResource.getStringResource("xmlType.txt");
                }
                HashMap<String, String> _attributes = new HashMap<String, String>();
                _attributes.put(this.typeRef, typeOfExt);
                try {
                    _saveEntry.setAttributes(_attributes);
                }
                catch (RepositoryException ex) {
                    String _i = RepositoryResource.getMessageString("GenericRepositoryAccesssaveBadRep.txt", 1, _argString);
                    this.messager.error(_i);
                    throw new IllegalSaveException();
                }
                boolean getStream = true;
                if (typeOfExt.equals(RepositoryResource.getStringResource("storeType.txt"))) {
                    getStream = false;
                } else if (typeOfExt.equals(RepositoryResource.getStringResource("iqType.txt"))) {
                    getStream = false;
                }
                if (getStream) {
                    OutputStream _fileStream;
                    try {
                        _fileStream = _saveEntry.getOutputStream();
                    }
                    catch (RepositoryException ex) {
                        String _i = RepositoryResource.getMessageString("GenericRepositoryAccessstreamBadRep.txt", 1, _argString);
                        this.messager.error(_i);
                        throw new IllegalSaveException();
                    }
                    _fout = _fileStream;
                }
            }
        } else {
            EntryInterface _openEntry;
            try {
                _openEntry = this.currentDirectory.getEntry(selectedFile);
            }
            catch (SecurityException ex) {
                String _i = RepositoryResource.getMessageString("GenericRepositoryAccessopenSecurity.txt", 1, _argString);
                this.messager.error(_i);
                throw new IllegalOpenException();
            }
            catch (RepositoryNotFoundException ex) {
                throw new NotFoundException();
            }
            catch (RepositoryIllegalNameException ex) {
                throw new IllegalNameException();
            }
            catch (RepositoryException ex) {
                String _i = RepositoryResource.getMessageString("GenericRepositoryAccessopenBadRep.txt", 1, _argString);
                this.messager.error(_i);
                throw new IllegalOpenException();
            }
            boolean getStream = true;
            if (typeOfExt.equals(RepositoryResource.getStringResource("storeType.txt"))) {
                getStream = false;
            } else if (typeOfExt.equals(RepositoryResource.getStringResource("iqType.txt"))) {
                getStream = false;
            }
            if (_openEntry != null) {
                if (getStream) {
                    InputStream _fileStream;
                    try {
                        _fileStream = _openEntry.getInputStream();
                    }
                    catch (RepositoryIOException ex) {
                        String _i = RepositoryResource.getMessageString("GenericRepositoryAccessstreamBadRep.txt", 1, _argString);
                        this.messager.error(_i);
                        throw new IllegalOpenException();
                    }
                    _fout = _fileStream;
                }
            } else {
                throw new NotFoundException();
            }
        }
        return _fout;
    }

    public boolean isRepository() {
        return this.isRepository;
    }

    public void addFolder(String newFolder) throws InvalidNewFolderException, DuplicateNameException {
        DirectoryInterface _new = null;
        try {
            _new = this.currentDirectory.createDirectory(newFolder);
        }
        catch (SecurityException exc) {
            throw new InvalidNewFolderException(exc.getMessage());
        }
        catch (RepositoryCreateException exc) {
            throw new InvalidNewFolderException(exc.getMessage());
        }
        catch (RepositoryLockedException exc) {
            throw new InvalidNewFolderException(exc.getMessage());
        }
        catch (RepositoryIllegalNameException exc) {
            throw new InvalidNewFolderException(exc.getMessage());
        }
        catch (RepositoryDuplicateNameException exc) {
            throw new DuplicateNameException();
        }
        catch (RepositoryException ex) {
            throw new InvalidNewFolderException(ex.getMessage());
        }
        this.rootDirectory = this.getRoot();
    }

    private void initRepository() throws NoRepositoryServiceException {
        this.repositories = new Vector();
        this.entryData = new Vector();
        this.typeData = new Vector();
        this.folders = new ArrayList();
        this.isRepository = true;
        if (this.sessionId == null) {
            System.out.println(RepositoryResource.getStringResource("GenericRepositoryAccessnotFactNoSession.txt"));
            System.out.println(this.factorerr1);
            throw new NoRepositoryServiceException();
        }
        try {
            this.repositoryFactory = new RepositoryFactory(this.sessionId);
        }
        catch (RepositoryException e) {
            System.out.println(RepositoryResource.getStringResource("factorException.txt"));
            System.out.println(this.factorerr1);
            throw new NoRepositoryServiceException();
        }
        if (this.repositoryFactory == null) {
            System.out.println(this.factorerr1);
            System.out.println(RepositoryResource.getStringResource("factornull.txt"));
            throw new NoRepositoryServiceException();
        }
        try {
            List rList = this.repositoryFactory.getReportRepositories();
            this.repositoryList = new Vector();
            this.repositoryList.addAll(rList);
        }
        catch (RepositoryException e) {
            System.out.println(RepositoryResource.getStringResource("errorRepositoryList.txt"));
            throw new NoRepositoryServiceException();
        }
        if (this.repositoryList.size() == 0) {
            System.out.println(this.emptyRList);
            throw new NoRepositoryServiceException();
        }
        Repository _rR = (Repository)this.repositoryList.get(0);
        this.messager = _rR.getRepositoryMessager();
        this.userInformationProvider = _rR.getUserInformationProvider();
        if (this.repositoryList == null) {
            this.reportRepositoryName = this.rrConnectErrorMessage1;
            this.setErrorVector(this.repositoryList);
            throw new NoRepositoryServiceException();
        }
    }

    public static OutputStream getOutputStreamOnly(String fullFileName, String sessionId) throws NoRepositoryServiceException, IllegalSaveException, NotFoundException, OutputStreamException {
        String _i;
        OutputStream _fileStream;
        Vector<String> typeLabels = new Vector<String>();
        Vector<String> typePointers = new Vector<String>();
        String[] _argString = new String[]{fullFileName};
        typePointers.addElement("xml");
        typePointers.addElement("pck");
        typePointers.addElement("erp");
        typePointers.addElement("erf");
        typePointers.addElement("html");
        typePointers.addElement("htm");
        typePointers.addElement("jpeg");
        typePointers.addElement("pdf");
        typePointers.addElement("tif");
        typePointers.addElement("tiff");
        typePointers.addElement("gif");
        typeLabels.addElement(RepositoryResource.getStringResource("xmlType.txt"));
        typeLabels.addElement(RepositoryResource.getStringResource("pckType.txt"));
        typeLabels.addElement(RepositoryResource.getStringResource("erpType.txt"));
        typeLabels.addElement(RepositoryResource.getStringResource("erfType.txt"));
        typeLabels.addElement(RepositoryResource.getStringResource("htmlType.txt"));
        typeLabels.addElement(RepositoryResource.getStringResource("htmlType.txt"));
        typeLabels.addElement(RepositoryResource.getStringResource("jpegType.txt"));
        typeLabels.addElement(RepositoryResource.getStringResource("pdfType.txt"));
        typeLabels.addElement(RepositoryResource.getStringResource("tifType.txt"));
        typeLabels.addElement(RepositoryResource.getStringResource("tifType.txt"));
        typeLabels.addElement(RepositoryResource.getStringResource("gifType.txt"));
        RepositoryFactory _rF = null;
        if (sessionId == null) {
            System.out.println(RepositoryResource.getStringResource("GenericRepositoryAccessnotFactNoSession.txt"));
            System.out.println(RepositoryResource.getStringResource("factorerr1.txt"));
            throw new NoRepositoryServiceException();
        }
        try {
            _rF = new RepositoryFactory(sessionId);
        }
        catch (RepositoryException e) {
            String _message = RepositoryResource.getMessageString("GenericRepositoryAccessnotFact.txt", 1, _argString);
            System.out.println(_message);
            throw new NoRepositoryServiceException();
        }
        if (_rF == null) {
            System.out.println(RepositoryResource.getStringResource("factorerr1.txt"));
            throw new NoRepositoryServiceException();
        }
        SBIPURL _srrp = new SBIPURL(fullFileName);
        Repository _rr = null;
        try {
            _rr = _rF.getRepository(_srrp.getRepository());
        }
        catch (RepositoryException ex) {
            String _message = RepositoryResource.getMessageString("GenericRepositoryAccessopenBadRep.txt", 1, _argString);
            System.out.println(_message);
            throw new NoRepositoryServiceException();
        }
        DirectoryInterface _root = null;
        DirectoryInterface _location = null;
        EntryInterface _saveEntry = null;
        if (_rr == null) {
            System.out.println(RepositoryResource.getStringResource("factorerr1.txt"));
            throw new NoRepositoryServiceException();
        }
        try {
            _root = _rr.getDirectory(_rr.getRootDirectory());
        }
        catch (RepositoryNotFoundException ex) {
            String _message = RepositoryResource.getMessageString("GenericRepositoryAccesssaveDirNotFound.txt", 1, _argString);
            System.out.println(_message);
            throw new NoRepositoryServiceException();
        }
        catch (RepositoryException ex) {
            String _message = RepositoryResource.getMessageString("GenericRepositoryAccessopenBadRep.txt", 1, _argString);
            System.out.println(_message);
            throw new NoRepositoryServiceException();
        }
        catch (SecurityException ex) {
            String _message = RepositoryResource.getMessageString("GenericRepositoryAccessopenSecurity.txt", 1, _argString);
            System.out.println(_message);
            throw new NoRepositoryServiceException();
        }
        String _fullDir = _srrp.getFile();
        int _pos = _fullDir.lastIndexOf("/");
        if (_pos == -1) {
            _pos = _fullDir.lastIndexOf("\\");
        }
        String _currentDir = _fullDir.substring(0, _pos);
        String _fileName = _fullDir.substring(_pos + 1);
        try {
            _location = _root.getDirectory(_currentDir);
        }
        catch (SecurityException exc) {
            String _message = RepositoryResource.getMessageString("GenericRepositoryAccessopenSecurity.txt", 1, _argString);
            System.out.println(_message);
            throw new NotFoundException();
        }
        catch (RepositoryException exc) {
            String _message = RepositoryResource.getMessageString("GenericRepositoryAccesssaveDirNotFound.txt", 1, _argString);
            System.out.println(_message);
            throw new NotFoundException();
        }
        if (_location == null) {
            String _message = RepositoryResource.getMessageString("GenericRepositoryAccesssaveDirNotFound.txt", 1, _argString);
            System.out.println(_message);
            throw new NotFoundException();
        }
        try {
            _saveEntry = _location.getEntry(_fileName);
        }
        catch (SecurityException exc) {
            String _i2 = RepositoryResource.getMessageString("GenericRepositoryAccesssaveSecurity.txt", 1, _argString);
            System.out.println(_i2);
            throw new IllegalSaveException();
        }
        catch (RepositoryNotFoundException exc) {
            _saveEntry = null;
        }
        catch (RepositoryException exc) {
            String _i3 = RepositoryResource.getMessageString("GenericRepositoryAccesssaveBadRep.txt", 1, _argString);
            System.out.println(_i3);
            throw new IllegalSaveException();
        }
        if (_saveEntry == null) {
            boolean _updateAttributes = true;
            try {
                _saveEntry = _location.createEntry(_fileName);
            }
            catch (RepositoryDuplicateNameException ex) {
                _updateAttributes = true;
            }
            catch (RepositoryException ex) {
                String _message = RepositoryResource.getMessageString("GenericRepositoryAccesssaveBadRep.txt", 1, _argString);
                System.out.println(_message);
                throw new NoRepositoryServiceException();
            }
            if (_updateAttributes) {
                HashMap<String, String> _attributes = new HashMap<String, String>();
                _attributes.put("type", RepositoryResource.getStringResource("xmlType.txt"));
                try {
                    _saveEntry.setAttributes(_attributes);
                }
                catch (SecurityException ex) {
                    String _i4 = RepositoryResource.getMessageString("GenericRepositoryAccesssaveSecurity.txt", 1, _argString);
                    System.out.println(_i4);
                    throw new IllegalSaveException();
                }
                catch (RepositoryLockedException ex) {
                    String _i5 = RepositoryResource.getMessageString("GenericRepositoryAccesssaveRepLock.txt", 1, _argString);
                    System.out.println(_i5);
                    throw new IllegalSaveException();
                }
                catch (RepositoryException ex) {
                    String _message = RepositoryResource.getMessageString("GenericRepositoryAccesssaveBadRep.txt", 1, _argString);
                    System.out.println(_message);
                    throw new IllegalSaveException();
                }
            }
        }
        try {
            _fileStream = _saveEntry.getOutputStream();
        }
        catch (RepositoryException ex) {
            _i = RepositoryResource.getMessageString("GenericRepositoryAccesssaveBadRep.txt", 1, _argString);
            System.out.println(_i);
            throw new OutputStreamException();
        }
        catch (SecurityException ex) {
            _i = RepositoryResource.getMessageString("GenericRepositoryAccesssaveSecurity.txt", 1, _argString);
            System.out.println(_i);
            throw new OutputStreamException();
        }
        if (_fileStream == null) {
            String _i6 = RepositoryResource.getMessageString("GenericRepositoryAccessstreamBadRep.txt", 1, _argString);
            System.out.println(_i6);
            throw new OutputStreamException();
        }
        _rr.close();
        return _fileStream;
    }

    public static InputStream getInputStreamOnly(String fullFileName, String sessionId) throws NoRepositoryServiceException, IllegalOpenException, InputStreamException, NotFoundException {
        InputStream _fileStream;
        RepositoryFactory _rF = null;
        String[] _argString = new String[]{fullFileName};
        if (sessionId == null) {
            System.out.println(RepositoryResource.getStringResource("GenericRepositoryAccessnotFactNoSession.txt"));
            System.out.println(RepositoryResource.getStringResource("factorerr1.txt"));
            throw new NoRepositoryServiceException();
        }
        try {
            _rF = new RepositoryFactory(sessionId);
        }
        catch (RepositoryException e) {
            String _message = RepositoryResource.getMessageString("GenericRepositoryAccessnotFact.txt", 1, _argString);
            System.out.println(_message);
            throw new NoRepositoryServiceException();
        }
        if (_rF == null) {
            System.out.println(RepositoryResource.getStringResource("factorerr1.txt"));
            throw new NoRepositoryServiceException();
        }
        SBIPURL _srrp = new SBIPURL(fullFileName);
        Repository _rr = null;
        try {
            _rr = _rF.getRepository(_srrp.getRepository());
        }
        catch (RepositoryException ex) {
            String _message = RepositoryResource.getMessageString("GenericRepositoryAccessopenBadRep.txt", 1, _argString);
            System.out.println(_message);
            throw new NoRepositoryServiceException();
        }
        DirectoryInterface _root = null;
        EntryInterface _entry = null;
        if (_rr == null) {
            System.out.println(RepositoryResource.getStringResource("factorerr1.txt"));
            throw new NoRepositoryServiceException();
        }
        try {
            _root = _rr.getDirectory(_rr.getRootDirectory());
        }
        catch (RepositoryNotFoundException ex) {
            String _message = RepositoryResource.getMessageString("GenericRepositoryAccesssaveDirNotFound.txt", 1, _argString);
            System.out.println(_message);
            throw new NotFoundException();
        }
        catch (RepositoryException ex) {
            String _message = RepositoryResource.getMessageString("GenericRepositoryAccessopenBadRep.txt", 1, _argString);
            System.out.println(_message);
            throw new IllegalOpenException();
        }
        catch (SecurityException ex) {
            String _i = RepositoryResource.getMessageString("GenericRepositoryAccessopenSecurity.txt", 1, _argString);
            System.out.println(_i);
            throw new IllegalOpenException();
        }
        try {
            _entry = _root.getEntry(_srrp.getFile());
        }
        catch (SecurityException ex) {
            String _i = RepositoryResource.getMessageString("GenericRepositoryAccessopenSecurity.txt", 1, _argString);
            System.out.println(_i);
            throw new IllegalOpenException();
        }
        catch (RepositoryException ex) {
            String _i = RepositoryResource.getMessageString("GenericRepositoryAccessopenBadRep.txt", 1, _argString);
            System.out.println(_i);
            throw new IllegalOpenException();
        }
        if (_entry == null) {
            String _i = RepositoryResource.getMessageString("GenericRepositoryAccessopenBadRep.txt", 1, _argString);
            System.out.println(_i);
            throw new IllegalOpenException();
        }
        try {
            _fileStream = _entry.getInputStream();
        }
        catch (RepositoryException ex) {
            String _message = RepositoryResource.getMessageString("GenericRepositoryAccesssaveBadRep.txt", 1, _argString);
            System.out.println(_message);
            throw new InputStreamException();
        }
        catch (SecurityException ex) {
            String _i = RepositoryResource.getMessageString("GenericRepositoryAccesssaveSecurity.txt", 1, _argString);
            System.out.println(_i);
            throw new InputStreamException();
        }
        if (_fileStream == null) {
            String _i = RepositoryResource.getMessageString("GenericRepositoryAccessopenBadRep.txt", 1, _argString);
            System.out.println(_i);
            throw new InputStreamException();
        }
        _rr.close();
        return _fileStream;
    }

    public void storeDirectory() {
        this.storedDirectory = this.currentDirectory;
    }

    public void pasteEntry(String entryName, boolean isMove) throws InvalidPasteException, DuplicateNameException, IllegalNameException, NoNewLocationException, NoPasteEntryException, NotFoundException {
        EntryInterface _e;
        if (this.currentEntry == null) {
            throw new NoNewLocationException();
        }
        if (this.storedDirectory == null) {
            throw new NoPasteEntryException();
        }
        try {
            _e = this.storedDirectory.getEntry(entryName);
        }
        catch (RepositoryException ex) {
            throw new InvalidPasteException(ex.getMessage());
        }
        if (_e == null) {
            throw new NotFoundException();
        }
        if (!isMove) {
            DirectoryInterface _d = this.currentDirectory;
            try {
                _e.copyTo(_d);
            }
            catch (RepositoryIllegalNameException ex) {
                throw new IllegalNameException();
            }
            catch (RepositoryNotFoundException ex) {
                throw new InvalidPasteException(ex.getMessage());
            }
            catch (RepositoryDuplicateNameException ex) {
                throw new DuplicateNameException();
            }
            catch (RepositoryLockedException ex) {
                throw new InvalidPasteException(ex.getMessage());
            }
            catch (RepositoryException ex) {
                throw new InvalidPasteException(ex.getMessage());
            }
        }
        try {
            _e.moveTo(this.currentEntry);
        }
        catch (RepositoryIllegalNameException ex) {
            throw new IllegalNameException();
        }
        catch (RepositoryNotFoundException ex) {
            throw new InvalidPasteException(ex.getMessage());
        }
        catch (RepositoryDuplicateNameException ex) {
            throw new DuplicateNameException();
        }
        catch (RepositoryLockedException ex) {
            throw new InvalidPasteException(ex.getMessage());
        }
        catch (RepositoryException ex) {
            throw new InvalidPasteException(ex.getMessage());
        }
    }

    public String getParent() throws Exception {
        String parentStr = null;
        try {
            parentStr = this.currentDirectory.getParent();
        }
        catch (RepositoryException exc) {
            this.messager.error(exc.getMessage());
            throw new Exception();
        }
        return parentStr;
    }

    public String getEntryType(String entryName) {
        EntryInterface _e = null;
        String _type = null;
        if (this.currentDirectory != null) {
            try {
                _e = this.currentDirectory.getEntry(entryName);
            }
            catch (RepositoryException exc) {
                _type = null;
                _e = null;
            }
        }
        if (_e != null) {
            try {
                _type = (String)_e.getAttribute("type");
            }
            catch (RepositoryException ex) {
                _type = null;
            }
        }
        if (_type != null) {
            return _type;
        }
        return this.getType(_e);
    }

    private String getType(EntryInterface _ee) {
        if (this.repositoryList.size() == 0) {
            return this.repStr;
        }
        this.isRepository = this.repositories.contains(_ee.toString());
        if (this.isRepository) {
            return this.repStr;
        }
        if (_ee == null) {
            return this.folderStr;
        }
        boolean _isfolder = _ee.isDirectory();
        if (_isfolder) {
            return this.folderStr;
        }
        return this.entryStr;
    }

    public DirectoryInterface getRoot() {
        try {
            String _home = this.reportRepository.getRootDirectory();
            this.rootDirectory = this.reportRepository.getDirectory(_home);
        }
        catch (IllegalStateException ex) {
            this.messager.error(ex.getMessage());
            return null;
        }
        catch (RepositoryNotFoundException ex) {
            this.messager.error(ex.getMessage());
            return null;
        }
        catch (RepositoryException ex) {
            this.messager.error(ex.getMessage());
            return null;
        }
        return this.rootDirectory;
    }

    public Vector getRepositoryFolders() {
        this.entryData.clear();
        this.repositories.clear();
        this.reportRepositoryName = null;
        this.currentDirectory = null;
        this.currentEntry = null;
        this.typeData.clear();
        this.isRepository = true;
        for (int j = 0; j < this.repositoryList.size(); ++j) {
            Vector<String> _entryDataRow = new Vector<String>();
            String _name = this.repositoryList.get(j).toString();
            this.repositories.add(_name);
            _entryDataRow.add(_name);
            this.reportRepositoryName = _name;
            _entryDataRow.add(this.repStr);
            String _noRepAuthor = RepositoryResource.getStringResource(this.pgm + "noRepAuthor.txt");
            String _noRepCre = RepositoryResource.getStringResource(this.pgm + "noRepCre.txt");
            String _noRepMod = RepositoryResource.getStringResource(this.pgm + "noRepMod.txt");
            _entryDataRow.add(_noRepAuthor);
            _entryDataRow.add(_noRepCre);
            _entryDataRow.add(_noRepMod);
            this.entryData.add(_entryDataRow);
            this.typeData.add(this.repStr);
        }
        return this.entryData;
    }

    public String getCurrentLocation() {
        if (this.currentEntry != null) {
            return this.currentEntry.toString();
        }
        return null;
    }

    public DirectoryInterface getCurrentFolder() {
        DirectoryInterface _folder = this.currentDirectory;
        return _folder;
    }

    public String getCurrentPathName() {
        if (this.currentDirectory != null) {
            DirectoryInterface _folder = this.currentDirectory;
            return _folder.toString();
        }
        return "";
    }

    public String getFolderName() {
        String _folderName = this.currentSelection;
        return _folderName;
    }

    public String getCurrentEntryString() {
        if (this.currentEntry != null) {
            return this.currentEntry.toString();
        }
        return null;
    }

    public EntryInterface getCurrentEntry() {
        return this.currentEntry;
    }

    public String getCurrentEntryName() {
        PathUrl _path = null;
        String name = null;
        if (this.currentEntry == null) {
            return name;
        }
        try {
            _path = this.currentEntry.getLocationUrl();
            if (_path != null) {
                name = _path.getName();
            }
            if (name == null) {
                name = _path.getRepository();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return name;
    }

    public boolean isValidRepository(String location) {
        SBIPURL _srrp = new SBIPURL(location);
        if (_srrp == null) {
            return false;
        }
        try {
            this.reportRepository = this.repositoryFactory.getRepository(_srrp.getRepository());
            if (this.reportRepository == null) {
                return false;
            }
        }
        catch (RepositoryException e) {
            return false;
        }
        return true;
    }

    public boolean checkLocation(String location) {
        String _currentProtocol = this.getRepositoryProtocol();
        if (location.equals(_currentProtocol)) {
            return true;
        }
        SBIPURL _srrp = new SBIPURL(location);
        try {
            this.reportRepository = this.repositoryFactory.getRepository(_srrp.getRepository());
            if (this.reportRepository == null) {
                return false;
            }
        }
        catch (RepositoryException e) {
            return false;
        }
        this.reportRepositoryName = this.reportRepository.toString();
        String _fileName = null;
        this.rootDirectory = this.getRoot();
        if (this.rootDirectory == null) {
            return false;
        }
        if (this.rootDirectory.toString().equals(location)) {
            this.currentDirectory = this.rootDirectory;
            this.currentEntry = this.rootDirectory;
        } else {
            try {
                _fileName = _srrp.getFile();
                if (_fileName.equals("BIP Tree/")) {
                    return true;
                }
                if (_fileName.equals("BIP Tree")) {
                    return true;
                }
                if (_fileName.equals("")) {
                    _fileName = null;
                    this.currentDirectory = null;
                } else {
                    this.currentEntry = this.rootDirectory.getEntry(_fileName);
                }
            }
            catch (RepositoryException ex) {
                return false;
            }
            catch (SecurityException ex) {
                return false;
            }
        }
        return true;
    }

    public Vector setCurrentLocation(String location) {
        Vector parList = new Vector();
        String _currentProtocol = this.getRepositoryProtocol();
        if (location.equals(_currentProtocol)) {
            parList = this.getRepositoryFolders();
            this.rootDirectory = this.getRoot();
            this.currentEntry = this.rootDirectory;
            this.currentDirectory = this.rootDirectory;
            this.reportRepositoryName = this.reportRepository.toString();
            return parList;
        }
        SBIPURL _srrp = new SBIPURL(location);
        try {
            this.reportRepository = this.repositoryFactory.getRepository(_srrp.getRepository());
            if (this.reportRepository == null) {
                this.setErrorVector(parList);
                return parList;
            }
            this.messager = this.reportRepository.getRepositoryMessager();
        }
        catch (RepositoryException e) {
            this.messager.error(e.getMessage());
            this.setErrorVector(parList);
            return parList;
        }
        this.reportRepositoryName = this.reportRepository.toString();
        String _fileName = null;
        this.rootDirectory = this.getRoot();
        if (this.rootDirectory == null) {
            this.setErrorVector(parList);
            return parList;
        }
        if (this.rootDirectory.toString().equals(location)) {
            this.currentDirectory = this.rootDirectory;
            this.currentEntry = this.rootDirectory;
        } else {
            try {
                _fileName = _srrp.getFile();
                if (_fileName.equals("")) {
                    _fileName = null;
                    this.currentDirectory = null;
                } else {
                    this.currentEntry = this.rootDirectory.getEntry(_fileName);
                }
            }
            catch (RepositoryException ex) {
                if (_fileName != null) {
                    this.messager.error(ex.getMessage());
                }
            }
            catch (SecurityException ex) {
                this.messager.error(ex.getMessage());
            }
            this.currentDirectory = (DirectoryInterface)this.currentEntry;
        }
        if (this.currentDirectory == null) {
            this.setErrorVector(parList);
            return parList;
        }
        Vector _dir = new Vector();
        try {
            this.currentDirectory.list(_dir, this.currentFilter, SortOrder.ASCENDING);
        }
        catch (RepositoryException e) {
            this.messager.error(e.getMessage());
            this.setErrorVector(parList);
            return parList;
        }
        try {
            this.setDataVector(_dir, parList);
        }
        catch (InvalidDirectoryException exc) {
            this.setErrorVector(parList);
            return parList;
        }
        this.isRepository = false;
        return parList;
    }

    public Vector getTypeData() {
        return this.typeData;
    }

    public void setTypeData(Vector inTypeData) {
        this.typeData = inTypeData;
    }

    public String getRepositoryName() {
        String _loc = this.currentDirectory.toString();
        SBIPURL _s = new SBIPURL(_loc);
        return _s.getRepository();
    }

    public String getFullRepositoryName() {
        String fullRepName = null;
        if (this.currentDirectory != null) {
            String _loc = this.currentDirectory.toString();
            SBIPURL _s = new SBIPURL(_loc);
            fullRepName = _s.getProtocol() + "://" + _s.getRepository();
        }
        return fullRepName;
    }

    public String getRepositoryProtocol() {
        if (this.currentDirectory == null) {
            return "SBIP:";
        }
        String _loc = this.currentDirectory.toString();
        SBIPURL _s = new SBIPURL(_loc);
        String _protocol = _s.getProtocol();
        return _protocol;
    }

    public Vector getRepositories() {
        return this.repositories;
    }

    public void renameEntry(String selection, String newName) throws InvalidRenameException, DuplicateNameException, IllegalNameException {
        EntryInterface _ent;
        String[] _argString = new String[]{newName};
        try {
            _ent = this.currentDirectory.getEntry(selection);
        }
        catch (RepositoryException exc) {
            this.messager.error(RepositoryResource.getMessageString("nogetErr.txt", 1, _argString));
            throw new InvalidRenameException(exc.getMessage());
        }
        try {
            _ent.renameTo(newName);
        }
        catch (RepositoryIllegalNameException ex) {
            this.messager.error(RepositoryResource.getMessageString("illegalErr.txt", 1, _argString));
            throw new IllegalNameException();
        }
        catch (RepositoryLockedException ex) {
            this.messager.error(RepositoryResource.getMessageString("lockErr.txt", 1, _argString));
            throw new InvalidRenameException(ex.getMessage());
        }
        catch (SecurityException ex) {
            this.messager.error(RepositoryResource.getMessageString("securityErr.txt", 1, _argString));
            throw new InvalidRenameException(ex.getMessage());
        }
        catch (RepositoryDuplicateNameException ex) {
            this.messager.error(RepositoryResource.getMessageString("duplicateErr.txt", 1, _argString));
            throw new DuplicateNameException();
        }
        catch (RepositoryException exc) {
            throw new InvalidRenameException(exc.getMessage());
        }
    }

    public void deleteEntry(String selection) throws InvalidDeletionException, NotFoundException {
        EntryInterface _ent = null;
        String[] _argString = new String[]{selection};
        try {
            _ent = this.currentDirectory.getEntry(selection);
        }
        catch (RepositoryIllegalNameException ex) {
            this.messager.error(RepositoryResource.getMessageString("illegalErr.txt", 1, _argString));
            throw new InvalidDeletionException(ex.getMessage());
        }
        catch (RepositoryNotFoundException ex) {
            this.messager.error(RepositoryResource.getMessageString("notFoundErr.txt", 1, _argString));
            throw new NotFoundException();
        }
        catch (SecurityException ex) {
            this.messager.error(RepositoryResource.getMessageString("securityErr.txt", 1, _argString));
            throw new InvalidDeletionException(ex.getMessage());
        }
        catch (RepositoryException exc) {
            throw new InvalidDeletionException(exc.getMessage());
        }
        if (_ent == null) {
            throw new InvalidDeletionException(RepositoryResource.getStringResource("rrIsNull.txt"));
        }
        try {
            _ent.delete();
        }
        catch (RepositoryException exc) {
            this.messager.error(RepositoryResource.getMessageString("delerr1.txt", 1, _argString));
            throw new InvalidDeletionException(exc.getMessage());
        }
    }

    public void setEntryIndex(int entryIndexNumber) {
        this.entryIndexNumber = entryIndexNumber;
    }

    public void updateFolderData(Vector folderList, String selection, boolean hasFullPathName) throws Exception {
        Object _directoryListing;
        String _p;
        this.isRepository = this.repositories.contains(selection);
        if (!this.isRepository && selection.length() >= 7 && (_p = selection.substring(0, 7)).equals("SBIP://")) {
            String _s = selection.substring(7);
            this.isRepository = this.repositories.contains(_s);
            if (this.isRepository) {
                selection = _s;
            }
        }
        String _file = null;
        int _rsel = this.repositories.indexOf(selection);
        this.rootDirectory = null;
        this.currentSelection = selection;
        this.currentEntry = null;
        if (selection.equals(this.rrConnectErrorMessage1)) {
            if (!hasFullPathName) {
                folderList.clear();
            }
            this.setErrorVector(folderList);
            return;
        }
        if (hasFullPathName) {
            DirectoryInterface _en = this.rootDirectory = this.getRoot();
            String _rootString = null;
            PathUrl _path = null;
            try {
                _path = _en.getLocationUrl();
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            if (_path != null) {
                _rootString = "SBIP://" + _path.getRepository();
            }
            if (this.isRepository) {
                selection = _rootString + "/BIP Tree";
            }
            this.isRepository = false;
            SBIPURL _srrp = new SBIPURL(selection);
            _file = _srrp.getFile();
            StringBuffer _SRP = new StringBuffer();
            _SRP.append(_srrp.getProtocol() + "://" + _srrp.getRepository() + "/" + _file);
            String _SRPA = _SRP.toString();
            if (_file != null) {
                String _e;
                String _d;
                PathUrl _filePath = new PathUrl(_SRPA);
                StringBuffer buffer = new StringBuffer();
                String rootTree = _filePath.getRootTree();
                if (!rootTree.equals("BIP Tree")) {
                    buffer.append(rootTree);
                }
                if ((_d = _filePath.getPath()) != null) {
                    buffer.append("/" + _d);
                }
                if ((_e = _filePath.getName()) != null) {
                    buffer.append("/" + _e);
                }
                if (buffer != null && buffer.length() > 0) {
                    _file = buffer.toString();
                }
            }
            if (this.rootDirectory.toString().equals(selection)) {
                this.currentDirectory = this.rootDirectory;
                this.currentEntry = this.rootDirectory;
            } else if (_file.equals("BIP Tree")) {
                this.currentDirectory = this.rootDirectory;
                this.currentEntry = this.rootDirectory;
            } else if (selection.equals(_rootString)) {
                this.currentDirectory = this.rootDirectory;
                this.currentEntry = this.rootDirectory;
            } else {
                try {
                    this.currentEntry = this.rootDirectory.getEntry(_file);
                }
                catch (RepositoryException ex) {
                    this.messager.error(ex.getMessage());
                    throw new Exception();
                }
                if (this.currentEntry == null) {
                    this.setErrorVector(folderList);
                    return;
                }
                selection = this.currentEntry.toString();
                this.currentDirectory = (DirectoryInterface)this.currentEntry;
            }
        } else if (!this.isRepository) {
            try {
                this.currentEntry = this.currentDirectory.getEntry(selection);
            }
            catch (RepositoryException ex) {
                this.messager.error(ex.getMessage());
                throw new Exception();
            }
            if (this.currentEntry == null) {
                _directoryListing = this.currentDirectory.list(this.currentFilter);
                String _tryagainItem = _directoryListing[this.entryIndexNumber];
                try {
                    this.currentEntry = this.currentDirectory.getEntry(_tryagainItem);
                }
                catch (RepositoryException ex) {
                    this.messager.error(ex.getMessage());
                    throw new InvalidDirectoryException(ex.getMessage());
                }
                if (this.currentEntry == null) {
                    if (!hasFullPathName) {
                        folderList.clear();
                    }
                    this.setErrorVector(folderList);
                    return;
                }
                this.currentDirectory = (DirectoryInterface)this.currentEntry;
            }
            this.currentDirectory = (DirectoryInterface)this.currentEntry;
        } else {
            if (this.repositoryList != null) {
                this.reportRepository = (Repository)this.repositoryList.get(_rsel);
                if (this.reportRepository == null) {
                    if (!hasFullPathName) {
                        folderList.clear();
                    }
                    this.setErrorVector(folderList);
                    return;
                }
                this.reportRepositoryName = this.reportRepository.getName();
            }
            this.rootDirectory = this.getRoot();
            if (this.rootDirectory == null) {
                if (!hasFullPathName) {
                    folderList.clear();
                }
                this.setErrorVector(folderList);
                return;
            }
            this.currentEntry = this.rootDirectory;
            this.currentDirectory = this.rootDirectory;
            if (this.rootDirectory == null) {
                if (!hasFullPathName) {
                    folderList.clear();
                }
                this.setErrorVector(folderList);
                throw new Exception();
            }
        }
        _directoryListing = new Vector();
        this.currentDirectory.list((List)_directoryListing);
        if (!hasFullPathName) {
            folderList.clear();
        }
        try {
            this.setDataVector((Vector)_directoryListing, folderList);
        }
        catch (InvalidDirectoryException exc) {
            this.setErrorVector(folderList);
            throw new Exception();
        }
    }

    private void setErrorVector(Vector errorList) {
        this.messager.error(this.rrConnectErrorMessage1);
        this.typeData.clear();
        String[] _e = new String[]{this.rrConnectErrorMessage1, this.repStr};
        this.setDataRows(_e, errorList, this.repStr);
    }

    public void setDataRows(String[] elements, Vector list, String type) {
        Vector<String> _rows = new Vector<String>();
        for (int i = 0; i < elements.length; ++i) {
            _rows.add(elements[i]);
        }
        list.addElement(_rows);
        this.typeData.add(type);
    }

    private void setDataVector(Vector strList, Vector folderList) throws InvalidDirectoryException {
        this.typeData.clear();
        EntryInterface _entryListItem = null;
        String _name = null;
        String _type = null;
        String _author = null;
        String _lastMod = null;
        String _created = null;
        for (int i = 0; i < strList.size(); ++i) {
            _entryListItem = (EntryInterface)strList.get(i);
            Iterator _it = null;
            try {
                _it = _entryListItem.getAttributes();
            }
            catch (RepositoryException exc) {
                this.messager.error(exc.getMessage());
                throw new InvalidDirectoryException(exc.getMessage());
            }
            _type = null;
            if (_it != null) {
                while (_it.hasNext()) {
                    Map.Entry e = (Map.Entry)_it.next();
                    Object _n = e.getKey();
                    Object _value = e.getValue();
                    if (_value == null) continue;
                    if (_n.toString().equals(this.typeRef)) {
                        _type = _value.toString();
                        continue;
                    }
                    if (_n.toString().equals(this.authorRef)) {
                        _author = _value.toString();
                        continue;
                    }
                    if (_n.toString().equals(this.lastModRef)) {
                        _lastMod = _value.toString();
                        continue;
                    }
                    if (_n.toString().equals(this.createdRef)) {
                        _created = _value.toString();
                        continue;
                    }
                    if (!_n.toString().equals(this.nameRef)) continue;
                    _name = _value.toString();
                }
            }
            if (_type == null) {
                _type = this.getType(_entryListItem);
            }
            String[] _e = new String[]{_name, _type, _author, _created, _lastMod};
            this.setDataRows(_e, folderList, _type);
        }
    }
}

