/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository.visuals;

import com.sas.report.repository.RepositoryMessager;
import com.sas.report.repository.RepositoryResource;
import com.sas.report.repository.visuals.BetterComboRenderer;
import com.sas.report.repository.visuals.DialogCloser;
import com.sas.report.repository.visuals.GenericActions;
import com.sas.report.repository.visuals.GenericRepositoryAccess;
import com.sas.report.repository.visuals.InvalidDeletionException;
import com.sas.report.repository.visuals.NoRepositoryServiceException;
import com.sas.report.repository.visuals.NotFoundException;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public abstract class GenericDialog
extends JDialog {
    public boolean isCancelled;
    protected GenericRepositoryAccess repositoryInfo;
    protected Vector typeLabels;
    protected Vector typePointers;
    private static final String saveStr = RepositoryResource.getStringResource("saveStr.txt");
    private static final String delerr2 = RepositoryResource.getStringResource("delerr2.txt");
    private static final String verifyStr = RepositoryResource.getStringResource("verifyStr.txt");
    private String sessionId;
    private GenericActions actionButtons;
    protected RepositoryMessager messager;

    public GenericDialog(Frame parent, String sessionId) {
        super(parent, true);
        this.sessionId = sessionId;
        this.setRepositoryInfo();
        this.init();
    }

    public GenericDialog(GenericDialog parent, String sessionId) {
        super((Dialog)parent, true);
        this.sessionId = sessionId;
        this.setRepositoryInfo();
        this.init();
    }

    public GenericDialog(JDialog parent, String sessionId) {
        super((Dialog)parent, true);
        this.sessionId = sessionId;
        this.setRepositoryInfo();
        this.init();
    }

    public GenericDialog(GenericDialog parent, GenericRepositoryAccess repositoryInfo) {
        super((Dialog)parent, true);
        this.repositoryInfo = repositoryInfo;
        this.messager = repositoryInfo.getMessager();
        this.init();
    }

    public GenericDialog(Frame parent) {
        super(parent, true);
        this.setRepositoryInfo();
        this.init();
    }

    public GenericDialog(GenericDialog parent) {
        super((Dialog)parent, true);
        this.setRepositoryInfo();
        this.init();
    }

    public GenericDialog(JDialog parent) {
        super((Dialog)parent, true);
        this.setRepositoryInfo();
        this.init();
    }

    private void setRepositoryInfo() {
        try {
            this.repositoryInfo = new GenericRepositoryAccess(this, this.sessionId);
        }
        catch (NoRepositoryServiceException ex) {
            this.repositoryInfo = null;
        }
        if (this.repositoryInfo != null) {
            this.messager = this.repositoryInfo.getMessager();
        }
    }

    private void init() {
        this.typeLabels = new Vector();
        this.typePointers = new Vector();
        this.typePointers.addElement("xml");
        this.typePointers.addElement("pck");
        this.typePointers.addElement("erp");
        this.typePointers.addElement("erf");
        this.typePointers.addElement("html");
        this.typePointers.addElement("htm");
        this.typePointers.addElement("jpeg");
        this.typePointers.addElement("pdf");
        this.typePointers.addElement("tif");
        this.typePointers.addElement("tiff");
        this.typePointers.addElement("gif");
        this.typeLabels.addElement(RepositoryResource.getStringResource("xmlType.txt"));
        this.typeLabels.addElement(RepositoryResource.getStringResource("pckType.txt"));
        this.typeLabels.addElement(RepositoryResource.getStringResource("erpType.txt"));
        this.typeLabels.addElement(RepositoryResource.getStringResource("erfType.txt"));
        this.typeLabels.addElement(RepositoryResource.getStringResource("htmlType.txt"));
        this.typeLabels.addElement(RepositoryResource.getStringResource("htmlType.txt"));
        this.typeLabels.addElement(RepositoryResource.getStringResource("jpegType.txt"));
        this.typeLabels.addElement(RepositoryResource.getStringResource("pdfType.txt"));
        this.typeLabels.addElement(RepositoryResource.getStringResource("tifType.txt"));
        this.typeLabels.addElement(RepositoryResource.getStringResource("tifType.txt"));
        this.typeLabels.addElement(RepositoryResource.getStringResource("gifType.txt"));
        this.typeLabels.addElement(RepositoryResource.getStringResource("genericType.txt"));
        this.setBackground(SystemColor.control);
        this.addWindowListener(new DialogCloser(this));
        this.actionButtons = new GenericActions(saveStr);
        this.actionButtons.getStdAction().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionButtonEvent) {
                GenericDialog.this.onStdAction();
            }
        });
        this.actionButtons.getCancel().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent cancelButtonEvent) {
                GenericDialog.this.onCancel();
            }
        });
    }

    protected void finish() {
        this.dispose();
    }

    protected RepositoryMessager getMessager() {
        return this.repositoryInfo.getMessager();
    }

    protected void setGenericAction(String actionText, String actionMnemonic) {
        this.actionButtons.setGenericAction(actionText);
        this.actionButtons.setActionMnemonic(actionMnemonic);
    }

    protected boolean setDeletion(int result, String stringValue, Vector storeRows, boolean isDeleteAll, Vector toDelete, String[] argString, int rowIndex, Object[] options) {
        boolean _add = true;
        switch (result) {
            case 0: {
                try {
                    this.repositoryInfo.deleteEntry(stringValue);
                }
                catch (InvalidDeletionException ex) {
                    this.showErrDialog(RepositoryResource.getMessageString("delerr1.txt", 1, argString), delerr2);
                    _add = false;
                }
                catch (NotFoundException ex) {
                    this.showErrDialog(RepositoryResource.getMessageString("notFoundErr.txt", 1, argString), delerr2);
                    _add = false;
                }
                if (!_add) break;
                toDelete.add(stringValue);
                break;
            }
            case 1: {
                isDeleteAll = true;
                try {
                    this.repositoryInfo.deleteEntry(stringValue);
                }
                catch (InvalidDeletionException ex) {
                    this.showErrDialog(RepositoryResource.getMessageString("delerr1.txt", 1, argString), delerr2);
                    _add = false;
                }
                catch (NotFoundException ex) {
                    this.showErrDialog(RepositoryResource.getMessageString("notFoundErr.txt", 1, argString), delerr2);
                    _add = false;
                }
                if (!_add) break;
                toDelete.add(stringValue);
                break;
            }
            case 2: {
                rowIndex = storeRows.size();
            }
        }
        return isDeleteAll;
    }

    protected String getSession() {
        if (this.sessionId.trim() == "") {
            return null;
        }
        return this.sessionId;
    }

    protected void setSession(String sessionId) {
        this.sessionId = sessionId;
    }

    protected JButton getStdButton() {
        return this.actionButtons.getStdAction();
    }

    protected JButton getCancelButton() {
        return this.actionButtons.getCancel();
    }

    protected void onStdAction() {
        this.isCancelled = false;
        this.finish();
    }

    protected void onCancel() {
        this.isCancelled = true;
        this.finish();
    }

    public String getCurrentLocation() {
        String location = this.repositoryInfo.getCurrentLocation();
        return location;
    }

    public boolean wasCancelled() {
        return this.isCancelled;
    }

    protected void setBusyCursor(boolean isBusy) {
        if (isBusy) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected static void setScrollPane(JScrollPane scrollpane) {
        scrollpane.setBorder(BorderFactory.createBevelBorder(1, SystemColor.controlLtHighlight, SystemColor.controlHighlight, SystemColor.controlDkShadow, SystemColor.controlShadow));
    }

    protected static void fixupJComboBox(JComboBox combo) {
        combo.setRenderer(new BetterComboRenderer());
        combo.setBorder(BorderFactory.createBevelBorder(1, SystemColor.controlLtHighlight, SystemColor.controlHighlight, SystemColor.controlDkShadow, SystemColor.controlShadow));
    }

    protected void setLabelRows(JLabel[] labels, JLabel[] textFields, GridBagLayout gridbag, Container container) {
        GridBagConstraints c = new GridBagConstraints();
        c.insets.top = 0;
        c.insets.left = 4;
        c.insets.bottom = 4;
        c.anchor = 17;
        int numLabels = labels.length;
        for (int i = 0; i < numLabels; ++i) {
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            gridbag.setConstraints(labels[i], c);
            container.add(labels[i]);
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            gridbag.setConstraints(textFields[i], c);
            container.add(textFields[i]);
        }
    }

    protected void setTextFieldRows(JLabel[] labels, JScrollPane[] textPane, GridBagLayout gridbag, Container container) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets.top = 7;
        c.insets.bottom = 4;
        int numLabels = labels.length;
        for (int i = 0; i < numLabels; ++i) {
            c.gridwidth = -1;
            c.fill = 1;
            c.weightx = 0.0;
            gridbag.setConstraints(labels[i], c);
            container.add(labels[i]);
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            gridbag.setConstraints(textPane[i], c);
            container.add(textPane[i]);
        }
    }

    protected void setLabelMnemonic(JLabel label, String labelMnemonic) {
        char _c = labelMnemonic.charAt(0);
        label.setDisplayedMnemonic(_c);
    }

    protected void setCheckBoxMnemonic(JCheckBox checkBox, String actionMnemonic) {
        char _c = actionMnemonic.charAt(0);
        checkBox.setMnemonic(_c);
    }

    protected void showErrDialog(String errorMessage, String errorTitle) {
        JOptionPane.showMessageDialog(this, errorMessage, errorTitle, 0);
    }

    protected String showErrInputDialog(String errorMessage, String errorTitle) {
        String text = JOptionPane.showInputDialog(this, errorMessage, errorTitle, 0);
        return text;
    }

    protected int showWarnDialog(String warnMessage) {
        int _result = JOptionPane.showConfirmDialog(this, warnMessage, verifyStr, 0, 2);
        int _r = 1;
        switch (_result) {
            case 0: {
                _r = 0;
                break;
            }
            case 1: {
                _r = 1;
            }
        }
        return _r;
    }

    protected void refresh() {
        Container _p = this.getContentPane();
        _p.repaint();
    }

    protected abstract void setDefaultFocusText(String var1);

    protected abstract String getDefaultFocusText();

    protected abstract void addFolder(String var1, String var2);

    protected abstract void setDefaultFocus();
}

