/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository.adapter;

import com.sas.report.repository.UserId;
import com.sas.svcs.reportrepository.client.domain.KeywordListType;
import com.sas.svcs.reportrepository.client.domain.ObjectFactory;
import com.sas.svcs.reportrepository.client.domain.UserIdListType;
import com.sas.svcs.reportrepository.client.domain.UserIdType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UtilAttrValueConverter {
    private static final Logger logger = LogManager.getLogger(UtilAttrValueConverter.class);

    public static Object convertToServiceAttrValue(String attrName, Object attrValue, String entryPathUrl) {
        if (attrName.equals("userids")) {
            UserIdListType userIdList = new ObjectFactory().createUserIdListType();
            for (Object attrMemValue : (List)attrValue) {
                if (attrMemValue instanceof UserId) {
                    UserId attrUserId = (UserId)attrMemValue;
                    UserIdType userId = new ObjectFactory().createUserIdType();
                    userId.setName(attrUserId.getName());
                    userId.setLoginId(attrUserId.getUserId());
                    userIdList.getUserId().add(userId);
                    continue;
                }
                logger.warn("Found non UserId value: " + attrMemValue + " in List attribute of Report: " + entryPathUrl);
            }
            return userIdList;
        }
        if (attrName.equals("keywords")) {
            KeywordListType keywordList = new ObjectFactory().createKeywordListType();
            Iterator iter = attrValue instanceof Iterator ? (Iterator)attrValue : ((List)attrValue).iterator();
            while (iter.hasNext()) {
                String keyword = (String)iter.next();
                keywordList.getKeyword().add(keyword);
            }
            return keywordList;
        }
        return attrValue;
    }

    public static Object convertFromServiceAttrValue(Object attrValue, boolean clientSide) {
        if (attrValue instanceof XMLGregorianCalendar) {
            return ((XMLGregorianCalendar)attrValue).toGregorianCalendar().getTime();
        }
        if (attrValue instanceof UserIdListType) {
            ArrayList userIdList = new ArrayList();
            for (UserIdType attrUserId : ((UserIdListType)attrValue).getUserId()) {
                UserId userId = new UserId(attrUserId.getName(), attrUserId.getLoginId());
            }
            return userIdList;
        }
        if (attrValue instanceof KeywordListType) {
            if (clientSide) {
                return ((KeywordListType)attrValue).getKeyword().iterator();
            }
            return ((KeywordListType)attrValue).getKeyword();
        }
        return attrValue;
    }
}

