/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository.adapter;

import com.sas.report.repository.ContentAlreadyExistsException;
import com.sas.report.repository.ContentDirectoryException;
import com.sas.report.repository.ContentException;
import com.sas.report.repository.ContentFileException;
import com.sas.report.repository.ContentInterface;
import com.sas.report.repository.ContentMalformedNameException;
import com.sas.report.repository.ContentNameNotFoundException;
import com.sas.report.repository.RepositoryException;
import com.sas.svcs.reportrepository.client.ProjectContentServiceInterface;
import com.sas.svcs.reportrepository.client.domain.ContentExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.ContentFileExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.ContentMalformedNameExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.ContentNameNotFoundExceptionHolder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProjectContentInterfaceServiceAdapter
implements ContentInterface {
    private static final Logger logger = LogManager.getLogger(ProjectContentInterfaceServiceAdapter.class);
    protected ProjectContentServiceInterface projectContentService;
    protected String projectPathUrl;

    public ProjectContentInterfaceServiceAdapter(ProjectContentServiceInterface projectContentService, String projectPathUrl) {
        this.projectContentService = projectContentService;
        this.projectPathUrl = projectPathUrl;
    }

    @Override
    public OutputStream add(String fileName) throws ContentFileException, ContentException, ContentAlreadyExistsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String buildPath(String basePath, String subPath) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyTo(String oldName, String newName) throws ContentMalformedNameException, ContentNameNotFoundException, ContentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyTo(String oldName, ContentInterface dest, String newName) throws ContentMalformedNameException, ContentNameNotFoundException, ContentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createDirectory(String newDirectoryName) throws ContentNameNotFoundException, ContentException, ContentAlreadyExistsException, ContentDirectoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(String fileName) throws ContentNameNotFoundException, ContentFileException, ContentException {
        try {
            this.projectContentService.delete(this.projectPathUrl, fileName);
        }
        catch (ContentNameNotFoundExceptionHolder e) {
            logger.error((Object)e);
            throw new ContentNameNotFoundException(e.getExceptionType().getMessage());
        }
        catch (ContentFileExceptionHolder e) {
            logger.error((Object)e);
            throw new ContentFileException(e.getExceptionType().getMessage());
        }
        catch (ContentExceptionHolder e) {
            logger.error((Object)e);
            throw new ContentException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public void deleteTree(String fileName) throws ContentNameNotFoundException, ContentFileException, ContentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean exists(String name) throws ContentException {
        try {
            return this.projectContentService.exists(this.projectPathUrl, name);
        }
        catch (ContentExceptionHolder e) {
            logger.error((Object)e);
            throw new ContentException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public InputStream get(String fileName) throws ContentNameNotFoundException, ContentFileException, ContentException {
        try {
            byte[] contents = this.projectContentService.get(this.projectPathUrl, fileName);
            return new ByteArrayInputStream(contents);
        }
        catch (ContentNameNotFoundExceptionHolder e) {
            logger.error((Object)e);
            throw new ContentNameNotFoundException(e.getExceptionType().getMessage());
        }
        catch (ContentFileExceptionHolder e) {
            logger.error((Object)e);
            throw new ContentFileException(e.getExceptionType().getMessage());
        }
        catch (ContentExceptionHolder e) {
            logger.error((Object)e);
            throw new ContentException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public ContentInterface getParent() throws ContentException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPassword(String password) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPathSeparator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRootPath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getSizeInBytes(String name) throws ContentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getUserName(String userName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDirectory(String directoryName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List list(String directoryName) throws ContentNameNotFoundException, ContentException, ContentDirectoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveTo(String oldName, String newName) throws ContentMalformedNameException, ContentNameNotFoundException, ContentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveTo(String oldName, ContentInterface dest, String newName) throws ContentMalformedNameException, ContentNameNotFoundException, ContentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void renameTo(String oldName, String newName) throws ContentMalformedNameException, ContentNameNotFoundException, ContentException {
        try {
            this.projectContentService.renameTo(this.projectPathUrl, oldName, newName);
        }
        catch (ContentNameNotFoundExceptionHolder e) {
            logger.error((Object)e);
            throw new ContentNameNotFoundException(e.getExceptionType().getMessage());
        }
        catch (ContentMalformedNameExceptionHolder e) {
            logger.error((Object)e);
            throw new ContentMalformedNameException(e.getExceptionType().getMessage());
        }
        catch (ContentExceptionHolder e) {
            logger.error((Object)e);
            throw new ContentException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public OutputStream update(String fileName) throws ContentNameNotFoundException, ContentFileException, ContentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream write(final String fileName) throws ContentFileException, ContentNameNotFoundException, ContentException {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                try {
                    ProjectContentInterfaceServiceAdapter.this.projectContentService.write(ProjectContentInterfaceServiceAdapter.this.projectPathUrl, fileName, this.toByteArray());
                }
                catch (ContentNameNotFoundExceptionHolder e) {
                    logger.error((Object)e);
                    throw new RuntimeException(e.getExceptionType().getMessage());
                }
                catch (ContentFileExceptionHolder e) {
                    logger.error((Object)e);
                    throw new RuntimeException(e.getExceptionType().getMessage());
                }
                catch (ContentExceptionHolder e) {
                    logger.error((Object)e);
                    throw new RuntimeException(e.getExceptionType().getMessage());
                }
            }
        };
    }

    public int hashCode() {
        if (this.projectPathUrl != null) {
            return this.projectPathUrl.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.stringEquals(this.projectPathUrl, ((ProjectContentInterfaceServiceAdapter)o).projectPathUrl);
    }

    protected boolean stringEquals(String str1, String str2) {
        if (str1 != null) {
            return str1.equals(str2);
        }
        return str2 == null;
    }

    @Override
    public String getAttribute(String name, String attrName) throws ContentException {
        return null;
    }

    @Override
    public Map getAttributes(String name) throws ContentException {
        return null;
    }

    @Override
    public void setAttribute(String name, String attrName, String attrValue) throws ContentException {
    }

    @Override
    public void setAttributes(String name, Map attributes) throws ContentException {
    }

    @Override
    public void lock(String name) throws ContentException {
    }

    @Override
    public void unlock(String name) throws ContentException {
    }
}

