/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository.adapter;

import com.sas.report.repository.CacheFilter;
import com.sas.report.repository.CacheInterface;
import com.sas.report.repository.CacheSetInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.report.repository.adapter.CacheInterfaceServiceAdapter;
import com.sas.svcs.reportrepository.client.CacheItemServiceInterface;
import com.sas.svcs.reportrepository.client.CacheServiceInterface;
import com.sas.svcs.reportrepository.client.CacheSetServiceInterface;
import com.sas.svcs.reportrepository.client.domain.RepositoryDuplicateNameExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryIllegalNameExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryLockedExceptionHolder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CacheSetInterfaceServiceAdapter
implements CacheSetInterface {
    private static final Logger logger = LogManager.getLogger(CacheSetInterfaceServiceAdapter.class);
    protected CacheSetServiceInterface cacheSetService;
    protected CacheServiceInterface cacheService;
    protected CacheItemServiceInterface cacheItemService;
    protected String entryPathUrl;

    public CacheSetInterfaceServiceAdapter(CacheSetServiceInterface cacheSetService, CacheServiceInterface cacheService, CacheItemServiceInterface cacheItemService, String entryPathUrl) {
        this.cacheSetService = cacheSetService;
        this.cacheService = cacheService;
        this.cacheItemService = cacheItemService;
        this.entryPathUrl = entryPathUrl;
    }

    @Override
    public int archivePDFs(String srcCacheName, Date archiveDate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheInterface create(String cacheName) throws RepositoryIllegalNameException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException {
        try {
            this.cacheSetService.createCache(this.entryPathUrl, cacheName);
            return new CacheInterfaceServiceAdapter(this.cacheService, this.cacheItemService, this.entryPathUrl, cacheName);
        }
        catch (RepositoryIllegalNameExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryIllegalNameException(e.getExceptionType().getMessage());
        }
        catch (RepositoryLockedExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryLockedException(e.getExceptionType().getMessage());
        }
        catch (RepositoryDuplicateNameExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryDuplicateNameException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public CacheInterface create(String cacheName, boolean transientCache) throws RepositoryIllegalNameException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteAll() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteTransient() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean exists(String cacheName) throws RepositoryException {
        try {
            return this.cacheSetService.existsCache(this.entryPathUrl, cacheName);
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public CacheInterface get(String cacheName) throws RepositoryException, RepositoryNotFoundException {
        return new CacheInterfaceServiceAdapter(this.cacheService, this.cacheItemService, this.entryPathUrl, cacheName);
    }

    @Override
    public EntryInterface getEntryInterface() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxNumberOfVersions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List list(CacheFilter filter) throws RepositoryException {
        try {
            ArrayList<CacheInterfaceServiceAdapter> cacheList = new ArrayList<CacheInterfaceServiceAdapter>();
            List cacheNamesList = this.cacheSetService.listCaches(this.entryPathUrl);
            for (String cacheName : cacheNamesList) {
                CacheInterfaceServiceAdapter cache = new CacheInterfaceServiceAdapter(this.cacheService, this.cacheItemService, this.entryPathUrl, cacheName);
                cacheList.add(cache);
            }
            return cacheList;
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public List listCacheItems(CacheFilter filter) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMaxNumberOfVersions(int maxVersionsToKeep) throws RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        if (this.entryPathUrl != null) {
            return this.entryPathUrl.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.stringEquals(this.entryPathUrl, ((CacheSetInterfaceServiceAdapter)o).entryPathUrl);
    }

    protected boolean stringEquals(String str1, String str2) {
        if (str1 != null) {
            return str1.equals(str2);
        }
        return str2 == null;
    }
}

