/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository.adapter;

import com.sas.report.repository.CacheFilter;
import com.sas.report.repository.CacheInterface;
import com.sas.report.repository.CacheItemInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.report.repository.adapter.CacheItemInterfaceServiceAdapter;
import com.sas.svcs.reportrepository.client.CacheItemServiceInterface;
import com.sas.svcs.reportrepository.client.CacheServiceInterface;
import com.sas.svcs.reportrepository.client.domain.RepositoryDuplicateNameExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryIllegalNameExceptionHolder;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CacheInterfaceServiceAdapter
implements CacheInterface {
    private static final Logger logger = LogManager.getLogger(CacheInterfaceServiceAdapter.class);
    protected CacheServiceInterface cacheService;
    protected CacheItemServiceInterface cacheItemService;
    protected String entryPathUrl;
    protected String cacheName;

    public CacheInterfaceServiceAdapter(CacheServiceInterface cacheService, CacheItemServiceInterface cacheItemService, String entryPathUrl, String cacheName) {
        this.cacheService = cacheService;
        this.cacheItemService = cacheItemService;
        this.entryPathUrl = entryPathUrl;
        this.cacheName = cacheName;
    }

    @Override
    public CacheItemInterface create(String cacheEntryName) throws RepositoryIllegalNameException, RepositoryDuplicateNameException, RepositoryException {
        try {
            this.cacheService.createCacheItem(this.entryPathUrl, this.cacheName, cacheEntryName);
            return new CacheItemInterfaceServiceAdapter(this.cacheItemService, this.entryPathUrl, this.cacheName, cacheEntryName);
        }
        catch (RepositoryIllegalNameExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryIllegalNameException(e.getExceptionType().getMessage());
        }
        catch (RepositoryDuplicateNameExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryDuplicateNameException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public void createTransactionEnd() throws IllegalStateException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createTransactionStart() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete() throws RepositoryException {
        try {
            this.cacheService.delete(this.entryPathUrl, this.cacheName);
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public boolean exists(String cacheEntryName) throws RepositoryException {
        try {
            return this.cacheService.existsCacheItem(this.entryPathUrl, this.cacheName, cacheEntryName);
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public CacheItemInterface get(String cacheEntryName) throws RepositoryException, RepositoryNotFoundException {
        try {
            if (this.cacheService.existsCacheItem(this.entryPathUrl, this.cacheName, cacheEntryName)) {
                return new CacheItemInterfaceServiceAdapter(this.cacheItemService, this.entryPathUrl, this.cacheName, cacheEntryName);
            }
            throw new RepositoryNotFoundException(cacheEntryName);
        }
        catch (RepositoryExceptionHolder e) {
            throw new RepositoryException();
        }
    }

    @Override
    public String getName() throws RepositoryException {
        return this.cacheName;
    }

    @Override
    public EntryInterface getParentEntry() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List list(CacheFilter filter) throws RepositoryException {
        try {
            ArrayList<CacheItemInterfaceServiceAdapter> cacheItemList = new ArrayList<CacheItemInterfaceServiceAdapter>();
            List cacheItemNamesList = this.cacheService.listCacheItems(this.entryPathUrl, this.cacheName);
            for (String cacheItemName : cacheItemNamesList) {
                CacheItemInterfaceServiceAdapter cacheItem = new CacheItemInterfaceServiceAdapter(this.cacheItemService, this.entryPathUrl, this.cacheName, cacheItemName);
                if (filter == null) {
                    cacheItemList.add(cacheItem);
                    continue;
                }
                if (!filter.accept(cacheItem)) continue;
                cacheItemList.add(cacheItem);
            }
            return cacheItemList;
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
    }

    public int hashCode() {
        if (this.entryPathUrl != null) {
            return this.entryPathUrl.hashCode() + this.cacheName != null ? this.cacheName.hashCode() : 0;
        }
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.stringEquals(this.entryPathUrl, ((CacheInterfaceServiceAdapter)o).entryPathUrl) && this.stringEquals(this.cacheName, ((CacheInterfaceServiceAdapter)o).cacheName);
    }

    protected boolean stringEquals(String str1, String str2) {
        if (str1 != null) {
            return str1.equals(str2);
        }
        return str2 == null;
    }
}

