/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository.adapter;

import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.Transformation;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.RepositoryException;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import java.rmi.RemoteException;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseMetadataAdapter {
    private static final Logger logger = LogManager.getLogger(BaseMetadataAdapter.class);
    protected String pathUrl;
    protected ServerInterface server;
    private MetadataInterface smartObj;

    public BaseMetadataAdapter(String pathUrl, ServerInterface server, MetadataInterface smartObj) {
        this.pathUrl = pathUrl;
        this.server = server;
        this.smartObj = smartObj;
    }

    public Object getMetadataObject() {
        try {
            if (this.smartObj == null && this.server != null) {
                String[] tokens = this.pathUrl.split("\\|");
                PathUrl pUrl = new PathUrl(tokens[0]);
                pUrl.setRepository(this.server.getName());
                this.smartObj = this.server.getObjectByPath(pUrl);
            }
            return this.smartObj;
        }
        catch (ServiceException e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    protected void resetMetadataObject() {
        this.smartObj = null;
    }

    public int hashCode() {
        if (this.pathUrl != null) {
            return this.pathUrl.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.stringEquals(this.pathUrl, ((BaseMetadataAdapter)o).pathUrl);
    }

    protected boolean stringEquals(String str1, String str2) {
        if (str1 != null) {
            return str1.equals(str2);
        }
        return str2 == null;
    }

    protected static void fireCreatedEvents(EntryInterface ei) {
        BaseMetadataAdapter.fireEvents(ei, true, true);
    }

    protected static void fireModifiedEvents(EntryInterface ei) {
        BaseMetadataAdapter.fireEvents(ei, false, true);
    }

    private static void fireEvents(EntryInterface ei, boolean created, boolean modified) {
        try {
            MetadataInterface mi = (MetadataInterface)ei.getMetadataObject();
            if (mi != null) {
                Transformation trans = (Transformation)mi.getRepositoryEntity();
                HashMap<String, String> objectMap = new HashMap<String, String>(1);
                objectMap.put(trans.getId(), trans.getCMetadataType());
                MdFactory mdFactory = trans.getObjectStore().getFactory();
                MdFactoryEvent event = new MdFactoryEvent(mdFactory, objectMap);
                if (created) {
                    mdFactory.fireMdObjectsCreated(event);
                }
                if (modified) {
                    mdFactory.fireMdObjectsModified(event);
                }
            } else if (logger.isInfoEnabled()) {
                try {
                    logger.info("getMetadataObject returned null for: " + ei.getLocationUrl().toString());
                }
                catch (RepositoryException repositoryException) {}
            }
        }
        catch (RemoteException e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }
}

