/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.ReportManagementCache;
import junit.framework.TestCase;

public class TestReportManagementCache
extends TestCase {
    private long myStartTime;

    public TestReportManagementCache(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        System.out.println("\n--------------- " + this.getName());
        this.myStartTime = System.currentTimeMillis();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        long deltaT = System.currentTimeMillis() - this.myStartTime;
        System.out.println("--------------- Elapsed time = " + deltaT + " ms");
    }

    public void testConstructors() {
        ReportManagementCache cache = new ReportManagementCache();
        TestReportManagementCache.assertNotNull((String)"cache", (Object)cache);
        ReportManagementCache cache2 = new ReportManagementCache(10);
        TestReportManagementCache.assertNotNull((String)"cache2", (Object)cache2);
    }

    public void testBasicPutAndGet() {
        ReportManagementCache cache = new ReportManagementCache();
        try {
            cache.put(null, new Object());
            TestReportManagementCache.fail((String)"succeeded with null key!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            cache.put("foo", null);
            TestReportManagementCache.fail((String)"succeeded with null value!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Object obj1 = new Object();
        cache.put("obj1", obj1);
        int[] obj2 = new int[10];
        cache.put("obj2", obj2);
        String obj3 = new String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        cache.put("obj3", obj3);
        TestReportManagementCache.runGarbageCollector();
        TestReportManagementCache.assertEquals((String)"obj1", (Object)obj1, (Object)cache.get("obj1"));
        TestReportManagementCache.assertEquals((String)"obj2", (Object)obj2, (Object)cache.get("obj2"));
        TestReportManagementCache.assertEquals((String)"obj3", (Object)obj3, (Object)cache.get("obj3"));
    }

    public void testGetNeverCachedItem() {
        ReportManagementCache cache = new ReportManagementCache();
        Object obj = cache.get("non_existent_key");
        TestReportManagementCache.assertEquals((String)"obj", null, (Object)obj);
    }

    public void testGetCachedItems() {
        int i;
        ReportManagementCache cache = new ReportManagementCache();
        int itemCount = 50;
        Object[] objArray = new Object[itemCount];
        for (i = 0; i < itemCount; ++i) {
            Integer obj = i;
            objArray[i] = obj;
            cache.put("Int" + i, obj);
        }
        TestReportManagementCache.runGarbageCollector();
        for (i = 0; i < itemCount; ++i) {
            TestReportManagementCache.assertEquals((String)("Item" + i), (Object)objArray[i], (Object)cache.get("Int" + i));
        }
    }

    public void testRemoveItems() {
        ReportManagementCache cache = new ReportManagementCache();
        Object obj1 = new Object();
        cache.put("AAA", obj1);
        int[] obj2 = new int[10];
        cache.put("BBB", obj2);
        String obj3 = new String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        cache.put("CCC", obj3);
        TestReportManagementCache.assertEquals((String)"AAA", (Object)obj1, (Object)cache.get("AAA"));
        TestReportManagementCache.assertEquals((String)"BBB", (Object)obj2, (Object)cache.get("BBB"));
        TestReportManagementCache.assertEquals((String)"CCC", (Object)obj3, (Object)cache.get("CCC"));
        cache.remove("AAA");
        cache.remove("CCC");
        TestReportManagementCache.assertEquals((String)"AAA", null, (Object)cache.get("AAA"));
        TestReportManagementCache.assertEquals((String)"BBB", (Object)obj2, (Object)cache.get("BBB"));
        TestReportManagementCache.assertEquals((String)"CCC", null, (Object)cache.get("CCC"));
        cache.remove("AAA");
        cache.remove("JYHGGYJYHtgrfgregfwegtHTRH");
    }

    public void testGetPurgedItems() {
        int i;
        ReportManagementCache cache = new ReportManagementCache();
        int itemCount = 50;
        Object[] objArray = new Object[itemCount];
        for (i = 0; i < itemCount; ++i) {
            Integer obj = i;
            objArray[i] = obj;
            cache.put("Int" + i, obj);
        }
        for (i = 0; i < itemCount; i += 2) {
            objArray[i] = null;
        }
        TestReportManagementCache.runGarbageCollector();
        for (i = 0; i < itemCount; ++i) {
            if (i % 2 == 0) {
                TestReportManagementCache.assertEquals((String)("Even entries gone, i=" + i), null, (Object)cache.get("Int" + i));
                continue;
            }
            TestReportManagementCache.assertNotNull((String)("array ref, i=" + i), (Object)objArray[i]);
            TestReportManagementCache.assertEquals((String)("Odd entries kept, i=" + i), (Object)objArray[i], (Object)cache.get("Int" + i));
        }
    }

    public void testToString() {
        ReportManagementCache cache = new ReportManagementCache();
        String result = cache.toString();
        TestReportManagementCache.assertNotNull((String)"toString", (Object)result);
        Object obj1 = new Object();
        cache.put("AAA", obj1);
        int[] obj2 = new int[10];
        cache.put("BBB", obj2);
        String obj3 = new String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        cache.put("CCC", obj3);
        result = cache.toString();
        System.out.println("toString returned:\n" + result);
        TestReportManagementCache.assertTrue((String)"contains AAA", (result.indexOf("AAA") > 0 ? 1 : 0) != 0);
        TestReportManagementCache.assertTrue((String)"contains BBB", (result.indexOf("BBB") > 0 ? 1 : 0) != 0);
        TestReportManagementCache.assertTrue((String)"contains CCC", (result.indexOf("CCC") > 0 ? 1 : 0) != 0);
    }

    public static void runGarbageCollector() {
        long oldfree;
        Runtime rt = Runtime.getRuntime();
        long free = rt.freeMemory();
        do {
            oldfree = free;
            System.out.println("Calling garbage collector: free mem = " + free);
            rt.gc();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((free = rt.freeMemory()) != oldfree);
    }
}

