/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.RBUtil;
import com.sas.services.information.metadata.PathUrl;

public class SBIPURL {
    private static final String PROTOCOL = "SBIP";
    private PathUrl myPathUrl;

    public SBIPURL(String sbip) {
        this.myPathUrl = new PathUrl(sbip.replace('\\', '/'));
    }

    public SBIPURL(String repositoryName, String providerName, String fileName) {
        if (repositoryName == null || repositoryName.length() < 7) {
            throw new IllegalArgumentException(RBUtil.getStringResource("SBIPURLinvalidRepositoryName.txt", repositoryName));
        }
        String path = repositoryName;
        if (fileName != null && fileName.length() > 0) {
            path = path + "/" + fileName;
        }
        this.myPathUrl = new PathUrl(repositoryName.replace('\\', '/'));
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public String getRepository() {
        return this.myPathUrl.getRepository();
    }

    public String getType() {
        return this.myPathUrl.getType();
    }

    public String getFile() {
        String r = this.myPathUrl.getRootTree();
        String p = this.myPathUrl.getPath();
        String n = this.myPathUrl.getName();
        StringBuffer fileStr = new StringBuffer();
        if (r != null) {
            fileStr.append(r);
        }
        if (p != null) {
            fileStr.append("/");
            fileStr.append(p);
        }
        if (n != null) {
            fileStr.append("/");
            fileStr.append(n);
        }
        return fileStr.toString();
    }

    public String getProvider() {
        return "";
    }

    public static String getDefaultProvider() {
        return "";
    }

    public String toString() {
        return this.myPathUrl.toString();
    }
}

