/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.services.information.metadata.MetadataInterface;
import java.rmi.RemoteException;

public class RepositoryUtils {
    private static final String[] imageExts = new String[]{"bmp", "dib", "emf", "gif", "jpg", "jpeg", "tif", "tiff", "wmf", "eps", "ps", "png"};
    private static final String[] reportExts = new String[]{"srx"};

    public static boolean isImageType(String name) {
        String ext;
        boolean result = false;
        int p = name.lastIndexOf(46);
        if (p != -1 && (ext = name.substring(p + 1)).length() > 0) {
            for (int i = 0; i < imageExts.length; ++i) {
                if (!ext.equalsIgnoreCase(imageExts[i])) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static boolean isComponentType(String name) {
        return !RepositoryUtils.isReportType(name) && !RepositoryUtils.isImageType(name);
    }

    public static boolean isReportType(String name) {
        String ext;
        boolean result = false;
        int p = name.lastIndexOf(46);
        if (p != -1 && (ext = name.substring(p + 1)).length() > 0) {
            for (int i = 0; i < reportExts.length; ++i) {
                if (!ext.equalsIgnoreCase(reportExts[i])) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static String publicType(String name) {
        String publicType = "Report.Component";
        if (RepositoryUtils.isReportType(name)) {
            publicType = "Report";
        } else if (RepositoryUtils.isImageType(name)) {
            publicType = "Report.Image";
        }
        return publicType;
    }

    public static boolean sameRepository(MetadataInterface m1, MetadataInterface m2) {
        boolean result = false;
        try {
            String rid1 = m1.getReposId();
            String rid2 = m2.getReposId();
            result = rid1.substring(0, 8).equals(rid2.substring(0, 8));
        }
        catch (RemoteException e) {
            result = false;
        }
        return result;
    }
}

