/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.metadata.remote.Timestamp;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.SmartObjectHelper;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.Date;

public class RepositoryRepairUtil {
    private OMRID _omrid;

    public static Date toDate(Timestamp timestamp) throws RemoteException {
        return new Date((long)timestamp.getDateandTime());
    }

    public RepositoryRepairUtil(SessionContextInterface sessionContext, MetadataInterface mdi) throws RemoteException, RepositoryException {
        OMIRepositoryInterface omiRepos = (OMIRepositoryInterface)mdi.getRepository();
        SmartObjectHelper soh = new SmartObjectHelper((RepositoryInterface)omiRepos);
        soh.initOMRID(sessionContext, omiRepos);
        this._omrid = soh.getOMRID();
    }

    public Timestamp setTimestamp(MetadataInterface mdi, String timestampRole, Date dateValue) throws RepositoryException, RemoteException {
        return this._omrid.setTimestamp(mdi, timestampRole, dateValue);
    }

    public Timestamp getTimestamp(MetadataInterface mdi, String timestampRole) throws RepositoryException, RemoteException {
        return this._omrid.getTimestamp(mdi, timestampRole);
    }

    public void addTimestamps(MetadataInterface mdi) throws RepositoryException, RemoteException, ServiceException {
        Timestamp lastModTS;
        Timestamp createdTS = this.getTimestamp(mdi, "Creation Date");
        if (createdTS == null) {
            Date mdCreatedDate = mdi.getCreateDate();
            createdTS = this.setTimestamp(mdi, "Creation Date", mdCreatedDate);
        }
        if ((lastModTS = this.getTimestamp(mdi, "Modified Date")) == null) {
            Date mdLastModDate = mdi.getModifyDate();
            lastModTS = this.setTimestamp(mdi, "Modified Date", mdLastModDate);
        }
        Date createDate = RepositoryRepairUtil.toDate(createdTS);
        Date lastModDate = RepositoryRepairUtil.toDate(lastModTS);
        if (lastModDate.before(createDate)) {
            this.setTimestamp(mdi, "Modified Date", createDate);
        }
        mdi.update();
    }

    public void removeTimestamps(MetadataInterface mdi) throws RepositoryException, RemoteException, ServiceException {
        this.removeTimestamp(mdi, "Creation Date");
        this.removeTimestamp(mdi, "Modified Date");
        mdi.update();
    }

    private void removeTimestamp(MetadataInterface mdi, String role) throws RepositoryException, RemoteException {
        Timestamp ts = this._omrid.getTimestamp(mdi, role);
        if (ts != null) {
            ts.delete();
        }
    }
}

