/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.OMRRepositoryService;
import com.sas.report.repository.PFServices;
import com.sas.report.repository.Repository;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryService;
import com.sas.report.repository.UtilReportReposService;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulingDeleteHelperInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.reportrepository.client.RepositoryFactoryServiceInterface;
import com.sas.svcs.reportrepository.client.domain.RepositoryExceptionHolder;
import com.sas.util.UncheckedException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RepositoryFactory {
    public static final String OMRSERVICE = "OMR";
    private static SchedulingDeleteHelperInterface theSchedulingDeleteHelper = RepositoryFactory.getSchedulingDeleteHelperInstance();
    private boolean DEBUG = false;
    private PFServices pfs = null;
    private OMRRepositoryService OMRService = null;
    private RepositoryFactoryServiceInterface reposFacService = null;
    private boolean credentialAccessible = true;

    public static void setSchedulingDeleteHelper(SchedulingDeleteHelperInterface schedulingDeleteHelper) {
        theSchedulingDeleteHelper = schedulingDeleteHelper;
    }

    static void markForDeletion(Object jomaObject) throws SchedulerException, RemoteException {
        if (theSchedulingDeleteHelper != null) {
            theSchedulingDeleteHelper.markForDeletion(jomaObject);
        }
    }

    public RepositoryFactory(String PFSSessionId) throws RepositoryIOException, RepositoryException {
        if (this.DEBUG) {
            System.out.println("RepositoryFactory(1)(" + PFSSessionId + ")");
        }
        try {
            this.pfs = new PFServices(PFSSessionId);
            this.OMRService = new OMRRepositoryService(this.pfs);
            this.OMRService.connect(null);
        }
        catch (RepositoryException e) {
            if (this.DEBUG) {
                e.printStackTrace();
            }
            this.pfs = null;
            throw e;
        }
        catch (RemoteException e) {
            if (this.DEBUG) {
                e.printStackTrace();
            }
            this.pfs = null;
            throw new RepositoryException(e, e.getMessage());
        }
    }

    public RepositoryFactory(SessionContextInterface PFSSession) throws RepositoryIOException, RepositoryException {
        if (this.DEBUG) {
            System.out.println("RepositoryFactory(2)(" + PFSSession + ")");
        }
        try {
            this.pfs = new PFServices(PFSSession);
            this.OMRService = new OMRRepositoryService(this.pfs);
            this.OMRService.connect(null);
        }
        catch (RepositoryException e) {
            if (this.DEBUG) {
                e.printStackTrace();
            }
            this.pfs = null;
            throw e;
        }
        catch (RemoteException e) {
            if (this.DEBUG) {
                e.printStackTrace();
            }
            this.pfs = null;
            throw new RepositoryException(e, e.getMessage());
        }
    }

    public List getRepositories() throws RepositoryException {
        List v = this.OMRService.getRepositories();
        return v;
    }

    public Repository getRepository(String repositoryName) throws RepositoryException {
        return this.OMRService.getRepository(repositoryName);
    }

    public List getReportRepositories() throws RepositoryException {
        if (this.credentialAccessible) {
            return this.OMRService.getReportRepositories();
        }
        try {
            SessionContextInterface sc = this.pfs.getSessionContext();
            ArrayList<Repository> repositories = new ArrayList<Repository>();
            List reposNames = this.reposFacService.getReportRepositories();
            for (String reposName : reposNames) {
                Repository repos;
                try {
                    repos = UtilReportReposService.getRepositoryAdapter(null, sc.getUserContext(), reposName);
                }
                catch (RemoteException e) {
                    throw new RepositoryException(e, e.getMessage());
                }
                catch (ServiceException e) {
                    throw new RepositoryException(e, e.getMessage());
                }
                catch (IllegalStateException e) {
                    throw new RepositoryException(e, e.getMessage());
                }
                repositories.add(repos);
            }
            return repositories;
        }
        catch (RepositoryExceptionHolder e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    public Repository getReportRepository(String repositoryName) throws RepositoryException {
        SessionContextInterface sc = this.pfs.getSessionContext();
        try {
            UserContextInterface uc = sc.getUserContext();
            if (UtilReportReposService.credentialsAccessible(uc)) {
                return this.OMRService.getReportRepository(repositoryName);
            }
            this.credentialAccessible = false;
            return this.getRepositoryAdapter(uc, repositoryName);
        }
        catch (ServiceException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    public Repository getReportRepository(PathUrl pathUrl) throws RepositoryException {
        SessionContextInterface sc = this.pfs.getSessionContext();
        try {
            UserContextInterface uc = sc.getUserContext();
            if (UtilReportReposService.credentialsAccessible(uc)) {
                return this.OMRService.getReportRepository(pathUrl);
            }
            this.credentialAccessible = false;
            return this.getRepositoryAdapter(uc, pathUrl);
        }
        catch (ServiceException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    public RepositoryService getRepositoryService(String serviceName) {
        if (serviceName.equals(OMRSERVICE)) {
            return this.OMRService;
        }
        return null;
    }

    public void clearCache() {
        try {
            Map omridMap;
            SessionContextInterface sc = this.pfs.getSessionContext();
            if (!this.credentialAccessible) {
                this.reposFacService.clearCache();
            } else if (sc != null && (omridMap = (Map)sc.getAttribute(OMRID.SESSION_CONTEXT_MAP_KEY)) != null) {
                for (OMRID omrid : omridMap.values()) {
                    omrid.getCache().clearCache();
                    SoftwareComponent bipService = omrid.findBIPService();
                    AssociationList rootTrees = bipService.getSoftwareTrees(true);
                    for (Object obj : rootTrees) {
                        if (!(obj instanceof Tree)) continue;
                        ((Tree)obj).getDocuments(true);
                    }
                    omrid.clearContentRootCache();
                }
            }
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e, e.getMessage());
        }
    }

    public String getCacheStatus() {
        String result = "";
        try {
            Map omridMap;
            SessionContextInterface sc = this.pfs.getSessionContext();
            if (!this.credentialAccessible) {
                return this.reposFacService.getCacheStatus();
            }
            if (sc != null && (omridMap = (Map)sc.getAttribute(OMRID.SESSION_CONTEXT_MAP_KEY)) != null) {
                for (OMRID omrid : omridMap.values()) {
                    result = result + omrid.getCache().toString();
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e, e.getMessage());
        }
    }

    public Repository getRepositoryAdapter(UserContextInterface userContext, PathUrl pathUrl) throws RemoteException, ServiceException {
        if (pathUrl == null || pathUrl.getServer().length() == 0) {
            return null;
        }
        ServerInterface server = userContext.getServer(pathUrl.getServer());
        PathUrl pathUrlClone = (PathUrl)pathUrl.clone();
        pathUrlClone.setPath(null);
        pathUrlClone.setType(null);
        pathUrlClone.setName(null);
        MetadataInterface md = server.getObjectByPath(pathUrlClone);
        String reposName = md.getRepositoryName();
        this.reposFacService = UtilReportReposService.getRepositoryFactoryService(null, userContext);
        return UtilReportReposService.getRepositoryAdapter(null, userContext, reposName);
    }

    public Repository getRepositoryAdapter(UserContextInterface userContext, String repositoryName) throws RemoteException, ServiceException {
        this.reposFacService = UtilReportReposService.getRepositoryFactoryService(null, userContext);
        return UtilReportReposService.getRepositoryAdapter(null, userContext, repositoryName);
    }

    public static SchedulingDeleteHelperInterface getSchedulingDeleteHelperInstance() {
        try {
            Class<?> helperClass = Class.forName("com.sas.scheduler.api.oma.SchedulingDeleteHelper");
            Object o = helperClass.newInstance();
            return (SchedulingDeleteHelperInterface)o;
        }
        catch (Exception e) {
            System.err.println("ERROR getting scheduling delete helper instance.");
            e.printStackTrace();
            return null;
        }
    }
}

