/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.ReportTypeDescriptor;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ReportTypeDescriptorNonPlatform
extends ReportTypeDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(ReportTypeDescriptorNonPlatform.class);
    private static int TOTAL_INIT_NONPLATFORM_TYPES = 20;
    private static Map<ReportTypeDescriptor.ServerComparer, Collection<ReportTypeDescriptor>> reportTypeDescriptorsCollectionMap = new HashMap<ReportTypeDescriptor.ServerComparer, Collection<ReportTypeDescriptor>>();
    private static Map<ReportTypeDescriptor.ServerComparer, Collection<String>> publicTypesCollectionMap = new HashMap<ReportTypeDescriptor.ServerComparer, Collection<String>>();
    private static Map<ReportTypeDescriptor.ServerComparer, Collection<ReportTypeDescriptor>> reportTypeDescriptorsSupportingAddContentCollectionMap = new HashMap<ReportTypeDescriptor.ServerComparer, Collection<ReportTypeDescriptor>>();
    private static Map<ReportTypeDescriptor.ServerComparer, Collection<String>> publicTypesSupportingAddContentCollectionMap = new HashMap<ReportTypeDescriptor.ServerComparer, Collection<String>>();
    private static Map<ReportTypeDescriptor.ServerComparer, Map<String, ReportTypeDescriptor>> publicTypeToReportTypeDescriptorMapMap = new HashMap<ReportTypeDescriptor.ServerComparer, Map<String, ReportTypeDescriptor>>();

    ReportTypeDescriptorNonPlatform() {
    }

    protected static void initializeReportTypeDescriptor(ReportTypeDescriptor.ServerComparer serverComparer) {
        HashSet<ReportTypeDescriptor> reportTypeDescriptorSet = new HashSet<ReportTypeDescriptor>(TOTAL_INIT_NONPLATFORM_TYPES);
        HashSet<String> publicTypesSet = new HashSet<String>(TOTAL_INIT_NONPLATFORM_TYPES);
        HashSet<ReportTypeDescriptor> reportTypeDescriptorSupportingAddContentSet = new HashSet<ReportTypeDescriptor>(TOTAL_INIT_NONPLATFORM_TYPES);
        HashSet<String> publicTypesSupportingAddContentSet = new HashSet<String>(TOTAL_INIT_NONPLATFORM_TYPES);
        HashMap<String, ReportTypeDescriptor> publicTypeToReportTypeDescriptorMap = new HashMap<String, ReportTypeDescriptor>(TOTAL_INIT_NONPLATFORM_TYPES);
        try {
            ServerInterface server = serverComparer.getServer();
            for (TypeDescriptorInterface type : ((MetadataServerInterface)server).getTypeDictionaryMap().values()) {
                String typeName = type.getTypeName();
                if (type.getPropertyValue("ReportTypeDescriptorClass") == null) continue;
                try {
                    ReportTypeDescriptor typeDescriptor = ReportTypeDescriptor.getInstance(type);
                    if (typeDescriptor.isPlatformType()) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Info: Did not load ReportTypeDescriptor for " + typeName + ".   Platform Type");
                        continue;
                    }
                    reportTypeDescriptorSet.add(typeDescriptor);
                    publicTypesSet.add(typeName);
                    publicTypeToReportTypeDescriptorMap.put(typeName, typeDescriptor);
                    if (typeDescriptor.isAddContentSupported()) {
                        reportTypeDescriptorSupportingAddContentSet.add(typeDescriptor);
                        publicTypesSupportingAddContentSet.add(typeName);
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Success: loading ReportTypeDescriptor for " + typeName);
                }
                catch (ClassNotFoundException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Failure: loading ReportTypeDescriptor for " + typeName);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Failure: loading ReportTypeDescriptor for " + typeName + ".  Cause " + e.getMessage());
                }
            }
            reportTypeDescriptorsCollectionMap.put(serverComparer, reportTypeDescriptorSet);
            publicTypesCollectionMap.put(serverComparer, publicTypesSet);
            reportTypeDescriptorsSupportingAddContentCollectionMap.put(serverComparer, reportTypeDescriptorSupportingAddContentSet);
            publicTypesSupportingAddContentCollectionMap.put(serverComparer, publicTypesSupportingAddContentSet);
            publicTypeToReportTypeDescriptorMapMap.put(serverComparer, publicTypeToReportTypeDescriptorMap);
        }
        catch (RemoteException re) {
            throw new RuntimeException(re);
        }
        catch (ServiceException se) {
            throw new RuntimeException(se);
        }
    }

    protected static void deinitializeReportTypeDescriptor(ReportTypeDescriptor.ServerComparer serverComparer) {
        if (reportTypeDescriptorsCollectionMap.containsKey(serverComparer)) {
            reportTypeDescriptorsCollectionMap.remove(serverComparer);
        }
        if (publicTypesCollectionMap.containsKey(serverComparer)) {
            publicTypesCollectionMap.remove(serverComparer);
        }
        if (reportTypeDescriptorsSupportingAddContentCollectionMap.containsKey(serverComparer)) {
            reportTypeDescriptorsSupportingAddContentCollectionMap.remove(serverComparer);
        }
        if (publicTypesSupportingAddContentCollectionMap.containsKey(serverComparer)) {
            publicTypesSupportingAddContentCollectionMap.remove(serverComparer);
        }
        if (publicTypeToReportTypeDescriptorMapMap.containsKey(serverComparer)) {
            publicTypeToReportTypeDescriptorMapMap.remove(serverComparer);
        }
    }

    public static Collection<ReportTypeDescriptor> getAllTypeDescriptors(ServerInterface server) {
        ReportTypeDescriptor.ServerComparer sc = new ReportTypeDescriptor.ServerComparer(server);
        return reportTypeDescriptorsCollectionMap.containsKey(sc) ? reportTypeDescriptorsCollectionMap.get(sc) : null;
    }

    public static Collection<String> getAllPublicTypes(ServerInterface server) {
        ReportTypeDescriptor.ServerComparer sc = new ReportTypeDescriptor.ServerComparer(server);
        return publicTypesCollectionMap.containsKey(sc) ? publicTypesCollectionMap.get(sc) : null;
    }

    public static Collection<ReportTypeDescriptor> getTypeDescriptorsSupportingAddContent(ServerInterface server) {
        ReportTypeDescriptor.ServerComparer sc = new ReportTypeDescriptor.ServerComparer(server);
        return reportTypeDescriptorsSupportingAddContentCollectionMap.containsKey(sc) ? reportTypeDescriptorsSupportingAddContentCollectionMap.get(sc) : null;
    }

    public static Collection<String> getPublicTypesSupportingAddContent(ServerInterface server) {
        ReportTypeDescriptor.ServerComparer sc = new ReportTypeDescriptor.ServerComparer(server);
        return publicTypesSupportingAddContentCollectionMap.containsKey(sc) ? publicTypesSupportingAddContentCollectionMap.get(sc) : null;
    }

    public static Map<String, ReportTypeDescriptor> getPublicTypeToReportTypeDescriptorMap(ServerInterface server) {
        ReportTypeDescriptor.ServerComparer sc = new ReportTypeDescriptor.ServerComparer(server);
        return publicTypeToReportTypeDescriptorMapMap.containsKey(sc) ? publicTypeToReportTypeDescriptorMapMap.get(sc) : null;
    }
}

