/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.nls.collator.SASCollator;
import com.sas.nls.collator.SASCollatorFactory;
import com.sas.nls.collator.SASStringComparator;
import com.sas.report.repository.AddContentPostProcessorInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.ReportEntryCreator;
import com.sas.report.repository.ReportEntryCreatorInterface;
import com.sas.report.repository.ReportTypeDescriptorLegacy;
import com.sas.report.repository.ReportTypeDescriptorNonPlatform;
import com.sas.report.repository.ReportTypeDescriptorPlatform;
import com.sas.report.repository.RepositoryException;
import com.sas.services.ServiceException;
import com.sas.services.information.Factory;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.filechooser.FileFilter;

public class ReportTypeDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean INCLUDE_LEGACY = true;
    private static final boolean INCLUDE_PLATFORM = true;
    private static final boolean INCLUDE_NONPLATFORM = true;
    private static Map<ServerComparer, Collection<ReportTypeDescriptor>> reportTypeDescriptorsCollectionMap = new HashMap<ServerComparer, Collection<ReportTypeDescriptor>>();
    private static Map<ServerComparer, Collection<String>> publicTypesCollectionMap = new HashMap<ServerComparer, Collection<String>>();
    private static Map<ServerComparer, Collection<ReportTypeDescriptor>> reportTypeDescriptorSupportingAddContentCollectionMap = new HashMap<ServerComparer, Collection<ReportTypeDescriptor>>();
    private static Map<ServerComparer, Collection<String>> publicTypesSupportingAddContentCollectionMap = new HashMap<ServerComparer, Collection<String>>();
    private static Map<ServerComparer, Map<String, ReportTypeDescriptor>> publicTypeToReportTypeDescriptorMapMap = new HashMap<ServerComparer, Map<String, ReportTypeDescriptor>>();
    private static Map<ServerComparer, Map<Locale, FileFilter[]>> addContentFiltersMapMap = new HashMap<ServerComparer, Map<Locale, FileFilter[]>>();
    private static Set<ServerComparer> initializationFlagSet = new HashSet<ServerComparer>();
    private static Object initializerToken = new Object();
    private static Object initializerFileFilterToken = new Object();

    public static ReportTypeDescriptor getInstance(ServerInterface server, String typeName) {
        ServerComparer sc = new ServerComparer(server);
        if (!ReportTypeDescriptor.isReportTypeDescriptorInitialized(sc)) {
            ReportTypeDescriptor.initializeReportTypeDescriptor(sc);
        }
        if (!publicTypeToReportTypeDescriptorMapMap.containsKey(sc)) {
            return null;
        }
        Map<String, ReportTypeDescriptor> typeNameToReportTypeDescriptorMap = publicTypeToReportTypeDescriptorMapMap.get(sc);
        return typeNameToReportTypeDescriptorMap.containsKey(typeName) ? typeNameToReportTypeDescriptorMap.get(typeName) : null;
    }

    public static ReportTypeDescriptor getInstance(TypeDescriptorInterface typeDescriptor) throws ClassNotFoundException, ServiceException {
        String typeName;
        block4: {
            typeName = null;
            try {
                typeName = typeDescriptor.getTypeName();
                String className = typeDescriptor.getPropertyValue("ReportTypeDescriptorClass");
                ReportTypeDescriptor _rd = ReportTypeDescriptor.getReportTypeDescriptor(className);
                if (_rd != null) {
                    return _rd;
                }
            }
            catch (RemoteException e) {
                if (typeName != null) break block4;
                throw new ServiceException((Throwable)e);
            }
        }
        for (Map<String, ReportTypeDescriptor> map : publicTypeToReportTypeDescriptorMapMap.values()) {
            if (!map.containsKey(typeName)) continue;
            return map.get(typeName);
        }
        return null;
    }

    protected static ReportTypeDescriptor getReportTypeDescriptor(String reportTypeDescriptorClassName) {
        try {
            Class<?> clazz = Class.forName(reportTypeDescriptorClassName);
            Constructor<?> ctor = null;
            ctor = clazz.getConstructor(new Class[0]);
            return (ReportTypeDescriptor)ctor.newInstance(new Object[0]);
        }
        catch (Exception clazz) {
            try {
                Factory factory = Factory.getInstance();
                if (!factory.isConfigured()) {
                    InformationServiceInterface _is = Metadata.getInformationService();
                    HashMap config = null;
                    try {
                        config = _is.getFactoryConfig();
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                    factory.configure((Map)config);
                }
                return (ReportTypeDescriptor)factory.newInstance(reportTypeDescriptorClassName);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static Collection<ReportTypeDescriptor> getAllTypeDescriptors(ServerInterface server) {
        ServerComparer sc = new ServerComparer(server);
        if (!ReportTypeDescriptor.isReportTypeDescriptorInitialized(sc)) {
            ReportTypeDescriptor.initializeReportTypeDescriptor(sc);
        }
        return reportTypeDescriptorsCollectionMap.containsKey(sc) ? reportTypeDescriptorsCollectionMap.get(sc) : null;
    }

    public static Collection<ReportTypeDescriptor> getTypeDescriptorsSupportingAddContent(ServerInterface server) {
        ServerComparer sc = new ServerComparer(server);
        if (!ReportTypeDescriptor.isReportTypeDescriptorInitialized(sc)) {
            ReportTypeDescriptor.initializeReportTypeDescriptor(sc);
        }
        return reportTypeDescriptorSupportingAddContentCollectionMap.containsKey(sc) ? reportTypeDescriptorSupportingAddContentCollectionMap.get(sc) : null;
    }

    public static Collection<String> getAllPublicTypes(ServerInterface server) {
        ServerComparer sc = new ServerComparer(server);
        if (!ReportTypeDescriptor.isReportTypeDescriptorInitialized(sc)) {
            ReportTypeDescriptor.initializeReportTypeDescriptor(sc);
        }
        return publicTypesCollectionMap.containsKey(sc) ? publicTypesCollectionMap.get(sc) : null;
    }

    public static Collection<String> getPublicTypesSupportingAddContent(ServerInterface server) {
        ServerComparer sc = new ServerComparer(server);
        if (!ReportTypeDescriptor.isReportTypeDescriptorInitialized(sc)) {
            ReportTypeDescriptor.initializeReportTypeDescriptor(sc);
        }
        return publicTypesSupportingAddContentCollectionMap.containsKey(sc) ? publicTypesSupportingAddContentCollectionMap.get(sc) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileFilter[] getAllAddContentFileFilters(ServerInterface server, Locale locale) {
        Map<Locale, FileFilter[]> addContentFiltersMap;
        ServerComparer sc = new ServerComparer(server);
        if (!ReportTypeDescriptor.isReportTypeDescriptorInitialized(sc)) {
            ReportTypeDescriptor.initializeReportTypeDescriptor(sc);
        }
        if (!addContentFiltersMapMap.containsKey(server)) {
            Object object = initializerFileFilterToken;
            synchronized (object) {
                if (!addContentFiltersMapMap.containsKey(server)) {
                    addContentFiltersMap = new HashMap<Locale, FileFilter[]>();
                    addContentFiltersMapMap.put(sc, addContentFiltersMap);
                } else {
                    addContentFiltersMap = addContentFiltersMapMap.get(sc);
                }
            }
        } else {
            addContentFiltersMap = addContentFiltersMapMap.get(sc);
        }
        if (addContentFiltersMap.containsKey(locale)) {
            return addContentFiltersMap.get(locale);
        }
        if (!reportTypeDescriptorsCollectionMap.containsKey(sc)) {
            return null;
        }
        Collection<ReportTypeDescriptor> RTDs = reportTypeDescriptorsCollectionMap.get(sc);
        ArrayList<FileFilter> fileFilterList = new ArrayList<FileFilter>();
        for (ReportTypeDescriptor rtd : RTDs) {
            if (!rtd.isAddContentSupported()) continue;
            fileFilterList.add(rtd.getAddContentFileFilter(locale));
        }
        FileFilter[] fileFilterArray = new FileFilter[fileFilterList.size()];
        int i = 0;
        for (FileFilter filter : fileFilterList) {
            fileFilterArray[i++] = filter;
        }
        Arrays.sort(fileFilterArray, new Comparator<FileFilter>(){

            @Override
            public int compare(FileFilter ff1, FileFilter ff2) {
                if (ff1 == null || ff2 == null) {
                    return 0;
                }
                String name1 = ff1.getDescription();
                String name2 = ff2.getDescription();
                if (name1 == null || name2 == null) {
                    return 0;
                }
                SASStringComparator comparator = SASCollatorFactory.createCollator((Locale)Locale.getDefault());
                if (comparator instanceof SASCollator) {
                    SASCollator _colator = (SASCollator)comparator;
                    _colator.setStrength(0);
                    return _colator.compare(name1, name2);
                }
                Collator _colator = Collator.getInstance(Locale.getDefault());
                return _colator.compare(name1, name2);
            }
        });
        Object object = initializerFileFilterToken;
        synchronized (object) {
            if (addContentFiltersMap.containsKey(locale)) {
                fileFilterArray = addContentFiltersMap.get(locale);
            } else {
                addContentFiltersMap.put(locale, fileFilterArray);
            }
        }
        return fileFilterArray;
    }

    private static boolean isReportTypeDescriptorInitialized(ServerComparer serverComparer) {
        return initializationFlagSet.contains(serverComparer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeReportTypeDescriptor(ServerComparer serverComparer) {
        Object object = initializerToken;
        synchronized (object) {
            if (!ReportTypeDescriptor.isReportTypeDescriptorInitialized(serverComparer)) {
                ServerInterface server = serverComparer.getServer();
                try {
                    ReportTypeDescriptorLegacy.initializeReportTypeDescriptor(serverComparer);
                    ReportTypeDescriptorNonPlatform.initializeReportTypeDescriptor(serverComparer);
                    ReportTypeDescriptorPlatform.initializeReportTypeDescriptor(serverComparer);
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                HashSet<ReportTypeDescriptor> reportTypeDescriptorSet = new HashSet<ReportTypeDescriptor>(25);
                reportTypeDescriptorSet.addAll(ReportTypeDescriptorLegacy.getAllTypeDescriptors(server));
                reportTypeDescriptorSet.addAll(ReportTypeDescriptorNonPlatform.getAllTypeDescriptors(server));
                reportTypeDescriptorSet.addAll(ReportTypeDescriptorPlatform.getAllTypeDescriptors(server));
                reportTypeDescriptorsCollectionMap.put(serverComparer, Collections.unmodifiableSet(reportTypeDescriptorSet));
                HashSet<String> publicTypesSet = new HashSet<String>(25);
                publicTypesSet.addAll(ReportTypeDescriptorLegacy.getAllPublicTypes(server));
                publicTypesSet.addAll(ReportTypeDescriptorNonPlatform.getAllPublicTypes(server));
                publicTypesSet.addAll(ReportTypeDescriptorPlatform.getAllPublicTypes(server));
                publicTypesCollectionMap.put(serverComparer, Collections.unmodifiableSet(publicTypesSet));
                HashSet<ReportTypeDescriptor> reportTypeDescriptorSupportingAddContentSet = new HashSet<ReportTypeDescriptor>(25);
                reportTypeDescriptorSupportingAddContentSet.addAll(ReportTypeDescriptorLegacy.getTypeDescriptorsSupportingAddContent(server));
                reportTypeDescriptorSupportingAddContentSet.addAll(ReportTypeDescriptorNonPlatform.getTypeDescriptorsSupportingAddContent(server));
                reportTypeDescriptorSupportingAddContentSet.addAll(ReportTypeDescriptorPlatform.getTypeDescriptorsSupportingAddContent(server));
                reportTypeDescriptorSupportingAddContentCollectionMap.put(serverComparer, Collections.unmodifiableSet(reportTypeDescriptorSupportingAddContentSet));
                HashSet<String> publicTypesSupportingAddContentSet = new HashSet<String>(25);
                publicTypesSupportingAddContentSet.addAll(ReportTypeDescriptorLegacy.getPublicTypesSupportingAddContent(server));
                publicTypesSupportingAddContentSet.addAll(ReportTypeDescriptorNonPlatform.getPublicTypesSupportingAddContent(server));
                publicTypesSupportingAddContentSet.addAll(ReportTypeDescriptorPlatform.getPublicTypesSupportingAddContent(server));
                publicTypesSupportingAddContentCollectionMap.put(serverComparer, Collections.unmodifiableSet(publicTypesSupportingAddContentSet));
                HashMap<String, ReportTypeDescriptor> publicTypeToReportTypeDescriptorMap = new HashMap<String, ReportTypeDescriptor>();
                publicTypeToReportTypeDescriptorMap.putAll(ReportTypeDescriptorLegacy.getPublicTypeToReportTypeDescriptorMap(server));
                publicTypeToReportTypeDescriptorMap.putAll(ReportTypeDescriptorNonPlatform.getPublicTypeToReportTypeDescriptorMap(server));
                publicTypeToReportTypeDescriptorMap.putAll(ReportTypeDescriptorPlatform.getPublicTypeToReportTypeDescriptorMap(server));
                publicTypeToReportTypeDescriptorMapMap.put(serverComparer, Collections.unmodifiableMap(publicTypeToReportTypeDescriptorMap));
                ReportTypeDescriptorLegacy.deinitializeReportTypeDescriptor(serverComparer);
                ReportTypeDescriptorNonPlatform.deinitializeReportTypeDescriptor(serverComparer);
                ReportTypeDescriptorPlatform.deinitializeReportTypeDescriptor(serverComparer);
                initializationFlagSet.add(serverComparer);
            }
        }
    }

    public boolean isPlatformType() {
        return true;
    }

    public boolean isAddContentSupported() {
        return true;
    }

    public FileFilter getAddContentFileFilter(Locale locale) {
        return null;
    }

    public ReportEntryCreatorInterface getEntryCreator() throws RepositoryException {
        return new ReportEntryCreator();
    }

    protected static String generateDescription(String label, String[] extensions) {
        StringBuffer description = new StringBuffer(label + ", (");
        boolean first = true;
        for (String extension : extensions) {
            if (first) {
                first = false;
            } else {
                description.append(", ");
            }
            description.append("*.");
            description.append(extension);
        }
        description.append(")");
        return description.toString();
    }

    public AddContentPostProcessorInterface getAddContentPostProcessor(ServerInterface server, EntryInterface entry) {
        return null;
    }

    private static class HashCodeUtil {
        public static final int SEED = 23;

        private HashCodeUtil() {
        }

        public static int hash(int paramInt1, int paramInt2) {
            return HashCodeUtil.firstTerm(paramInt1) + paramInt2;
        }

        public static int hash(int paramInt, Object paramObject) {
            int i = paramInt;
            if (paramObject == null) {
                i = HashCodeUtil.hash(i, 0);
            } else if (!HashCodeUtil.isArray(paramObject)) {
                i = HashCodeUtil.hash(i, paramObject.hashCode());
            } else {
                int j = Array.getLength(paramObject);
                for (int k = 0; k < j; ++k) {
                    Object localObject = Array.get(paramObject, k);
                    i = HashCodeUtil.hash(i, localObject);
                }
            }
            return i;
        }

        private static int firstTerm(int paramInt) {
            return 37 * paramInt;
        }

        private static boolean isArray(Object paramObject) {
            return paramObject.getClass().isArray();
        }
    }

    protected static class ServerComparer
    implements Comparable<Object> {
        private final int BEFORE = -1;
        private final int EQUAL = 0;
        private final int AFTER = 1;
        private ServerInterface _server = null;

        public ServerInterface getServer() {
            return this._server;
        }

        public ServerComparer(ServerInterface server) {
            this._server = server;
        }

        @Override
        public int compareTo(Object other) {
            if (other instanceof ServerComparer) {
                try {
                    ServerInterface _otherServer = ((ServerComparer)other).getServer();
                    int _otherServerPort = _otherServer.getPort();
                    int _serverPort = this._server.getPort();
                    if (_serverPort < _otherServerPort) {
                        return -1;
                    }
                    if (_serverPort > _otherServerPort) {
                        return 1;
                    }
                    String _otherServerHost = _otherServer.getHost();
                    String _serverHost = this._server.getHost();
                    int compare = _serverHost.compareTo(_otherServerHost);
                    if (compare != 0) {
                        return compare;
                    }
                    return this._server.getProtocol().compareTo(_otherServer.getProtocol());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return 1;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ServerComparer)) {
                return false;
            }
            int compare = this.compareTo(other);
            return compare == 0;
        }

        public int hashCode() {
            int result = 23;
            try {
                result = HashCodeUtil.hash(result, this._server.getPort());
                result = HashCodeUtil.hash(result, this._server.getHost());
                result = HashCodeUtil.hash(result, this._server.getProtocol());
                return result;
            }
            catch (Exception exception) {
                return HashCodeUtil.hash(23, this._server);
            }
        }
    }
}

