/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.Entry;
import com.sas.report.repository.RB;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

class ReportManagementCache {
    private static long totalCacheGets = 0L;
    private static long totalCacheHits = 0L;
    private Map myHashMap;
    private ReferenceQueue myRefQueue;
    private final int myPurgeFrequency;
    private int myAccessCount;

    public ReportManagementCache(int purgeFrequency) {
        this.myPurgeFrequency = purgeFrequency;
        this.myHashMap = new HashMap();
        this.myRefQueue = new ReferenceQueue();
    }

    public ReportManagementCache() {
        this(50);
    }

    public synchronized void put(String key, Object obj) {
        if (key == null) {
            throw new IllegalArgumentException(RB.getStringResource("ReportManagementCacheNullKey.txt"));
        }
        if (obj == null) {
            throw new IllegalArgumentException(RB.getStringResource("ReportManagementCacheNullKey.txt"));
        }
        this.runPurge();
        WeakRef ref = new WeakRef(key, obj, this.myRefQueue);
        this.myHashMap.put(key, ref);
    }

    public synchronized Object get(String key) {
        ++totalCacheGets;
        this.runPurge();
        WeakRef ref = (WeakRef)this.myHashMap.get(key);
        if (ref == null) {
            return null;
        }
        Object cachedObj = ref.get();
        if (cachedObj == null) {
            this.myHashMap.remove(key);
            return null;
        }
        ++totalCacheHits;
        return cachedObj;
    }

    public synchronized void remove(String key) {
        this.myHashMap.remove(key);
    }

    public synchronized void clearCache() {
        for (WeakRef ref : this.myHashMap.values()) {
            Entry entry;
            Object obj;
            if (ref == null || !((obj = ref.get()) instanceof Entry) || (entry = (Entry)obj) == null) continue;
            entry.invalidatePathUrl();
        }
        this.myHashMap.clear();
    }

    public String toString() {
        this.removeUnreferencedEntries();
        int ndx = 1;
        StringBuffer buf = new StringBuffer();
        buf.append("===== Report Repository Object Cache [");
        buf.append(super.toString());
        buf.append("=====\n");
        for (Map.Entry entry : this.myHashMap.entrySet()) {
            String key = (String)entry.getKey();
            buf.append(ndx++);
            buf.append(" : ");
            buf.append(key);
            WeakRef ref = (WeakRef)entry.getValue();
            if (ref != null) {
                Object obj = ref.get();
                if (obj != null) {
                    buf.append(" ==> [");
                    buf.append(obj.getClass());
                    buf.append("] ");
                    buf.append(obj);
                } else {
                    buf.append("  <<<ref.get() == null>>>");
                }
            } else {
                buf.append("  <<< ref == null >>>");
            }
            buf.append("\n");
        }
        buf.append("==========================================\n");
        buf.append("Cache hit rate: ");
        buf.append(totalCacheHits);
        buf.append(" / ");
        buf.append(totalCacheGets);
        if (totalCacheGets > 0L) {
            buf.append(" = ");
            buf.append(100L * totalCacheHits / totalCacheGets);
            buf.append("%\n");
        }
        return buf.toString();
    }

    private void runPurgePeriodically() {
        ++this.myAccessCount;
        if (this.myAccessCount > this.myPurgeFrequency) {
            this.removeUnreferencedEntries();
            this.myAccessCount = 0;
        }
    }

    private void runPurge() {
        this.removeUnreferencedEntries();
    }

    private void removeUnreferencedEntries() {
        WeakRef ref;
        while ((ref = (WeakRef)this.myRefQueue.poll()) != null) {
            this.myHashMap.remove(ref.getKey());
        }
    }

    private static class WeakRef
    extends WeakReference {
        private final String myKey;

        public WeakRef(String key, Object cachedObj, ReferenceQueue q) {
            super(cachedObj, q);
            this.myKey = key;
        }

        public String getKey() {
            return this.myKey;
        }
    }
}

