/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.io.RemoteInputStream;
import com.sas.io.RemoteInputStreamInterface;
import com.sas.io.RemoteOutputStream;
import com.sas.io.RemoteOutputStreamInterface;
import com.sas.report.repository.AgingPolicy;
import com.sas.report.repository.CacheSetInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.OMRDirectory;
import com.sas.report.repository.OMREntry;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.RemoteCacheSet;
import com.sas.report.repository.RemoteCacheSetInterface;
import com.sas.report.repository.RemoteDirectory;
import com.sas.report.repository.RemoteDirectoryInterface;
import com.sas.report.repository.RemoteEntryInterface;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryNotDirectoryException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.services.information.metadata.PathUrl;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import java.util.Map;

class RemoteEntry
extends UnicastRemoteObject
implements RemoteEntryInterface {
    private OMREntry myLocalEntry;

    public RemoteEntry(EntryInterface localEntry) throws RemoteException, IllegalArgumentException {
        if (!(localEntry instanceof OMREntry)) {
            throw new IllegalArgumentException(RBUtil.getStringResource("RemoteEntry.CastError.txt", localEntry));
        }
        this.myLocalEntry = (OMREntry)localEntry;
    }

    @Override
    public AgingPolicy getAgingPolicy() throws RemoteException, RepositoryException, SecurityException {
        return this.myLocalEntry.getAgingPolicy();
    }

    @Override
    public boolean canRead() throws RemoteException, SecurityException {
        return this.myLocalEntry.canRead();
    }

    @Override
    public boolean canWrite() throws RemoteException, SecurityException {
        return this.myLocalEntry.canWrite();
    }

    @Override
    public boolean entryExists(String entryName) throws RemoteException, RepositoryIllegalNameException, RepositoryException, SecurityException {
        return this.myLocalEntry.entryExists(entryName);
    }

    @Override
    public boolean isDirectory() throws RemoteException {
        return this.myLocalEntry.isDirectory();
    }

    @Override
    public boolean isEmpty() throws RemoteException, RepositoryException {
        return this.myLocalEntry.isEmpty();
    }

    @Override
    public boolean isKeyword(String keyword) throws RemoteException, RepositoryException, SecurityException {
        return this.myLocalEntry.isKeyword(keyword);
    }

    @Override
    public RemoteCacheSetInterface getCacheSetInterface() throws RemoteException, RepositoryException {
        CacheSetInterface localCacheSet = this.myLocalEntry.getCacheSetInterface();
        return new RemoteCacheSet(localCacheSet);
    }

    @Override
    public RemoteEntryInterface createEntry(Object entryMetadataObject) throws RemoteException, RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        EntryInterface entry = this.myLocalEntry.createEntry(entryMetadataObject);
        return new RemoteEntry(entry);
    }

    @Override
    public RemoteEntryInterface createEntry(String entryName) throws RemoteException, RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        EntryInterface entry = this.myLocalEntry.createEntry(entryName);
        return new RemoteEntry(entry);
    }

    @Override
    public RemoteEntryInterface createEntry(String entryName, AgingPolicy agePolicy) throws RemoteException, RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        EntryInterface entry = this.myLocalEntry.createEntry(entryName, agePolicy);
        return new RemoteEntry(entry);
    }

    @Override
    public RemoteEntryInterface getEntry(String entryName) throws RemoteException, RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryException, SecurityException {
        EntryInterface entry = this.myLocalEntry.getEntry(entryName);
        return new RemoteEntry(entry);
    }

    @Override
    public RemoteEntryInterface getEntry(String entryName, long generation) throws RemoteException, RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryException, SecurityException {
        EntryInterface entry = this.myLocalEntry.getEntry(entryName, generation);
        return new RemoteEntry(entry);
    }

    @Override
    public RemoteEntryInterface getGeneration(long generation) throws RemoteException, RepositoryNotFoundException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RemoteDirectoryInterface getParentEntry() throws RemoteException, RepositoryNotFoundException, RepositoryException, SecurityException {
        OMRDirectory parentDir = (OMRDirectory)this.myLocalEntry.getParentEntry();
        return new RemoteDirectory(parentDir);
    }

    @Override
    public RemoteInputStreamInterface getInputStream() throws RemoteException, RepositoryIOException, SecurityException {
        InputStream is = this.myLocalEntry.getInputStream();
        return new RemoteInputStream(is);
    }

    @Override
    public Map getAttributesAsMap() throws RemoteException, RepositoryException, SecurityException {
        Map attribMap = this.myLocalEntry.getAttributesAsMap();
        return attribMap;
    }

    @Override
    public List getKeywords() throws RemoteException, RepositoryException, SecurityException {
        return this.myLocalEntry.getKeywordsAsList();
    }

    @Override
    public long getSizeOfContent() throws RemoteException, UnsupportedOperationException, RepositoryException {
        return this.myLocalEntry.getSizeOfContent();
    }

    @Override
    public Object getAttribute(String attribName) throws RemoteException, RepositoryNotFoundException, RepositoryException, SecurityException {
        return this.myLocalEntry.getAttribute(attribName);
    }

    @Override
    public Object getMetadataObject() throws RemoteException {
        return this.myLocalEntry.getMetadataObject();
    }

    @Override
    public RemoteOutputStreamInterface getOutputStream() throws RemoteException, SecurityException, RepositoryIOException {
        OutputStream os = this.myLocalEntry.getOutputStream();
        return new RemoteOutputStream(os);
    }

    @Override
    public RemoteOutputStreamInterface getOutputStream(boolean deleteCaches) throws RemoteException, SecurityException, RepositoryIOException {
        OutputStream os = this.myLocalEntry.getOutputStream(deleteCaches);
        return new RemoteOutputStream(os);
    }

    @Override
    public PathUrl getLocationUrl() throws RemoteException, RepositoryException {
        return this.myLocalEntry.getLocationUrl();
    }

    @Override
    public String getContentLocation() throws RemoteException, RepositoryException {
        return this.myLocalEntry.getContentLocation();
    }

    @Override
    public String getName() throws RemoteException {
        return this.myLocalEntry.getName();
    }

    @Override
    public String getParent() throws RemoteException, RepositoryNotFoundException, RepositoryException, SecurityException {
        return this.myLocalEntry.getParent();
    }

    @Override
    public void addKeyword(String keyword) throws RemoteException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        this.myLocalEntry.addKeyword(keyword);
    }

    @Override
    public void addKeyword(String keyword, String keywordDescription) throws RemoteException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        this.myLocalEntry.addKeyword(keyword, keywordDescription);
    }

    @Override
    public void addKeywords(List keywords) throws RemoteException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        this.myLocalEntry.addKeywords(keywords);
    }

    @Override
    public void age(long generationIncrement) throws RemoteException, RepositoryException, SecurityException {
        this.myLocalEntry.age(generationIncrement);
    }

    EntryInterface getLocalEntry() {
        return this.myLocalEntry;
    }

    @Override
    public void copyTo(PathUrl destPathUrl) throws RemoteException, RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        this.myLocalEntry.copyTo(destPathUrl);
    }

    @Override
    public void copyWithoutCaches(PathUrl destPathUrl) throws RemoteException, RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        this.myLocalEntry.copyWithoutCaches(destPathUrl);
    }

    @Override
    public void moveTo(PathUrl destPathUrl) throws RemoteException, RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        this.myLocalEntry.moveTo(destPathUrl);
    }

    @Override
    public void delete() throws RemoteException, RepositoryLockedException, RepositoryException, SecurityException {
        this.myLocalEntry.delete();
    }

    @Override
    public void delete(long generation) throws RemoteException, RepositoryLockedException, RepositoryException, SecurityException {
        this.myLocalEntry.delete(generation);
    }

    @Override
    public void deleteContent() throws RemoteException, RepositoryLockedException, RepositoryException, SecurityException {
        this.myLocalEntry.deleteContent();
    }

    public void moveTo(RemoteEntryInterface entry) throws RemoteException, RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RBUtil.getStringResource("RemoteEntry.MoveToNotSupported.txt"));
    }

    @Override
    public void removeAllKeywords() throws RemoteException, RepositoryLockedException, RepositoryException, SecurityException {
        this.myLocalEntry.removeAllKeywords();
    }

    @Override
    public void removeKeyword(String keyword) throws RemoteException, RepositoryLockedException, RepositoryException, SecurityException {
        this.myLocalEntry.removeKeyword(keyword);
    }

    @Override
    public void renameTo(String newContentName) throws RemoteException, RepositoryIllegalNameException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        this.myLocalEntry.renameTo(newContentName);
    }

    @Override
    public void setAgingPolicy(AgingPolicy agingPolicy) throws RemoteException, RepositoryLockedException, RepositoryException, SecurityException {
        this.myLocalEntry.setAgingPolicy(agingPolicy);
    }

    @Override
    public void setAttribute(String attributeName, Object attributeValue) throws RemoteException, RepositoryLockedException, RepositoryException, SecurityException {
        this.myLocalEntry.setAttribute(attributeName, attributeValue);
    }

    @Override
    public void setAttributes(Map attributes) throws RemoteException, RepositoryLockedException, RepositoryException, SecurityException {
        this.myLocalEntry.setAttributes(attributes);
    }

    @Override
    public void setKeyword(String keyword) throws RemoteException, RepositoryLockedException, RepositoryException, SecurityException {
        this.myLocalEntry.setKeyword(keyword);
    }

    @Override
    public void setKeyword(String keyword, String keywordDescription) throws RemoteException, RepositoryLockedException, RepositoryException, SecurityException {
        this.myLocalEntry.setKeyword(keyword, keywordDescription);
    }

    @Override
    public void setKeywords(List keywords) throws RemoteException, RepositoryLockedException, RepositoryException, SecurityException {
        this.myLocalEntry.setKeywords(keywords);
    }

    @Override
    public String getApplicationData(String applicationDataName) throws RemoteException, RepositoryException {
        return this.myLocalEntry.getApplicationData(applicationDataName);
    }

    @Override
    public void setApplicationData(String applicationDataName, String value) throws RemoteException, RepositoryException {
        this.myLocalEntry.setApplicationData(applicationDataName, value);
    }

    @Override
    public void setApplicationData(String applicationDataName, String value, boolean transientData, boolean updateTimestamps) throws RemoteException, RepositoryException {
        this.myLocalEntry.setApplicationData(applicationDataName, value, transientData, updateTimestamps);
    }

    @Override
    public void refresh() throws RemoteException {
        this.myLocalEntry.refresh();
    }
}

