/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.AgingPolicy;
import com.sas.report.repository.CacheSetInterface;
import com.sas.report.repository.DirectoryInterface;
import com.sas.report.repository.EntryInstantiatorInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.RB;
import com.sas.report.repository.RemoteDirectoryInterface;
import com.sas.report.repository.RemoteEntryAdapter;
import com.sas.report.repository.RemoteEntryInterface;
import com.sas.report.repository.RepositoryCreateException;
import com.sas.report.repository.RepositoryDeleteException;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryFilter;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryMetadataFilter;
import com.sas.report.repository.RepositoryNotDirectoryException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.report.repository.SortOrder;
import com.sas.services.information.metadata.PathUrl;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RemoteDirectoryAdapter
implements DirectoryInterface {
    private RemoteDirectoryInterface myRemoteDir;

    public RemoteDirectoryAdapter(RemoteDirectoryInterface remoteDir) {
        this.myRemoteDir = remoteDir;
    }

    @Override
    public DirectoryInterface getDirectory(String name) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            RemoteDirectoryInterface rmtDir = this.myRemoteDir.getDirectory(name);
            return new RemoteDirectoryAdapter(rmtDir);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public DirectoryInterface createDirectory(String name) throws RepositoryCreateException, RepositoryIllegalNameException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        try {
            RemoteDirectoryInterface rmtDir = this.myRemoteDir.createDirectory(name);
            return new RemoteDirectoryAdapter(rmtDir);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void delete(RepositoryMetadataFilter filter) throws RepositoryDeleteException, RepositoryException {
        try {
            this.myRemoteDir.delete(filter);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public String[] list() throws RepositoryException, SecurityException {
        try {
            return this.myRemoteDir.list();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void list(List directoryV) throws RepositoryException, SecurityException {
        this.list(directoryV, null, null);
    }

    @Override
    public String[] list(RepositoryFilter filter) throws RepositoryException, SecurityException {
        try {
            return this.myRemoteDir.list(filter);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void list(List directoryV, RepositoryFilter filter, SortOrder order) throws RepositoryException, SecurityException {
        List dirs = this.listDirs(filter, order);
        List files = this.listFiles(filter, order);
        directoryV.addAll(dirs);
        directoryV.addAll(files);
    }

    @Override
    public List listDirs(RepositoryFilter filter, SortOrder order) throws RepositoryException, SecurityException {
        try {
            List rmtDirs = this.myRemoteDir.listDirs(filter, order);
            ArrayList<RemoteDirectoryAdapter> adaptedDirs = new ArrayList<RemoteDirectoryAdapter>(rmtDirs.size());
            for (RemoteDirectoryInterface rmtDir : rmtDirs) {
                adaptedDirs.add(new RemoteDirectoryAdapter(rmtDir));
            }
            return adaptedDirs;
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public List listFiles(RepositoryFilter filter, SortOrder order) throws RepositoryException, SecurityException {
        try {
            List rmtFiles = this.myRemoteDir.listFiles(filter, order);
            ArrayList<RemoteEntryAdapter> adaptedFiles = new ArrayList<RemoteEntryAdapter>(rmtFiles.size());
            for (RemoteEntryInterface rmtFile : rmtFiles) {
                adaptedFiles.add(new RemoteEntryAdapter(rmtFile));
            }
            return adaptedFiles;
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public DirectoryInterface ensurePath(PathUrl dirPathUrl) throws RepositoryException {
        try {
            RemoteDirectoryInterface rmtDir = this.myRemoteDir.ensurePath(dirPathUrl);
            return new RemoteDirectoryAdapter(rmtDir);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public PathUrl getLocationUrl() throws RepositoryException {
        try {
            return this.myRemoteDir.getLocationUrl();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public AgingPolicy getAgingPolicy() throws RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void setAgingPolicy(AgingPolicy agingPolicy) throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public Iterator getKeywords() throws RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public boolean isKeyword(String keyword) throws RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void setKeywords(List keywords) throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void setKeyword(String keyword, String keywordDescription) throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void setKeyword(String keyword) throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void addKeywords(List keywords) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void addKeyword(String keyword) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void addKeyword(String keyword, String keywordDescription) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void removeKeyword(String keyword) throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void removeAllKeywords() throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public EntryInterface getGeneration(long generation) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void age(long generationIncrement) throws RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public EntryInterface createEntry(String entryName) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        try {
            RemoteEntryInterface rmtEntry = this.myRemoteDir.createEntry(entryName);
            return new RemoteEntryAdapter(rmtEntry);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public EntryInterface createEntry(String entryName, AgingPolicy agePolicy) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public EntryInterface createEntry(Object entryMetadataObject) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public boolean entryExists(String entryName) throws RepositoryIllegalNameException, RepositoryException, SecurityException {
        try {
            return this.myRemoteDir.entryExists(entryName);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public EntryInterface getEntry(String entryName) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            RemoteEntryInterface rmtEntry = this.myRemoteDir.getEntry(entryName);
            return new RemoteEntryAdapter(rmtEntry);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public EntryInterface getEntry(String entryName, long generation) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void renameTo(String newContentName) throws RepositoryIllegalNameException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.myRemoteDir.renameTo(newContentName);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void moveTo(EntryInterface entry) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void copyTo(EntryInterface entry) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void copyWithoutCaches(EntryInterface destEntry) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void delete(long generation) throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public String getParent() throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            return this.myRemoteDir.getParent();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public boolean canRead() throws SecurityException {
        try {
            return this.myRemoteDir.canRead();
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public boolean canWrite() throws SecurityException {
        try {
            return this.myRemoteDir.canWrite();
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public boolean isDirectory() {
        try {
            return this.myRemoteDir.isDirectory();
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public CacheSetInterface getCacheSetInterface() throws RepositoryException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public OutputStream getOutputStream(boolean deleteCaches) throws SecurityException, RepositoryIOException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public String getContentLocation() throws RepositoryException {
        try {
            return this.myRemoteDir.getContentLocation();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void delete() throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.myRemoteDir.delete();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void deleteContent() throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public Iterator getAttributes() throws RepositoryException, SecurityException {
        try {
            Map attribs = this.myRemoteDir.getAttributes();
            return attribs.entrySet().iterator();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public EntryInterface getParentEntry() throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            RemoteDirectoryInterface rmtDir = this.myRemoteDir.getParentEntry();
            return new RemoteDirectoryAdapter(rmtDir);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void setAttribute(String attributeName, Object attributeValue) throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.myRemoteDir.setAttribute(attributeName, attributeValue);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public void setAttributes(Map attributes) throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.myRemoteDir.setAttributes(attributes);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public Object getMetadataObject() {
        try {
            return this.myRemoteDir.getMetadataObject();
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public String getName() {
        try {
            return this.myRemoteDir.getName();
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public InputStream getInputStream() throws RepositoryIOException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public OutputStream getOutputStream() throws SecurityException, RepositoryIOException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public Object getAttribute(String attribName) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            return this.myRemoteDir.getAttribute(attribName);
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public int read(InputStream stream, byte[] data) throws RepositoryIOException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public int write(OutputStream stream, byte[] data, int len) throws RepositoryIOException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void close(OutputStream stream) throws RepositoryIOException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public boolean isEmpty() throws RepositoryException {
        try {
            return this.myRemoteDir.isEmpty();
        }
        catch (Exception e) {
            throw (RepositoryException)((Object)new RepositoryException(e.getMessage()).initCause(e));
        }
    }

    @Override
    public long getSizeOfContent() throws UnsupportedOperationException, RepositoryException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    RemoteDirectoryInterface getRemoteDirectory() {
        return this.myRemoteDir;
    }

    @Override
    public String getApplicationData(String applicationDataName) {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void setApplicationData(String applicationDataName, String value) {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void setApplicationData(String applicationDataName, String value, boolean transientData, boolean updateTimestamps) throws RepositoryException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void refresh() {
        try {
            this.myRemoteDir.refresh();
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public EntryInterface createEntry(String entryName, EntryInstantiatorInterface ei) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        return null;
    }

    @Override
    public EntryInterface getEntry(String entryName, EntryInstantiatorInterface ei) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryException, SecurityException {
        return null;
    }

    @Override
    public boolean entryExists(String entryName, EntryInstantiatorInterface ei) throws RepositoryIllegalNameException, RepositoryException, SecurityException {
        return this.getName().equals(entryName);
    }
}

