/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.AgingPolicy;
import com.sas.report.repository.DirectoryInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.OMRDirectory;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.RemoteDirectoryInterface;
import com.sas.report.repository.RemoteEntry;
import com.sas.report.repository.RemoteEntryInterface;
import com.sas.report.repository.RepositoryDeleteException;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryFilter;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryMetadataFilter;
import com.sas.report.repository.RepositoryNotDirectoryException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.report.repository.SortOrder;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.PathUrl;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class RemoteDirectory
extends UnicastRemoteObject
implements RemoteDirectoryInterface {
    private OMRDirectory myLocalDirectory;

    public RemoteDirectory(DirectoryInterface localDirectory) throws RemoteException, IllegalArgumentException {
        if (!(localDirectory instanceof OMRDirectory)) {
            throw new IllegalArgumentException("Object cannot be cast to an OMRDirectory: " + localDirectory);
        }
        this.myLocalDirectory = (OMRDirectory)localDirectory;
    }

    @Override
    public boolean canRead() throws RemoteException, SecurityException {
        return this.myLocalDirectory.canRead();
    }

    @Override
    public boolean canWrite() throws RemoteException, SecurityException {
        return this.myLocalDirectory.canWrite();
    }

    @Override
    public boolean isDirectory() throws RemoteException {
        return this.myLocalDirectory.isDirectory();
    }

    @Override
    public boolean isEmpty() throws RemoteException, RepositoryException {
        return this.myLocalDirectory.isEmpty();
    }

    @Override
    public RemoteDirectoryInterface createDirectory(String dirName) throws RemoteException, RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        DirectoryInterface dir = this.myLocalDirectory.createDirectory(dirName);
        return new RemoteDirectory(dir);
    }

    @Override
    public Map getAttributes() throws RemoteException, RepositoryException, SecurityException {
        return this.myLocalDirectory.getAttributesAsMap();
    }

    @Override
    public Object getAttribute(String attribName) throws RemoteException, RepositoryNotFoundException, RepositoryException, SecurityException {
        return this.myLocalDirectory.getAttribute(attribName);
    }

    @Override
    public Object getMetadataObject() throws RemoteException {
        return this.myLocalDirectory.getMetadataObject();
    }

    @Override
    public PathUrl getLocationUrl() throws RemoteException, RepositoryException {
        return this.myLocalDirectory.getLocationUrl();
    }

    @Override
    public String getContentLocation() throws RemoteException, RepositoryException {
        return this.myLocalDirectory.getContentLocation();
    }

    @Override
    public String getName() throws RemoteException {
        return this.myLocalDirectory.getName();
    }

    @Override
    public String getParent() throws RemoteException, RepositoryNotFoundException, RepositoryException, SecurityException {
        return this.myLocalDirectory.getParent();
    }

    @Override
    public void copyTo(RemoteDirectoryInterface directory) throws RemoteException, RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        PathUrl pTgt = directory.getLocationUrl();
        OMRID omiR = this.myLocalDirectory.repositoryId;
        OMIRepositoryInterface ori = omiR.getOMIRepository();
        FolderInterface fiTgt = null;
        try {
            fiTgt = (FolderInterface)ori.getObjectByPath(pTgt);
            DirectoryInterface di = omiR.getRootOMRDirectory(pTgt.getRootTree()).getDirectory(fiTgt);
            this.myLocalDirectory.copyTo(di);
        }
        catch (Exception e) {
            throw new RepositoryException();
        }
    }

    @Override
    public void delete() throws RemoteException, RepositoryLockedException, RepositoryException, SecurityException {
        this.myLocalDirectory.delete();
    }

    @Override
    public void moveTo(RemoteDirectoryInterface directory) throws RemoteException, RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        Object mi = null;
        FolderInterface fiTgt = null;
        PathUrl pTgt = directory.getLocationUrl();
        OMRID omiR = this.myLocalDirectory.repositoryId;
        OMIRepositoryInterface ori = omiR.getOMIRepository();
        try {
            fiTgt = (FolderInterface)ori.getObjectByPath(pTgt);
            DirectoryInterface di = omiR.getRootOMRDirectory(pTgt.getRootTree()).getDirectory(fiTgt);
            this.myLocalDirectory.moveTo(di);
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        catch (RepositoryNotFoundException e) {
            throw new RepositoryNotFoundException((Throwable)((Object)e), e.getMessage());
        }
    }

    @Override
    public void renameTo(String newContentName) throws RemoteException, RepositoryIllegalNameException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        this.myLocalDirectory.renameTo(newContentName);
    }

    @Override
    public void setAttribute(String attributeName, Object attributeValue) throws RemoteException, RepositoryLockedException, RepositoryException, SecurityException {
        this.myLocalDirectory.setAttribute(attributeName, attributeValue);
    }

    @Override
    public void setAttributes(Map attributes) throws RemoteException, RepositoryLockedException, RepositoryException, SecurityException {
        this.myLocalDirectory.setAttributes(attributes);
    }

    @Override
    public void delete(RepositoryMetadataFilter filter) throws RemoteException, RepositoryDeleteException, RepositoryException {
        this.myLocalDirectory.delete(filter);
    }

    @Override
    public String[] list() throws RemoteException, RepositoryException, SecurityException {
        return this.myLocalDirectory.list();
    }

    @Override
    public String[] list(RepositoryFilter filter) throws RemoteException, RepositoryException, SecurityException {
        return this.myLocalDirectory.list(filter);
    }

    @Override
    public List listDirs(RepositoryFilter filter, SortOrder order) throws RemoteException, RepositoryException, SecurityException {
        List localDirs = this.myLocalDirectory.listDirs(filter, order);
        ArrayList<RemoteDirectory> rmtDirs = new ArrayList<RemoteDirectory>(localDirs.size());
        for (DirectoryInterface localDir : localDirs) {
            rmtDirs.add(new RemoteDirectory(localDir));
        }
        return rmtDirs;
    }

    @Override
    public List listFiles(RepositoryFilter filter, SortOrder order) throws RemoteException, RepositoryException, SecurityException {
        List localFiles = this.myLocalDirectory.listFiles(filter, order);
        ArrayList<RemoteEntry> rmtFiles = new ArrayList<RemoteEntry>(localFiles.size());
        for (EntryInterface localFile : localFiles) {
            rmtFiles.add(new RemoteEntry(localFile));
        }
        return rmtFiles;
    }

    @Override
    public RemoteDirectoryInterface ensurePath(PathUrl dirPathUrl) throws RemoteException, RepositoryException {
        DirectoryInterface dir = this.myLocalDirectory.ensurePath(dirPathUrl);
        return new RemoteDirectory(dir);
    }

    @Override
    public RemoteEntryInterface createEntry(String entryName) throws RemoteException, RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        EntryInterface newEntry = this.myLocalDirectory.createEntry(entryName);
        return new RemoteEntry(newEntry);
    }

    @Override
    public RemoteEntryInterface createEntry(String entryName, AgingPolicy agePolicy) throws RemoteException, RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        EntryInterface entry = this.myLocalDirectory.createEntry(entryName, agePolicy);
        return new RemoteEntry(entry);
    }

    @Override
    public RemoteEntryInterface createEntry(Object entryMetadataObject) throws RemoteException, RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        EntryInterface entry = this.myLocalDirectory.createEntry(entryMetadataObject);
        return new RemoteEntry(entry);
    }

    @Override
    public boolean entryExists(String entryName) throws RemoteException, RepositoryIllegalNameException, RepositoryException, SecurityException {
        return this.myLocalDirectory.entryExists(entryName);
    }

    @Override
    public RemoteEntryInterface getEntry(String entryName) throws RemoteException, RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryException, SecurityException {
        EntryInterface entry = this.myLocalDirectory.getEntry(entryName);
        return new RemoteEntry(entry);
    }

    public void moveTo(EntryInterface entry) throws RemoteException, RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        this.myLocalDirectory.moveTo(entry);
    }

    public void copyTo(RemoteEntryInterface entry) throws RemoteException, RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    DirectoryInterface getLocalDir() {
        return this.myLocalDirectory;
    }

    @Override
    public RemoteDirectoryInterface getParentEntry() throws RemoteException, RepositoryNotFoundException, RepositoryException, SecurityException {
        OMRDirectory parentDir = (OMRDirectory)this.myLocalDirectory.getParentEntry();
        return new RemoteDirectory(parentDir);
    }

    @Override
    public RemoteDirectoryInterface getDirectory(String name) throws RemoteException, RepositoryNotFoundException, RepositoryException, SecurityException {
        DirectoryInterface dir = this.myLocalDirectory.getDirectory(name);
        return new RemoteDirectory(dir);
    }

    @Override
    public void refresh() throws RemoteException {
        this.myLocalDirectory.refresh();
    }
}

