/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.CacheFilter;
import com.sas.report.repository.CacheInterface;
import com.sas.report.repository.CacheItemInterface;
import com.sas.report.repository.CacheSetInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.RemoteCache;
import com.sas.report.repository.RemoteCacheInterface;
import com.sas.report.repository.RemoteCacheItem;
import com.sas.report.repository.RemoteCacheSetInterface;
import com.sas.report.repository.RemoteEntry;
import com.sas.report.repository.RemoteEntryInterface;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryNotFoundException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class RemoteCacheSet
extends UnicastRemoteObject
implements RemoteCacheSetInterface {
    private CacheSetInterface myCacheSet;

    public RemoteCacheSet(CacheSetInterface cacheSetInterface) throws RemoteException {
        this.myCacheSet = cacheSetInterface;
    }

    @Override
    public RemoteCacheInterface create(String cacheName) throws RemoteException, RepositoryIllegalNameException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException {
        CacheInterface cache = this.myCacheSet.create(cacheName);
        return new RemoteCache(cache);
    }

    @Override
    public RemoteCacheInterface create(String cacheName, boolean transientCache) throws RemoteException, RepositoryIllegalNameException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException {
        CacheInterface cache = this.myCacheSet.create(cacheName, transientCache);
        return new RemoteCache(cache);
    }

    @Override
    public List list(CacheFilter filter) throws RemoteException, RepositoryException {
        List localCaches = this.myCacheSet.list(filter);
        ArrayList<RemoteCache> remoteCaches = new ArrayList<RemoteCache>(localCaches.size());
        for (CacheInterface localCache : localCaches) {
            remoteCaches.add(new RemoteCache(localCache));
        }
        return remoteCaches;
    }

    @Override
    public List listCacheItems(CacheFilter filter) throws RemoteException, RepositoryException {
        List localItems = this.myCacheSet.listCacheItems(filter);
        ArrayList<RemoteCacheItem> remoteItems = new ArrayList<RemoteCacheItem>(localItems.size());
        for (CacheItemInterface localItem : localItems) {
            remoteItems.add(new RemoteCacheItem(localItem));
        }
        return remoteItems;
    }

    @Override
    public boolean exists(String cacheName) throws RemoteException, RemoteException, RepositoryException {
        return this.myCacheSet.exists(cacheName);
    }

    @Override
    public RemoteCacheInterface get(String cacheName) throws RemoteException, RepositoryException, RepositoryNotFoundException {
        CacheInterface cache = this.myCacheSet.get(cacheName);
        return new RemoteCache(cache);
    }

    @Override
    public void deleteAll() throws RemoteException, RepositoryException {
        this.myCacheSet.deleteAll();
    }

    @Override
    public void deleteTransient() throws RemoteException, RepositoryException {
        this.myCacheSet.deleteTransient();
    }

    @Override
    public RemoteEntryInterface getEntryInterface() throws RemoteException {
        EntryInterface entry = this.myCacheSet.getEntryInterface();
        return new RemoteEntry(entry);
    }

    @Override
    public int getMaxNumberOfVersions() throws RemoteException {
        return this.myCacheSet.getMaxNumberOfVersions();
    }

    @Override
    public void setMaxNumberOfVersions(int maxVersionsToKeep) throws RemoteException, RepositoryException, SecurityException {
        this.myCacheSet.setMaxNumberOfVersions(maxVersionsToKeep);
    }

    @Override
    public int archivePDFs(String srcCacheName, Date archiveDate) throws RemoteException {
        return this.myCacheSet.archivePDFs(srcCacheName, null);
    }
}

