/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.CacheFilter;
import com.sas.report.repository.CacheInterface;
import com.sas.report.repository.CacheItemInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.RemoteCacheInterface;
import com.sas.report.repository.RemoteCacheItem;
import com.sas.report.repository.RemoteCacheItemInterface;
import com.sas.report.repository.RemoteEntry;
import com.sas.report.repository.RemoteEntryInterface;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIllegalNameException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;

class RemoteCache
extends UnicastRemoteObject
implements RemoteCacheInterface {
    private CacheInterface myCache;

    public RemoteCache(CacheInterface cacheInterface) throws RemoteException {
        this.myCache = cacheInterface;
    }

    @Override
    public String getName() throws RemoteException, RepositoryException {
        return this.myCache.getName();
    }

    @Override
    public RemoteCacheItemInterface create(String cacheEntryName) throws RemoteException, RepositoryIllegalNameException, RepositoryDuplicateNameException, RepositoryException {
        CacheItemInterface cii = this.myCache.create(cacheEntryName);
        return new RemoteCacheItem(cii);
    }

    @Override
    public RemoteCacheItemInterface get(String cacheEntryName) throws RemoteException, RepositoryException {
        CacheItemInterface cii = this.myCache.get(cacheEntryName);
        return new RemoteCacheItem(cii);
    }

    @Override
    public List list(CacheFilter filter) throws RemoteException, RepositoryException {
        List localItems = this.myCache.list(filter);
        ArrayList<RemoteCacheItem> remoteItems = new ArrayList<RemoteCacheItem>();
        for (CacheItemInterface localItem : localItems) {
            remoteItems.add(new RemoteCacheItem(localItem));
        }
        return remoteItems;
    }

    @Override
    public void delete() throws RemoteException, RepositoryException {
        this.myCache.delete();
    }

    @Override
    public boolean exists(String cacheEntryName) throws RemoteException, RepositoryException {
        return this.myCache.exists(cacheEntryName);
    }

    @Override
    public RemoteEntryInterface getParentEntry() throws RemoteException, RepositoryException {
        EntryInterface entry = this.myCache.getParentEntry();
        return new RemoteEntry(entry);
    }

    @Override
    public void createTransactionStart() throws RemoteException, IllegalStateException {
        this.myCache.createTransactionStart();
    }

    @Override
    public void createTransactionEnd() throws RemoteException, IllegalStateException, RepositoryException {
        this.myCache.createTransactionEnd();
    }
}

