/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.RBUtil;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryResource;
import com.sas.services.ServiceException;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.ServiceNotAvailableException;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionService;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class PFServices {
    private static final String PGM = "PFServices";
    private SessionServiceInterface mySessionService = null;
    private SessionContextInterface mySessionContext;
    private UserContextInterface myUserContext;
    private static final Logger log = LogManager.getLogger(PFServices.class);
    private SessionContextInterface myRoot;
    private DiscoveryServiceInterface myDiscoveryService;
    private String mySessionId;
    private List myUserRepoDef;
    private boolean myDebugEnabledFlag;

    public PFServices(String sessionId) throws RepositoryException, RemoteException {
        log.debug("Entering PFSServices: SessionId" + sessionId);
        this.mySessionContext = null;
        this.myRoot = null;
        if (sessionId == null || sessionId.length() == 0) {
            String msg = RBUtil.getStringResource("PFServicesnoSessionId.txt");
            throw new RepositoryException(msg);
        }
        this.mySessionId = sessionId;
        this.checkServices();
        this.mySessionContext = this.mySessionService.getSessionContext(sessionId);
        if (this.mySessionContext == null) {
            this.mySessionContext = this.myRoot;
        }
        if (this.mySessionContext == null) {
            String msg = RBUtil.getStringResource("PFServicesnoSessionContext.txt");
            throw new RepositoryException(msg);
        }
        this.setUserContext();
    }

    public PFServices(SessionContextInterface sessionContext) throws RepositoryException, RemoteException {
        log.debug("Entering PFSServices: SessionId" + sessionContext.toString());
        this.myRoot = null;
        this.mySessionContext = sessionContext;
        if (sessionContext == null) {
            String msg = RBUtil.getStringResource("PFServicesnoSessionId.txt");
            throw new RepositoryException(msg);
        }
        this.checkServices();
        this.setUserContext();
        this.mySessionId = sessionContext.getEntityKey();
    }

    public Logger getLogger() {
        return log;
    }

    public void setLogMessage(String type, String theMessage) {
        this.setMessage(type, theMessage, null);
    }

    public SessionContextInterface getSessionContext() {
        return this.mySessionContext;
    }

    public String getSessionId() {
        return this.mySessionId;
    }

    public UserContextInterface getUserContext() {
        return this.myUserContext;
    }

    public boolean isDebugEnabled() {
        return this.myDebugEnabledFlag;
    }

    private void setUserContext() throws RepositoryException, RemoteException {
        try {
            this.myUserContext = this.mySessionContext.getUserContext();
        }
        catch (IllegalStateException exc) {
            this.setLogMessage("E", RBUtil.getStringResource("PFServicesillegalContext.txt"));
            this.setLogMessage("E", exc.getMessage());
            throw new RepositoryException(exc, exc.getMessage());
        }
        if (this.myUserContext == null) {
            String msg = RBUtil.getStringResource("userContextNull.txt");
            this.setLogMessage("E", msg);
            throw new RepositoryException(msg);
        }
        if (this.isDebugEnabled()) {
            this.setLogMessage("I", RBUtil.getStringResource("PFServicesgoodUserID.txt"));
        }
        this.myUserRepoDef = this.myUserContext.getRepositories();
        if (!this.isDebugEnabled()) {
            return;
        }
        String _nameOfUser = this.getUserName();
        Filter filter = new Filter();
        FilterComponent _f1 = new FilterComponent("Name", 0, _nameOfUser);
        filter.setFilterComponent(_f1);
        filter.setType("Person");
        filter.setOMRFlags(8192);
        for (Object item : this.myUserRepoDef) {
            if (!(item instanceof OMIRepositoryInterface)) continue;
            OMIRepositoryInterface reposDef = (OMIRepositoryInterface)item;
            boolean _checkForUser = true;
            RepositoryInterface ri = null;
            String _name = null;
            try {
                _name = reposDef.getDefaultRepositoryName();
            }
            catch (RemoteException e) {
                this.setLogMessage("E", RBUtil.getStringResource("PFServicesillegalBaseNameFilter.txt"));
                e.printStackTrace();
                _name = null;
            }
            if (_name == null) continue;
            try {
                ri = this.myUserContext.getRepository(_name);
                filter.setOMRRepository(_name);
            }
            catch (RemoteException e) {
                this.setLogMessage("E", RBUtil.getStringResource("PFServicesremoteErrorFilter.txt"));
                e.printStackTrace();
                System.out.println(filter.getFilterString());
                _checkForUser = false;
            }
            catch (ServiceException e) {
                this.setLogMessage("E", RBUtil.getStringResource("PFServicesserviceErrorFilter.txt"));
                e.printStackTrace();
                System.out.println(filter.getFilterString());
                _checkForUser = false;
            }
            if (ri == null) {
                this.setLogMessage("E", RBUtil.getStringResource("PFServicesnullRepositoryFilter.txt"));
                this.setLogMessage("E", filter.getFilterString());
                _checkForUser = false;
                continue;
            }
            List results = null;
            try {
                results = ri.search((FilterInterface)filter);
            }
            catch (RemoteException e) {
                this.setLogMessage("E", RBUtil.getStringResource("PFServicesremoteErrFilter.txt"));
                this.setLogMessage("E", filter.getFilterString());
                _checkForUser = false;
            }
            catch (ServiceException e) {
                this.setLogMessage("E", RBUtil.getStringResource("PFServicesserviceErrFilter.txt"));
                this.setLogMessage("E", filter.getFilterString());
                _checkForUser = false;
            }
            if (results == null) {
                this.setLogMessage("E", RBUtil.getStringResource("PFServicesnullFilter.txt"));
                this.setLogMessage("E", filter.getFilterString());
                return;
            }
            Iterator resultsOfFilter = results.iterator();
            if (!_checkForUser || resultsOfFilter.hasNext()) continue;
            this.setLogMessage("I", RBUtil.getStringResource("PFServicesnameNotInRepos.txt", (Object)_nameOfUser, _name));
        }
    }

    public void verifyRepository(String repositoryName) throws RepositoryException {
        if (this.myUserContext == null) {
            String msg = RBUtil.getStringResource("PFServicesuserContextNull.txt");
            this.setLogMessage("E", msg);
            throw new RepositoryException(msg);
        }
        ServerInterface si = null;
        OMIRepositoryInterface ri = null;
        try {
            si = this.myUserContext.getServer(repositoryName);
            if (si == null) {
                ri = (OMIRepositoryInterface)this.myUserContext.getRepository(repositoryName);
                if (ri == null) {
                    String msg = RBUtil.getStringResource("PFServicesinfoServicesReposNotFound.txt", repositoryName);
                    this.setLogMessage("E", msg);
                    throw new RepositoryException(msg);
                }
            } else {
                ri = (OMIRepositoryInterface)si.getFoundationRepository();
            }
        }
        catch (RemoteException e) {
            String msg = RBUtil.getStringResource("PFServicesremoteErrorFilter.txt");
            this.setLogMessage("E", msg);
            throw new RepositoryException(e, msg);
        }
        catch (ServiceException e) {
            String msg = RBUtil.getStringResource("PFServicesserviceErrorFilter.txt");
            this.setLogMessage("E", msg);
            throw new RepositoryException(e, msg);
        }
        String _nameOfUser = null;
        try {
            _nameOfUser = this.getUserName();
        }
        catch (RepositoryException e) {
            String msg = RBUtil.getStringResource("PFServicescannotGetUser.txt");
            this.setLogMessage("E", msg);
            throw new RepositoryException((Throwable)((Object)e), msg);
        }
        if (!this.isDebugEnabled()) {
            return;
        }
        Filter filter = new Filter();
        FilterComponent _f1 = new FilterComponent("Name", 0, _nameOfUser);
        filter.setFilterComponent(_f1);
        filter.setType("Person");
        filter.setOMRFlags(8192);
        List results = null;
        try {
            filter.setOMRRepository(ri.getDefaultRepositoryId());
            results = ri.search((FilterInterface)filter);
        }
        catch (RemoteException e) {
            String msg = RBUtil.getStringResource("PFServicesremoteErrFilter.txt");
            this.setLogMessage("E", msg);
            throw new RepositoryException(e, msg);
        }
        catch (ServiceException e) {
            String msg = RBUtil.getStringResource("PFServicesserviceErrFilter.txt");
            this.setLogMessage("E", msg);
            throw new RepositoryException(e, msg);
        }
        if (results == null) {
            String msg = RBUtil.getStringResource("PFServicesnullFilter.txt");
            this.setLogMessage("E", msg);
            throw new RepositoryException(msg);
        }
        Iterator resultsOfFilter = results.iterator();
        if (!resultsOfFilter.hasNext()) {
            String msg = RepositoryResource.getMessageString("PFServicesrepositoryInvalidUser.txt", new String[]{_nameOfUser});
            this.setLogMessage("W", msg);
        }
    }

    public List getUserContextRepositories() throws RepositoryException, RemoteException {
        return this.myUserRepoDef;
    }

    public String getUserName() throws SecurityException, RepositoryException {
        String _userName = null;
        if (this.myUserContext == null) {
            String msg = RBUtil.getStringResource("PFServicesuserNamenoUserContext.txt");
            this.setLogMessage("E", msg);
            throw new SecurityException();
        }
        try {
            _userName = this.myUserContext.getName();
        }
        catch (RemoteException e) {
            String msg = RBUtil.getStringResource("PFServicesnoBaseUser.txt");
            this.setLogMessage("E", msg);
            throw new RepositoryException(e, msg);
        }
        if (_userName == null) {
            String msg = RBUtil.getStringResource("PFServicesuserNameNull.txt");
            this.setLogMessage("E", msg);
            throw new RepositoryException(msg);
        }
        return _userName;
    }

    public Logger getSessionLogger() {
        return log;
    }

    public void setLogMessage(String type, String theMessage, Throwable exception) {
        this.setMessage(type, theMessage, exception);
    }

    private void checkServices() throws RepositoryException, RemoteException {
        this.myDiscoveryService = DiscoveryService.defaultInstance();
        Class[] desiredServiceCapabilities = new Class[]{SessionServiceInterface.class};
        try {
            this.mySessionService = (SessionServiceInterface)this.myDiscoveryService.findService(new ServiceTemplate(desiredServiceCapabilities));
        }
        catch (ServiceNotAvailableException e) {
            if (this.myDebugEnabledFlag) {
                e.printStackTrace();
            }
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ServiceException e) {
            if (this.myDebugEnabledFlag) {
                e.printStackTrace();
            }
            throw new RepositoryException(e, e.getMessage());
        }
        if (this.mySessionService == null) {
            String msg = RBUtil.getStringResource("PFServicesserviceNull.txt");
            throw new RepositoryException(msg);
        }
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return SessionService.getRootSessionContext();
            }
        };
        try {
            this.myRoot = (SessionContextInterface)AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            pae.printStackTrace();
            throw new RepositoryException(pae, pae.getMessage());
        }
    }

    private void setMessage(String type, String theMessage, Throwable exception) {
        String _upType = type.toUpperCase();
        if (log == null) {
            System.out.println(theMessage);
        } else if (_upType.startsWith("E")) {
            if (exception == null) {
                log.error(theMessage);
            } else {
                log.error(theMessage, exception);
            }
        } else if (_upType.startsWith("W")) {
            if (exception == null) {
                log.warn(theMessage);
            } else {
                log.warn(theMessage, exception);
            }
        } else if (_upType.startsWith("D")) {
            if (this.myDebugEnabledFlag) {
                if (exception == null) {
                    log.debug(theMessage);
                } else {
                    log.debug(theMessage, exception);
                }
            }
        } else if (_upType.startsWith("I")) {
            if (exception == null) {
                log.info(theMessage);
            } else {
                log.info(theMessage, exception);
            }
        } else if (_upType.startsWith("F")) {
            if (exception == null) {
                log.fatal(theMessage);
            } else {
                log.fatal(theMessage, exception);
            }
        }
    }
}

