/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.ContentInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.OMREntry;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class OMRSPEntry
extends OMREntry {
    private static final Logger log = LogManager.getLogger(OMRSPEntry.class);

    public OMRSPEntry(String entryName, OMRID omrRepositoryId, ContentInterface content) throws RepositoryException, RemoteException {
        super(omrRepositoryId);
        log.debug(RBUtil.getStringResource("OMRSPEntryConstructor1called.notrans", entryName));
        throw new RepositoryException(RBUtil.getStringResource("OMRSPEntrynoConst.txt"));
    }

    public OMRSPEntry(MetadataInterface entryObject, OMRID omrRepositoryId, ContentInterface content) throws RepositoryException, RemoteException {
        super(omrRepositoryId);
        log.debug(RBUtil.getStringResource("OMRSPEntryConstructor2called.notrans", entryObject));
        if (!(entryObject instanceof StoredProcessInterface)) {
            throw new IllegalArgumentException(RBUtil.getStringResource("OMRSPEntryMetadataNotSP.txt"));
        }
        this.setMetadataObject(entryObject);
        this.myContent = content;
    }

    @Override
    public InputStream getInputStream() throws RepositoryIOException, SecurityException {
        return null;
    }

    @Override
    public OutputStream getOutputStream() throws RepositoryIOException, SecurityException {
        return null;
    }

    @Override
    public EntryInterface getGeneration(long generation) throws RepositoryNotFoundException, SecurityException {
        return null;
    }

    @Override
    public void age(long generationIncrement) throws SecurityException {
    }

    @Override
    public boolean isEmpty() throws RepositoryException {
        return true;
    }

    @Override
    public void renameTo(String newName) throws RepositoryIllegalNameException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        throw new RepositoryException(RBUtil.getStringResource("OMRSPEntryrenameTo.txt"));
    }

    @Override
    public void moveTo(EntryInterface destEntry) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        throw new RepositoryException(RBUtil.getStringResource("OMRSPEntrymoveTo.txt"));
    }

    @Override
    public void copyTo(EntryInterface destEntry) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        throw new RepositoryException(RBUtil.getStringResource("OMRSPEntrycopyTo.txt"));
    }

    @Override
    public void delete() throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new RepositoryException(RBUtil.getStringResource("OMRSPEntrydelete.txt"));
    }

    @Override
    public void delete(long generation) throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new RepositoryException(RBUtil.getStringResource("OMRSPEntrydelete.txt"));
    }

    @Override
    public boolean canRead() throws SecurityException {
        return false;
    }

    @Override
    public boolean canWrite() throws SecurityException {
        return false;
    }

    @Override
    public String toString() {
        String location;
        try {
            location = this.getLocation();
            if (location == null) {
                location = "";
            }
        }
        catch (RepositoryException e) {
            log.debug(RBUtil.getStringResource("OMRSPEntryError.notrans", (Object)e));
            location = "";
        }
        return location;
    }

    @Override
    public Object getAttribute(String attribName) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            if (attribName.equals("type")) {
                MetadataInterface mdObj = (MetadataInterface)this.getMetadataObject();
                String name = mdObj.getName();
                String type = mdObj.getType();
                log.debug(RBUtil.getStringResource("OMRSPEntrygetAttribute.notrans", (Object)name, (Object)attribName, type));
                return type;
            }
            return super.getAttribute(attribName);
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    @Override
    public Iterator getAttributes() throws RepositoryException, SecurityException {
        HashMap<String, Object> attributeList = new HashMap<String, Object>();
        attributeList.put("description", this.getAttribute("description"));
        attributeList.put("Comments", this.getAttribute("Comments"));
        attributeList.put("Author", this.getAttribute("Author"));
        attributeList.put("userids", this.getAttribute("userids"));
        attributeList.put("locale", this.getAttribute("locale"));
        attributeList.put("Creation Date", this.getAttribute("Creation Date"));
        attributeList.put("Modified Date", this.getAttribute("Modified Date"));
        attributeList.put("Reference Date", this.getAttribute("Reference Date"));
        MetadataInterface mdObj = (MetadataInterface)this.getMetadataObject();
        this.repositoryId.addUserDefinedAttributesToMap(attributeList, mdObj);
        attributeList.put("location", this.getLocation());
        attributeList.put("name", this.getAttribute("name"));
        attributeList.put("type", this.getAttribute("type"));
        return attributeList.entrySet().iterator();
    }

    @Override
    protected void setAttribute_p(String attribName, Object value) throws RepositoryNotFoundException, RepositoryLockedException, RepositoryException, SecurityException {
        if (attribName.equals("type")) {
            throw new IllegalArgumentException(RBUtil.getStringResource("OMRSPEntryattributeReadonly.txt", attribName));
        }
        super.setAttribute_p(attribName, value);
    }
}

