/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.report.repository.AgingPolicy;
import com.sas.report.repository.ContentInterface;
import com.sas.report.repository.DirectoryInterface;
import com.sas.report.repository.Entry;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.OMRDirectory;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.OMRRepositoryMessager;
import com.sas.report.repository.OMRRepositoryUserInformation;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.ReportManagementCache;
import com.sas.report.repository.Repository;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryMessager;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.report.repository.RepositoryUserInformation;
import com.sas.report.repository.SearchInterface;
import com.sas.report.repository.UrlChangeCode;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import java.io.FilenameFilter;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OMRRepository
extends Repository
implements SearchInterface {
    private static final String REPORT_TYPE = "Report";
    private static final String FOLDER_TYPE = "Folder";
    private OMRID repositoryId = null;
    private static final Logger log = LogManager.getLogger(OMRRepository.class);
    OMRRepositoryMessager messager = null;
    OMRRepositoryUserInformation userInformationProvider = null;
    private static final String _version = "1.01";

    public OMRRepository(OMRID repositoryId) throws RepositoryException, RemoteException {
        if (repositoryId == null) {
            throw new IllegalArgumentException("repositoryId = null");
        }
        OMIRepositoryInterface omiRepository = repositoryId.getOMIRepository();
        this.setName(omiRepository.getDefaultRepositoryName());
        this.repositoryId = repositoryId;
        this.messager = new OMRRepositoryMessager(repositoryId);
        this.userInformationProvider = new OMRRepositoryUserInformation(repositoryId);
        log.debug(RBUtil.getStringResource("OMRRepositoryconstructor.txt"));
    }

    @Override
    public boolean hasReportRepositoryService() {
        try {
            List rootFolders = this.repositoryId.getRootFolders();
            for (FolderInterface folder : rootFolders) {
                PathUrl pathUrl = folder.getPathUrl();
                try {
                    OMRID.ContentInfo contentInfo = this.repositoryId.getContentInfo(pathUrl);
                    if (contentInfo == null) continue;
                    return true;
                }
                catch (IllegalStateException e) {
                    boolean expectThisException = Boolean.getBoolean("logRootDirectoriesWithoutContentMappings");
                    if (!expectThisException) continue;
                    log.warn(RBUtil.getStringResource("OMRRepositoryError.notrans", e));
                }
            }
        }
        catch (RepositoryException e) {
            log.debug(RBUtil.getStringResource("OMRRepositoryError.notrans", (Object)e));
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRRepositoryError.notrans", (Object)e));
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMRRepositoryError.notrans", e));
        }
        return false;
    }

    @Override
    public String getRepositoryId() {
        return this.repositoryId.getRepositoryId();
    }

    @Override
    public OMRID getOMRID() {
        return this.repositoryId;
    }

    @Override
    public RepositoryMessager getRepositoryMessager() {
        return this.messager;
    }

    @Override
    public RepositoryUserInformation getUserInformationProvider() {
        return this.userInformationProvider;
    }

    public void createReportRepositoryServices(SoftwareComponent rrServices) throws RepositoryException {
        throw new RepositoryException("Use the SAS Management Console to set up a BIP Service/BIP Tree.");
    }

    public void addProvider(String providerName, String providerLocation) throws RepositoryException {
        try {
            String pName;
            SoftwareComponent rrServices = this.repositoryId.findBIPService();
            AssociationList providerList = null;
            providerList = rrServices.getDocuments();
            Document providerDoc = null;
            for (int i = 0; i < providerList.size() && (pName = (providerDoc = (Document)providerList.get(i)).getName()).compareTo(providerName) != 0; ++i) {
                providerDoc = null;
            }
            if (providerDoc != null) {
                providerDoc.setURI(providerLocation);
                providerDoc.setDesc(RBUtil.getStringResource("OMRRepositorycontentProviderDesc.txt"));
            } else {
                MetadataInterface md = this.repositoryId.createMetadataObject(providerName, "Document");
                providerDoc = (Document)md.getRepositoryEntity();
                providerDoc.setURI(providerLocation);
                providerList.add((Object)providerDoc);
            }
            rrServices.updateMetadataAll();
        }
        catch (MdException e) {
            log.debug(RBUtil.getStringResource("OMRRepositoryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMRRepositoryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
    }

    public void delete() throws RepositoryException {
        throw new RepositoryException("Repository delete is no longer supported. See com.sas.services.information.OMIRepository.");
    }

    @Override
    public DirectoryInterface getDirectory(String directoryName) throws RepositoryException, RepositoryNotFoundException {
        int firstSeparatorPos;
        DirectoryInterface directory = null;
        if (directoryName == null || directoryName.length() == 0) {
            throw new RepositoryNotFoundException(RBUtil.getStringResource("OMRRepositorynotFound.txt", directoryName));
        }
        if (directoryName.charAt(0) == '/') {
            directoryName = directoryName.substring(1);
        }
        if (directoryName.charAt(directoryName.length() - 1) == '/') {
            directoryName = directoryName.substring(0, directoryName.length() - 1);
        }
        String firstSegment = (firstSeparatorPos = directoryName.indexOf(47)) > -1 ? directoryName.substring(0, firstSeparatorPos) : directoryName;
        try {
            OMRDirectory rootDir = this.repositoryId.getRootOMRDirectory(firstSegment);
            int idx = directoryName.indexOf(rootDir.getName());
            if (idx == 0) {
                idx = directoryName.indexOf(47);
                if (idx == -1) {
                    return rootDir;
                }
                directoryName = directoryName.substring(idx + 1);
            }
            directory = rootDir.getDirectory(directoryName);
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        return directory;
    }

    @Override
    public String getVersion() {
        return _version;
    }

    @Override
    public void close() {
        if (this.repositoryId == null) {
            return;
        }
        this.repositoryId.close();
        this.repositoryId = null;
    }

    @Override
    public AgingPolicy getAgingPolicyForEntryType(String entryType) throws IllegalStateException, RepositoryNotFoundException {
        return null;
    }

    @Override
    public void setAgingPolicyForEntryType(String entryType, AgingPolicy agingPolicy) throws IllegalStateException, RepositoryNotFoundException {
    }

    @Override
    public String getRootDirectory() throws IllegalStateException, RepositoryNotFoundException {
        try {
            List rootFolders = this.repositoryId.getRootFolders();
            if (rootFolders.size() > 0) {
                return ((FolderInterface)rootFolders.get(0)).getName();
            }
            throw new RepositoryNotFoundException(RBUtil.getStringResource("OMRRepositoryNoRootsFound.txt"));
        }
        catch (RepositoryException e) {
            throw new RepositoryNotFoundException((Throwable)((Object)e), e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryNotFoundException(e, e.getMessage());
        }
    }

    @Override
    public String getHomeDirectory() throws IllegalStateException, RepositoryNotFoundException {
        return this.getRootDirectory();
    }

    @Override
    public String getUsersDirectory() throws RepositoryNotFoundException {
        return this.getRootDirectory();
    }

    @Override
    public Object getMetadataObject() {
        return this.repositoryId.getOMIRepository();
    }

    @Override
    public void setPackageToSearch(String pathName) {
    }

    @Override
    public void setFilter(FilenameFilter filter) {
    }

    @Override
    public void setSearch(String searchString) {
    }

    @Override
    public void setLevel(int level) {
    }

    @Override
    public void setScope(int scope) {
    }

    @Override
    public void search(boolean isSynchronous) {
    }

    @Override
    public Iterator getSearchResults() {
        return null;
    }

    @Override
    public void setTotalSearchItemLimit(long nEntries) {
    }

    @Override
    public void setSearchItemLimit(long nEntries) {
    }

    @Override
    public void setSearchTimeLimit(long nSeconds) {
    }

    @Override
    public boolean isSearchDone() {
        return true;
    }

    @Override
    public DirectoryInterface ensurePath(PathUrl dirPathUrl) throws RepositoryException {
        Entry.validatePath(dirPathUrl);
        try {
            String rootDirName = dirPathUrl.getRootTree();
            OMRDirectory rootDir = this.repositoryId.getRootOMRDirectory(rootDirName);
            return rootDir.ensurePath(dirPathUrl);
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, RBUtil.getStringResource("OMRRepositoryError.txt"));
        }
    }

    @Override
    public void ensureRepositoryContentExists() throws RepositoryException {
        String uniqueName = Long.toHexString(System.currentTimeMillis());
        try {
            OMRDirectory rootDir = this.repositoryId.getRootOMRDirectory(this.getHomeDirectory());
            ContentInterface content = rootDir.getContent(true);
            content.createDirectory(uniqueName);
            if (!content.exists(uniqueName)) {
                throw new RepositoryException(RBUtil.getStringResource("OMRRepositorynotFoundAfterCreate.txt"));
            }
            content.delete(uniqueName);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = RBUtil.getStringResource("OMRRepositoryensureRepositoryFailed.txt");
            }
            throw new RepositoryException(e, msg);
        }
    }

    @Override
    public void refreshPathUrl(PathUrl oldPathUrl, UrlChangeCode changeType) throws RepositoryException {
        String oldPathUrlStr;
        ReportManagementCache cache = this.repositoryId.getCache();
        Entry entry = (Entry)cache.get(oldPathUrlStr = oldPathUrl.toString());
        if (entry != null) {
            cache.remove(oldPathUrlStr);
            entry.invalidatePathUrl();
            if (changeType == UrlChangeCode.RENAME) {
                String newPathUrlStr = entry.getLocation();
                cache.put(newPathUrlStr, entry);
            }
        }
    }

    @Override
    public void ensureRepositoryContentExists(String rootFolderName) throws IllegalStateException, RepositoryException {
        try {
            OMRDirectory rootDir = this.repositoryId.getRootOMRDirectory(rootFolderName);
            rootDir.getContent(true);
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (RepositoryNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = RBUtil.getStringResource("OMRRepositoryensureRepositoryFailed.txt");
            }
            throw (RepositoryException)((Object)new RepositoryException(msg).initCause(e));
        }
    }

    @Override
    public EntryInterface getEntry(PathUrl dirPathUrl) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            String key = dirPathUrl.toString();
            EntryInterface rval = (EntryInterface)this.getOMRID().getCache().get(key);
            if (rval != null) {
                return rval;
            }
        }
        catch (Exception e) {
            throw new RepositoryException(e, e.getMessage());
        }
        try {
            StringBuffer pathAndName = new StringBuffer();
            OMRDirectory rootDir = null;
            RootFolderInterface _workingTop = this.repositoryId.getOMIRepository().getServer().getRootFolder();
            rootDir = dirPathUrl.getRootTree() != null ? this.repositoryId.getRootOMRDirectory(dirPathUrl.getRootTree()) : new OMRDirectory((FolderInterface)_workingTop, this.repositoryId);
            if (dirPathUrl.getPath() != null) {
                pathAndName.append(dirPathUrl.getPath());
            }
            if (dirPathUrl.getName() != null && !dirPathUrl.getName().equals("/")) {
                if (pathAndName.length() > 0) {
                    pathAndName.append("/");
                }
                pathAndName.append(dirPathUrl.getName());
            }
            if (pathAndName.length() > 0) {
                if (dirPathUrl.getType() != null) {
                    for (int i = 0; i < OMRDirectory.KNOWN_TYPE_SUFFIXES.length; ++i) {
                        String suffix = OMRDirectory.KNOWN_TYPE_SUFFIXES[i];
                        if (!dirPathUrl.toString().endsWith(suffix)) continue;
                        pathAndName.append(suffix);
                        break;
                    }
                }
                EntryInterface _entry = rootDir.getEntry(pathAndName.toString());
                return _entry;
            }
            return rootDir;
        }
        catch (ServiceException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    @Override
    public DirectoryInterface getDirectory(PathUrl dirPathUrl) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            String key = dirPathUrl.toString();
            OMRDirectory rval = (OMRDirectory)this.getOMRID().getCache().get(key);
            if (rval != null) {
                return rval;
            }
        }
        catch (Exception e) {
            throw new RepositoryException(e, e.getMessage());
        }
        try {
            StringBuffer pathAndName = new StringBuffer();
            OMRDirectory rootDir = null;
            RootFolderInterface _workingTop = this.repositoryId.getOMIRepository().getServer().getRootFolder();
            rootDir = dirPathUrl.getRootTree() != null ? this.repositoryId.getRootOMRDirectory(dirPathUrl.getRootTree()) : new OMRDirectory((FolderInterface)_workingTop, this.repositoryId);
            if (dirPathUrl.getPath() != null) {
                pathAndName.append(dirPathUrl.getPath());
            }
            if (dirPathUrl.getName() != null && !dirPathUrl.getName().equals("/")) {
                if (pathAndName.length() > 0) {
                    pathAndName.append("/");
                }
                pathAndName.append(dirPathUrl.getName());
            }
            if (pathAndName.length() > 0) {
                if (dirPathUrl.getType() != null) {
                    pathAndName.append("(" + dirPathUrl.getType() + ")");
                }
                rootDir = (OMRDirectory)rootDir.getDirectory(pathAndName.toString());
                return rootDir;
            }
            return rootDir;
        }
        catch (ServiceException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    @Override
    public DirectoryInterface getDirectory(FolderInterface fi, PathUrl dirPathUrl) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            String key = dirPathUrl.toString();
            OMRDirectory rval = (OMRDirectory)this.getOMRID().getCache().get(key);
            if (rval != null) {
                return rval;
            }
        }
        catch (Exception e) {
            throw new RepositoryException(e, e.getMessage());
        }
        try {
            StringBuffer pathAndName = new StringBuffer();
            OMRDirectory rootDir = null;
            RootFolderInterface _workingTop = this.repositoryId.getOMIRepository().getServer().getRootFolder();
            rootDir = dirPathUrl.getRootTree() != null ? this.repositoryId.getRootOMRDirectory(dirPathUrl.getRootTree()) : new OMRDirectory((FolderInterface)_workingTop, this.repositoryId);
            if (dirPathUrl.getPath() != null) {
                pathAndName.append(dirPathUrl.getPath());
            }
            if (dirPathUrl.getName() != null && !dirPathUrl.getName().equals("/")) {
                if (pathAndName.length() > 0) {
                    pathAndName.append("/");
                }
                pathAndName.append(dirPathUrl.getName());
            }
            if (pathAndName.length() > 0) {
                if (dirPathUrl.getType() != null) {
                    pathAndName.append("(" + dirPathUrl.getType() + ")");
                }
                rootDir = (OMRDirectory)rootDir.getDirectory(fi);
                return rootDir;
            }
            return rootDir;
        }
        catch (ServiceException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }
}

