/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Transformation;
import com.sas.report.repository.AgingPolicy;
import com.sas.report.repository.CacheSetInterface;
import com.sas.report.repository.ContentException;
import com.sas.report.repository.ContentFactory;
import com.sas.report.repository.ContentFileException;
import com.sas.report.repository.ContentInterface;
import com.sas.report.repository.ContentNameNotFoundException;
import com.sas.report.repository.Directory;
import com.sas.report.repository.DirectoryInterface;
import com.sas.report.repository.Entry;
import com.sas.report.repository.EntryInstantiatorInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.Interval;
import com.sas.report.repository.OMREntry;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.OMRIQEntry;
import com.sas.report.repository.OMRSPEntry;
import com.sas.report.repository.OperationBestEffortHandler;
import com.sas.report.repository.OperationFailFastHandler;
import com.sas.report.repository.OperationResult;
import com.sas.report.repository.OperationResultHandler;
import com.sas.report.repository.RB;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.ReportEntryCreatorInterface;
import com.sas.report.repository.ReportManagementCache;
import com.sas.report.repository.ReportTypeDescriptor;
import com.sas.report.repository.RepositoryBetweenRepositoriesException;
import com.sas.report.repository.RepositoryCreateException;
import com.sas.report.repository.RepositoryDeleteException;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryFactory;
import com.sas.report.repository.RepositoryFilter;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryMetadataFilter;
import com.sas.report.repository.RepositoryNotDirectoryException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.report.repository.RepositoryUnknownTypeException;
import com.sas.report.repository.RepositoryUtils;
import com.sas.report.repository.SortOrder;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.Names;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class OMRDirectory
extends Directory {
    OperationFailFastHandler FAIL_FAST_HANDLER = new OperationFailFastHandler();
    protected OMRID repositoryId = null;
    protected ContentInterface myContent = null;
    private static final Logger log = LogManager.getLogger(OMRDirectory.class);
    private static final Comparator SORT_ASCENDING = new Comparator(){

        public int compare(Object obj1, Object obj2) {
            String name1 = ((EntryInterface)obj1).getName();
            String name2 = ((EntryInterface)obj2).getName();
            return name1.compareTo(name2);
        }
    };
    private static final Comparator SORT_DESCENDING = new Comparator(){

        public int compare(Object obj1, Object obj2) {
            String name1 = ((EntryInterface)obj1).getName();
            String name2 = ((EntryInterface)obj2).getName();
            return name2.compareTo(name1);
        }
    };
    protected static String[] KNOWN_TYPE_SUFFIXES = new String[]{"(Report)", "(Folder)"};

    public OMRDirectory(FolderInterface directoryObject, OMRID omrRepositoryId) throws RepositoryException, RemoteException {
        this.repositoryId = omrRepositoryId;
        this.setMetadataObject(directoryObject);
        if (KNOWN_TYPE_SUFFIXES.length < 3) {
            KNOWN_TYPE_SUFFIXES = this.getAllReportPublicTypes();
        }
    }

    private Entry getEntryInstance(MetadataInterface entryObject, OMRID omrRepositoryId, ContentInterface content) throws RepositoryException, RemoteException {
        return this.getEntryInstance(entryObject, omrRepositoryId, content, null);
    }

    private Entry getEntryInstance(MetadataInterface entryObject, OMRID omrRepositoryId, ContentInterface content, EntryInstantiatorInterface ei) throws RepositoryException, RemoteException {
        ReportManagementCache cache = this.repositoryId.getCache();
        String className = "com.sas.report.repository.OMRID";
        try {
            PathUrl pathUrl = entryObject.getPathUrl();
            if (pathUrl == null) {
                throw new RepositoryException(RB.getStringResource("OMRDirectorypathUrlNull.txt"));
            }
            String key = pathUrl.toString();
            Entry e = (Entry)cache.get(key);
            if (e == null) {
                String type = entryObject.getType();
                ServerInterface server = omrRepositoryId.getOMIRepository().getServer();
                Collection<String> allTypeNamesWithReportTypeDescriptor = ReportTypeDescriptor.getAllPublicTypes(server);
                EntryInterface _entry = null;
                if (allTypeNamesWithReportTypeDescriptor.contains(type)) {
                    ReportTypeDescriptor rtd = ReportTypeDescriptor.getInstance(server, type);
                    ReportEntryCreatorInterface entryCreator = rtd.getEntryCreator();
                    _entry = entryCreator.createEntry(entryObject, omrRepositoryId, content);
                }
                if (_entry != null) {
                    e = (Entry)_entry;
                } else if (type.equals("Report")) {
                    e = new OMREntry(entryObject, omrRepositoryId, content);
                } else if (type.equals("Report.Image")) {
                    e = new OMREntry(entryObject, omrRepositoryId, content);
                } else if (type.equals("Report.Component")) {
                    e = new OMREntry(entryObject, omrRepositoryId, content);
                } else if (type.equals("InformationMap")) {
                    e = new OMRIQEntry(entryObject, omrRepositoryId, null);
                } else if (type.equals("InformationMap.OLAP")) {
                    e = new OMRIQEntry(entryObject, omrRepositoryId, null);
                } else if (type.equals("InformationMap.Relational")) {
                    e = new OMRIQEntry(entryObject, omrRepositoryId, null);
                } else if (type.equals("StoredProcess")) {
                    e = new OMRSPEntry(entryObject, omrRepositoryId, null);
                } else if (type.equals("Report.StoredProcess")) {
                    e = new OMREntry(entryObject, omrRepositoryId, null);
                } else if (type.equals("Transformation")) {
                    String role = ((Transformation)entryObject.getRepositoryEntity()).getTransformRole();
                    if (role.equals("Report")) {
                        e = new OMREntry(entryObject, omrRepositoryId, content);
                    }
                } else if (ei != null && ei.isValidType(type)) {
                    e = ei.get(type, entryObject, omrRepositoryId, content);
                } else {
                    boolean isKnownType;
                    block34: {
                        isKnownType = false;
                        try {
                            Class _getServiceObjectClass;
                            Constructor _getServiceObjectConstructor;
                            Method _getServiceObjectClassMethod = entryObject.getClass().getDeclaredMethod("getServiceObjectClass", new Class[0]);
                            if (_getServiceObjectClassMethod == null || (_getServiceObjectConstructor = (_getServiceObjectClass = (Class)_getServiceObjectClassMethod.invoke((Object)entryObject, new Object[0])).getConstructor(OMRID.class)) == null) break block34;
                            String omridClassName = omrRepositoryId.getClass().getName();
                            if (className.equals(omridClassName)) {
                                EntryInstantiatorInterface eii = (EntryInstantiatorInterface)_getServiceObjectConstructor.newInstance(omrRepositoryId);
                                if (eii != null) {
                                    e = eii.get(type, entryObject, omrRepositoryId, content);
                                    isKnownType = true;
                                }
                                break block34;
                            }
                            throw new IllegalStateException();
                        }
                        catch (Exception ex) {
                            log.debug((Object)ex.getStackTrace());
                        }
                    }
                    if (!isKnownType) {
                        String msg = RBUtil.getStringResource("OMRDirectoryunknownType.txt", type);
                        log.debug(msg);
                        throw new RepositoryUnknownTypeException(msg);
                    }
                }
                if (e == null) {
                    String msg = RBUtil.getStringResource("OMRDirectoryunknownType.txt", type);
                    msg = msg + " (" + entryObject.getName() + ")";
                    log.debug(msg);
                    throw new RepositoryUnknownTypeException(msg);
                }
                cache.put(e.getLocation(), e);
            }
            return e;
        }
        catch (ServiceException ex) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)ex));
            throw new RepositoryException(ex, ex.getMessage());
        }
    }

    @Override
    public DirectoryInterface getDirectory(String directoryName) throws RepositoryException, RepositoryNotFoundException {
        return this.getDirectory_p(directoryName, false);
    }

    public DirectoryInterface getDirectory(FolderInterface fi) throws RepositoryException, RepositoryNotFoundException {
        return this.getDirectory_p(fi, false);
    }

    @Override
    public DirectoryInterface createDirectory(String directoryName) throws RepositoryCreateException, RepositoryIllegalNameException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        String serverName;
        boolean metadataFolderAdded;
        boolean contentAlreadyExists;
        OMRDirectory newDirectory;
        block19: {
            newDirectory = null;
            Entry.validateName(directoryName);
            directoryName = this.parseDirName(directoryName);
            contentAlreadyExists = false;
            metadataFolderAdded = false;
            serverName = null;
            log.debug(RBUtil.getStringResource("OMRDirectorycreateDisplay.notrans", directoryName));
            try {
                newDirectory = (OMRDirectory)this.getDirectory(directoryName);
                if (newDirectory != null) {
                    String msg = RBUtil.getStringResource("OMRDirectoryexists.txt", directoryName);
                    log.debug(msg);
                    throw new RepositoryDuplicateNameException(msg);
                }
            }
            catch (RepositoryNotFoundException e) {
                ContentInterface c = this.getContent(true);
                if (c == null) break block19;
                try {
                    if (c.exists(directoryName)) {
                        contentAlreadyExists = true;
                        log.warn(RBUtil.getStringResource("OMRDirectoryexistsContent.txt", directoryName));
                    }
                }
                catch (ContentException ee) {
                    throw new RepositoryException((Throwable)((Object)ee), ee.getMessage());
                }
            }
        }
        FolderInterface folderEntry = (FolderInterface)this.getMetadataObject();
        FolderInterface childFolderEntry = null;
        ContentInterface content = null;
        try {
            childFolderEntry = this.repositoryId.createReportFolderSmartObject(directoryName, (OMIRepositoryInterface)folderEntry.getRepository());
            folderEntry.addSubfolder(childFolderEntry);
            metadataFolderAdded = true;
            newDirectory = new OMRDirectory(childFolderEntry, this.repositoryId);
            PathUrl childPathUrl = childFolderEntry.getPathUrl();
            String childPathStr = childPathUrl.toString();
            serverName = childPathUrl.getServer();
            if (!contentAlreadyExists) {
                String childContentPath = this.repositoryId.resolveName(childPathUrl);
                PathUrl pathUrl = folderEntry.getPathUrl();
                OMRID.ContentInfo contentInfo = this.repositoryId.getContentInfo(pathUrl);
                String userId = contentInfo.getUserId();
                String pw = contentInfo.getPassword();
                content = ContentFactory.create(this.repositoryId, childContentPath, userId, pw);
                content.createDirectory("");
            }
            this.repositoryId.getCache().put(childPathStr, newDirectory);
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ContentException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
        HashMap<String, Date> attributeList = new HashMap<String, Date>();
        Date today = new Date();
        try {
            attributeList.put("Creation Date", today);
            attributeList.put("Modified Date", today);
            newDirectory.setAttributes(attributeList);
            return newDirectory;
        }
        catch (RepositoryException e) {
            try {
                metadataFolderAdded = true;
                if (true) {
                    UserContextInterface uci = this.repositoryId.getOMIRepository().getUserContext();
                    ServerInterface si = uci.getServer(serverName);
                    si.clearPendingChanges(true);
                }
                if (content != null) {
                    content.delete("");
                }
            }
            catch (ContentException e2) {
                log.warn(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e2));
            }
            catch (RemoteException e2) {
                throw new RepositoryException((Throwable)((Object)e), e.getMessage());
            }
            catch (ServiceException e2) {
                log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
                throw new RepositoryException((Throwable)((Object)e), e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public boolean isEmpty() throws RepositoryException {
        FolderInterface dir = (FolderInterface)this.getMetadataObject();
        try {
            List l = dir.getItems();
            if (l.size() > 0) {
                return false;
            }
            l = dir.getSubfolders();
            if (l.size() > 0) {
                return false;
            }
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        return true;
    }

    @Override
    public String[] list() throws RepositoryException, SecurityException {
        ArrayList list = new ArrayList();
        this.list(list, null, SortOrder.ASCENDING);
        String[] l = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            EntryInterface e = (EntryInterface)list.get(i);
            l[i] = e.getName();
        }
        return l;
    }

    @Override
    public void list(List directoryV) throws RepositoryException, SecurityException {
        this.list(directoryV, null, SortOrder.ASCENDING);
    }

    @Override
    public String[] list(RepositoryFilter filter) throws RepositoryException, SecurityException {
        Vector vec = new Vector();
        this.list(vec, filter, SortOrder.ASCENDING);
        String[] l = new String[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            EntryInterface e = (EntryInterface)vec.get(i);
            l[i] = e.getName();
        }
        return l;
    }

    @Override
    public void list(List dirList, RepositoryFilter filter, SortOrder order) throws RepositoryException, SecurityException {
        log.debug(RBUtil.getStringResource("OMRDirectorylistDisplay.notrans", this.getName()));
        List dirs = this.listDirs(filter, order);
        List files = this.listFiles(filter, order);
        dirList.addAll(dirs);
        dirList.addAll(files);
    }

    @Override
    public List listDirs(RepositoryFilter filter, SortOrder order) throws RepositoryException, SecurityException {
        ArrayList<OMRDirectory> dirList;
        FolderInterface dir = (FolderInterface)this.getMetadataObject();
        ReportManagementCache cache = this.repositoryId.getCache();
        try {
            List directories = dir.getSubfolders();
            dirList = new ArrayList<OMRDirectory>(directories.size());
            for (FolderInterface dirMdObj : directories) {
                String key = dirMdObj.getPathUrl().toString();
                OMRDirectory newdir = (OMRDirectory)cache.get(key);
                if (newdir == null) {
                    newdir = new OMRDirectory(dirMdObj, this.repositoryId);
                    cache.put(key, newdir);
                }
                if (filter != null && !filter.accept(newdir)) continue;
                log.debug(RBUtil.getStringResource("OMRDirectoryListDirName.notrans", newdir.getName()));
                dirList.add(newdir);
            }
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        this.sort(dirList, order);
        return dirList;
    }

    @Override
    public List listFiles(RepositoryFilter filter, SortOrder order) throws RepositoryException, SecurityException {
        ArrayList<Entry> fileList;
        FolderInterface dir = (FolderInterface)this.getMetadataObject();
        try {
            List entries = dir.getItems();
            fileList = new ArrayList<Entry>(entries.size());
            for (MetadataInterface entryMdObj : entries) {
                try {
                    Entry newEntry = this.getEntryInstance(entryMdObj, this.repositoryId, this.getContent(true));
                    if (filter != null && !filter.accept(newEntry)) continue;
                    log.debug(RBUtil.getStringResource("OMRDirectoryListEntryName.notrans", newEntry.getName()));
                    fileList.add(newEntry);
                }
                catch (RepositoryUnknownTypeException repositoryUnknownTypeException) {}
            }
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        this.sort(fileList, order);
        return fileList;
    }

    private void sort(List list, SortOrder order) {
        if (order != null && order != SortOrder.NONE && !list.isEmpty()) {
            Collections.sort(list, order == SortOrder.ASCENDING ? SORT_ASCENDING : SORT_DESCENDING);
        }
    }

    @Override
    public Iterator getAttributes() throws RepositoryException, SecurityException {
        return this.getAttributesAsMap().entrySet().iterator();
    }

    public Map getAttributesAsMap() throws RepositoryException, SecurityException {
        HashMap<String, Object> attributeList = new HashMap<String, Object>();
        attributeList.put("description", this.getAttribute("description"));
        attributeList.put("Creation Date", this.getAttribute("Creation Date"));
        attributeList.put("Modified Date", this.getAttribute("Modified Date"));
        MetadataInterface mdObj = (MetadataInterface)this.getMetadataObject();
        this.repositoryId.addUserDefinedAttributesToMap(attributeList, mdObj);
        attributeList.put("name", this.getAttribute("name"));
        attributeList.put("location", this.getLocation());
        attributeList.put("type", this.getAttribute("type"));
        return attributeList;
    }

    @Override
    public Object getAttribute(String attribName) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        FolderInterface omDirectoryObject = (FolderInterface)this.getMetadataObject();
        try {
            String name = omDirectoryObject.getName();
            if (attribName.equals("name")) {
                log.debug(RBUtil.getStringResource("OMRDirectorygetAttribute.notrans", (Object)name, (Object)attribName, name));
                return name;
            }
            if (attribName.equals("location")) {
                String location = this.getLocation();
                log.debug(RBUtil.getStringResource("OMRDirectorygetAttribute.notrans", (Object)name, (Object)attribName, location));
                return location;
            }
            if (attribName.equals("type")) {
                MetadataInterface mdObj = (MetadataInterface)this.getMetadataObject();
                String type = mdObj.getType();
                log.debug(RBUtil.getStringResource("OMRDirectorygetAttribute.notrans", (Object)name, (Object)attribName, type));
                return type;
            }
            if (attribName.equals("description")) {
                String description = omDirectoryObject.getDescription();
                log.debug(RBUtil.getStringResource("OMRDirectorygetAttribute.notrans", (Object)name, (Object)attribName, description));
                return description;
            }
            if (attribName.equals("Creation Date")) {
                MetadataInterface omEntryObject = (MetadataInterface)this.getMetadataObject();
                Date d = omEntryObject.getCreateDate();
                log.debug(RBUtil.getStringResource("OMRDirectorygetAttribute.notrans", (Object)name, (Object)attribName, d.toString()));
                return d;
            }
            if (attribName.equals("Modified Date")) {
                MetadataInterface omEntryObject = (MetadataInterface)this.getMetadataObject();
                Date d = omEntryObject.getModifyDate();
                log.debug(RBUtil.getStringResource("OMRDirectorygetAttribute.notrans", (Object)name, (Object)attribName, d.toString()));
                return d;
            }
            Object value = this.repositoryId.getUserDefinedProperty((MetadataInterface)omDirectoryObject, attribName);
            if (value == null) {
                String msg = RBUtil.getStringResource("OMRDirectoryattributeNotFound.txt", attribName);
                log.debug(msg);
                throw new RepositoryNotFoundException(msg);
            }
            return value;
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttributes(Map attributes) throws RepositoryLockedException, RepositoryException, SecurityException {
        Set attributeSet = attributes.entrySet();
        try {
            for (Map.Entry mapEntry : attributeSet) {
                this.setAttribute_p((String)mapEntry.getKey(), mapEntry.getValue());
            }
        }
        finally {
            this.updateMetadataAll();
        }
    }

    @Override
    public void setAttribute(String attribName, Object value) throws RepositoryLockedException, RepositoryException, SecurityException {
        this.setAttribute_p(attribName, value);
        this.updateMetadataAll();
    }

    @Override
    public AgingPolicy getAgingPolicy() throws SecurityException {
        return null;
    }

    @Override
    public void setAgingPolicy(AgingPolicy agingPolicy) throws SecurityException, RepositoryLockedException {
    }

    @Override
    public Iterator getKeywords() throws RepositoryException, SecurityException {
        return null;
    }

    @Override
    public boolean isKeyword(String keywordValue) throws RepositoryException, SecurityException {
        return false;
    }

    @Override
    public void setKeywords(List keywords) throws RepositoryLockedException, RepositoryException, SecurityException {
    }

    @Override
    public void setKeyword(String keywordName, String keywordDescription) throws SecurityException, RepositoryException, RepositoryLockedException {
    }

    @Override
    public void setKeyword(String keyword) throws RepositoryLockedException, RepositoryException, SecurityException {
    }

    @Override
    public void addKeywords(List keywords) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
    }

    @Override
    public void addKeyword(String keyword) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
    }

    @Override
    public void addKeyword(String keywordName, String keywordDescription) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
    }

    @Override
    public void removeKeyword(String keywordValue) throws RepositoryLockedException, RepositoryNotFoundException, RepositoryException, SecurityException {
    }

    @Override
    public void removeAllKeywords() throws RepositoryLockedException, RepositoryException, SecurityException {
    }

    @Override
    public InputStream getInputStream() throws RepositoryIOException, SecurityException {
        return null;
    }

    @Override
    public OutputStream getOutputStream() throws RepositoryIOException, SecurityException {
        return null;
    }

    @Override
    public OutputStream getOutputStream(boolean deleteCaches) throws RepositoryIOException, SecurityException {
        return null;
    }

    @Override
    public EntryInterface getGeneration(long generation) throws RepositoryNotFoundException, SecurityException {
        return null;
    }

    @Override
    public void age(long generationIncrement) throws SecurityException {
    }

    @Override
    public EntryInterface createEntry(String entryName) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        String publicType = null;
        String[] tokens = entryName.split("\\/");
        if (tokens.length == 2) {
            entryName = tokens[0];
            publicType = tokens[1];
        }
        String serverName = null;
        OMRDirectory.validateName(entryName);
        entryName = entryName.trim();
        FolderInterface omDirectoryObject = (FolderInterface)this.getMetadataObject();
        Entry entry = null;
        try {
            Interval interval = Interval.start("new OMREntry");
            if (publicType != null) {
                try {
                    ServerInterface server = this.repositoryId.getOMIRepository().getServer();
                    Collection<String> allTypeNamesWithReportTypeDescriptor = ReportTypeDescriptor.getAllPublicTypes(server);
                    EntryInterface _entry = null;
                    if (log.isDebugEnabled()) {
                        String nameType = entryName + "/" + publicType;
                        log.debug(RBUtil.getStringResource("OMRDirectorycreateEntry.notrans", nameType));
                    }
                    if (allTypeNamesWithReportTypeDescriptor.contains(publicType)) {
                        ReportTypeDescriptor rtd = ReportTypeDescriptor.getInstance(server, publicType);
                        ReportEntryCreatorInterface entryCreator = rtd.getEntryCreator();
                        _entry = entryCreator.createEntry(entryName, publicType, this.repositoryId, this.getContent(true), (OMIRepositoryInterface)omDirectoryObject.getRepository());
                    }
                    if (_entry != null) {
                        entry = (Entry)_entry;
                    }
                }
                catch (RepositoryException e) {
                    log.warn((Object)e);
                }
                catch (Exception e) {
                    log.debug((Object)e);
                }
            } else {
                entry = new OMREntry(entryName, this.repositoryId, this.getContent(true), (OMIRepositoryInterface)omDirectoryObject.getRepository());
                log.debug(RBUtil.getStringResource("OMRDirectorycreateEntry.notrans", entryName));
            }
            interval.stop();
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        if (entry == null && publicType != null) {
            String msg = RBUtil.getStringResource("OMRDirectoryunknownType.txt", publicType);
            log.debug(msg);
            throw new RepositoryUnknownTypeException(msg);
        }
        MetadataInterface entryObject = (MetadataInterface)entry.getMetadataObject();
        try {
            Interval interval = Interval.start("omDirectoryObject.addItem");
            omDirectoryObject.addItem(entryObject);
            interval.stop();
            Interval i2 = Interval.start("getPathUrl");
            String key = entryObject.getPathUrl().toString();
            serverName = entryObject.getPathUrl().getServer();
            this.repositoryId.getCache().put(key, entry);
            i2.stop();
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        HashMap<String, Object> attributeList = new HashMap<String, Object>();
        Date today = new Date();
        attributeList.put("Creation Date", today);
        attributeList.put("Modified Date", today);
        attributeList.put("Reference Date", today);
        attributeList.put("locale", Locale.getDefault().toString());
        try {
            Interval i3 = Interval.start("entry.setAttributes");
            entry.setAttributes(attributeList);
            i3.stop();
            OMREntry oe = (OMREntry)entry;
            HashMap<String, Object> eventInfo = new HashMap<String, Object>();
            eventInfo.put("name", entry.getName());
            eventInfo.put("path", entry.getParent());
            eventInfo.put("method", "create(" + entryName + ")");
            oe.generateEvent("SAS.Content.Created", eventInfo);
            return entry;
        }
        catch (RepositoryException e) {
            try {
                UserContextInterface uci = this.repositoryId.getOMIRepository().getUserContext();
                ServerInterface si = uci.getServer(serverName);
                si.clearPendingChanges(true);
            }
            catch (RemoteException e2) {
                throw new RepositoryException((Throwable)((Object)e), e.getMessage());
            }
            catch (ServiceException e2) {
                log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
                throw new RepositoryException((Throwable)((Object)e), e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public EntryInterface createEntry(String entryName, EntryInstantiatorInterface ei) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        String serverName = null;
        OMRDirectory.validateName(entryName);
        entryName = entryName.trim();
        FolderInterface omDirectoryObject = (FolderInterface)this.getMetadataObject();
        if (this.entryExists(entryName, ei)) {
            String msg = RBUtil.getStringResource("OMRDirectoryexists.txt", entryName);
            log.debug(msg);
            throw new RepositoryDuplicateNameException(msg);
        }
        OMREntry entry = null;
        Interval interval = Interval.start("new OMRGeneralEntry");
        entry = ei.create(entryName, this.repositoryId, this.getContent(true));
        interval.stop();
        MetadataInterface entryObject = (MetadataInterface)entry.getMetadataObject();
        try {
            interval = Interval.start("omDirectoryObject.addItem");
            omDirectoryObject.addItem(entryObject);
            interval.stop();
            Interval i2 = Interval.start("getPathUrl");
            String key = entryObject.getPathUrl().toString();
            serverName = entryObject.getPathUrl().getServer();
            this.repositoryId.getCache().put(key, entry);
            i2.stop();
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        HashMap<String, Object> attributeList = new HashMap<String, Object>();
        Date today = new Date();
        attributeList.put("Modified Date", today);
        attributeList.put("locale", Locale.getDefault().toString());
        try {
            Interval i3 = Interval.start("entry.setAttributes");
            entry.setAttributes(attributeList);
            i3.stop();
            OMREntry oe = entry;
            HashMap<String, Object> eventInfo = new HashMap<String, Object>();
            eventInfo.put("name", entry.getName());
            eventInfo.put("path", entry.getParent());
            eventInfo.put("method", "create(" + entryName + ")");
            oe.generateEvent("SAS.Content.Created", eventInfo);
            log.debug(RBUtil.getStringResource("OMRDirectorycreateEntry.notrans", entry.getName()));
            return entry;
        }
        catch (RepositoryException e) {
            try {
                UserContextInterface uci = this.repositoryId.getOMIRepository().getUserContext();
                ServerInterface si = uci.getServer(serverName);
                si.clearPendingChanges(true);
            }
            catch (RemoteException e2) {
                throw new RepositoryException((Throwable)((Object)e), e.getMessage());
            }
            catch (ServiceException e2) {
                log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
                throw new RepositoryException((Throwable)((Object)e), e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public EntryInterface createEntry(String entryName, AgingPolicy agingPolicy) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        String serverName = null;
        entryName = entryName.trim();
        FolderInterface omDirectoryObject = (FolderInterface)this.getMetadataObject();
        if (entryName == null || entryName.length() == 0) {
            throw new RepositoryIllegalNameException(RBUtil.getStringResource("OMRDirectorynoName.txt"));
        }
        if (this.entryExists(entryName)) {
            throw new RepositoryDuplicateNameException(RBUtil.getStringResource("OMRDirectoryexists.txt", entryName));
        }
        OMREntry entry = null;
        MetadataInterface entryObject = null;
        try {
            entry = new OMREntry(entryName, this.repositoryId, this.getContent(true));
            entryObject = (MetadataInterface)entry.getMetadataObject();
            omDirectoryObject.addItem(entryObject);
            String key = entryObject.getPathUrl().toString();
            serverName = entryObject.getPathUrl().getServer();
            this.repositoryId.getCache().put(key, entry);
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        entry.setAgingPolicy(agingPolicy);
        HashMap<String, Object> attributeList = new HashMap<String, Object>();
        Date today = new Date();
        attributeList.put("Creation Date", today);
        attributeList.put("Modified Date", today);
        String userId = null;
        try {
            userId = this.repositoryId.getUserName();
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        attributeList.put("locale", Locale.getDefault().toString());
        try {
            entry.setAttributes(attributeList);
        }
        catch (RepositoryException e) {
            try {
                UserContextInterface uci = this.repositoryId.getOMIRepository().getUserContext();
                ServerInterface si = uci.getServer(serverName);
                si.clearPendingChanges(true);
            }
            catch (RemoteException e2) {
                throw new RepositoryException((Throwable)((Object)e), e.getMessage());
            }
            catch (ServiceException e2) {
                log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
                throw new RepositoryException((Throwable)((Object)e), e.getMessage());
            }
            throw e;
        }
        log.debug(RBUtil.getStringResource("OMRDirectorycreateEntry.notrans", entry.getName()));
        return entry;
    }

    @Override
    public EntryInterface createEntry(Object entryMetadataObject) throws RepositoryIllegalNameException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        if (entryMetadataObject == null) {
            throw new IllegalArgumentException(RBUtil.getStringResource("OMRDirectoryMetadataObjNull.txt"));
        }
        if (!(entryMetadataObject instanceof MetadataInterface)) {
            throw new IllegalArgumentException(RBUtil.getStringResource("OMRDirectoryMetadataObjExpected.txt"));
        }
        FolderInterface omDirectoryObject = (FolderInterface)this.getMetadataObject();
        MetadataInterface entryObject = (MetadataInterface)entryMetadataObject;
        Entry entry = null;
        try {
            String entryName = entryObject.getName().trim();
            if (entryName == null || entryName.length() == 0) {
                throw new RepositoryIllegalNameException(RBUtil.getStringResource("OMRDirectorynoName.txt"));
            }
            if (entryName.indexOf(47) != -1) {
                throw new RepositoryIllegalNameException(RBUtil.getStringResource("OMRDirectorynoSlash.txt", entryName));
            }
            String entryType = entryObject.getType();
            String entryNameAndType = null;
            if (entryType != null) {
                int subType = entryType.lastIndexOf(".");
                entryNameAndType = entryName + "(" + entryType + ")";
                if (subType > 0) {
                    entryNameAndType = entryName + "(" + entryType.substring(0, subType) + ")";
                }
            }
            if (this.entryExists(entryNameAndType)) {
                throw new RepositoryDuplicateNameException(RBUtil.getStringResource("OMRDirectoryexists.txt", entryName));
            }
            omDirectoryObject.addItem(entryObject);
            this.updateMetadataAll();
            entry = this.getEntryInstance(entryObject, this.repositoryId, this.getContent(true));
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        HashMap<String, Object> attributeList = new HashMap<String, Object>();
        Date today = new Date();
        attributeList.put("Creation Date", today);
        attributeList.put("Modified Date", today);
        attributeList.put("Reference Date", today);
        String userId = null;
        try {
            userId = this.repositoryId.getUserName();
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        attributeList.put("locale", Locale.getDefault().toString());
        entry.setAttributes(attributeList);
        log.debug(RBUtil.getStringResource("OMRDirectorycreateEntry.notrans", entry.getName()));
        return entry;
    }

    private EntryInterface getEntry_p(String entryName) throws RepositoryIllegalNameException, RepositoryException, SecurityException {
        return this.getEntry_p(entryName, null);
    }

    private EntryInterface getEntry_p(String entryName, EntryInstantiatorInterface ei) throws RepositoryIllegalNameException, RepositoryException, SecurityException {
        if (entryName == null || entryName.length() == 0) {
            throw new RepositoryIllegalNameException(RBUtil.getStringResource("OMRDirectoryblankName.txt"));
        }
        String typeSuffix = null;
        typeSuffix = this.getKnownTypeSuffix(entryName);
        entryName = this.stripKnownTypeSuffix(entryName);
        EntryInterface retVal = null;
        OMRDirectory parentDir = null;
        String parentDirName = "";
        String simpleEntryName = entryName;
        int lastPathSepNdx = entryName.lastIndexOf(47);
        if (lastPathSepNdx == -1) {
            parentDir = this;
        } else {
            if (lastPathSepNdx < entryName.length() - 1) {
                parentDirName = entryName.substring(0, lastPathSepNdx);
                simpleEntryName = entryName.substring(lastPathSepNdx + 1);
            }
            parentDir = (OMRDirectory)this.getDirectory_p(parentDirName, true);
        }
        if (parentDir != null) {
            FolderInterface entryFolder = (FolderInterface)parentDir.getMetadataObject();
            try {
                MetadataInterface entryItem = entryFolder.getItemByType(simpleEntryName, typeSuffix);
                if (entryItem != null) {
                    retVal = this.getEntryInstance(entryItem, this.repositoryId, parentDir.getContent(true), ei);
                }
            }
            catch (ServiceException e) {
                log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
                throw new RepositoryException(e, e.getMessage());
            }
            catch (RemoteException e) {
                throw new RepositoryException(e, e.getMessage());
            }
        }
        if (retVal == null) {
            retVal = this.getDirectory_p(entryName, true);
        }
        return retVal;
    }

    protected String[] getAllReportPublicTypes() throws RepositoryException {
        String[] allTypes;
        try {
            ServerInterface si = this.repositoryId.getOMIRepository().getServer();
            Collection<String> allReportPublicTypes = ReportTypeDescriptor.getAllPublicTypes(si);
            int countTypes = 0;
            for (String publicType : allReportPublicTypes) {
                if (publicType.contains(".")) continue;
                ++countTypes;
            }
            allTypes = new String[countTypes + 1];
            allTypes[0] = "(Folder)";
            int i = 1;
            for (String publicType : allReportPublicTypes) {
                if (publicType.contains(".")) continue;
                allTypes[i++] = "(" + publicType + ")";
            }
        }
        catch (ServiceException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        return allTypes;
    }

    private String stripKnownTypeSuffix(String name) {
        if (name.endsWith(")")) {
            for (int i = 0; i < KNOWN_TYPE_SUFFIXES.length; ++i) {
                String suffix = KNOWN_TYPE_SUFFIXES[i];
                if (!name.endsWith(suffix)) continue;
                name = name.substring(0, name.length() - suffix.length());
                break;
            }
        }
        return name;
    }

    private String stripFilePath(String filePath) {
        String _entryName = null;
        int lastPathSepNdx = filePath.lastIndexOf(File.separatorChar);
        if (lastPathSepNdx == -1) {
            _entryName = filePath;
        } else if (lastPathSepNdx < filePath.length()) {
            _entryName = filePath.substring(lastPathSepNdx + 1);
        }
        return _entryName;
    }

    protected String getKnownTypeSuffix(String name) {
        String typeSuffix = null;
        if (name.endsWith(")")) {
            for (int i = 0; i < KNOWN_TYPE_SUFFIXES.length; ++i) {
                String suffix = KNOWN_TYPE_SUFFIXES[i];
                if (!name.endsWith(suffix)) continue;
                typeSuffix = KNOWN_TYPE_SUFFIXES[i];
                int lenTypeSuffix = typeSuffix.length();
                typeSuffix = typeSuffix.substring(1, lenTypeSuffix - 1);
                break;
            }
        }
        return typeSuffix;
    }

    private String getTypeSuffix(String name) {
        int openParenNdx;
        String typeSuffix = null;
        if (name.endsWith(")") && (openParenNdx = name.lastIndexOf("(")) > -1) {
            int len = name.length();
            typeSuffix = name.substring(openParenNdx + 1, len - 1);
        }
        return typeSuffix;
    }

    @Override
    public boolean entryExists(String entryName) throws RepositoryIllegalNameException, RepositoryException, SecurityException {
        String typeSuffix = this.getKnownTypeSuffix(entryName);
        if (typeSuffix == null) {
            String _entryName = this.stripFilePath(entryName);
            EntryInterface entry = this.getEntry_p(_entryName, null);
            return entry != null;
        }
        try {
            OMRDirectory parentDir = null;
            FolderInterface entryFolder = null;
            String parentDirName = "";
            int lastPathSepNdx = entryName.lastIndexOf(47);
            if (lastPathSepNdx == -1) {
                parentDir = this;
            } else {
                if (lastPathSepNdx < entryName.length() - 1) {
                    parentDirName = entryName.substring(0, lastPathSepNdx);
                    entryName = entryName.substring(lastPathSepNdx + 1);
                }
                parentDir = (OMRDirectory)this.getDirectory_p(parentDirName, true);
            }
            if (parentDir != null) {
                entryFolder = (FolderInterface)parentDir.getMetadataObject();
                if (entryName == null || entryName.length() == 0) {
                    throw new RepositoryIllegalNameException(RBUtil.getStringResource("OMRDirectoryblankName.txt"));
                }
                typeSuffix = this.getKnownTypeSuffix(entryName);
                entryName = this.stripKnownTypeSuffix(entryName);
                boolean exists = entryFolder.hasDuplicate(entryName, typeSuffix);
                return exists;
            }
        }
        catch (ServiceException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        return false;
    }

    @Override
    public boolean entryExists(String entryName, EntryInstantiatorInterface ei) throws RepositoryIllegalNameException, RepositoryException, SecurityException {
        String _entryName = this.stripFilePath(entryName);
        EntryInterface entry = this.getEntry_p(_entryName, ei);
        return entry != null;
    }

    @Override
    public EntryInterface getEntry(String entryName) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryException, SecurityException {
        EntryInterface entry = this.getEntry_p(entryName);
        if (entry == null) {
            throw new RepositoryNotFoundException(RBUtil.getStringResource("OMRDirectorynotFound.txt", entryName));
        }
        return entry;
    }

    @Override
    public EntryInterface getEntry(String entryName, EntryInstantiatorInterface ei) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryException, SecurityException {
        EntryInterface entry = this.getEntry_p(entryName, ei);
        if (entry == null) {
            throw new RepositoryNotFoundException(RBUtil.getStringResource("OMRDirectorynotFound.txt", entryName));
        }
        return entry;
    }

    @Override
    public EntryInterface getEntry(String entryName, long generation) throws RepositoryIllegalNameException, SecurityException {
        return null;
    }

    @Override
    public void renameTo(String newName) throws RepositoryIllegalNameException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        Entry.validateName(newName);
        try {
            if (!this.canWrite()) {
                throw new RepositoryCreateException(RBUtil.getStringResource("OMREntrynoWriteMetadata.txt"));
            }
        }
        catch (SecurityException e) {
            throw (RepositoryCreateException)((Object)new RepositoryCreateException(e.getMessage()).initCause(e));
        }
        if (this.checkDuplicateName(newName)) {
            throw new RepositoryDuplicateNameException(RBUtil.getStringResource("OMRDirectoryexists.txt", newName));
        }
        String oldName = this.getName();
        PathUrl oldLocationUrl = this.getLocationUrl();
        String oldLocation = this.getLocation();
        try {
            String mappedOldLocation;
            FolderInterface mdFolder = (FolderInterface)this.getMetadataObject();
            FolderInterface parentFolder = mdFolder.getParent();
            if (parentFolder == null) {
                throw new RepositoryIllegalNameException(RBUtil.getStringResource("OMRDirectorynoRenameRoot.txt"));
            }
            ContentInterface content = this.getContent(true);
            Names.validateOMRObjectName((String)newName, (boolean)true);
            if (!newName.equalsIgnoreCase(mdFolder.getName())) {
                String type = mdFolder.getType();
                List parentList = mdFolder.getParents();
                for (FolderInterface folder : parentList) {
                    if (!folder.hasDuplicate(newName, type)) continue;
                    throw new ServiceException(RBUtil.getStringResource("OMRDirectorydupItem.fmt.txt", (Object)newName, type));
                }
            }
            CMetadata c = (CMetadata)mdFolder.getRepositoryEntity();
            c.setName(newName);
            this.invalidatePathUrl();
            String location = this.getLocation();
            boolean contentRenamed = false;
            ContentInterface parentContent = null;
            String newDirName = null;
            String oldDirName = null;
            if (content != null && content.exists("") && !(oldDirName = this.getChildPath(mappedOldLocation = this.repositoryId.resolveName(oldLocationUrl))).equals(newName) && (parentContent = content.getParent()) != null && newName != null && oldDirName != null) {
                parentContent.renameTo(oldDirName, newName);
                this.myContent = null;
                contentRenamed = true;
            }
            try {
                this.updateMetadataAll();
            }
            catch (RepositoryException e) {
                log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
                if (contentRenamed) {
                    try {
                        parentContent.renameTo(newDirName, oldDirName);
                    }
                    catch (ContentException ee) {
                        throw new RepositoryException((Throwable)((Object)ee), ee.getMessage());
                    }
                }
                this.setName(oldName);
                this.invalidatePathUrl();
                throw e;
            }
            ReportManagementCache cache = this.repositoryId.getCache();
            cache.remove(oldLocation);
            cache.put(location, this);
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ContentException e) {
            try {
                this.setName(oldName);
                this.invalidatePathUrl();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
        log.debug(RBUtil.getStringResource("OMRDirectoryrenameMsg.notrans", (Object)oldName, newName));
    }

    @Override
    public void moveTo(EntryInterface destEntry) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        this.refresh();
        if (!destEntry.isDirectory()) {
            String msg = RBUtil.getStringResource("OMREntrynotDir.txt", destEntry.getName());
            throw new RepositoryNotFoundException(msg);
        }
        FolderInterface destParentFolder = null;
        FolderInterface srcParentFolder = null;
        FolderInterface destEntryObject = (FolderInterface)destEntry.getMetadataObject();
        FolderInterface srcEntryObject = (FolderInterface)this.getMetadataObject();
        OMRDirectory destParentDirectory = null;
        OMRDirectory srcParentDirectory = null;
        PathUrl destPathUrl = null;
        PathUrl srcPathUrl = null;
        String destLocation = null;
        String destPathNameAndType = null;
        String srcLocation = null;
        String srcName = null;
        String srcPathNameAndType = null;
        try {
            srcName = srcEntryObject.getName();
            srcPathUrl = srcEntryObject.getPathUrl();
            if (srcPathUrl == null) {
                throw new RepositoryNotFoundException(RBUtil.getStringResource("OMREntryNullPathUrl.fmt.txt", srcName));
            }
            srcLocation = srcPathUrl.toString();
            srcPathNameAndType = this.getPathNameWithType(srcPathUrl);
            destPathUrl = this.buildPathUrl((MetadataInterface)destEntryObject, srcName, srcPathUrl.getType());
            destLocation = destPathUrl.toString();
            destLocation = destPathUrl.toString();
            destPathNameAndType = this.getPathNameWithType(destPathUrl);
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        srcParentDirectory = (OMRDirectory)this.getParentEntry();
        srcParentFolder = (FolderInterface)srcParentDirectory.getMetadataObject();
        if (srcLocation == null || srcLocation.length() <= 0) {
            throw new RepositoryIllegalNameException(RBUtil.getStringResource("OMRDirectorysourceNull.txt"));
        }
        destParentDirectory = (OMRDirectory)destEntry;
        try {
            if (!destParentDirectory.canWrite()) {
                throw new RepositoryCreateException(RBUtil.getStringResource("OMRDirectorynoWriteMetadata.txt"));
            }
        }
        catch (SecurityException e) {
            RepositoryCreateException ex = new RepositoryCreateException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        destParentFolder = (FolderInterface)destParentDirectory.getMetadataObject();
        if (destLocation == null || destLocation.length() <= 0) {
            throw new RepositoryIllegalNameException(RBUtil.getStringResource("OMRDirectorydestNull.txt"));
        }
        if (srcLocation.equals(destLocation)) {
            throw new RepositoryException(RBUtil.getStringResource("OMRDirectorydestSourceSame.txt"));
        }
        if (!RepositoryUtils.sameRepository((MetadataInterface)destParentFolder, (MetadataInterface)srcParentFolder)) {
            throw new RepositoryBetweenRepositoriesException(RBUtil.getStringResource("OMRDirectorymoveTonotSupported.txt"));
        }
        try {
            ChildServerInterface childServer = null;
            UserContextInterface uci = this.repositoryId.getOMIRepository().getUserContext();
            ServerInterface si = uci.getAuthServer();
            childServer = si.newChild(false);
            PathUrl targetPathUrl = destParentFolder.getPathUrl();
            FolderInterface targetParentFolder = (FolderInterface)childServer.getObjectByPath(targetPathUrl);
            FolderInterface sourceParentFolder = (FolderInterface)childServer.getObjectByPath(srcParentFolder.getPathUrl());
            FolderInterface tgt = sourceParentFolder.getSubfolder(srcName);
            sourceParentFolder.removeSubfolder(srcName);
            sourceParentFolder.update();
            ReportManagementCache cache = this.repositoryId.getCache();
            cache.remove(srcPathUrl.toString());
            ContentInterface srcRoot = this.getRootContent(srcPathUrl);
            ContentInterface destRoot = destParentDirectory.getRootContent(destPathUrl);
            boolean contentMoved = false;
            String srcPathName = this.getPathName(srcPathUrl);
            String destPathName = this.getPathName(destPathUrl);
            try {
                srcRoot.moveTo(srcPathName, destRoot, destPathName);
                contentMoved = true;
            }
            catch (ContentNameNotFoundException e) {
                log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            }
            ContentInterface oldContent = this.myContent;
            this.myContent = this.getNewContentInterface(destParentDirectory.getLocationUrl());
            targetParentFolder.addSubfolder(tgt);
            targetParentFolder.update();
            try {
                childServer.flush();
                cache.put(destPathUrl.toString(), this);
            }
            catch (Exception e) {
                log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", e));
                this.myContent = oldContent;
                if (contentMoved) {
                    try {
                        destRoot.moveTo(destPathName, srcRoot, srcPathName);
                    }
                    catch (ContentException ee) {
                        throw new RepositoryException((Throwable)((Object)ee), ee.getMessage());
                    }
                }
                throw new RepositoryException(e, e.getMessage());
            }
            finally {
                try {
                    childServer.destroy();
                }
                catch (Exception e) {
                    log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", e));
                }
            }
            this.invalidatePathUrl();
            ((MetadataInterface)this.getMetadataObject()).refresh();
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ContentException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
        log.debug(RBUtil.getStringResource("OMRDirectorymoveTo.notrans", (Object)srcPathNameAndType, destPathNameAndType));
    }

    @Override
    public void copyTo(EntryInterface destEntry) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        this.refresh();
        MetadataInterface destEntryObject = (MetadataInterface)destEntry.getMetadataObject();
        MetadataInterface srcEntryObject = (MetadataInterface)this.getMetadataObject();
        OMRDirectory destParentDirectory = null;
        PathUrl destPathUrl = null;
        PathUrl srcPathUrl = null;
        String destLocation = null;
        String destName = null;
        String destPathNameAndType = null;
        String srcLocation = null;
        String srcName = null;
        String srcPathNameAndType = null;
        try {
            srcPathUrl = srcEntryObject.getPathUrl();
            srcLocation = srcPathUrl.toString();
            srcName = srcEntryObject.getName();
            srcPathNameAndType = this.getPathNameWithType(srcPathUrl);
            boolean destIsADir = destEntry.isDirectory();
            if (!destIsADir) {
                throw new RepositoryException("Target entry must be a directory, for a directory copy");
            }
            destPathUrl = this.buildPathUrl(destEntryObject, srcName, srcPathUrl.getType());
            destLocation = destPathUrl.toString();
            destName = destPathUrl.getName();
            destPathNameAndType = this.getPathNameWithType(destPathUrl);
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        if (srcLocation == null || srcLocation.length() <= 0) {
            throw new RepositoryIllegalNameException(RBUtil.getStringResource("OMRDirectorysourceNull.txt"));
        }
        destParentDirectory = (OMRDirectory)destEntry;
        if (destLocation == null || destLocation.length() <= 0) {
            throw new RepositoryIllegalNameException(RBUtil.getStringResource("OMRDirectorydestNull.txt"));
        }
        if (srcLocation.equals(destLocation)) {
            throw new RepositoryException(RBUtil.getStringResource("OMRDirectorydestSourceSame.txt"));
        }
        for (EntryInterface entry : this.listFiles(null, null)) {
            entry.copyTo(destEntry);
        }
        for (DirectoryInterface dir : this.listDirs(null, null)) {
            DirectoryInterface dest;
            try {
                dest = ((DirectoryInterface)destEntry).getDirectory(dir.getName());
            }
            catch (RepositoryNotFoundException e) {
                FolderInterface destFolderObjectNew = null;
                try {
                    destFolderObjectNew = (FolderInterface)this.repositoryId.cloneMetadataObject((MetadataInterface)dir.getMetadataObject(), (OMIRepositoryInterface)destEntryObject.getRepository());
                    ((FolderInterface)destEntry.getMetadataObject()).addSubfolder(destFolderObjectNew);
                    dest = new OMRDirectory(destFolderObjectNew, destParentDirectory.repositoryId);
                }
                catch (ServiceException e2) {
                    log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e2));
                    throw new RepositoryException(e2, e2.getMessage());
                }
                catch (RemoteException e2) {
                    log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", e2));
                    throw new RepositoryException(e2, e2.getMessage());
                }
            }
            dir.copyTo(dest);
        }
    }

    private boolean deleteItems_p(OperationResultHandler handler, RepositoryMetadataFilter filter, FolderInterface omEntryObject, ContentInterface content) throws ServiceException, RemoteException, RepositoryException {
        boolean ableToDeleteAllItems = true;
        List children = omEntryObject.getItems();
        for (MetadataInterface child : children) {
            if (filter == null || filter.accept(child)) {
                PathUrl pathUrl;
                try {
                    Entry entry = this.getEntryInstance(child, this.repositoryId, content);
                    if (filter == null || filter.accept(entry)) {
                        log.debug(RBUtil.getStringResource("OMRDirectorydeleteMsg.notrans", (Object)omEntryObject.getName(), child.getName()));
                        try {
                            entry.delete();
                        }
                        catch (Exception e) {
                            ableToDeleteAllItems = false;
                            pathUrl = entry.getLocationUrl();
                            handler.handle(new OperationResult(pathUrl.toString(), OperationResult.EXCEPTION, e));
                        }
                        continue;
                    }
                    ableToDeleteAllItems = false;
                    PathUrl pathUrl2 = entry.getLocationUrl();
                    handler.handle(new OperationResult(pathUrl2.toString(), OperationResult.FILTER_DENY));
                }
                catch (RepositoryUnknownTypeException e) {
                    try {
                        child.delete();
                    }
                    catch (Exception e2) {
                        ableToDeleteAllItems = false;
                        pathUrl = child.getPathUrl();
                        handler.handle(new OperationResult(pathUrl.toString(), OperationResult.EXCEPTION, e2));
                    }
                }
                continue;
            }
            ableToDeleteAllItems = false;
            PathUrl pathUrl = child.getPathUrl();
            handler.handle(new OperationResult(pathUrl.toString(), OperationResult.FILTER_DENY));
        }
        return ableToDeleteAllItems;
    }

    private boolean delete_p(OperationResultHandler handler, RepositoryMetadataFilter filter) throws RepositoryLockedException, RepositoryException, SecurityException {
        FolderInterface omEntryObject = (FolderInterface)this.getMetadataObject();
        if (omEntryObject == null) {
            return true;
        }
        try {
            if (!this.canWrite()) {
                throw new RepositoryDeleteException(RBUtil.getStringResource("OMREntrynoWriteMetadata.txt"));
            }
        }
        catch (SecurityException e) {
            throw (RepositoryCreateException)((Object)new RepositoryCreateException(e.getMessage()).initCause(e));
        }
        String pathUrlStr = this.getLocation();
        try {
            ContentInterface content = this.getContent(false);
            boolean ableToDeleteAllItems = true;
            try {
                ableToDeleteAllItems = this.deleteItems_p(handler, filter, omEntryObject, content);
                ReportManagementCache cache = this.repositoryId.getCache();
                List childSubDirs = omEntryObject.getSubfolders();
                for (FolderInterface child : childSubDirs) {
                    String key = child.getPathUrl().toString();
                    OMRDirectory subdir = (OMRDirectory)cache.get(key);
                    if (subdir == null) {
                        subdir = new OMRDirectory(child, this.repositoryId);
                    }
                    log.debug(RBUtil.getStringResource("OMRDirectorydeleteMsg.notrans", (Object)omEntryObject.getName(), child.getName()));
                    if (subdir.delete_p(handler, filter)) continue;
                    ableToDeleteAllItems = false;
                }
                if (!ableToDeleteAllItems) {
                    handler.handle(new OperationResult(pathUrlStr, OperationResult.NOT_EMPTY));
                    return false;
                }
                if (!(filter == null || filter.accept(this) && filter.accept((MetadataInterface)this.getMetadataObject()))) {
                    handler.handle(new OperationResult(pathUrlStr, OperationResult.FILTER_DENY));
                    return false;
                }
                ArrayList<Object> objectsToDelete = new ArrayList<Object>();
                objectsToDelete.addAll((Collection<Object>)this.repositoryId.getTimestamps((MetadataInterface)omEntryObject));
                AssociationList propList = this.repositoryId.getProperties((MetadataInterface)omEntryObject);
                objectsToDelete.addAll((Collection<Object>)propList);
                for (Property property : propList) {
                    objectsToDelete.addAll((Collection<Object>)this.repositoryId.getPropertyTypes(property));
                }
                objectsToDelete.addAll((Collection<Object>)this.repositoryId.getKeywords((MetadataInterface)omEntryObject, false));
                Object jomaObject = omEntryObject.getRepositoryEntity();
                objectsToDelete.add(jomaObject);
                try {
                    RepositoryFactory.markForDeletion(omEntryObject.getRepositoryEntity());
                }
                catch (Exception e) {
                    log.warn(RBUtil.getStringResource("OMRDirectorymarkForDeletionFailed.txt", e));
                }
                OMIRepositoryInterface omiRepos = this.repositoryId.getOMIRepository();
                omiRepos.deleteEntities(objectsToDelete);
            }
            catch (ServiceException e) {
                log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
                throw new RepositoryException(e, e.getMessage());
            }
            catch (RemoteException e) {
                throw new RepositoryException(e, e.getMessage());
            }
            this.repositoryId.getCache().remove(pathUrlStr);
            if (content != null) {
                try {
                    content.delete("");
                }
                catch (ContentNameNotFoundException e) {
                }
                catch (ContentFileException e) {
                    throw new RepositoryException((Throwable)((Object)e), e.getMessage());
                }
                catch (ContentException e) {
                    throw new RepositoryException((Throwable)((Object)e), e.getMessage());
                }
            }
            this.setMetadataObject(null);
            return true;
        }
        catch (Exception e) {
            OperationResult result = new OperationResult(pathUrlStr, OperationResult.EXCEPTION, e);
            handler.handle(result);
            return false;
        }
    }

    @Override
    public void delete(RepositoryMetadataFilter filter) throws RepositoryException {
        OperationBestEffortHandler handler = new OperationBestEffortHandler();
        this.delete_p(handler, filter);
        if (handler.hasResults()) {
            throw new RepositoryDeleteException(handler.getResults());
        }
    }

    @Override
    public void delete() throws RepositoryLockedException, RepositoryException, SecurityException {
        this.delete_p(this.FAIL_FAST_HANDLER, null);
    }

    @Override
    public void delete(long generation) throws RepositoryLockedException, SecurityException {
    }

    @Override
    public String getParent() throws RepositoryNotFoundException, RepositoryException, SecurityException {
        EntryInterface parentEntry = this.getParentEntry();
        return parentEntry.toString();
    }

    @Override
    public EntryInterface getParentEntry() throws RepositoryNotFoundException, RepositoryException, SecurityException {
        DirectoryInterface parentEntry;
        block5: {
            FolderInterface parentFolder = null;
            parentEntry = null;
            FolderInterface omDirectoryObject = (FolderInterface)this.getMetadataObject();
            try {
                parentFolder = omDirectoryObject.getParent();
                if (parentFolder != null) {
                    log.debug(RBUtil.getStringResource("OMRDirectoryparentMsg.notrans", (Object)this.getName(), parentFolder.getName()));
                    ReportManagementCache cache = this.repositoryId.getCache();
                    String key = parentFolder.getPathUrl().toString();
                    parentEntry = (DirectoryInterface)cache.get(key);
                    if (parentEntry == null) {
                        parentEntry = new OMRDirectory(parentFolder, this.repositoryId);
                        cache.put(key, parentEntry);
                    }
                    break block5;
                }
                throw new RepositoryNotFoundException(RBUtil.getStringResource("OMRDirectorynoParent.txt", this.getName()));
            }
            catch (ServiceException e) {
                log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
                throw new RepositoryException(e, e.getMessage());
            }
            catch (RemoteException e) {
                throw new RepositoryException(e, e.getMessage());
            }
        }
        return parentEntry;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public CacheSetInterface getCacheSetInterface() {
        throw new UnsupportedOperationException(RBUtil.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void deleteContent() {
        throw new UnsupportedOperationException(RBUtil.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public DirectoryInterface ensurePath(PathUrl dirPathUrl) throws RepositoryException {
        OMRDirectory.validatePath(dirPathUrl);
        String reqLocStr = dirPathUrl.toString();
        return this.ensurePath_p(reqLocStr);
    }

    private DirectoryInterface ensurePath_p(String reqLocStr) throws RepositoryException {
        String locStr = this.getLocation();
        if (reqLocStr.equals(locStr)) {
            return this;
        }
        String locWithoutType = this.getAddressWithoutType();
        if (reqLocStr.equals(locWithoutType)) {
            return this;
        }
        int locLen = locWithoutType.length() + 1;
        if (!reqLocStr.startsWith(locWithoutType)) {
            throw new RepositoryException(RBUtil.getStringResource("OMRDirectorycannotEnsure.txt", (Object)reqLocStr, locStr));
        }
        String subPath = reqLocStr.substring(locLen);
        if (subPath.length() == 0) {
            return this;
        }
        int firstSlash = subPath.indexOf(47);
        if (firstSlash > 0) {
            subPath = subPath.substring(0, firstSlash);
        }
        OMRDirectory subdir = null;
        try {
            subdir = (OMRDirectory)this.getDirectory(subPath);
        }
        catch (RepositoryNotFoundException e) {
            subdir = (OMRDirectory)this.createDirectory(subPath);
        }
        return subdir.ensurePath_p(reqLocStr);
    }

    protected void ensureContent(ContentInterface content) throws ContentException, RepositoryException {
        if (content.exists("")) {
            return;
        }
        if (!this.isRootFolder()) {
            OMRDirectory parentDir = (OMRDirectory)this.getParentEntry();
            if (parentDir == null) {
                throw new RuntimeException("parentDir == null");
            }
            parentDir.getContent(true);
        }
        content.createDirectory("");
    }

    private boolean isRootFolder() throws RepositoryException {
        boolean retVal = false;
        try {
            FolderInterface mdObj = (FolderInterface)this.getMetadataObject();
            ServerInterface server = mdObj.getRepository().getServer();
            RootFolderInterface theRoot = server.getRootFolder();
            String rootId = theRoot.getReposId();
            FolderInterface _parent = mdObj.getParent();
            if (_parent == null) {
                throw new RepositoryException(RBUtil.getStringResource("OMRDirectoryIsRootFolderFoundOrphan.txt"));
            }
            if (_parent.getReposId().equals(rootId)) {
                retVal = true;
            }
            return retVal;
        }
        catch (ServiceException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    @Override
    public String getContentLocation() throws RepositoryException {
        try {
            PathUrl sbipLocation = this.getLocationUrl();
            log.debug(RBUtil.getStringResource("OMRDirectorysrrpDisplay.notrans", sbipLocation));
            String contentLocation = null;
            if (sbipLocation != null) {
                contentLocation = this.repositoryId.resolveName(sbipLocation);
            }
            return contentLocation;
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
    }

    protected ContentInterface getContent(boolean repairIfNeeded) throws RepositoryException {
        if (this.myContent != null) {
            return this.myContent;
        }
        try {
            String contentLocation = this.getContentLocation();
            log.debug(RBUtil.getStringResource("OMRDirectorycontentDisplay.notrans", contentLocation));
            if (contentLocation != null && contentLocation.length() != 0) {
                MetadataInterface mdObj = (MetadataInterface)this.getMetadataObject();
                PathUrl pathUrl = mdObj.getPathUrl();
                OMRID.ContentInfo contentInfo = this.repositoryId.getContentInfo(pathUrl);
                String userId = contentInfo.getUserId();
                String pw = contentInfo.getPassword();
                this.myContent = ContentFactory.create(this.repositoryId, contentLocation, userId, pw);
                if (repairIfNeeded) {
                    this.ensureContent(this.myContent);
                }
            }
        }
        catch (ContentException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
        return this.myContent;
    }

    private boolean checkDuplicateName(String name) throws RepositoryException {
        FolderInterface parentFolder = null;
        FolderInterface omDirectoryObject = (FolderInterface)this.getMetadataObject();
        try {
            parentFolder = omDirectoryObject.getParent();
            if (parentFolder != null) {
                List subtrees = parentFolder.getSubfolders();
                for (FolderInterface tree : subtrees) {
                    if (!name.equals(tree.getName())) continue;
                    return true;
                }
                List members = parentFolder.getItems();
                for (MetadataInterface member : members) {
                    if (!name.equals(member.getName())) continue;
                    return true;
                }
            }
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        return false;
    }

    private String getChildPath(String path) {
        if (path.length() == 0) {
            return null;
        }
        path = path.replace('\\', '/');
        int lastCharPos = path.length() - 1;
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash == lastCharPos) {
            path = path.substring(0, lastCharPos);
            lastSlash = path.lastIndexOf(47);
        }
        if (lastSlash < 0) {
            return path;
        }
        return path.substring(lastSlash + 1);
    }

    private void setAttribute_p(String attribName, Object value) throws RepositoryLockedException, RepositoryException, SecurityException {
        FolderInterface omDirectoryObject = (FolderInterface)this.getMetadataObject();
        try {
            if (attribName.equals("name")) {
                this.repositoryId.verifyStringType(attribName, value);
                String newName = (String)value;
                log.debug(RBUtil.getStringResource("OMRDirectoryattMsg.notrans", (Object)this.getName(), (Object)attribName, newName));
                this.renameTo(newName);
            } else {
                if (attribName.equals("location")) {
                    throw new IllegalArgumentException(RBUtil.getStringResource("OMRDirectoryreadonlyAttribute.txt", attribName));
                }
                if (attribName.equals("type")) {
                    throw new IllegalArgumentException(RBUtil.getStringResource("OMRDirectoryreadonlyAttribute.txt", attribName));
                }
                if (attribName.equals("description")) {
                    this.repositoryId.verifyStringType(attribName, value);
                    String newDescription = (String)value;
                    log.debug(RBUtil.getStringResource("OMRDirectoryattMsg.notrans", (Object)this.getName(), (Object)attribName, newDescription));
                    omDirectoryObject.setDescription(newDescription);
                } else if (!attribName.equals("Creation Date") && !attribName.equals("Modified Date")) {
                    this.repositoryId.setUserDefinedProperty((MetadataInterface)omDirectoryObject, attribName, value);
                }
            }
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
    }

    private void updateMetadataAll() throws RepositoryException {
        MetadataInterface omEntryObject = (MetadataInterface)this.getMetadataObject();
        try {
            omEntryObject.update();
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
    }

    private String parseDirName(String dirName) throws IllegalArgumentException {
        int openParenNdx;
        if (dirName == null) {
            throw new IllegalArgumentException(RBUtil.getStringResource("EntryNameNull.txt"));
        }
        if (dirName.trim().length() == 0) {
            throw new IllegalArgumentException(RBUtil.getStringResource("EntryNameZeroLength.txt"));
        }
        int len = dirName.length();
        int closeParenNdx = dirName.lastIndexOf(")");
        if (closeParenNdx == len - 1 && (openParenNdx = dirName.lastIndexOf("(")) > -1) {
            log.debug(RBUtil.getStringResource("OMRDirectoryparenInDirName.txt"));
            String type = dirName.substring(openParenNdx + 1, len - 1);
            if (type.equals("Folder")) {
                dirName = dirName.substring(0, openParenNdx);
            }
        }
        return dirName;
    }

    private DirectoryInterface getDirectory_p(String directoryName, boolean favorNulls) throws RepositoryException, RepositoryNotFoundException {
        if (directoryName == null || directoryName.length() == 0) {
            if (favorNulls) {
                return null;
            }
            throw new IllegalArgumentException(RBUtil.getStringResource("OMRDirectoryblankName.txt"));
        }
        String dirName = this.parseDirName(directoryName);
        OMRDirectory curDir = this;
        while (dirName != null && dirName.length() > 0) {
            String subDir = "";
            int idx = dirName.indexOf(47);
            if (idx == 0) {
                dirName = dirName.substring(1);
                idx = dirName.indexOf(47);
            }
            if (idx >= 0) {
                subDir = dirName.substring(0, idx);
                dirName = dirName.substring(idx);
            } else {
                subDir = dirName;
                dirName = "";
            }
            Entry.validateName(subDir);
            FolderInterface curDirFolder = (FolderInterface)curDir.getMetadataObject();
            FolderInterface mdFolder = null;
            try {
                List subFolders = curDirFolder.getSubfolders();
                Iterator itor = subFolders.iterator();
                while (mdFolder == null && itor.hasNext()) {
                    FolderInterface subF = (FolderInterface)itor.next();
                    if (!subDir.equalsIgnoreCase(subF.getName())) continue;
                    mdFolder = subF;
                }
            }
            catch (ServiceException e) {
                log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
                throw new RepositoryException(e, e.getMessage());
            }
            catch (RemoteException e) {
                throw new RepositoryException(e, e.getMessage());
            }
            if (mdFolder == null) {
                if (favorNulls) {
                    return null;
                }
                log.debug(RBUtil.getStringResource("OMRDirectorynotFound.txt", directoryName));
                throw new RepositoryNotFoundException(RBUtil.getStringResource("OMRDirectorynotFound.txt", directoryName));
            }
            try {
                String key;
                ReportManagementCache cache = this.repositoryId.getCache();
                curDir = (OMRDirectory)cache.get(key = mdFolder.getPathUrl().toString());
                if (curDir != null) continue;
                curDir = new OMRDirectory(mdFolder, this.repositoryId);
                cache.put(key, curDir);
            }
            catch (RemoteException e) {
                throw new RepositoryException(e, e.getMessage());
            }
            catch (ServiceException e) {
                log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
                throw new RepositoryException(e, e.getMessage());
            }
        }
        return curDir;
    }

    private DirectoryInterface getDirectory_p(FolderInterface fi, boolean favorNulls) throws RepositoryException, RepositoryNotFoundException {
        String key = "";
        OMRDirectory curDir = this;
        try {
            key = fi.getPathUrl().toString();
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        catch (ServiceException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            throw new RepositoryException(e, e.getMessage());
        }
        if (fi == null) {
            if (favorNulls) {
                return null;
            }
            throw new RepositoryNotFoundException(RBUtil.getStringResource("OMRDirectorynotFound.txt", key));
        }
        try {
            ReportManagementCache cache = this.repositoryId.getCache();
            curDir = (OMRDirectory)cache.get(key);
            if (curDir == null) {
                curDir = new OMRDirectory(fi, this.repositoryId);
                cache.put(key, curDir);
            }
        }
        catch (RemoteException e) {
            throw new RepositoryException(e, e.getMessage());
        }
        return curDir;
    }

    @Override
    public long getSizeOfContent() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    protected void closeContentConnections() {
        if (this.myContent == null) {
            return;
        }
        this.myContent.close();
    }

    @Override
    public void copyWithoutCaches(EntryInterface destEntry) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public String getApplicationData(String applicationDataName) {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void setApplicationData(String applicationDataName, String value) {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void setApplicationData(String applicationDataName, String value, boolean transientData, boolean updateTimestamps) {
        throw new UnsupportedOperationException(RB.getStringResource("OMRDirectorynotSupported.txt"));
    }

    @Override
    public void refresh() {
        FolderInterface mdObj = (FolderInterface)this.getMetadataObject();
        if (mdObj != null) {
            try {
                mdObj.refresh();
            }
            catch (Exception e) {
                log.warn(RBUtil.getStringResource("OMRDirectoryError.notrans", e));
            }
        }
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof OMRDirectory)) {
                return false;
            }
            OMRDirectory other = (OMRDirectory)obj;
            String otherLoc = other.getLocation();
            String loc = this.getLocation();
            return loc.equals(otherLoc);
        }
        catch (RepositoryException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            return false;
        }
    }

    private PathUrl buildPathUrl(MetadataInterface mdObj, String name, String type) throws RemoteException, ServiceException {
        PathUrl newPathUrl = (PathUrl)mdObj.getPathUrl().clone();
        String newPath = newPathUrl.getName();
        String oldPath = newPathUrl.getPath();
        if (oldPath != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(oldPath).append("/").append(newPath);
            newPath = buf.toString();
        }
        newPathUrl.setPath(newPath);
        newPathUrl.setName(name);
        newPathUrl.setType(type);
        return newPathUrl;
    }

    private ContentInterface getRootContent(PathUrl pathUrl) throws RepositoryException, ContentException, RemoteException {
        pathUrl = (PathUrl)pathUrl.clone();
        pathUrl.setName(null);
        pathUrl.setPath(null);
        pathUrl.setType(null);
        String rootPath = this.repositoryId.resolveName(pathUrl);
        OMRID.ContentInfo contentInfo = this.repositoryId.getContentInfo(pathUrl);
        String userId = contentInfo.getUserId();
        String pw = contentInfo.getPassword();
        return ContentFactory.create(this.repositoryId, rootPath, userId, pw);
    }

    private ContentInterface getNewContentInterface(PathUrl pathUrl) throws RepositoryException {
        try {
            String contentLocation = this.repositoryId.resolveName(pathUrl);
            if (contentLocation != null && contentLocation.length() != 0) {
                OMRID.ContentInfo contentInfo = this.repositoryId.getContentInfo(pathUrl);
                String userId = contentInfo.getUserId();
                String pw = contentInfo.getPassword();
                return ContentFactory.create(this.repositoryId, contentLocation, userId, pw);
            }
            return null;
        }
        catch (ContentException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", (Object)e));
            throw new RepositoryException((Throwable)((Object)e), e.getMessage());
        }
        catch (RemoteException e) {
            log.debug(RBUtil.getStringResource("OMRDirectoryError.notrans", e));
            throw new RepositoryException(e, e.getMessage());
        }
    }

    @Override
    protected String getPathName(PathUrl pathUrl) throws RepositoryException {
        String name = pathUrl.getName();
        String path = pathUrl.getPath();
        if (path == null) {
            return name;
        }
        return path + "/" + name;
    }

    public OMRID getOMRID() {
        return this.repositoryId;
    }
}

