/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

class Interval {
    private static final Interval NULL_INTERVAL = new Interval();
    private static boolean myEnabledFlag;

    public static Interval start(String title) {
        if (myEnabledFlag) {
            return new RealInterval(title);
        }
        return NULL_INTERVAL;
    }

    private Interval() {
    }

    public void stop() {
    }

    static {
        try {
            myEnabledFlag = Boolean.getBoolean("com.sas.report.repository.profile");
            if (myEnabledFlag) {
                System.err.println("com.sas.report.repository.Interval: Profiling Enabled");
            }
        }
        catch (Throwable th) {
            System.err.println("Interval::failure in static block!");
            th.printStackTrace();
        }
    }

    private static class RealInterval
    extends Interval {
        private long myStartTime;
        private String myTitle;

        private RealInterval(String title) {
            this.myTitle = title;
            this.myStartTime = System.currentTimeMillis();
        }

        @Override
        public void stop() {
            long interval = System.currentTimeMillis() - this.myStartTime;
            StringBuffer buf = new StringBuffer();
            buf.append("\"");
            buf.append(this.myTitle);
            buf.append("\", ");
            buf.append(interval);
            buf.append(",");
            System.out.print(buf.toString());
        }
    }
}

