/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.metadata.remote.Transformation;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.Lock;
import com.sas.report.repository.RB;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.report.repository.RepositoryUtils;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.util.UncheckedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Entry
extends Lock
implements EntryInterface {
    private static final List INVALID_CHAR_LIST;
    private static final char[] INVALID_CHAR_ARRAY;
    private static int cacheHit;
    private static int cacheTotal;
    private static boolean myDisablePathCacheFlag;
    protected MetadataInterface metadataObject = null;
    private static final Logger log;
    private PathUrl myCachedPathUrl;
    private String myCachedPathUrlStr;

    protected static void validatePath(PathUrl pathUrl) throws IllegalArgumentException {
        if (pathUrl == null) {
            throw new IllegalArgumentException(RBUtil.getStringResource("EntryPathUrlNull.txt"));
        }
        if (pathUrl.getRootTree() == null) {
            throw new IllegalArgumentException(RBUtil.getStringResource("EntryPathUrlNotRooted.txt"));
        }
        String name = pathUrl.getName();
        if (name != null && name.indexOf(40) == 0) {
            throw new IllegalArgumentException(RBUtil.getStringResource("EntryPathUrlNoName.fmt.txt", pathUrl.toString()));
        }
    }

    public static List getInvalidCharacters() {
        return INVALID_CHAR_LIST;
    }

    public static void validateName(String name) throws IllegalArgumentException {
        Entry.validateName(name, Locale.getDefault());
    }

    public static void validateCacheName(String name) throws IllegalArgumentException {
        Entry.validateCacheName(name, Locale.getDefault());
    }

    public static void validateCacheName(String name, Locale locale) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException(RBUtil.getStringResource("EntryNameNull.txt", locale));
        }
        int nameLength = name.trim().length();
        if (nameLength == 0) {
            throw new IllegalArgumentException(RBUtil.getStringResource("EntryNameZeroLength.txt", locale));
        }
        for (int i = 0; i < INVALID_CHAR_ARRAY.length; ++i) {
            if (name.indexOf(INVALID_CHAR_ARRAY[i]) == -1) continue;
            throw new IllegalArgumentException(RBUtil.getStringResource("EntryNameIllegalChar.fmt.txt", (Object)name, locale));
        }
    }

    public static void validateName(String name, Locale locale) throws IllegalArgumentException {
        Entry.validateCacheName(name, locale);
        int nameLength = name.trim().length();
        if (nameLength > 60) {
            throw new IllegalArgumentException(RBUtil.getStringResource("EntryNameTooLong.fmt.txt", (Object)name, locale));
        }
    }

    protected static boolean isBlankString(String s) {
        return s == null || s.trim().length() == 0;
    }

    @Override
    public PathUrl getLocationUrl() throws RepositoryException {
        block6: {
            ++cacheTotal;
            if (this.myCachedPathUrl == null || myDisablePathCacheFlag) {
                try {
                    this.myCachedPathUrl = this.metadataObject.getPathUrl();
                    if (this.myCachedPathUrl == null) {
                        String name = this.metadataObject.getName();
                        if (name == null) {
                            name = "(null)";
                        }
                        throw new RepositoryNotFoundException(RBUtil.getStringResource("EntryNullPathUrl.fmt.txt", name));
                    }
                    break block6;
                }
                catch (ServiceException e) {
                    throw new RepositoryException(e, e.getMessage());
                }
                catch (RemoteException e) {
                    throw new RepositoryException(e, e.getMessage());
                }
            }
            ++cacheHit;
        }
        return this.myCachedPathUrl;
    }

    protected String getLocation() throws RepositoryException {
        if (this.myCachedPathUrlStr == null) {
            this.myCachedPathUrlStr = this.getLocationUrl().toString();
        }
        return this.myCachedPathUrlStr;
    }

    void invalidatePathUrl() {
        this.myCachedPathUrl = null;
        this.myCachedPathUrlStr = null;
    }

    @Override
    public Object getMetadataObject() {
        return this.metadataObject;
    }

    protected void setMetadataObject(Object metadataObject) {
        this.metadataObject = (MetadataInterface)metadataObject;
    }

    @Override
    public String getName() {
        String name = null;
        try {
            name = this.metadataObject.getName();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new UncheckedException((Throwable)e, e.getMessage());
        }
        if (name == null) {
            throw new UncheckedException(RB.getStringResource("EntryNameNullMetadata.txt"));
        }
        return name;
    }

    protected void setName(String name) throws RemoteException {
        this.metadataObject.setName(name);
    }

    protected void setPublicType(String name) throws RemoteException {
        String _reportType = RepositoryUtils.publicType(name);
        MetadataInterface omEntryObject = (MetadataInterface)this.getMetadataObject();
        Transformation jomaObj = (Transformation)omEntryObject.getRepositoryEntity();
        jomaObj.setPublicType(_reportType);
    }

    protected void setMetadataUpdated() throws RemoteException {
        MetadataInterface omEntryObject = (MetadataInterface)this.getMetadataObject();
        Object o = omEntryObject.getRepositoryEntity();
        if (o instanceof Transformation) {
            Transformation jomaObj = (Transformation)o;
            jomaObj.touch();
        }
    }

    public String getMetadataUpdated() throws RemoteException {
        MetadataInterface omEntryObject = (MetadataInterface)this.getMetadataObject();
        Object o = omEntryObject.getRepositoryEntity();
        if (o instanceof Transformation) {
            Transformation jomaObj = (Transformation)o;
            String _metadataUpdated = jomaObj.getMetadataUpdated();
            return _metadataUpdated;
        }
        return null;
    }

    protected String getNameWithType() throws RepositoryException {
        String sbipAddress = this.getLocation();
        return this.getNameWithType(sbipAddress);
    }

    protected String getNameWithType(String sbipAddress) {
        int firstCharAfterLastSlash = sbipAddress.lastIndexOf(47) + 1;
        return sbipAddress.substring(firstCharAfterLastSlash);
    }

    protected String getPathNameWithType(PathUrl pathUrl) throws RepositoryException {
        String nameWithType = this.getNameWithType(pathUrl.toString());
        String path = pathUrl.getPath();
        if (path == null) {
            return nameWithType;
        }
        return path + "/" + nameWithType;
    }

    protected String getPathName(PathUrl pathUrl) throws RepositoryException {
        String name = pathUrl.getName();
        String path = pathUrl.getPath();
        if (path == null) {
            return name;
        }
        return path + "/" + name;
    }

    protected String getAddressWithoutType() throws RepositoryException {
        PathUrl pathUrl = this.getLocationUrl();
        String addr = pathUrl.toString();
        String type = pathUrl.getType();
        if (type == null) {
            return addr;
        }
        int lastOpenParen = addr.lastIndexOf(40);
        return addr.substring(0, lastOpenParen);
    }

    @Override
    public int read(InputStream stream, byte[] b) throws RepositoryIOException {
        int len = 0;
        try {
            len = stream.read(b);
        }
        catch (IOException e) {
            throw new RepositoryIOException(e, e.getMessage());
        }
        return len;
    }

    @Override
    public int write(OutputStream stream, byte[] b, int len) throws RepositoryIOException {
        try {
            stream.write(b, 0, len);
        }
        catch (IOException e) {
            throw new RepositoryIOException(e, e.getMessage());
        }
        return len;
    }

    @Override
    public void close(OutputStream stream) throws RepositoryIOException {
        try {
            stream.close();
        }
        catch (IOException e) {
            throw new RepositoryIOException(e, e.getMessage());
        }
    }

    @Override
    public String toString() {
        String location;
        try {
            location = this.getLocation();
            if (location == null) {
                location = "null";
            }
        }
        catch (Exception e) {
            location = "*** " + e.toString() + " ***";
        }
        return location;
    }

    @Override
    public OutputStream getOutputStream() throws SecurityException, RepositoryIOException {
        return this.getOutputStream(true);
    }

    @Override
    public boolean canRead() throws SecurityException {
        MetadataInterface mdObj = (MetadataInterface)this.getMetadataObject();
        try {
            return mdObj.isAuthorized("ReadMetadata");
        }
        catch (ServiceException e) {
            log.error("OMREntryError.notrans", (Throwable)e);
            throw (SecurityException)new SecurityException(e.getMessage()).initCause(e);
        }
        catch (RemoteException e) {
            log.error("OMREntryError.notrans", (Throwable)e);
            throw (SecurityException)new SecurityException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public boolean canWrite() throws SecurityException {
        MetadataInterface mdObj = (MetadataInterface)this.getMetadataObject();
        try {
            boolean retVal = mdObj.isAuthorized("WriteMemberMetadata");
            return retVal;
        }
        catch (ServiceException e) {
            log.error("OMREntryError.notrans", (Throwable)e);
            throw (SecurityException)new SecurityException(e.getMessage()).initCause(e);
        }
        catch (RemoteException e) {
            log.error("OMREntryError.notrans", (Throwable)e);
            throw (SecurityException)new SecurityException(e.getMessage()).initCause(e);
        }
    }

    static {
        ArrayList<Character> invalidCharList = new ArrayList<Character>();
        invalidCharList.add(Character.valueOf('\\'));
        invalidCharList.add(Character.valueOf('/'));
        INVALID_CHAR_LIST = Collections.unmodifiableList(invalidCharList);
        INVALID_CHAR_ARRAY = new char[invalidCharList.size()];
        int i = 0;
        for (Character c : invalidCharList) {
            Entry.INVALID_CHAR_ARRAY[i++] = c.charValue();
        }
        myDisablePathCacheFlag = Boolean.getBoolean("report.repository.disablePathUrlCache");
        if (myDisablePathCacheFlag) {
            System.out.println("report.repository --> PathUrl caching is disabled");
        }
        log = LogManager.getLogger(Entry.class);
    }
}

