/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.OMRRepository;
import com.sas.report.repository.Repository;
import com.sas.report.repository.RepositoryFactory;
import com.sas.report.repository.StartPFS;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.util.ChainedException;

public class ContentSetupTool {
    public static void main(String[] args) {
        if (args.length != 7) {
            ContentSetupTool.printUsageAndExit();
        } else {
            String configFile = args[0];
            String repositoryName = args[1];
            String providerName = args[2];
            String providerLocation = args[3];
            String userId = args[4];
            String password = args[5];
            String domain = args[6];
            new ContentSetupTool(configFile, repositoryName, providerName, providerLocation, userId, password, domain);
        }
        System.exit(0);
    }

    private static void printUsageAndExit() {
        System.out.println("Usage:\n\tjava  com.sas.report.repository.ContentSetupTool configFile repositoryName providerName providerLocation userId password domain\n\nExample:\n\tjava com.sas.report.repository.ContentSetupTool c:\\BIReporting\\config\\sas_pfs_services_core.xml Hope \"BIP Tree\" http://bipsvr05.na.sas.com/repositoryContent/ omruser DemoDemo1 CARYNT");
        System.exit(-1);
    }

    public ContentSetupTool(String configFile, String repositoryName, String providerName, String providerLocation, String userId, String password, String domain) {
        try {
            System.out.println("Obtaining default software component...");
            String defaultComponent = StartPFS.getDefaultSoftwareComponentName();
            if (defaultComponent == null) {
                this.fail("StartPFS.getDefaultSoftwareComponentName() returned null");
            }
            System.out.println("Deploying platform services...");
            StartPFS.deployPlatformServices(configFile, defaultComponent);
            System.out.println("Logging in...  " + userId + " / " + password + " / " + domain);
            SessionContextInterface session = StartPFS.loginUser(userId, password, domain);
            if (session == null) {
                this.fail("StartPFS.loginUser(" + userId + ", " + password + ", " + domain + ") returned null");
            }
            System.out.println("Obtaining repository factory...");
            RepositoryFactory rf = new RepositoryFactory(session);
            if (rf == null) {
                this.fail("Unable to construct RepositoryFactory object.");
            }
            System.out.println("Obtaining repository '" + repositoryName + "'...");
            Repository r = rf.getRepository(repositoryName);
            if (r == null) {
                this.fail("Unable to access Repository " + repositoryName);
            }
            OMRRepository omrR = (OMRRepository)r;
            System.out.println("Assigning provider location...");
            omrR.addProvider(providerName, providerLocation);
            System.out.println("Operation successful.");
        }
        catch (Exception e) {
            System.err.println("----------- Fatal error: Outermost Exception ------------");
            e.printStackTrace();
            Throwable innermost = ChainedException.getRootException((Throwable)e);
            if (e != innermost) {
                System.err.println("----------- Innermost Exception -------------------------");
                innermost.printStackTrace();
            } else if (innermost instanceof UserInitializationException) {
                UserInitializationException uie = (UserInitializationException)innermost;
                Exception[] eArray = uie.getExceptions();
                for (int i = 0; i < eArray.length; ++i) {
                    System.err.println("----------- Inner Exception[" + i + "] -------------------------");
                    eArray[i].printStackTrace();
                }
            }
            System.err.println("---------------------------------------------------------");
            this.fail(e.getMessage());
        }
    }

    private void fail(String msg) {
        System.err.println("\nERROR\n" + msg + "\n...Exiting.");
        System.exit(-1);
    }
}

