/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.ContentAlreadyExistsException;
import com.sas.report.repository.ContentDirectoryException;
import com.sas.report.repository.ContentDirectoryHeaderEntry;
import com.sas.report.repository.ContentException;
import com.sas.report.repository.ContentFactory;
import com.sas.report.repository.ContentFileException;
import com.sas.report.repository.ContentInterface;
import com.sas.report.repository.ContentLockedException;
import com.sas.report.repository.ContentMalformedNameException;
import com.sas.report.repository.ContentNameNotFoundException;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.Path;
import com.sas.report.repository.RB;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.RepositoryException;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResource;
import com.sas.services.webdav.DavPropertyItem;
import com.sas.services.webdav.DavPropertyResult;
import com.sas.services.webdav.FileCleanup;
import com.sas.services.webdav.PropertyName;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ContentProviderDAV
implements ContentInterface {
    public static final String defaultUserID = "anonymous";
    public static final String defaultPassWD = "";
    private static final String DATE_FORMAT = RB.getStringResource("ContentProviderDAVdateFormat.notrans");
    protected static final String hostPathSeparator = "/";
    protected static final String colonSlashSlash = "://";
    private String myFullRootPath;
    private String myUserId;
    private String myPassword;
    private OMRID repositoryId;
    private static final Logger log = LogManager.getLogger(ContentProviderDAV.class);
    private boolean myIsCollectionFlag;
    private String myRelativePath;
    private String myPathPrefix;

    private static void checkStatus(DAVResource r) throws ContentNameNotFoundException, ContentException {
        String url;
        if (r == null) {
            String message = RBUtil.getStringResource("ContentProviderDAVnoDAV.txt");
            throw new ContentException(message);
        }
        int statusCode = 0;
        try {
            statusCode = r.getStatusCode();
        }
        catch (DAVException e) {
            throw new ContentException(e, RBUtil.getStringResource("ContentProviderDAVerrorOnStatus.txt", e.getMessage()));
        }
        catch (RemoteException e) {
            throw new ContentException(e, RBUtil.getStringResource("ContentProviderDAVerrorOnStatus.txt", e.getMessage()));
        }
        if (statusCode / 100 * 100 == 200) {
            return;
        }
        try {
            url = r.getURL().toString();
        }
        catch (Exception e) {
            url = defaultPassWD;
        }
        if (statusCode == 404) {
            String msg = RBUtil.getStringResource("ContentProviderDAVnoFound.txt", url);
            throw new ContentNameNotFoundException(msg);
        }
        String msg = RBUtil.getStringResource("ContentProviderDAVcontentError.txt", (Object)url, (Object)Integer.toString(statusCode), r.getStatusMessage());
        throw new ContentException(msg);
    }

    public ContentProviderDAV(OMRID omrid, String URI2, String userID, String passWD) throws ContentNameNotFoundException, ContentException, RepositoryException {
        this.repositoryId = omrid;
        if (userID.length() == 0) {
            userID = defaultUserID;
        }
        if (passWD.length() == 0) {
            passWD = defaultPassWD;
        }
        this.initialize(URI2, userID, passWD);
    }

    public String toString() {
        return "rootPath='" + this.myFullRootPath + ", relativePath='" + this.myRelativePath + "', userId='" + this.myUserId + "', pathSeparator='" + hostPathSeparator + "'";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initialize(String URI2, String userID, String passWD) throws ContentNameNotFoundException, ContentException {
        this.myFullRootPath = URI2;
        this.myUserId = userID;
        this.myPassword = passWD;
        String protocol = defaultPassWD;
        int idx = URI2.indexOf(58);
        if (idx > 0) {
            protocol = URI2.substring(0, idx);
        }
        if (!(protocol.equalsIgnoreCase("HTTP") || protocol.equalsIgnoreCase("HTTPS"))) {
            String msg = RBUtil.getStringResource("ContentProviderDAVbadName.txt", URI2);
            log.debug(msg);
            throw new ContentNameNotFoundException(msg);
        }
        DAVResource r = null;
        try {
            int doubleSlashes = URI2.indexOf("//");
            if (doubleSlashes < 0) {
                throw new ContentNameNotFoundException(RBUtil.getStringResource("ContentProviderDAVbadName.txt", URI2));
            }
            int firstSingleSlash = URI2.indexOf(47, doubleSlashes + 2);
            if (firstSingleSlash < 0) {
                throw new ContentNameNotFoundException(RBUtil.getStringResource("ContentProviderDAVbadName.txt", URI2));
            }
            this.myPathPrefix = URI2.substring(0, firstSingleSlash);
            this.myRelativePath = URI2.substring(firstSingleSlash);
            r = this.getDAVResource(defaultPassWD);
            r.setOverwrite(true);
            log.debug(RBUtil.getStringResource("ContentProviderDAVcreateDAV.notrans", Integer.toString(r.getStatusCode())));
            log.debug(RBUtil.getStringResource("ContentProviderDAVStatusMsg.notrans", r.getStatusMessage()));
            ContentProviderDAV.checkStatus(r);
            this.myIsCollectionFlag = r.isCollection();
            this.returnResource(r);
            return;
        }
        catch (ContentNameNotFoundException doubleSlashes) {
            return;
            catch (DAVException e) {
                throw new ContentException(e, e.getMessage());
                catch (RemoteException e2) {
                    throw new ContentException(e2, e2.getMessage());
                }
            }
        }
        finally {
            this.returnResource(r);
        }
    }

    private boolean isNewResourceNeeded(DAVResource resource) throws DAVException {
        if (resource == null || null == this.repositoryId.getContentBasePath()) {
            return true;
        }
        return this.myFullRootPath.startsWith(this.repositoryId.getContentBasePath());
    }

    private DAVResource getDAVResource(String pathSuffix) throws DAVException {
        DAVResource resource = (DAVResource)this.repositoryId.checkoutContentResource();
        if (this.isNewResourceNeeded(resource)) {
            String path = this.buildPath(this.myFullRootPath, pathSuffix);
            try {
                resource = new DAVResource(path, this.myUserId, this.myPassword);
            }
            catch (DAVException e) {
                Exception _e = e.getException();
                if (_e instanceof ConnectException) {
                    String msg;
                    try {
                        URL u = new URL(this.myFullRootPath);
                        msg = RBUtil.getStringResource("ContentProviderDAVconnectRefused1.txt", (Object)u.getHost(), Integer.toString(u.getPort()));
                    }
                    catch (MalformedURLException mue) {
                        msg = RBUtil.getStringResource("ContentProviderDAVconnectRefused2.txt", this.myFullRootPath);
                    }
                    throw new DAVException(msg, (Exception)((Object)e));
                }
                if (_e instanceof IOException) {
                    String msg;
                    try {
                        URL u = new URL(this.myFullRootPath);
                        msg = RBUtil.getStringResource("ContentProviderDAVconnectError1.txt", (Object)u.getHost(), Integer.toString(u.getPort()));
                    }
                    catch (MalformedURLException mue) {
                        msg = RBUtil.getStringResource("ContentProviderDAVconnectError2.txt", this.myFullRootPath);
                    }
                    throw new DAVException(msg, (Exception)((Object)e));
                }
                throw e;
            }
        }
        if (pathSuffix == null || pathSuffix.length() == 0) {
            String path = this.buildPath(this.myRelativePath, defaultPassWD);
            resource.setPath(path);
        } else {
            String path = this.buildPath(this.myRelativePath, pathSuffix);
            resource.setPath(path);
        }
        return resource;
    }

    @Override
    public String getRootPath() {
        return this.myFullRootPath;
    }

    @Override
    public String getPathSeparator() {
        return hostPathSeparator;
    }

    @Override
    public String getUserName(String userName) {
        return this.myUserId;
    }

    @Override
    public String getPassword(String password) {
        return this.myPassword;
    }

    @Override
    public ContentInterface getParent() throws ContentException, RepositoryException {
        String path = this.myFullRootPath;
        int idx = path.lastIndexOf(hostPathSeparator);
        if (idx == -1) {
            return null;
        }
        if (idx == path.length() - 1) {
            path = path.substring(0, idx);
            idx = path.lastIndexOf(hostPathSeparator);
        }
        if (idx == -1) {
            return null;
        }
        path = path.substring(0, idx + 1);
        ContentProviderDAV c = new ContentProviderDAV(this.repositoryId, path, this.myUserId, this.myPassword);
        return c;
    }

    @Override
    public String buildPath(String basePath, String subPath) {
        String s = basePath == null || basePath.length() == 0 ? (subPath == null ? null : new String(subPath)) : (subPath == null || subPath.length() == 0 ? new String(basePath) : (basePath.lastIndexOf(hostPathSeparator) == basePath.length() - 1 ? new String(basePath + subPath) : new String(basePath + hostPathSeparator + subPath)));
        log.debug(RBUtil.getStringResource("ContentProviderDAVBuildPath.notrans", s));
        ContentFactory.validateResolvedAddress(basePath, subPath, s);
        s = ContentProviderDAV.escapeChars(s);
        return s;
    }

    private static String escapeChars(String s) {
        log.debug("escapeChars(" + s.toString() + ")");
        int doubleSlashes = s.indexOf("//");
        if (doubleSlashes == -1) {
            doubleSlashes = -2;
        }
        int firstSingleSlash = s.indexOf(hostPathSeparator, doubleSlashes + 2);
        String p1 = defaultPassWD;
        String p2 = defaultPassWD;
        if (firstSingleSlash != -1) {
            p1 = s.substring(0, firstSingleSlash);
            p2 = s.substring(firstSingleSlash);
        } else {
            p2 = s;
        }
        p2 = p2.replace(':', '\uf03a');
        p2 = p2.replace('\u3000', '\uf020');
        p2 = p2.replace('|', '\uf07c');
        return p1 + p2;
    }

    @Override
    public void createDirectory(String newDirectoryName) throws ContentNameNotFoundException, ContentException {
        DAVResource r = null;
        try {
            r = this.getDAVResource(newDirectoryName);
            r.makeCollection();
            log.debug(RBUtil.getStringResource("ContentProviderDAVcreateDir.notrans", (Object)r.getPath(), Integer.toString(r.getStatusCode())));
            log.debug(RBUtil.getStringResource("ContentProviderDAVStatusMsg.notrans", r.getStatusMessage()));
            ContentProviderDAV.checkStatus(r);
        }
        catch (DAVException e) {
            throw new ContentException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new ContentException(e, e.getMessage());
        }
        finally {
            this.returnResource(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDirectory(String directoryName) {
        if (directoryName.length() == 0) {
            return this.myIsCollectionFlag;
        }
        String fullPath = this.buildPath(this.myFullRootPath, directoryName);
        DAVResource r = null;
        try {
            r = this.getDAVResource(directoryName);
            ContentProviderDAV.checkStatus(r);
            boolean b = r.isCollection();
            log.debug(RBUtil.getStringResource("ContentProviderDAVIsDir.notrans", (Object)fullPath, String.valueOf(b)));
            boolean bl = b;
            return bl;
        }
        catch (DAVException e) {
            boolean bl = false;
            return bl;
        }
        catch (Exception ee) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.returnResource(r);
        }
    }

    @Override
    public void lock(String name) throws ContentException {
        String fullPath = this.buildPath(this.myFullRootPath, name);
        DAVResource r = null;
        try {
            r = this.getDAVResource(name);
            r.lock();
        }
        catch (DAVException e) {
            if (e.getStatusCode() == 404) {
                throw new ContentNameNotFoundException();
            }
            if (e.getStatusCode() == 423) {
                throw new ContentLockedException(e, e.getMessage());
            }
            throw new ContentException(e, e.getMessage());
        }
        catch (Exception e) {
            throw new ContentException(e, e.getMessage());
        }
        finally {
            this.returnResource(r);
        }
    }

    @Override
    public void unlock(String name) throws ContentException {
        String fullPath = this.buildPath(this.myFullRootPath, name);
        DAVResource r = null;
        try {
            r = this.getDAVResource(name);
            r.unlock();
        }
        catch (DAVException e) {
            if (e.getStatusCode() == 404) {
                throw new ContentNameNotFoundException();
            }
            if (e.getStatusCode() == 423) {
                throw new ContentLockedException(e, e.getMessage());
            }
            throw new ContentException(e, e.getMessage());
        }
        catch (Exception e) {
            throw new ContentException(e, e.getMessage());
        }
        finally {
            this.returnResource(r);
        }
    }

    @Override
    public boolean exists(String name) throws ContentException {
        String fullPath = this.buildPath(this.myFullRootPath, name);
        DAVResource r = null;
        try {
            r = this.getDAVResource(name);
            ContentProviderDAV.checkStatus(r);
            log.debug(RBUtil.getStringResource("ContentProviderDAVExists.notrans", (Object)fullPath, "true"));
            boolean bl = true;
            return bl;
        }
        catch (ContentNameNotFoundException ce) {
            log.debug(RBUtil.getStringResource("ContentProviderDAVExists.notrans", (Object)fullPath, "false"));
            boolean bl = false;
            return bl;
        }
        catch (DAVException e) {
            throw new ContentException(e, e.getMessage());
        }
        catch (Exception e) {
            throw new ContentException(e, e.getMessage());
        }
        finally {
            this.returnResource(r);
        }
    }

    @Override
    public List list(String directoryName) throws ContentNameNotFoundException, ContentException, ContentDirectoryException {
        DAVDirectoryListing dirListing;
        String fullPath = this.buildPath(this.myFullRootPath, directoryName);
        log.debug(RBUtil.getStringResource("ContentProviderDAVList.notrans", fullPath));
        DAVResource r = null;
        try {
            r = this.getDAVResource(directoryName);
            ContentProviderDAV.checkStatus(r);
            if (!r.isCollection()) {
                throw new ContentDirectoryException(RBUtil.getStringResource("ContentProviderDAVNotDir.txt", fullPath));
            }
            String s = r.getContents().toString();
            log.debug(RBUtil.getStringResource("ContentProviderDAVContents.notrans", s));
            dirListing = new DAVDirectoryListing(s);
        }
        catch (DAVException e) {
            throw new ContentException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new ContentException(e, e.getMessage());
        }
        finally {
            this.returnResource(r);
        }
        List l = dirListing.getEntries();
        if (log.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < l.size(); ++i) {
                ContentDirectoryHeaderEntry entry = (ContentDirectoryHeaderEntry)l.get(i);
                buf.append("\n\t");
                buf.append(entry.getName());
            }
            log.debug(RBUtil.getStringResource("ContentProviderDAVDirList.notrans", (Object)Integer.toString(l.size()), buf.toString()));
        }
        return l;
    }

    @Override
    public void deleteTree(String fileName) throws ContentNameNotFoundException, ContentException {
        this.deleteIt(fileName, Integer.MAX_VALUE);
    }

    @Override
    public void delete(String fileName) throws ContentNameNotFoundException, ContentException {
        this.deleteIt(fileName, 0);
    }

    /*
     * Exception decompiling
     */
    @Override
    public OutputStream add(String fileName) throws ContentFileException, ContentException, ContentAlreadyExistsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream get(String fileName) throws ContentFileException, ContentNameNotFoundException, ContentException {
        String fullPath = this.buildPath(this.myFullRootPath, fileName);
        log.debug(RBUtil.getStringResource("ContentProviderDAVGet.notrans", fullPath));
        DAVResource r = null;
        try {
            InputStream i;
            try {
                r = this.getDAVResource(fileName);
            }
            catch (DAVException e) {
                throw new ContentException(e, e.getMessage());
            }
            try {
                i = r.getContentsInputStream();
            }
            catch (DAVException e) {
                throw new ContentException(e, e.getMessage());
            }
            catch (RemoteException e) {
                throw new ContentException(e, e.getMessage());
            }
            InputStream inputStream = i;
            return inputStream;
        }
        finally {
            this.returnResource(r);
        }
    }

    private void returnResource(DAVResource r) {
        DAVResource oldRes;
        if (r != null && (oldRes = (DAVResource)this.repositoryId.checkinContentResource(r)) != null) {
            try {
                oldRes.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public OutputStream update(String fileName) throws ContentFileException, ContentNameNotFoundException, ContentException {
        String fullPath = this.buildPath(this.myFullRootPath, fileName);
        log.debug(RBUtil.getStringResource("ContentProviderDAVUpdate.notrans", fullPath));
        DAVResource r = null;
        try {
            OutputStream ds;
            r = this.getDAVResource(fileName);
            ContentProviderDAV.checkStatus(r);
            if (r.isCollection()) {
                throw new ContentFileException(RBUtil.getStringResource("ContentProviderDAVnameIsDir.txt", fullPath));
            }
            OutputStream outputStream = ds = new DAVFile(fileName).getOutputStream();
            return outputStream;
        }
        catch (DAVException e) {
            if (e.getStatusCode() == 423) {
                throw new ContentLockedException(e, e.getMessage());
            }
            throw new ContentException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new ContentException(e, e.getMessage());
        }
        finally {
            this.returnResource(r);
        }
    }

    @Override
    public OutputStream write(String fileName) throws ContentFileException, ContentNameNotFoundException, ContentException {
        try {
            OutputStream ds = new DAVFile(fileName).getOutputStream();
            if (ds == null) {
                throw new ContentException(RBUtil.getStringResource("ContentProviderDAVnoTempLoc.txt"));
            }
            return ds;
        }
        catch (Exception e) {
            throw new ContentException(e, e.getMessage());
        }
    }

    @Override
    public void renameTo(String oldName, String newName) throws ContentMalformedNameException, ContentNameNotFoundException, ContentException {
        int index;
        URL u;
        if (oldName.length() == 0 || newName.length() == 0) {
            throw new ContentMalformedNameException(RBUtil.getStringResource("ContentProviderDAVemptyPath.txt"));
        }
        String oldPath = this.buildPath(this.myFullRootPath, oldName);
        String newPath = this.buildPath(this.myFullRootPath, newName);
        String oldSubPath = defaultPassWD;
        String newSubPath = defaultPassWD;
        String newBaseName = defaultPassWD;
        try {
            u = new URL(oldPath);
            oldSubPath = this.getContentRelativePath(oldPath);
            index = oldSubPath.lastIndexOf(hostPathSeparator);
            oldSubPath = index >= 0 ? oldSubPath.substring(0, index) : defaultPassWD;
        }
        catch (MalformedURLException e) {
            throw new ContentMalformedNameException(e, RBUtil.getStringResource("ContentProviderDAVbadRename.txt", e.getMessage()));
        }
        try {
            u = new URL(newPath);
            newSubPath = this.getContentRelativePath(newPath);
            index = newSubPath.lastIndexOf(hostPathSeparator);
            newBaseName = newSubPath.substring(index);
            newSubPath = newSubPath.substring(0, index);
        }
        catch (MalformedURLException e) {
            throw new ContentMalformedNameException(e, RBUtil.getStringResource("ContentProviderDAVbadRename.txt", e.getMessage()));
        }
        if (newSubPath.compareTo(oldSubPath) != 0) {
            throw new ContentMalformedNameException(RBUtil.getStringResource("ContentProviderDAVbadMove.txt", (Object)oldPath, newPath));
        }
        log.debug(RBUtil.getStringResource("ContentProviderDAVRenameTo.notrans", (Object)oldPath, oldSubPath + newBaseName));
        DAVResource r = null;
        try {
            r = this.getDAVResource(oldName);
            r.move(oldSubPath + newBaseName);
            ContentProviderDAV.checkStatus(r);
        }
        catch (DAVException e) {
            throw new ContentException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new ContentException(e, e.getMessage());
        }
        finally {
            this.returnResource(r);
        }
    }

    @Override
    public void moveTo(String srcName, String destName) throws ContentNameNotFoundException, ContentException {
        this.moveTo(srcName, this, destName);
    }

    @Override
    public void moveTo(String srcName, ContentInterface dest, String destName) throws ContentNameNotFoundException, ContentException {
        block15: {
            log.debug(RBUtil.getStringResource("ContentProviderDAVMoveTo.notrans", (Object)srcName, destName));
            if (!this.isSameServer(this, dest)) {
                throw new ContentException(RBUtil.getStringResource("ContentProviderDAVerrorMove.txt", "MoveAcrossServersNotSupportedException"));
            }
            if (srcName == null || srcName.length() == 0) {
                throw new ContentMalformedNameException(RBUtil.getStringResource("ContentProviderDAVNoSource.txt"));
            }
            String srcPath = this.buildPath(this.myFullRootPath, srcName);
            String destPath = this.buildPath(dest.getRootPath(), destName);
            log.debug(RBUtil.getStringResource("ContentProviderDAVMoveTo.notrans", (Object)srcPath, destPath));
            String destSubPath = null;
            try {
                URL u = new URL(destPath);
                destSubPath = this.getContentRelativePath(destPath);
            }
            catch (MalformedURLException e) {
                throw new ContentMalformedNameException(e, RBUtil.getStringResource("ContentProviderDAVerrorMove.txt", e.getMessage()));
            }
            DAVResource r = null;
            try {
                r = this.getDAVResource(srcName);
                r.move(destSubPath);
                ContentProviderDAV.checkStatus(r);
            }
            catch (DAVException e) {
                if (e.getStatusCode() == 409) {
                    try {
                        String savedPath = r.getPath();
                        r.setPath(destSubPath);
                        this.createIntermediateCollections(r);
                        r.setPath(savedPath);
                        r.move(destSubPath);
                        ContentProviderDAV.checkStatus(r);
                        break block15;
                    }
                    catch (RemoteException e2) {
                        throw new ContentException(e2, e2.getMessage());
                    }
                    catch (DAVException e2) {
                        throw new ContentException(e2, e2.getMessage());
                    }
                }
                throw new ContentException(e, e.getMessage());
            }
            catch (RemoteException e) {
                throw new ContentException(e, e.getMessage());
            }
            finally {
                this.returnResource(r);
            }
        }
    }

    @Override
    public void copyTo(String srcName, String destName) throws ContentNameNotFoundException, ContentException {
        this.copyTo(srcName, this, destName);
    }

    @Override
    public void copyTo(String srcName, ContentInterface dest, String destName) throws ContentNameNotFoundException, ContentException {
        block15: {
            log.debug(RBUtil.getStringResource("ContentProviderDAVCopyTo.notrans", (Object)srcName, destName));
            if (!this.isSameServer(this, dest)) {
                throw new ContentException(RBUtil.getStringResource("ContentProviderDAVbadCopy.txt", "CopyAcrossServersNotSupportedException"));
            }
            if (srcName == null || srcName.length() == 0) {
                throw new ContentMalformedNameException(RBUtil.getStringResource("ContentProviderDAVNoSource.txt"));
            }
            String srcPath = this.buildPath(this.myFullRootPath, srcName);
            String destPath = this.buildPath(dest.getRootPath(), destName);
            log.debug(RBUtil.getStringResource("ContentProviderDAVCopyTo.notrans", (Object)srcPath, destPath));
            String destSubPath = null;
            try {
                URL u = new URL(destPath);
                destSubPath = this.getContentRelativePath(destPath);
            }
            catch (MalformedURLException e) {
                throw new ContentMalformedNameException(e, RBUtil.getStringResource("ContentProviderDAVbadCopy.txt", e.getMessage()));
            }
            DAVResource r = null;
            try {
                r = this.getDAVResource(srcName);
                r.copy(destSubPath);
                ContentProviderDAV.checkStatus(r);
            }
            catch (DAVException e) {
                if (e.getStatusCode() == 409) {
                    try {
                        String savedPath = r.getPath();
                        r.setPath(destSubPath);
                        this.createIntermediateCollections(r);
                        r.setPath(savedPath);
                        r.copy(destSubPath);
                        ContentProviderDAV.checkStatus(r);
                        break block15;
                    }
                    catch (RemoteException e2) {
                        throw new ContentException(e2, e2.getMessage());
                    }
                    catch (DAVException e2) {
                        throw new ContentException(e2, e2.getMessage());
                    }
                }
                throw new ContentException(e, e.getMessage());
            }
            catch (RemoteException e) {
                throw new ContentException(e, e.getMessage());
            }
            finally {
                this.returnResource(r);
            }
        }
    }

    private void deleteIt(String name, int depthSupport) throws ContentNameNotFoundException, ContentFileException, ContentException {
        DAVResource r = null;
        try {
            int statusCode = 0;
            r = this.getDAVResource(name);
            try {
                r.delete();
            }
            catch (RemoteException e) {
                throw new ContentException(e, e.getMessage());
            }
            log.debug(RBUtil.getStringResource("ContentProviderDAVDeleteIt.notrans", (Object)name, Integer.toString(statusCode)));
            log.debug(RBUtil.getStringResource("ContentProviderDAVStatusMsg.notrans", r.getStatusMessage()));
            ContentProviderDAV.checkStatus(r);
            this.returnResource(r);
        }
        catch (DAVException e) {
            try {
                if (e.getStatusCode() == 423) {
                    throw new ContentLockedException(e, e.getMessage());
                }
                throw new ContentException(e, e.getMessage());
            }
            catch (Throwable throwable) {
                this.returnResource(r);
                throw throwable;
            }
        }
    }

    @Override
    public long getSizeInBytes(String name) throws ContentException {
        long contentLength;
        block9: {
            contentLength = 0L;
            DAVResource r = null;
            try {
                r = this.getDAVResource(name);
                DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
                davPropertyNameSet.add(DavPropertyName.GETCONTENTLENGTH);
                DavPropertyResult davPropertyResult = r.getDavProperties(davPropertyNameSet, r.getDepth());
                ContentProviderDAV.checkStatus(r);
                int statusCode = r.getStatusCode();
                if (207 != statusCode) break block9;
                for (DavPropertyItem davPropertyItem : davPropertyResult.getDavProperties()) {
                    DavProperty davProperty = davPropertyItem.getDavProperty();
                    DavPropertyName davPropertyName = davProperty.getName();
                    if (null == davPropertyName) continue;
                    Object value = davProperty.getValue();
                    String contentLengthString = null == value ? defaultPassWD : value.toString();
                    contentLength = Long.parseLong(contentLengthString);
                    break;
                }
            }
            catch (ContentNameNotFoundException davPropertyNameSet) {
            }
            catch (DAVException e) {
                throw new ContentException(e, e.getMessage());
            }
            catch (Exception e) {
                throw new ContentException(e, e.getMessage());
            }
            finally {
                this.returnResource(r);
            }
        }
        return contentLength;
    }

    @Override
    public void close() {
        DAVResource r = (DAVResource)this.repositoryId.checkoutContentResource();
        if (r != null) {
            try {
                r.close();
            }
            catch (Exception e) {
                log.warn("closeFailed.txt", (Throwable)e);
            }
            this.repositoryId.checkinContentResource(null);
        }
    }

    private void createIntermediateCollections(DAVResource r) throws RemoteException, DAVException {
        Path _path;
        Path path = new Path(r.getPath());
        int i = path.getNumSegments();
        do {
            _path = new Path(path, --i);
            r.setPath(_path.toString());
        } while (r.getStatusCode() == 404 && i > 0);
        ++i;
        while (i < path.getNumSegments()) {
            _path = new Path(path, i++);
            r.setPath(_path.toString());
            r.makeCollection();
        }
    }

    private boolean isSameServer(ContentInterface c1, ContentInterface c2) {
        if (c1 == null || c2 == null) {
            return false;
        }
        String u1 = c1.getRootPath();
        String u2 = c2.getRootPath();
        String s1 = null;
        String s2 = null;
        int p = u1.indexOf(colonSlashSlash);
        if (p != -1 && (p = u1.indexOf(hostPathSeparator, p + 3)) != -1) {
            s1 = u1.substring(0, p);
        }
        if ((p = u2.indexOf(colonSlashSlash)) != -1 && (p = u2.indexOf(hostPathSeparator, p + 3)) != -1) {
            s2 = u2.substring(0, p);
        }
        return s1 != null && s2 != null && s1.equals(s2);
    }

    @Override
    public Map getAttributes(String name) throws ContentException {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        DAVResource r = null;
        try {
            r = this.getDAVResource(name);
            DavPropertyResult davPropertyResult = r.getDavProperties();
            ContentProviderDAV.checkStatus(r);
            for (DavPropertyItem davPropertyItem : davPropertyResult.getDavProperties()) {
                DavProperty davProperty = davPropertyItem.getDavProperty();
                Object o = davProperty.getValue();
                String value = defaultPassWD;
                if (null != o) {
                    value = o instanceof String ? (String)o : o.toString();
                }
                PropertyName propertyName = new PropertyName(davProperty);
                attrMap.put(propertyName.toPropertyNameString(), value);
            }
        }
        catch (ContentNameNotFoundException e) {
            throw new ContentException((Throwable)((Object)e), e.getMessage());
        }
        catch (DAVException e) {
            throw new ContentException(e, e.getMessage());
        }
        catch (Exception e) {
            throw new ContentException(e, e.getMessage());
        }
        finally {
            this.returnResource(r);
        }
        return attrMap;
    }

    @Override
    public void setAttributes(String name, Map attrMap) throws ContentException {
        DAVResource r = null;
        ArrayList<PropertyName> pns = new ArrayList<PropertyName>();
        ArrayList pvs = new ArrayList();
        try {
            r = this.getDAVResource(name);
            for (Map.Entry me : attrMap.entrySet()) {
                pns.add(new PropertyName((String)me.getKey()));
                pvs.add(me.getValue());
            }
            r.setProperties(pns.toArray(new PropertyName[0]), pvs.toArray(new String[0]));
            ContentProviderDAV.checkStatus(r);
        }
        catch (ContentNameNotFoundException ce) {
            throw new ContentException((Throwable)((Object)ce), ce.getMessage());
        }
        catch (DAVException e) {
            if (e.getStatusCode() == 423) {
                throw new ContentLockedException(e, e.getMessage());
            }
            throw new ContentException(e, e.getMessage());
        }
        catch (Exception e) {
            throw new ContentException(e, e.getMessage());
        }
        finally {
            this.returnResource(r);
        }
    }

    @Override
    public String getAttribute(String name, String attrName) throws ContentException {
        String value = null;
        DAVResource r = null;
        try {
            DavPropertyItem davPropertyItem;
            DavProperty davProperty;
            Object o;
            r = this.getDAVResource(name);
            DavPropertyResult davPropertyResult = r.getDavProperties(new PropertyName[]{new PropertyName(attrName)});
            ContentProviderDAV.checkStatus(r);
            List davPropertyItems = davPropertyResult.getDavProperties();
            if (1 == davPropertyItems.size() && null != (o = (davProperty = (davPropertyItem = (DavPropertyItem)davPropertyItems.get(0)).getDavProperty()).getValue())) {
                value = o instanceof String ? (String)o : o.toString();
            }
        }
        catch (ContentNameNotFoundException e) {
            throw new ContentException((Throwable)((Object)e), e.getMessage());
        }
        catch (DAVException e) {
            throw new ContentException(e, e.getMessage());
        }
        catch (Exception e) {
            throw new ContentException(e, e.getMessage());
        }
        finally {
            this.returnResource(r);
        }
        return value;
    }

    @Override
    public void setAttribute(String name, String attrName, String attrValue) throws ContentException {
        DAVResource r = null;
        try {
            r = this.getDAVResource(name);
            r.setProperty(new PropertyName(attrName), attrValue);
            ContentProviderDAV.checkStatus(r);
        }
        catch (ContentNameNotFoundException ce) {
            throw new ContentException((Throwable)((Object)ce), ce.getMessage());
        }
        catch (DAVException e) {
            if (e.getStatusCode() == 423) {
                throw new ContentLockedException(e, e.getMessage());
            }
            throw new ContentException(e, e.getMessage());
        }
        catch (Exception e) {
            throw new ContentException(e, e.getMessage());
        }
        finally {
            this.returnResource(r);
        }
    }

    private String getContentRelativePath(String contentAbsolutePath) {
        String contentAbsoluteSubPath = defaultPassWD;
        int index = contentAbsolutePath.indexOf(colonSlashSlash);
        index += colonSlashSlash.length();
        if ((index = contentAbsolutePath.indexOf(hostPathSeparator, index)) >= 0) {
            contentAbsoluteSubPath = contentAbsolutePath.substring(index);
        }
        return contentAbsoluteSubPath;
    }

    private class DAVFile {
        private String _path;
        private File _file;

        public DAVFile(String path) {
            if (path == null) {
                throw new IllegalArgumentException(RBUtil.getStringResource("ContentProviderDAVResourceNull.txt"));
            }
            this._path = path;
            this._file = FileCleanup.getInstance().newTemporaryFile(1);
        }

        public OutputStream getOutputStream() {
            DAVFileOutputStream os = null;
            if (this._file != null) {
                try {
                    os = new DAVFileOutputStream(this._file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            return os;
        }

        private class DAVFileOutputStream
        extends FileOutputStream {
            private File _file;

            public DAVFileOutputStream(File f) throws FileNotFoundException {
                super(f);
                this._file = f;
            }

            @Override
            public void close() throws IOException {
                block26: {
                    super.close();
                    if (this._file == null) {
                        return;
                    }
                    DAVResource r = null;
                    FileInputStream fin = null;
                    try {
                        r = ContentProviderDAV.this.getDAVResource(DAVFile.this._path);
                        fin = new FileInputStream(this._file);
                        r.setContents((InputStream)fin);
                        ContentProviderDAV.checkStatus(r);
                    }
                    catch (DAVException e) {
                        if (e.getStatusCode() == 409) {
                            try {
                                String savedPath = r.getPath();
                                ContentProviderDAV.this.createIntermediateCollections(r);
                                r.setPath(savedPath);
                                try {
                                    fin.close();
                                }
                                catch (IOException ioe) {
                                    log.warn("closeFailed.txt", (Throwable)ioe);
                                }
                                fin = new FileInputStream(this._file);
                                r.setContents((InputStream)fin);
                                ContentProviderDAV.checkStatus(r);
                                break block26;
                            }
                            catch (Exception e2) {
                                throw (IOException)new IOException(e.getMessage()).initCause(e);
                            }
                        }
                        throw (IOException)new IOException(e.getMessage()).initCause(e);
                    }
                    catch (Exception e) {
                        throw (IOException)new IOException(e.getMessage()).initCause(e);
                    }
                    finally {
                        if (fin != null) {
                            try {
                                fin.close();
                            }
                            catch (IOException ioe) {
                                log.warn("closeFailed.txt", (Throwable)ioe);
                            }
                        }
                        ContentProviderDAV.this.returnResource(r);
                        DAVFile.this._path = null;
                        try {
                            this._file.delete();
                        }
                        catch (Exception e) {
                            log.warn("closeFailed.txt", (Throwable)e);
                        }
                        this._file = null;
                    }
                }
            }

            protected void finalize() throws IOException {
                try {
                    this.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    super.finalize();
                }
            }
        }
    }

    private class DAVDirectoryListing {
        private ArrayList entries = new ArrayList();
        private static final short NO_ENTRY = 0;
        private static final short DIRECTORY_ENTRY = 1;
        private static final short FILE_ENTRY = 2;
        private static final short SEEN_A = 4;

        public DAVDirectoryListing(String HTMLDirContents) throws ContentException {
            if (HTMLDirContents != null) {
                this.parse(HTMLDirContents);
            }
        }

        public List getEntries() {
            return this.entries;
        }

        protected void parse(String HTMLDirContents) throws ContentException {
            CharArrayReader reader = new CharArrayReader(HTMLDirContents.toCharArray());
            try {
                new ParserDelegator().parse(reader, new CallbackHandler(), true);
            }
            catch (Exception e) {
                throw new ContentException(e, e.getMessage());
            }
        }

        private class DAVDirectoryEntry
        extends ContentDirectoryHeaderEntry {
            private DAVDirectoryEntry() {
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setType(int type) {
                this.type = type;
            }

            public void setSize(long size) {
                this.size = size;
            }

            public void setLastModifiedDate(Date lastModifiedDate) {
                this.lastModifiedDate = lastModifiedDate;
            }

            public void setDescription(String description) {
                this.description = description;
            }
        }

        private class CallbackHandler
        extends HTMLEditorKit.ParserCallback {
            private short state;
            private DAVDirectoryEntry lastEntry = null;

            @Override
            public void handleText(char[] data, int pos) {
                String theData = new String(data);
                if (theData.length() == 0) {
                    return;
                }
                switch (this.state) {
                    case 0: {
                        break;
                    }
                    case 6: {
                        this.state = 0;
                        this.parseFields(theData, this.lastEntry);
                        break;
                    }
                    case 5: {
                        this.state = 0;
                        this.parseFields(theData, this.lastEntry);
                        break;
                    }
                }
            }

            @Override
            public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (t == HTML.Tag.A) {
                    String strHREF = (String)a.getAttribute(HTML.Attribute.HREF);
                    if (strHREF.charAt(0) == '/') {
                        this.state = 0;
                    } else if ((this.state & 1) > 0) {
                        this.lastEntry = new DAVDirectoryEntry();
                        this.lastEntry.setName(new String(strHREF));
                        this.lastEntry.setType(1);
                    } else if ((this.state & 2) > 0) {
                        this.lastEntry = new DAVDirectoryEntry();
                        this.lastEntry.setName(new String(strHREF));
                        this.lastEntry.setType(2);
                    }
                }
            }

            @Override
            public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                String strType;
                if (t == HTML.Tag.IMG && (strType = (String)a.getAttribute(HTML.Attribute.ALT)).compareToIgnoreCase("     ") != 0) {
                    this.state = strType.compareToIgnoreCase("[DIR]") == 0 ? (short)1 : (short)2;
                }
            }

            @Override
            public void handleEndTag(HTML.Tag t, int pos) {
                if (t == HTML.Tag.A && ((this.state & 1) > 0 || (this.state & 2) > 0)) {
                    this.state = (short)(this.state + 4);
                    DAVDirectoryListing.this.entries.add(this.lastEntry);
                }
            }

            private void skipWhite(String theData, ParsePosition parsePos) {
                int length = theData.length();
                int index = parsePos.getIndex();
                char ch = theData.charAt(index);
                while (index < length && (ch == ' ' || ch == '\n' || ch == '\r')) {
                    parsePos.setIndex(++index);
                    if (index >= length) continue;
                    ch = theData.charAt(index);
                }
            }

            private void parseFields(String theData, DAVDirectoryEntry entry) {
                char ch;
                SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
                ParsePosition parsePos = new ParsePosition(0);
                Date d = df.parse(theData, parsePos);
                entry.setLastModifiedDate(d);
                DecimalFormat nf = new DecimalFormat();
                this.skipWhite(theData, parsePos);
                long n = 0L;
                try {
                    Number num = nf.parse(theData, parsePos);
                    if (num != null) {
                        n = num.longValue();
                    }
                }
                catch (Exception ee) {
                    log.error("parseFail.txt", (Throwable)ee);
                }
                entry.setSize(n);
                int index = parsePos.getIndex();
                if (index < theData.length() && ((ch = theData.charAt(index)) == 'k' || ch == '-')) {
                    parsePos.setIndex(index + 1);
                }
                this.skipWhite(theData, parsePos);
                index = parsePos.getIndex();
                if (index < theData.length()) {
                    String description = theData.substring(index);
                    entry.setDescription(description);
                }
            }
        }
    }
}

