/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ContentHelper {
    protected static final String XML_FILE_PREFIX = "<?xml version=\"";
    protected static final String SBIP_URL_PREFIX = "\"SBIP://";
    protected static final String SBIP_URL_SUFFIX = "\"";
    protected static final String SBIP_URL_REGEX = "SBIP://|sbip://";
    public static final String UTF8 = "UTF-8";
    private static final int BUFFER_SIZE = 4096;
    private static final Logger log = LogManager.getLogger(ContentHelper.class);
    protected byte[] _dataBuffer = new byte[4096];
    protected List _tempFiles = new ArrayList();
    protected String _reposSASOlapServer = null;
    protected String _reposSASWorkspaceServer = null;
    protected String _reposOlapSchema = null;
    protected String _reposCube = null;
    protected String _reposSASLibraryName = null;
    protected String _reposSASLibrarySchemaName = null;
    protected String _reposTable = null;

    public ContentHelper() {
        log.debug("Entering ContentHelper class");
    }

    public static String getDestinationPath() throws IOException {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir == null) {
            File f = File.createTempFile("tmp", ".tmp");
            tmpDir = f.getParent();
            f.delete();
        }
        return tmpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map retrieveMapOfSbipAndAbsolutePathUrl(InputStream is) throws IOException {
        try {
            XMLReader r = XMLReaderFactory.createXMLReader();
            FindReportLocalizableItems cHandler = new FindReportLocalizableItems(true);
            r.setContentHandler(cHandler);
            r.setErrorHandler(new QuietErrorHandler());
            r.parse(new InputSource(is));
            Map map = cHandler.getMap();
            return map;
        }
        catch (Exception e) {
            log.debug(e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map retrieveMapOfLocalizableItems(InputStream is) throws IOException {
        try {
            XMLReader r = XMLReaderFactory.createXMLReader();
            FindReportLocalizableItems cHandler = new FindReportLocalizableItems();
            r.setContentHandler(cHandler);
            r.setErrorHandler(new QuietErrorHandler());
            r.parse(new InputSource(is));
            Map map = cHandler.getMap();
            return map;
        }
        catch (Exception e) {
            log.debug(e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new LinkedHashMap();
    }

    class FindReportLocalizableItems
    implements ContentHandler {
        private Map _localizableMap = new LinkedHashMap();
        private String _xpath = "";
        private String _xpathEZ = "";
        private String _xpathEZwithAttr;
        private Stack stack = new Stack();
        private Map env = new HashMap();
        private Map _spanSubElementMap = new LinkedHashMap();
        private int _tokenCount = 0;
        private int _spanDepth = 0;
        private boolean _isTextNode = false;
        private boolean _isSpanTextNode = false;
        private boolean _filterURL = false;
        private boolean _spanMode = false;
        private boolean _collectText = true;
        private final String[] textNodes = new String[]{"ActionValue", "Caption", "ContextValue", "CSV", "Label", "Note", "Property", "Span", "URLValue", "Value", "ViewElement"};
        private final String[] textMultipleNodes = new String[]{"Graph/Titles/Title", "Graph/Footnotes/Footnote"};
        private final String[] textExcludeMultipleNodes = new String[]{"Format/Mapping/Label"};
        private final String[] nameAttrs = new String[]{"ActionValue", "Caption", "Column", "ContextValue", "CSV", "Label", "Note", "PromptValue", "Property", "RowGroup", "SASReport", "Span", "URLValue", "Value", "ViewElement"};
        private final String[] labelAttrs = new String[]{"AbstractAction", "ByGroupSection", "Container", "DataItem", "DataItemReference", "DataItemReferenceUse", "DataItemUse", "Dimension", "Hierarchy", "IQData", "Level", "Member", "Property", "SASProcessContainer", "SASProcessSection", "Scheme", "Section", "Variable"};
        private final String[] locationAttrs = new String[]{"InformationMap/absolutePathLocation", "InformationMap/location", "Image/file", "Graph/altImage", "SASProcessSection/file", "SASProcessContainer/file", "BusinessModelReferenceInformation/locationJSFStoredProcess/absolutePathLocation", "ReposSASOlapServer/name", "ReposOlapSchema/name", "ReposCube/name", "ReposWorkspaceServer/name", "ReposSASLibrary/name", "ReposSASLibrary/name", "ReposTable/name"};
        private final String[] textlocation = new String[]{"URLValue"};
        private final String span = "Span";
        CharArrayWriter text = new CharArrayWriter();

        public FindReportLocalizableItems(boolean filterURL) {
            this._filterURL = filterURL;
        }

        public FindReportLocalizableItems() {
            this._spanSubElementMap.put("PromptValue", "PV");
            this._spanSubElementMap.put("PageNumber", "PN");
            this._spanSubElementMap.put("ReportValue", "RV");
            this._spanSubElementMap.put("NBSP", "NB");
            this._spanSubElementMap.put("Span", "SP");
            this._spanSubElementMap.put("Expression", "EX");
            this._spanSubElementMap.put("Date", "DT");
        }

        public Map getMap() throws IOException {
            return this._localizableMap;
        }

        private void completeTextNode() throws SAXException {
            if (!this._spanMode) {
                this.text.reset();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this._collectText) {
                this.text.write(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) {
            this.text.write(ch, start, length);
        }

        @Override
        public void endDocument() throws SAXException {
            this.completeTextNode();
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this._spanMode) {
                if (qName.equals("Span")) {
                    --this._spanDepth;
                    if (this._spanDepth < 0) {
                        this._spanMode = false;
                        this._collectText = true;
                    }
                } else {
                    String token = "";
                    try {
                        String elementShortName = this._spanSubElementMap.get(qName).toString();
                        if (elementShortName == null) {
                            elementShortName = qName;
                        }
                        token = "[" + elementShortName + "-" + this._tokenCount + "]";
                    }
                    catch (Exception e) {
                        token = "[" + qName + "=" + this._tokenCount + "]";
                    }
                    this.text.append(token);
                    this._collectText = true;
                }
            }
            if (!this._spanMode) {
                if (this._isTextNode) {
                    if (this.text.size() != 0) {
                        this._localizableMap.put(this._xpath, this.text.toString());
                    }
                    this._isTextNode = false;
                }
                this.completeTextNode();
            }
            int p = this._xpath.lastIndexOf("/");
            this._xpath = this._xpath.substring(0, p);
            int pEZ = this._xpathEZ.lastIndexOf("/");
            this._xpathEZ = this._xpathEZ.substring(0, pEZ);
            this.env = (Map)this.stack.pop();
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.completeTextNode();
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.completeTextNode();
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            this.completeTextNode();
        }

        @Override
        public void startDocument() throws SAXException {
            this.completeTextNode();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this._xpath = this._xpath + "/" + qName;
            this._xpathEZ = this._xpathEZ + "/" + qName;
            int ord = 1;
            if (this.env.containsKey(qName)) {
                ord = (Integer)this.env.get(qName);
                this.env.put(qName, ++ord);
            } else {
                this.env.put(qName, ord);
            }
            if (!this.stack.empty()) {
                this._xpath = this._xpath + "[" + ord + "]";
            }
            this.stack.add(this.env);
            this.env = new HashMap();
            this.env.put(qName, 1);
            if (qName.equals("Span") && !this._spanMode && !this._filterURL) {
                this.completeTextNode();
                this._tokenCount = 0;
                this._spanDepth = 0;
                this._spanMode = true;
                this._isTextNode = true;
                this._collectText = true;
            } else if (qName.equals("Span") && this._spanMode) {
                ++this._spanDepth;
                this._collectText = true;
            } else if (!qName.equals("Span") && this._spanMode) {
                ++this._tokenCount;
                this._collectText = false;
            } else {
                String attr;
                int i;
                this.completeTextNode();
                this._collectText = true;
                this._isTextNode = false;
                if (qName.length() > 0) {
                    for (i = 0; i < this.textNodes.length; ++i) {
                        if (!qName.equalsIgnoreCase(this.textNodes[i]) || this._xpathEZ.endsWith(this.textExcludeMultipleNodes[0])) continue;
                        if (this._filterURL && qName.equalsIgnoreCase(this.textlocation[0])) {
                            this._isTextNode = true;
                            break;
                        }
                        if (this._filterURL) continue;
                        this._isTextNode = true;
                        break;
                    }
                }
                if ("InformationMap".equals(qName)) {
                    attr = atts.getValue("absolutePathLocation");
                    if (attr != null) {
                        this._localizableMap.put(this._xpath + "/@absolutePathLocation", attr);
                    }
                    if ((attr = atts.getValue("location")) != null) {
                        this._localizableMap.put(this._xpath + "/@location", attr);
                    }
                }
                if ("Image".equals(qName) && (attr = atts.getValue("file")) != null) {
                    this._localizableMap.put(this._xpath + "/@file", attr);
                }
                if ("Graph".equals(qName) && (attr = atts.getValue("altImage")) != null) {
                    this._localizableMap.put(this._xpath + "/@altImage", attr);
                }
                if ("SASProcessSection".equals(qName) && (attr = atts.getValue("file")) != null) {
                    this._localizableMap.put(this._xpath + "/@file", attr);
                }
                if ("SASProcessContainer".equals(qName) && (attr = atts.getValue("file")) != null) {
                    this._localizableMap.put(this._xpath + "/@file", attr);
                }
                if ("BusinessModelReferenceInformation".equals(qName) && (attr = atts.getValue("location")) != null) {
                    this._localizableMap.put(this._xpath + "/@location", attr);
                }
                if ("JFSStoredProcess".equals(qName) && (attr = atts.getValue("absolutePathLocation")) != null) {
                    this._localizableMap.put(this._xpath + "/@absolutePathLocation", attr);
                    log.info("Added JSFStoredProcess to localizableMap");
                }
                if ("ReposSASOlapServer".equals(qName) && (attr = atts.getValue("name")) != null) {
                    ContentHelper.this._reposSASOlapServer = attr;
                }
                if ("ReposOlapSchema".equals(qName) && (attr = atts.getValue("name")) != null) {
                    ContentHelper.this._reposOlapSchema = attr;
                }
                if ("ReposCube".equals(qName) && (attr = atts.getValue("name")) != null) {
                    ContentHelper.this._reposCube = attr;
                    if (this._filterURL) {
                        attr = ContentHelper.this._reposSASOlapServer + "|" + ContentHelper.this._reposOlapSchema + "|" + ContentHelper.this._reposCube;
                        this._localizableMap.put(this._xpath + "/@name", attr);
                    }
                    ContentHelper.this._reposSASOlapServer = null;
                    ContentHelper.this._reposOlapSchema = null;
                    ContentHelper.this._reposCube = null;
                }
                if ("ReposWorkspaceServer".equals(qName) && (attr = atts.getValue("name")) != null) {
                    ContentHelper.this._reposSASWorkspaceServer = attr;
                }
                if ("ReposSASLibrary".equals(qName)) {
                    attr = atts.getValue("name");
                    if (attr != null) {
                        ContentHelper.this._reposSASLibraryName = attr;
                    }
                    if ((attr = atts.getValue("schemaName")) != null) {
                        ContentHelper.this._reposSASLibrarySchemaName = attr;
                    }
                }
                if ("ReposTable".equals(qName) && (attr = atts.getValue("name")) != null) {
                    ContentHelper.this._reposTable = attr;
                    attr = ContentHelper.this._reposSASWorkspaceServer + "|" + ContentHelper.this._reposSASLibraryName + "|" + ContentHelper.this._reposSASLibrarySchemaName + "|" + ContentHelper.this._reposTable;
                    if (this._filterURL) {
                        this._localizableMap.put(this._xpath + "/@name", attr);
                    }
                    ContentHelper.this._reposSASWorkspaceServer = null;
                    ContentHelper.this._reposSASLibraryName = null;
                    ContentHelper.this._reposSASLibrarySchemaName = null;
                    ContentHelper.this._reposTable = null;
                }
                if (!this._filterURL) {
                    for (i = 0; i < this.nameAttrs.length; ++i) {
                        if (!qName.equalsIgnoreCase(this.nameAttrs[i]) || (attr = atts.getValue("name")) == null) continue;
                        this._localizableMap.put(this._xpath + "/@name", attr);
                    }
                    for (i = 0; i < this.labelAttrs.length; ++i) {
                        if (!qName.equalsIgnoreCase(this.labelAttrs[i]) || (attr = atts.getValue("label")) == null) continue;
                        this._localizableMap.put(this._xpath + "/@label", attr);
                    }
                    for (i = 0; i < this.textMultipleNodes.length; ++i) {
                        if (!this._xpathEZ.endsWith(this.textMultipleNodes[i])) continue;
                        this._isTextNode = true;
                        break;
                    }
                }
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.completeTextNode();
        }
    }

    class QuietErrorHandler
    implements ErrorHandler {
        QuietErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }
    }
}

