/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.ContentException;
import com.sas.report.repository.ContentInterface;
import com.sas.report.repository.ContentNameNotFoundException;
import com.sas.report.repository.ContentProviderDAV;
import com.sas.report.repository.ContentProviderFS;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.RepositoryException;
import com.sas.services.information.metadata.PathUrl;

public abstract class ContentFactory {
    public static ContentInterface create(OMRID omrid, String URI) throws ContentException, RepositoryException {
        return ContentFactory.initialize(omrid, URI, "", "");
    }

    public static ContentInterface create(OMRID omrid, String URI, String userID, String passWD) throws ContentException, RepositoryException {
        return ContentFactory.initialize(omrid, URI, userID, passWD);
    }

    public static ContentInterface create(OMRID omrid, PathUrl pathURL, String contentLocation) throws ContentException, RepositoryException {
        OMRID.ContentInfo contentInfo = omrid.getContentInfo(pathURL);
        String userId = contentInfo.getUserId();
        String password = contentInfo.getPassword();
        return ContentFactory.initialize(omrid, contentLocation, userId, password);
    }

    private static ContentInterface initialize(OMRID omrid, String URI, String userID, String passWD) throws ContentException, RepositoryException {
        String protocol = "";
        int idx = URI.indexOf(58);
        if (idx > 0) {
            protocol = URI.substring(0, idx);
        }
        try {
            if (protocol.toUpperCase().startsWith("HTTP")) {
                return new ContentProviderDAV(omrid, URI, userID, passWD);
            }
            return new ContentProviderFS(omrid, URI, userID, passWD);
        }
        catch (ContentNameNotFoundException ex) {
            return null;
        }
    }

    public static void validateResolvedAddress(String basePath, String subPath, String resolvedAddress) {
        if ((resolvedAddress = resolvedAddress.toUpperCase()).indexOf("SBIP:") > -1) {
            throw new IllegalArgumentException(RBUtil.getStringResource("ContentFactoryNotFullyResolved.fmt.txt", (Object)basePath, (Object)subPath, resolvedAddress));
        }
        int ndxOfHttp = resolvedAddress.lastIndexOf("HTTP:");
        int ndxOfHttps = resolvedAddress.lastIndexOf("HTTPS:");
        int ndxOfWinShare = resolvedAddress.lastIndexOf("\\\\");
        if (ndxOfHttp > 0 || ndxOfHttps > 0 || ndxOfWinShare > 0) {
            throw new IllegalArgumentException(RBUtil.getStringResource("ContentFactoryAppendedPrefix.fmt.txt", (Object)basePath, (Object)subPath, resolvedAddress));
        }
    }
}

