/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.CacheStorageFlat;
import com.sas.report.repository.CacheStorageZip;
import com.sas.report.repository.ContentInterface;
import com.sas.report.repository.OMRDirectory;
import com.sas.report.repository.OMREntry;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryInputStream;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.report.repository.RepositoryOutputStream;
import com.sas.services.information.metadata.PathUrl;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

abstract class CacheStorage {
    private OMREntry myEntry;
    private String myCacheName;
    private ContentInterface myContent;
    private boolean myInTransactionFlag;
    protected RepositoryInputStream myItemInputStream;
    protected RepositoryOutputStream myItemOutputStream;

    protected static CacheStorage getStorageStrategy(OMREntry entry, String cacheName) throws RepositoryException {
        if (entry == null) {
            throw new IllegalArgumentException(RBUtil.getStringResource("CacheStorageEntryNull.txt"));
        }
        if (Boolean.getBoolean("report.repository.zipCaches")) {
            return new CacheStorageZip(entry, cacheName);
        }
        return new CacheStorageFlat(entry, cacheName);
    }

    public CacheStorage(OMREntry entry, String cacheName) throws RepositoryException {
        this.myEntry = entry;
        this.myCacheName = cacheName;
    }

    public abstract void create(String var1) throws RepositoryException, RepositoryDuplicateNameException;

    public abstract void deleteAll() throws RepositoryException;

    public abstract void delete(String var1) throws RepositoryException;

    public abstract OutputStream getOutputStream(String var1) throws RepositoryIOException, RepositoryLockedException, IllegalStateException;

    public abstract InputStream getInputStream(String var1) throws RepositoryIOException, RepositoryLockedException, IllegalStateException;

    public abstract void deleteContent(String var1) throws RepositoryException;

    public abstract long getSizeInBytes(String var1) throws RepositoryException;

    public abstract String getContentLocation(String var1) throws RepositoryException;

    public abstract Set getItemNames();

    public abstract boolean exists(String var1);

    public abstract void copy(ContentInterface var1, String var2, String var3) throws RepositoryException;

    public abstract void copy(ContentInterface var1, String var2, ContentInterface var3, String var4) throws RepositoryException;

    public abstract void move(ContentInterface var1, String var2, String var3) throws RepositoryException;

    public abstract void move(ContentInterface var1, String var2, ContentInterface var3, String var4) throws RepositoryException;

    public abstract void rename(String var1, String var2) throws RepositoryException;

    public void transactionStart() throws IllegalStateException {
        if (this.myInTransactionFlag) {
            throw new IllegalStateException(RBUtil.getStringResource("CacheStorageTransInProgress.txt"));
        }
        this.myInTransactionFlag = true;
    }

    public void transactionEnd() throws IllegalStateException, RepositoryException {
        if (!this.myInTransactionFlag) {
            throw new IllegalStateException(RBUtil.getStringResource("CacheStorageNoTrans.txt"));
        }
        this.myInTransactionFlag = false;
    }

    public boolean isInTransaction() {
        return this.myInTransactionFlag;
    }

    ContentInterface getContent(boolean repairIfNeeded) throws RepositoryNotFoundException, RepositoryException {
        if (this.myContent == null) {
            this.myContent = ((OMRDirectory)this.myEntry.getParentEntry()).getContent(repairIfNeeded);
        }
        return this.myContent;
    }

    OMREntry getEntry() {
        return this.myEntry;
    }

    void verifyNotInTransaction() throws RepositoryLockedException {
        if (this.isInTransaction()) {
            throw new IllegalStateException(RBUtil.getStringResource("CacheStorageTransInProgress.txt"));
        }
    }

    void verifyStreamsClosed() throws RepositoryLockedException {
        this.verifyInputStreamClosed();
        this.verifyOutputStreamClosed();
    }

    void verifyOutputStreamClosed() throws RepositoryLockedException {
        if (this.myItemOutputStream != null && this.myItemOutputStream.isOpen()) {
            throw new RepositoryLockedException(RBUtil.getStringResource("OMRCacheItemlockedWriting.txt"));
        }
    }

    void verifyInputStreamClosed() throws RepositoryLockedException {
        if (this.myItemInputStream != null && this.myItemInputStream.isOpen()) {
            throw new RepositoryLockedException(RBUtil.getStringResource("OMRCacheItemlockedReading.txt"));
        }
    }

    String getContentName(String suffix) throws RepositoryException {
        PathUrl pathUrl = this.myEntry.getLocationUrl();
        String type = pathUrl.getType();
        String entryName = pathUrl.getName();
        StringBuffer buf = new StringBuffer();
        buf.append(entryName);
        buf.append("(");
        buf.append(type);
        buf.append(")");
        buf.append(this.myCacheName);
        buf.append(suffix);
        return buf.toString();
    }

    String getContentName(String prefix, String suffix) throws RepositoryException {
        StringBuffer buf = new StringBuffer(prefix.length() + 32);
        buf.append(prefix);
        buf.append(this.myCacheName);
        buf.append(suffix);
        return buf.toString();
    }

    public abstract Iterator getAttributes(String var1) throws RepositoryException, SecurityException;

    public abstract void setAttributes(String var1, Map var2) throws RepositoryException;

    public abstract Object getAttribute(String var1, String var2) throws RepositoryException;

    public abstract void setAttribute(String var1, String var2, Object var3) throws RepositoryException;

    public abstract void lock(String var1) throws RepositoryException;

    public abstract void unlock(String var1) throws RepositoryException;
}

