/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.PublicClonable;
import com.sas.measures.Time;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AgingPolicy
implements PublicClonable {
    private Time _interval = null;
    private long _maxGenerations = 1L;
    private long _currentGeneration = 1L;
    Map fileLocations = new HashMap();

    public AgingPolicy() {
    }

    public AgingPolicy(Time interval, long maxGenerations) {
        this();
        this._interval = interval;
        this._maxGenerations = maxGenerations;
    }

    public Time getInterval() {
        return this._interval;
    }

    public void setInterval(Time interval) {
        this._interval = interval;
    }

    public String getIntervalString() {
        if (this._interval.getMagnitude() < 0.0) {
            return "noage";
        }
        return this._interval.toString();
    }

    public void setIntervalString(String intervalString) {
        String iString = null;
        iString = intervalString.equals("noage") ? "-1 mo" : intervalString;
        this._interval = new Time(iString);
    }

    public long getMaxGenerations() {
        return this._maxGenerations;
    }

    public void setMaxGenerations(long maxGenerations) {
        this._maxGenerations = maxGenerations;
    }

    public long getCurrentGeneration() {
        return this._currentGeneration;
    }

    protected void setCurrentGeneration(long generation) {
        this._currentGeneration = generation;
    }

    public Iterator findAgedFiles() {
        return this.fileLocations.entrySet().iterator();
    }

    public String findGeneration(long generationNumber) {
        if (generationNumber > -1L && generationNumber <= this._currentGeneration) {
            return (String)this.fileLocations.get(generationNumber);
        }
        return null;
    }

    public void addGeneration(String fileLocation) {
        if (this._currentGeneration != this._maxGenerations) {
            ++this._currentGeneration;
            this.fileLocations.put(this._currentGeneration, fileLocation);
        }
    }

    public Object clone() {
        try {
            AgingPolicy clonePolicy = (AgingPolicy)super.clone();
            clonePolicy.setInterval(this._interval);
            clonePolicy.setMaxGenerations(this._maxGenerations);
            clonePolicy.setCurrentGeneration(this._currentGeneration);
            return clonePolicy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

