/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository;

import com.sas.report.repository.DirectoryInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.OMRDirectory;
import com.sas.report.repository.OMREntry;
import com.sas.report.repository.RBUtil;
import com.sas.report.repository.RemoteDirectoryAdapter;
import com.sas.report.repository.RemoteDirectoryInterface;
import com.sas.report.repository.RemoteEntryAdapter;
import com.sas.report.repository.RemoteEntryInterface;
import com.sas.report.repository.adapter.DirectoryInterfaceServiceAdapter;
import com.sas.report.repository.adapter.EntryInterfaceServiceAdapter;
import java.rmi.Remote;

public class AdapterFactory {
    private static boolean FORCE_LOCAL_MODE;

    static boolean isRemote(Remote rmtObj) {
        String str = rmtObj.toString();
        return str.indexOf("(local)") == -1;
    }

    public static void forceLocalMode(boolean local) {
        FORCE_LOCAL_MODE = local;
    }

    public static boolean isCallerRemote() {
        if (!FORCE_LOCAL_MODE) {
            Throwable t = new Throwable();
            StackTraceElement[] elements = t.getStackTrace();
            for (int i = 2; i < elements.length; ++i) {
                if (!elements[i].getClassName().equals("sun.rmi.server.UnicastServerRef")) continue;
                return true;
            }
        }
        return false;
    }

    public static EntryInterface adaptEntry(Object entryObj) {
        if (entryObj == null) {
            throw new IllegalArgumentException(RBUtil.getStringResource("AdapterFactory.AdaptNull.txt"));
        }
        if (entryObj instanceof OMREntry) {
            return (EntryInterface)entryObj;
        }
        if (entryObj instanceof RemoteEntryInterface) {
            return new RemoteEntryAdapter((RemoteEntryInterface)entryObj);
        }
        if (entryObj instanceof EntryInterfaceServiceAdapter) {
            return (EntryInterface)entryObj;
        }
        throw new IllegalArgumentException(RBUtil.getStringResource("AdapterFactory.UnableToHandle.txt", entryObj.getClass()));
    }

    public static DirectoryInterface adaptDirectory(Object dirObj) {
        if (dirObj == null) {
            throw new IllegalArgumentException(RBUtil.getStringResource("AdapterFactory.AdaptNull.txt"));
        }
        if (dirObj instanceof OMRDirectory) {
            return (DirectoryInterface)dirObj;
        }
        if (dirObj instanceof RemoteDirectoryInterface) {
            return new RemoteDirectoryAdapter((RemoteDirectoryInterface)dirObj);
        }
        if (dirObj instanceof DirectoryInterfaceServiceAdapter) {
            return (DirectoryInterface)dirObj;
        }
        throw new IllegalArgumentException(RBUtil.getStringResource("AdapterFactory.UnableToHandle.txt", dirObj.getClass()));
    }

    private AdapterFactory() {
    }
}

