/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.util;

import com.sas.tools.webappconfig.util.ErrorHandling;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import org.apache.tools.ant.Task;

public final class Logger {
    private static final int _EXCEPTION_TRACE_DEPTH = 4;
    private static final int _LOG_DATE_FORMAT_LENGTH = 5;
    private static final String _LOG_SUFFIX = ".log";
    private static final String _LOG_DATE_FORMAT = "yyDDD";
    private static final String _LOG_PREFIX = "sas.webappconfig.";
    private static final int _OBJECT_STRING_SIZE_ESTIMATE = 20;
    private static final String _LS = System.getProperty("line.separator");
    private static FileWriter _logWriter = null;
    private static String _logFileName = null;
    private static DateFormat _dateFormat = DateFormat.getDateTimeInstance(3, 2);

    public static void log(int logLevel, Task task, Object o1) {
        Object[] data = new Object[]{o1};
        Logger.doLog(logLevel, task, data);
    }

    static void log(int logLevel, Task task, Object o1, Object o2) {
        Object[] data = new Object[]{o1, o2};
        Logger.doLog(logLevel, task, data);
    }

    static void log(int logLevel, Task task, Object o1, Object o2, Object o3) {
        Object[] data = new Object[]{o1, o2, o3};
        Logger.doLog(logLevel, task, data);
    }

    private static void doLog(int logLevel, Task task, Object[] data) {
        String record = Logger.convertToString(data);
        if (null != task && null != task.getProject()) {
            task.log(record, logLevel);
        } else {
            System.out.println(record);
        }
    }

    private static String convertToString(Object[] data) {
        StringBuffer dataBuffer = new StringBuffer(20 * data.length);
        for (int j = 0; j < data.length; ++j) {
            if (data[j] instanceof Throwable) {
                Logger.doLog((Throwable)data[j], dataBuffer);
                continue;
            }
            dataBuffer.append(data[j]);
        }
        return dataBuffer.toString();
    }

    private static void doLog(Throwable t, StringBuffer buffer) {
        Logger.generateStackTrace(buffer, t, false);
        Throwable rootCause = Logger.getRootException(t);
        if (null != rootCause && !rootCause.equals(t)) {
            buffer.append("\t*** ROOT CAUSE ***:");
            Logger.generateStackTrace(buffer, rootCause, true);
        }
    }

    private static Throwable getRootException(Throwable t) {
        HashSet<Throwable> causes = new HashSet<Throwable>(4);
        causes.add(t);
        Throwable rval = t;
        Throwable cause = Logger.getCause(t);
        while (null != cause && !causes.contains(cause)) {
            causes.add(cause);
            rval = cause;
            cause = Logger.getCause(cause);
        }
        return rval;
    }

    private static Throwable getCause(Throwable t) {
        if (t instanceof ClassNotFoundException) {
            return ((ClassNotFoundException)t).getException();
        }
        if (t instanceof ExceptionInInitializerError) {
            return ((ExceptionInInitializerError)t).getException();
        }
        return t.getCause();
    }

    private static void generateStackTrace(StringBuffer buffer, Throwable t, boolean isRootCause) {
        buffer.append(_LS);
        if (isRootCause) {
            buffer.append("\t");
        }
        buffer.append(t).append(_LS);
        StackTraceElement[] elements = t.getStackTrace();
        for (int j = 0; j < elements.length; ++j) {
            StackTraceElement element = elements[j];
            buffer.append("\tat ").append(element).append(_LS);
            if (isRootCause && element.getClassName().startsWith("com.sas.tools.webappconfig")) break;
        }
    }

    private static void writeToLogFile(String buffer) {
        if (null == _logWriter) {
            Logger.generateLogFile();
        }
        if (null != _logWriter) {
            try {
                _logWriter.write(_dateFormat.format(new Date()));
                _logWriter.write(": ");
                _logWriter.write(buffer);
                _logWriter.write(_LS);
                _logWriter.flush();
            }
            catch (IOException e) {
                Logger.processInternalException(ErrorHandling.generateCannotWriteToLogFileErrorMessage(null, _logFileName), e);
            }
        }
    }

    private static void generateLogFile() {
        StringBuffer nameBuffer = new StringBuffer(_LOG_PREFIX.length() + 5 + _LOG_SUFFIX.length());
        nameBuffer.append(_LOG_PREFIX);
        nameBuffer.append(new SimpleDateFormat(_LOG_DATE_FORMAT).format(new Date()));
        nameBuffer.append(_LOG_SUFFIX);
        _logFileName = nameBuffer.toString();
        try {
            File logFile = new File(_logFileName);
            boolean alreadyExisted = logFile.exists();
            _logWriter = new FileWriter(logFile, true);
            if (alreadyExisted) {
                Logger.log(3, null, ErrorHandling.generateAppendingToLogFileInfoMessage(null, _logFileName));
            }
        }
        catch (IOException e) {
            Logger.processInternalException(ErrorHandling.generateCannotCreateLogFileErrorMessage(null, _logFileName), e);
        }
    }

    private static void processInternalException(String errorMessage, Exception e) {
        System.out.println(Logger.convertToString(new Object[]{errorMessage, e}));
    }
}

