/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.util;

import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.FileTransformationInterface;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.File;
import org.apache.tools.ant.Task;

public class FileTransformer {
    private FileTransformationInterface _transformation;
    private String _filename;
    private Task _task;

    public FileTransformer(Task task, String filename, FileTransformationInterface transformation) {
        this._task = task;
        this._filename = filename;
        this._transformation = transformation;
    }

    public void executeTransformation() throws WebAppConfigException {
        StringBuffer tmpNameBuffer = new StringBuffer(this._filename.length() + 4);
        tmpNameBuffer.append(this._filename);
        tmpNameBuffer.append(".tmp");
        String tmpName = tmpNameBuffer.toString();
        this._transformation.transformFile(this._task, this._filename, tmpName);
        File targetFile = new File(this._filename);
        if (!targetFile.delete()) {
            throw new WebAppConfigException(ErrorHandling.generateCannotDeleteFileErrorMessage(this._task, this._filename), null);
        }
        if (!new File(tmpName).renameTo(targetFile)) {
            throw new WebAppConfigException(ErrorHandling.generateCannotRenameFileErrorMessage(this._task, tmpName, this._filename), null);
        }
    }
}

