/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.tools.ant.Task;

public final class War
extends TaskImpl {
    private static final int _MAX_BUFFER_SIZE = 65536;
    private static final char _BACKSLASH = '\\';
    private static final char _FORWARD_SLASH = '/';
    private String _warFileName;
    private String _directory;
    private int _topFileNameLength;
    private JarOutputStream _jos;

    @Override
    protected boolean doWork() throws WebAppConfigException {
        try {
            this._warFileName = new File(this.getValue("warfile")).getCanonicalFile().toString();
        }
        catch (IOException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage((Task)this, this.getValue("warfile")), e);
        }
        this._directory = this.getValue("directory");
        File topFile = new File(this._directory);
        if (!topFile.exists()) {
            return false;
        }
        this._jos = null;
        try {
            this._jos = new JarOutputStream(new FileOutputStream(this._warFileName));
            this._topFileNameLength = topFile.toString().length() + 1;
            this.recurseFiles(topFile);
        }
        catch (IOException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage((Task)this, this._warFileName), e);
        }
        finally {
            CommonUtils.closeOutputStream(this._jos);
        }
        return true;
    }

    private void recurseFiles(File file) throws WebAppConfigException {
        if (file.isDirectory()) {
            Logger.log(3, this, ErrorHandling.generateProcessingDirectoryInfoMessage(this, file));
            String[] fileNames = file.list();
            if (null != fileNames) {
                for (int i = 0; i < fileNames.length; ++i) {
                    this.recurseFiles(new File(file, fileNames[i]));
                }
            }
            this.addFile(file);
        } else {
            try {
                if (!this._warFileName.equals(file.getCanonicalFile().toString())) {
                    this.addFile(file);
                } else {
                    Logger.log(3, this, ErrorHandling.generateIgnoringWarFileInfoMEssage(this));
                }
            }
            catch (IOException e) {
                Logger.log(0, this, e);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addFile(File file) throws WebAppConfigException {
        String entryName = file.toString();
        entryName = entryName.replace('\\', '/');
        if (file.isDirectory()) {
            if (entryName.equals(this._directory)) return;
            if (!entryName.endsWith("/")) {
                StringBuffer buffer = new StringBuffer(entryName.length() + 1);
                buffer.append(entryName);
                buffer.append('/');
                entryName = buffer.toString();
            }
        }
        entryName = entryName.substring(this._topFileNameLength);
        try {
            ZipEntry entry = new ZipEntry(entryName);
            entry.setTime(file.lastModified());
            this._jos.putNextEntry(entry);
        }
        catch (IOException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotAddEntryErrorMessage((Task)this, entryName), e);
        }
        if (file.isDirectory()) {
            return;
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            int size = Math.max(1, (int)Math.min(65536L, file.length()));
            byte[] buf = new byte[size];
            int len = 0;
            while (0 <= (len = in.read(buf))) {
                this._jos.write(buf, 0, len);
            }
            this._jos.closeEntry();
        }
        catch (FileNotFoundException e) {
            try {
                throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage((Task)this, file), e);
                catch (IOException e2) {
                    throw new WebAppConfigException(ErrorHandling.generateCannotAddEntryErrorMessage((Task)this, file), e2);
                }
            }
            catch (Throwable throwable) {
                CommonUtils.closeInputStream(in);
                throw throwable;
            }
        }
        CommonUtils.closeInputStream(in);
    }
}

