/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.tools.webappconfig.tasks.ObjectPropertiesUtil;
import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.apache.tools.ant.Task;

public class RemoveConfigurableObjectProperty
extends TaskImpl {
    private String fqid = null;
    private String propertytoremove = null;
    private String m_repositoryFQID = "";
    private String m_reposID = null;
    private MdFactory m_mdFactory = null;
    private MdObjectStore m_mdObjectStore = null;
    private static boolean connected = false;
    private static boolean removed = false;

    @Override
    public boolean doWork() throws WebAppConfigException {
        boolean valid = true;
        removed = false;
        HashMap publicProperties = new HashMap();
        HashMap privateProperties = new HashMap();
        TextStore textStore = null;
        this.m_reposID = this.fqid.substring(0, 8);
        this.m_repositoryFQID = "A0000001." + this.m_reposID;
        if (this.fqid == null) {
            valid = false;
            Logger.log(0, this, "\nError during setting of properties.  Passed in FullyQualifiedID is null.");
        }
        if (valid) {
            String host = this.getProject().getProperty("iomsrv.metadatasrv.host");
            String port = this.getProject().getProperty("iomsrv.metadatasrv.port");
            String user = this.getProject().getProperty("metadata.connection.userid");
            String password = this.getProject().getProperty("metadata.connection.passwd");
            this.m_mdFactory = ObjectPropertiesUtil.makeConnection(this, host, port, user, password);
            if (this.m_mdFactory == null) {
                connected = false;
            } else {
                this.m_mdObjectStore = ObjectPropertiesUtil.createObjectStore(this, this.m_mdFactory);
                connected = this.m_mdObjectStore != null;
            }
            Root softwareComponent = ObjectPropertiesUtil.getRoot(this, this.m_mdFactory, this.fqid, this.m_mdObjectStore, this.m_repositoryFQID);
            textStore = ObjectPropertiesUtil.getTextStore(this, softwareComponent, true);
            if (textStore != null) {
                ObjectPropertiesUtil.appendProperties(this, publicProperties, textStore);
            }
            textStore = null;
            textStore = ObjectPropertiesUtil.getTextStore(this, softwareComponent, false);
            if (textStore != null) {
                ObjectPropertiesUtil.appendProperties(this, privateProperties, textStore);
            }
            if (connected && softwareComponent != null) {
                if (valid) {
                    String publicStoredTextAttribute = RemoveConfigurableObjectProperty.getStringSubsetFromProperties(this, publicProperties, this.propertytoremove);
                    String privateStoredTextAttribute = RemoveConfigurableObjectProperty.getStringSubsetFromProperties(this, privateProperties, this.propertytoremove);
                    if (removed) {
                        valid = ObjectPropertiesUtil.setObjectProps(this, this.m_mdFactory, this.m_mdObjectStore, this.m_reposID, softwareComponent, publicStoredTextAttribute, privateStoredTextAttribute);
                    } else {
                        Logger.log(3, this, "\n\nWarning:  Property not found " + this.propertytoremove);
                    }
                }
                this.closeConnection();
            } else {
                valid = false;
                Logger.log(0, this, "Error setting object properties:");
                Logger.log(0, this, "   connected:" + connected);
                Logger.log(0, this, "   SoftwareComponent:" + softwareComponent);
            }
        }
        return valid;
    }

    public static String getStringSubsetFromProperties(Task owner, HashMap myProperties, String propertyToRemove) {
        PropertyList myPropertyList = new PropertyList();
        String[] s = myProperties.keySet().toArray(new String[0]);
        if (s != null && s.length > 0) {
            for (int i = 0; i < s.length; ++i) {
                if (!s[i].equals(propertyToRemove)) {
                    myPropertyList.addProperty(s[i], (String)myProperties.get(s[i]));
                    continue;
                }
                removed = true;
                Logger.log(3, owner, "Removed property " + s[i] + "=" + (String)myProperties.get(s[i]));
            }
        }
        StringWriter writer = new StringWriter();
        try {
            myPropertyList.save((Writer)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String storedTextAttribute = writer.toString();
        storedTextAttribute = storedTextAttribute.replaceAll("\\r", "");
        return storedTextAttribute;
    }

    public void setFqid(String fqid) {
        this.fqid = fqid;
    }

    public void setPropertytoRemove(String propertytoremove) {
        this.propertytoremove = propertytoremove;
    }

    public void closeConnection() {
        ObjectPropertiesUtil.closeConnection(this, this.m_mdFactory);
    }
}

