/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.metadata.MdException;
import com.sas.metadata.MetadataWorkspace;
import com.sas.tools.webappconfig.password.ChangeRequest;
import com.sas.tools.webappconfig.password.FileRule;
import com.sas.tools.webappconfig.password.InputFile;
import com.sas.tools.webappconfig.password.PwTuple;
import com.sas.tools.webappconfig.password.RulesParser;
import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.Task;

public final class PwFile
extends TaskImpl {
    private static final String _VALIDATION = "validation";
    private static final String _PASSWORD = "password";
    private static final String _USERID = "userid";
    private static final String _CONFIG_LEVEL = "configlevel";
    private static final String _DEFAULT_CONFIG_LEVEL = "Lev1";
    private static final String _SAS_CONFIG = "sasConfig";
    private static final String _SAS_HOME = "sasHome";
    private static final String _PW_FILE = "pwFile";
    private static final String _METADATA_PORT = "metadataPort";
    private static final String _METADATA_SERVER = "metadataServer";
    private static final String _CONFIGPATH = "configpath";
    private static final String _PROPERTIES_FILE_NAME = "pwfile.properties";
    private static final String _RULES_FILENAME = "pwfile.xml";
    private static final String _RULES_RESOURCE_PATH = "com/sas/tools/webappconfig/password/pwfile.xml";
    private Properties _properties = new Properties();
    private List _rules = new ArrayList();
    private String _configPath = null;

    private boolean checkPaths() {
        return this.verifyPath(_SAS_HOME) && this.verifyPath(_SAS_CONFIG);
    }

    private boolean verifyPath(String pathName) {
        String value = this._properties.getProperty(pathName);
        if (value == null) {
            Logger.log(0, this, ErrorHandling.generatePropertyUndefinedErrorMessage(this, pathName));
            return false;
        }
        if (!new File(value).isDirectory()) {
            Logger.log(0, this, ErrorHandling.generatePropertyIsNotDirectory(this, value, pathName));
            return false;
        }
        return true;
    }

    private List getChangeRequests(ChangeRequest request, String pwFileName) throws WebAppConfigException {
        if (request != null) {
            ArrayList<ChangeRequest> requests = new ArrayList<ChangeRequest>();
            requests.add(request);
            return requests;
        }
        return new InputFile(pwFileName).getChangeRequests(this);
    }

    private void listUsers() throws WebAppConfigException {
        Logger.log(2, this, ErrorHandling.generatePasswordListingHeader(this));
        List userids = this.findPasswords();
        Collections.sort(userids, PwTuple.getComparator());
        Iterator iter = userids.iterator();
        while (iter.hasNext()) {
            Logger.log(2, this, ((PwTuple)iter.next()).getRepresentation(this));
        }
    }

    private void changePasswords(ChangeRequest request, String pwFileName) throws WebAppConfigException {
        List requests = this.getChangeRequests(request, pwFileName);
        boolean changesMade = false;
        if (requests != null && this.confirmChanges(requests)) {
            changesMade = this.applyChanges(requests);
        }
        if (!changesMade) {
            Logger.log(2, this, ErrorHandling.generateNoPasswordsChangedInfoMessage(this));
        }
    }

    private boolean confirmChanges(List changeRequests) {
        if (!this.getValueAsBool(_VALIDATION, false)) {
            return true;
        }
        boolean result = true;
        String serverName = this._properties.getProperty(_METADATA_SERVER);
        if (serverName == null) {
            Logger.log(0, this, ErrorHandling.generateMissingServerNameErrorMessage(this));
            return false;
        }
        String serverPort = this._properties.getProperty(_METADATA_PORT);
        if (serverPort == null) {
            Logger.log(0, this, ErrorHandling.generateMissingPortIDErrorMessage(this));
            return false;
        }
        for (ChangeRequest request : changeRequests) {
            result &= this.confirmPassword(request, serverName, serverPort);
        }
        return result;
    }

    private boolean confirmPassword(ChangeRequest request, String serverName, String serverPort) {
        MetadataWorkspace workspace = MetadataWorkspace.getWorkspace();
        String userID = request.getUserID();
        try {
            workspace.makeOMRConnection(serverName, serverPort, userID, request.getPassword());
        }
        catch (MdException e) {
            Throwable t = e.getCause();
            if (t != null) {
                String errorType = e.getSASMessageSeverity();
                String errorMessage = e.getSASMessage();
                if (errorType != null) {
                    String reason = ErrorHandling.generateCannotValidatePasswordReasonText(this, errorType, errorMessage);
                    Logger.log(0, this, ErrorHandling.generateCannotValidatePasswordErrorMessage(this, userID, serverName, serverPort, reason));
                } else {
                    Logger.log(0, this, ErrorHandling.generateCannotValidatePasswordErrorMessage(this, userID, serverName, serverPort, t));
                }
            } else {
                Logger.log(0, this, ErrorHandling.generateCannotValidatePasswordErrorMessage(this, userID, serverName, serverPort, (Object)e));
            }
            return false;
        }
        catch (RemoteException e) {
            Logger.log(0, this, ErrorHandling.generateCannotValidatePasswordErrorMessage(this, userID, serverName, serverPort, e));
            return false;
        }
        return true;
    }

    private boolean loadRules() throws WebAppConfigException {
        InputStream rulesFileStream = null;
        File rulesFile = null;
        rulesFile = CommonUtils.isEmpty(this._configPath) ? new File(_RULES_FILENAME) : new File(new File(this._configPath), _RULES_FILENAME);
        if (rulesFile.exists()) {
            try {
                rulesFileStream = new FileInputStream(rulesFile);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else {
            rulesFileStream = this.getClass().getResourceAsStream(_RULES_RESOURCE_PATH);
            if (rulesFileStream == null) {
                Logger.log(0, this, ErrorHandling.generateCannotOpenFileErrorMessage((Task)this, _RULES_RESOURCE_PATH));
                return false;
            }
        }
        RulesParser handler = new RulesParser(this, _RULES_FILENAME, this.getConfigLevel());
        handler.setRulesStream(rulesFileStream);
        handler.setProperties(this._properties);
        this._rules = handler.getRules();
        return true;
    }

    private String getConfigLevel() {
        if (this.paramExists(_CONFIG_LEVEL)) {
            return this.getSafeValue(_CONFIG_LEVEL);
        }
        return _DEFAULT_CONFIG_LEVEL;
    }

    /*
     * Loose catch block
     */
    private void loadProperties() throws WebAppConfigException {
        FileInputStream fileInputStream = null;
        File source = new File(_PROPERTIES_FILE_NAME);
        if (!CommonUtils.isEmpty(this._configPath)) {
            source = new File(new File(this._configPath), _PROPERTIES_FILE_NAME);
        }
        try {
            fileInputStream = new FileInputStream(source);
            this._properties.load(fileInputStream);
        }
        catch (FileNotFoundException e) {
            Logger.log(2, this, ErrorHandling.generateCannotOpenFileErrorMessage((Task)this, source));
            CommonUtils.closeInputStream(fileInputStream);
        }
        catch (Exception e2) {
            throw new WebAppConfigException(ErrorHandling.generateCannotReadFileErrorMessage((Task)this, source), e2);
            {
                catch (Throwable throwable) {
                    CommonUtils.closeInputStream(fileInputStream);
                    throw throwable;
                }
            }
        }
        CommonUtils.closeInputStream(fileInputStream);
        this.maybeAddParamToProperties(_METADATA_SERVER);
        this.maybeAddParamToProperties(_METADATA_PORT);
        this.maybeAddParamToProperties(_PW_FILE);
        this.maybeAddParamToProperties(_SAS_HOME);
        this.maybeAddParamToProperties(_SAS_CONFIG);
    }

    private List findPasswords() throws WebAppConfigException {
        LinkedList matches = new LinkedList();
        Iterator iter = this._rules.iterator();
        while (iter.hasNext()) {
            matches.addAll(((FileRule)iter.next()).findPasswords(this));
        }
        return matches;
    }

    private boolean applyChanges(List changeRequests) throws WebAppConfigException {
        boolean result = false;
        Iterator iter = this._rules.iterator();
        while (iter.hasNext()) {
            if (!((FileRule)iter.next()).applyChanges(this, changeRequests)) continue;
            result = true;
        }
        return result;
    }

    public void setConfigpath(String value) {
        this.addParameter(_CONFIGPATH, value);
    }

    public void setConfiglevel(String value) {
        this.addParameter(_CONFIG_LEVEL, value);
    }

    public void setMetadataPort(String value) {
        this.addParameter(_METADATA_PORT, value);
    }

    public void setMetadataServer(String value) {
        this.addParameter(_METADATA_SERVER, value);
    }

    public void setPassword(String value) {
        this.addParameter(_PASSWORD, value);
    }

    public void setPwFile(String value) {
        this.addParameter(_PW_FILE, value);
    }

    public void setSasConfig(String value) {
        this.addParameter(_SAS_CONFIG, value);
    }

    public void setSasHome(String value) {
        this.addParameter(_SAS_HOME, value);
    }

    public void setUserid(String value) {
        this.addParameter(_USERID, value);
    }

    public void setValidation(String value) {
        this.addParameter(_VALIDATION, value);
    }

    @Override
    protected boolean doWork() throws WebAppConfigException {
        this.initializeConfigPath();
        this.loadProperties();
        if (!this.checkPaths()) {
            return false;
        }
        if (!this.loadRules()) {
            return false;
        }
        ChangeRequest request = null;
        if (this.paramExists(_USERID) || this.paramExists(_PASSWORD)) {
            request = new ChangeRequest();
            if (this.paramExists(_USERID)) {
                request.setUserID(this.getSafeValue(_USERID));
            }
            if (this.paramExists(_PASSWORD)) {
                request.setPassword(this.getSafeValue(_PASSWORD));
            }
        }
        if (this._properties.getProperty(_PW_FILE) == null && request == null) {
            this.listUsers();
        } else {
            this.changePasswords(request, this._properties.getProperty(_PW_FILE));
        }
        return true;
    }

    private void initializeConfigPath() {
        if (this.paramExists(_CONFIGPATH)) {
            this._configPath = this.getSafeValue(_CONFIGPATH);
        }
    }

    private String getSafeValue(String param) {
        String value = null;
        try {
            value = this.getValue(param);
        }
        catch (WebAppConfigException webAppConfigException) {
            // empty catch block
        }
        return value;
    }

    private void maybeAddParamToProperties(String propertyValue) {
        if (this.paramExists(propertyValue)) {
            this._properties.setProperty(propertyValue, this.getSafeValue(propertyValue));
        }
    }
}

