/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class OverwriteProperties
extends TaskImpl {
    protected String name;
    protected String value;
    protected File file;
    protected boolean newFile;
    protected File newConfigFile;
    protected URL url;
    protected String resource;
    protected Path classpath;
    protected String env;
    protected Reference ref;
    protected String prefix;
    protected String exclude;
    protected ArrayList<String> excludes = new ArrayList();
    private Project fallback;
    protected Properties newprops = new Properties();
    protected String instanceNumber = null;

    public OverwriteProperties() {
        this(null);
    }

    protected OverwriteProperties(Project fallback) {
        this.fallback = fallback;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setNewFile(boolean file) {
        this.newFile = file;
    }

    public Boolean getNewFile() {
        return this.newFile;
    }

    public String getExclude() {
        return this.exclude;
    }

    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        if (!prefix.endsWith(".")) {
            this.prefix = this.prefix + ".";
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setRefid(Reference ref) {
        this.ref = ref;
    }

    public Reference getRefid() {
        return this.ref;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getResource() {
        return this.resource;
    }

    public void setEnvironment(String env) {
        this.env = env;
    }

    public String getEnvironment() {
        return this.env;
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public String toString() {
        return this.value == null ? "" : this.value;
    }

    @Override
    public boolean doWork() throws BuildException {
        if (this.getProject() == null) {
            throw new IllegalStateException("project has not been set");
        }
        if (this.name != null) {
            if (this.value == null && this.ref == null) {
                throw new BuildException("You must specify value, location or refid with the name attribute", this.getLocation());
            }
        } else if (this.url == null && this.file == null && this.resource == null && this.env == null) {
            throw new BuildException("You must specify url, file, resource or environment when not using the name attribute", this.getLocation());
        }
        if (this.url == null && this.file == null && this.resource == null && this.prefix != null) {
            throw new BuildException("Prefix is only valid when loading from a url, file or resource", this.getLocation());
        }
        if (this.name != null && this.value != null) {
            this.addProperty(this.name, this.value);
        }
        if (this.exclude != null) {
            String[] tokens = this.exclude.split("[,]");
            for (int i = 0; i < tokens.length; ++i) {
                this.excludes.add(tokens[i].trim());
            }
        }
        if (this.newFile) {
            try {
                this.newConfigFile = this.getNewConfigFile();
                Project prj = this.getProject();
                File origFile = new File(prj.getProperty("configuration.properties.file"));
                FileInputStream in = new FileInputStream(origFile);
                this.newprops = this.loadFile(origFile);
                this.newprops.load(in);
            }
            catch (Exception ex) {
                throw new BuildException((Throwable)ex, this.getLocation());
            }
        }
        if (this.file != null) {
            Logger.log(2, this, "Overwriting properties with values from file: " + this.file.getAbsolutePath());
            Properties props = this.loadFile(this.file);
            this.addProperties(props);
        }
        if (!this.newprops.isEmpty()) {
            try {
                this.newprops.store(new FileOutputStream(this.newConfigFile), null);
            }
            catch (Exception ex) {
                throw new BuildException((Throwable)ex, this.getLocation());
            }
        }
        if (this.name != null && this.ref != null) {
            try {
                this.addProperty(this.name, this.ref.getReferencedObject(this.getProject()).toString());
            }
            catch (BuildException be) {
                if (this.fallback != null) {
                    this.addProperty(this.name, this.ref.getReferencedObject(this.fallback).toString());
                }
                throw be;
            }
        }
        return true;
    }

    private File getNewConfigFile() {
        File configfile = null;
        Project prj = this.getProject();
        File origFile = new File(prj.getProperty("temp.dir"));
        String my12byte = prj.getProperty("config.currprod.12byte");
        int i = 1;
        while (configfile == null || configfile.exists()) {
            configfile = new File(origFile, my12byte + i + ".configuration.properties");
            this.instanceNumber = "" + i;
            ++i;
        }
        return configfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadFile(File file) throws BuildException {
        Properties props;
        block7: {
            props = new Properties();
            try {
                if (file.exists()) {
                    try (FileInputStream fis = new FileInputStream(file);){
                        props.load(fis);
                        break block7;
                    }
                }
                Logger.log(3, this, "Unable to find property file: " + file.getAbsolutePath());
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex, this.getLocation());
            }
        }
        return props;
    }

    protected void addProperties(Properties props) {
        this.resolveAllProperties(props);
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            String propertyValue = props.getProperty(propertyName);
            String v = this.getProject().replaceProperties(propertyValue);
            if (this.prefix != null) {
                propertyName = this.prefix + propertyName;
            }
            if (!this.excludes.contains(propertyName)) {
                this.addProperty(propertyName, v);
                continue;
            }
            Logger.log(2, this, "Excluding \"" + propertyName + "\"");
        }
        if (this.instanceNumber != null) {
            Project prj = this.getProject();
            String my12byte = prj.getProperty("config.currprod.12byte");
            prj.setProperty(my12byte + ".property.instance.number", this.instanceNumber);
            this.newprops.setProperty(my12byte + ".property.instance.number", this.instanceNumber);
        }
    }

    protected void addProperty(String n, String v) {
        Project prj = this.getProject();
        if (prj.getUserProperty(n) != null) {
            Logger.log(2, this, "Overriding previous definition of user property \"" + n + "\"");
            prj.setUserProperty(n, v);
        } else {
            prj.setProperty(n, v);
        }
        if (!this.newprops.isEmpty()) {
            this.newprops.setProperty(n, v);
        }
    }

    private void resolveAllProperties(Properties props) throws BuildException {
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            Stack referencesSeen = new Stack();
            this.resolve(props, propertyName, referencesSeen);
        }
    }

    private void resolve(Properties props, String name, Stack referencesSeen) throws BuildException {
        if (referencesSeen.contains(name)) {
            throw new BuildException("Property " + name + " was circularly defined.");
        }
        String propertyValue = props.getProperty(name);
        Vector fragments = new Vector();
        Vector propertyRefs = new Vector();
        PropertyHelper.getPropertyHelper((Project)this.getProject()).parsePropertyString(propertyValue, fragments, propertyRefs);
        if (propertyRefs.size() != 0) {
            referencesSeen.push(name);
            StringBuffer sb = new StringBuffer();
            Enumeration i = fragments.elements();
            Enumeration j = propertyRefs.elements();
            while (i.hasMoreElements()) {
                String fragment = (String)i.nextElement();
                if (fragment == null) {
                    String propertyName = (String)j.nextElement();
                    fragment = this.getProject().getProperty(propertyName);
                    if (fragment == null) {
                        if (props.containsKey(propertyName)) {
                            this.resolve(props, propertyName, referencesSeen);
                            fragment = props.getProperty(propertyName);
                        } else {
                            fragment = "${" + propertyName + "}";
                        }
                    }
                }
                sb.append(fragment);
            }
            propertyValue = sb.toString();
            props.put(name, propertyValue);
            referencesSeen.pop();
        }
    }
}

