/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.iom.SASIOMDefs.DateTimeHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.meta.SASOMI.ISecurity_1_1Helper;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import org.apache.tools.ant.Project;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.Object;

public class OverrideInternalAccountDefaultOptions
extends TaskImpl {
    private static MdFactory mdFactory;
    private static MdOMRConnection metadataWorkspace;
    private static Project project;
    private static String host;
    private static String port;
    private static String user;
    private static String password;
    private static String internalUser;
    private static BooleanHolder HasInternalLogin;
    private static BooleanHolder Disabled;
    private static BooleanHolder BypassStrength;
    private static BooleanHolder BypassHistory;
    private static BooleanHolder UseStdExpirationDays;
    private static IntHolder ExpirationDays;
    private static BooleanHolder BypassLockout;
    private static BooleanHolder BypassInactivitySuspension;
    private static BooleanHolder DoesAccountExpire;
    private static DateTimeHolder AccountExpirationDate;
    private static DateTimeHolder LastPWChange;
    private static DateTimeHolder LastLogin;
    private static IntHolder NumFailures;
    private static DateTimeHolder LastLockout;
    private static BooleanHolder LockedOut;
    private static BooleanHolder PWExpired;
    private static BooleanHolder SuspendedForInactivity;
    private static BooleanHolder IsAccountExpired;
    private static IOMI omrConnection;
    private static final int RETURN_CODE_SUCCESS = 0;
    private static final int RETURN_CODE_WARNING = 1;
    private static final int RETURN_CODE_ERROR = 2;
    private static int returnCode;
    private static String errorMessage;
    private static boolean sdwDebugMode;

    @Override
    public boolean doWork() throws WebAppConfigException {
        String logMessage;
        int logLevel;
        block24: {
            logLevel = 2;
            logMessage = null;
            project = this.getProject();
            sdwDebugMode = project.getProperty("wizard.debug.mode").equalsIgnoreCase("true");
            try {
                mdFactory = new MdFactoryImpl(false);
                mdFactory.setDebug(true);
                mdFactory.setLoggingEnabled(false);
                mdFactory.getUtil().setOutputStream((OutputStream)System.out);
                metadataWorkspace = mdFactory.getConnection();
                logLevel = 3;
                logMessage = ErrorHandling.generateMetadataServerWorkspaceInfoMessage(this);
            }
            catch (Exception e) {
                errorMessage = e.getLocalizedMessage();
                logLevel = 0;
                logMessage = errorMessage != null ? errorMessage : ErrorHandling.generateMetadataServerWorkspaceErrorMessage(this);
                returnCode = 2;
            }
            Logger.log(logLevel, this, logMessage);
            if (host == null) {
                host = project.getProperty("iomsrv.metadatasrv.host");
            }
            if (port == null) {
                port = project.getProperty("iomsrv.metadatasrv.port");
            }
            if (user == null) {
                user = project.getProperty("oma.person.bootstrap.login.userid");
            }
            if (password == null) {
                password = project.getProperty("oma.person.bootstrap.login.passwd");
            }
            logLevel = 2;
            try {
                omrConnection = metadataWorkspace.makeOMRConnection(host, port, user, password);
                if (omrConnection != null) {
                    Logger.log(3, this, ErrorHandling.generateMetadataServerConnectionInfoMessage(this, host, port, user));
                    switch (returnCode) {
                        case 1: {
                            logLevel = 1;
                            logMessage = errorMessage != null ? errorMessage : ErrorHandling.generateInternalAccountWarningMessage(this);
                            break;
                        }
                        case 2: {
                            logLevel = 0;
                            logMessage = errorMessage != null ? errorMessage : ErrorHandling.generateInternalAccountErrorMessage(this);
                            break;
                        }
                        default: {
                            logLevel = 3;
                            logMessage = ErrorHandling.generateInternalAccountInfoMessage(this);
                            break;
                        }
                    }
                } else {
                    logLevel = 0;
                    logMessage = ErrorHandling.generateIOMServerConnectionErrorMessage(this);
                    returnCode = 2;
                }
            }
            catch (Exception e) {
                errorMessage = e.getLocalizedMessage();
                logLevel = 0;
                logMessage = ErrorHandling.generateOMRServerConnectionErrorMessage(this);
                logMessage = logMessage + (errorMessage != null ? ": " + errorMessage : ".");
                returnCode = 2;
            }
            Logger.log(logLevel, this, logMessage);
            ISecurity_1_1 security = null;
            String accessVerb = null;
            String successVerb = null;
            logLevel = 2;
            try {
                metadataWorkspace.setCMRHandle(omrConnection);
                security = ISecurity_1_1Helper.narrow((Object)metadataWorkspace.getCMRHandle());
                Logger.log(3, this, ErrorHandling.generateSecurityInterfaceAcquiredMessage(this));
                if (internalUser == null) break block24;
                try {
                    security.GetInternalLoginUserInfo(internalUser, HasInternalLogin, Disabled, BypassStrength, BypassHistory, UseStdExpirationDays, ExpirationDays, BypassLockout, BypassInactivitySuspension, DoesAccountExpire, AccountExpirationDate, LastPWChange, LastLogin, NumFailures, LastLockout, LockedOut, PWExpired, SuspendedForInactivity, IsAccountExpired);
                    Logger.log(2, this, ErrorHandling.generateInternalAccountInformationRetrievedMessage(this, internalUser));
                    if (OverrideInternalAccountDefaultOptions.BypassStrength.value || !OverrideInternalAccountDefaultOptions.BypassLockout.value) {
                        accessVerb = "updating";
                        successVerb = "Updated";
                        boolean bypassStrength = OverrideInternalAccountDefaultOptions.BypassStrength.value;
                        boolean bypassLockout = OverrideInternalAccountDefaultOptions.BypassLockout.value;
                        if (OverrideInternalAccountDefaultOptions.BypassStrength.value) {
                            bypassStrength = false;
                            Logger.log(2, this, ErrorHandling.generateInternalAccountPasswordOverrideMessage(this, internalUser));
                        }
                        if (!OverrideInternalAccountDefaultOptions.BypassLockout.value) {
                            bypassLockout = true;
                            Logger.log(2, this, ErrorHandling.generateInternalAccountLockoutOverrideMessage(this, internalUser));
                        }
                        security.SetInternalLoginUserOptions(internalUser, OverrideInternalAccountDefaultOptions.Disabled.value, bypassStrength, OverrideInternalAccountDefaultOptions.BypassHistory.value, OverrideInternalAccountDefaultOptions.UseStdExpirationDays.value, OverrideInternalAccountDefaultOptions.ExpirationDays.value, bypassLockout, OverrideInternalAccountDefaultOptions.BypassInactivitySuspension.value, OverrideInternalAccountDefaultOptions.DoesAccountExpire.value, OverrideInternalAccountDefaultOptions.AccountExpirationDate.value);
                        Logger.log(2, this, ErrorHandling.generateInternalAccountInformationUpdatedMessage(this, internalUser));
                    }
                }
                catch (GenericError ge) {
                    errorMessage = ge.getLocalizedMessage();
                    logLevel = 0;
                    logMessage = errorMessage != null ? errorMessage : ErrorHandling.generateInternalAccountGenErrMessage(this, accessVerb, internalUser);
                    Logger.log(logLevel, this, logMessage);
                    returnCode = 2;
                }
                catch (Exception e) {
                    errorMessage = e.getLocalizedMessage();
                    logLevel = 0;
                    logMessage = errorMessage != null ? errorMessage : ErrorHandling.generateInternalAccountExceptionMessage(this, accessVerb, internalUser);
                    Logger.log(logLevel, this, logMessage);
                    returnCode = 2;
                }
            }
            catch (Exception e) {
                errorMessage = e.getLocalizedMessage();
                logLevel = 0;
                logMessage = errorMessage != null ? errorMessage : ErrorHandling.generateSecurityInterfaceFailedMessage(this);
                Logger.log(logLevel, this, logMessage);
            }
        }
        logLevel = 2;
        try {
            metadataWorkspace.closeOMRConnection();
            mdFactory.dispose();
            logLevel = 3;
            logMessage = ErrorHandling.generateMetadataServerCloseConnectionInfoMessage(this);
        }
        catch (RemoteException re) {
            errorMessage = re.getLocalizedMessage();
            logLevel = 0;
            logMessage = errorMessage != null ? errorMessage : ErrorHandling.generateMetadataServerConnectionErrorMessage(this);
        }
        Logger.log(logLevel, this, logMessage);
        project.setProperty("metadatasrv.migrate.completion.status", returnCode != 2 ? "success" : "fail");
        return returnCode != 2;
    }

    public void setHost(String m_host) {
        host = m_host;
    }

    public void setPort(String m_port) {
        port = m_port;
    }

    public void setUser(String m_user) {
        user = m_user;
    }

    public void setPassword(String m_password) {
        password = m_password;
    }

    public void setInternalUser(String m_internalUser) {
        internalUser = m_internalUser;
    }

    static {
        metadataWorkspace = null;
        host = null;
        port = null;
        user = null;
        password = null;
        internalUser = null;
        HasInternalLogin = new BooleanHolder();
        Disabled = new BooleanHolder();
        BypassStrength = new BooleanHolder();
        BypassHistory = new BooleanHolder();
        UseStdExpirationDays = new BooleanHolder();
        ExpirationDays = new IntHolder();
        BypassLockout = new BooleanHolder();
        BypassInactivitySuspension = new BooleanHolder();
        DoesAccountExpire = new BooleanHolder();
        AccountExpirationDate = new DateTimeHolder();
        LastPWChange = new DateTimeHolder();
        LastLogin = new DateTimeHolder();
        NumFailures = new IntHolder();
        LastLockout = new DateTimeHolder();
        LockedOut = new BooleanHolder();
        PWExpired = new BooleanHolder();
        SuspendedForInactivity = new BooleanHolder();
        IsAccountExpired = new BooleanHolder();
        omrConnection = null;
        returnCode = 0;
        errorMessage = null;
        sdwDebugMode = false;
    }
}

